/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.RangeMarkerEx;
import com.intellij.openapi.editor.impl.DocumentImpl;
import com.intellij.openapi.editor.impl.IntervalTreeImpl;
import com.intellij.openapi.editor.impl.PersistentRangeMarkerUtil;
import com.intellij.openapi.editor.impl.RangeMarkerTree;
import com.intellij.openapi.editor.impl.StripedIDGenerator;
import com.intellij.openapi.editor.impl.event.DocumentEventImpl;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.BinaryFileTypeDecompilers;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.util.ProperTextRange;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.TextRangeScalarUtil;
import com.intellij.openapi.util.UnfairTextRange;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.DocumentUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.diff.FilesTooBigForDiffException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RangeMarkerImpl
extends UserDataHolderBase
implements RangeMarkerEx {
    private static final Logger LOG = Logger.getInstance(RangeMarkerImpl.class);
    @NotNull
    private final Object myDocumentOrFile;
    RangeMarkerTree.RMNode<RangeMarkerEx> myNode;
    private final long myId;
    private static final StripedIDGenerator counter = new StripedIDGenerator();

    RangeMarkerImpl(@NotNull DocumentEx document, int start, int end, boolean register2, boolean forceDocumentStrongReference) {
        if (document == null) {
            RangeMarkerImpl.$$$reportNull$$$0(0);
        }
        this(forceDocumentStrongReference ? document : ObjectUtils.notNull(FileDocumentManager.getInstance().getFile(document), document), document.getTextLength(), start, end, register2, false, false);
    }

    RangeMarkerImpl(@NotNull VirtualFile virtualFile2, int start, int end, int estimatedDocumentLength, boolean register2) {
        if (virtualFile2 == null) {
            RangeMarkerImpl.$$$reportNull$$$0(1);
        }
        this(virtualFile2, estimatedDocumentLength, start, end, register2, false, false);
    }

    private RangeMarkerImpl(@NotNull Object documentOrFile, int documentTextLength, int start, int end, boolean register2, boolean greedyToLeft, boolean greedyToRight) {
        if (documentOrFile == null) {
            RangeMarkerImpl.$$$reportNull$$$0(2);
        }
        if (start < 0 || end > documentTextLength || start > end) {
            throw new IllegalArgumentException("Wrong offsets: start=" + start + "; end=" + end + "; document length=" + documentTextLength);
        }
        this.myDocumentOrFile = documentOrFile;
        this.myId = counter.next();
        if (register2) {
            this.registerInTree(start, end, greedyToLeft, greedyToRight, 0);
        }
    }

    static int estimateDocumentLength(@NotNull VirtualFile virtualFile2) {
        Document document;
        if (virtualFile2 == null) {
            RangeMarkerImpl.$$$reportNull$$$0(3);
        }
        return (document = FileDocumentManager.getInstance().getCachedDocument(virtualFile2)) == null ? Math.max(0, (int)virtualFile2.getLength()) : document.getTextLength();
    }

    protected void registerInTree(int start, int end, boolean greedyToLeft, boolean greedyToRight, int layer) {
        this.getDocument().registerRangeMarker(this, start, end, greedyToLeft, greedyToRight, layer);
    }

    protected void unregisterInTree() {
        if (!this.isValid()) {
            return;
        }
        IntervalTreeImpl tree = this.myNode.getTree();
        tree.checkMax(true);
        DocumentEx document = this.getCachedDocument();
        if (document == null) {
            this.myNode = null;
        } else {
            document.removeRangeMarker(this);
        }
        tree.checkMax(true);
    }

    @Override
    public long getId() {
        return this.myId;
    }

    @Override
    public void dispose() {
        this.unregisterInTree();
    }

    @Override
    public int getStartOffset() {
        RangeMarkerTree.RMNode<RangeMarkerEx> node2 = this.myNode;
        return node2 == null ? -1 : node2.intervalStart() + node2.computeDeltaUpToRoot();
    }

    @Override
    public int getEndOffset() {
        RangeMarkerTree.RMNode<RangeMarkerEx> node2 = this.myNode;
        return node2 == null ? -1 : node2.intervalEnd() + node2.computeDeltaUpToRoot();
    }

    @Override
    @NotNull
    public TextRange getTextRange() {
        RangeMarkerTree.RMNode<RangeMarkerEx> node2 = this.myNode;
        if (node2 == null) {
            TextRange textRange = TextRange.EMPTY_RANGE;
            if (textRange == null) {
                RangeMarkerImpl.$$$reportNull$$$0(4);
            }
            return textRange;
        }
        int delta = node2.computeDeltaUpToRoot();
        TextRange textRange = TextRangeScalarUtil.create(TextRangeScalarUtil.shift(node2.toScalarRange(), delta, delta));
        if (textRange == null) {
            RangeMarkerImpl.$$$reportNull$$$0(5);
        }
        return textRange;
    }

    void invalidate(@NotNull Object reason) {
        if (reason == null) {
            RangeMarkerImpl.$$$reportNull$$$0(6);
        }
        this.setValid(false);
        RangeMarkerTree.RMNode<RangeMarkerEx> node2 = this.myNode;
        if (node2 != null) {
            node2.processAliveKeys(markerEx -> {
                this.myNode.getTree().beforeRemove(markerEx, reason);
                return true;
            });
        }
    }

    @Override
    @NotNull
    public final DocumentEx getDocument() {
        DocumentEx document;
        Object file2 = this.myDocumentOrFile;
        DocumentEx documentEx = document = file2 instanceof VirtualFile ? (DocumentEx)FileDocumentManager.getInstance().getDocument((VirtualFile)file2) : (DocumentEx)file2;
        if (document == null) {
            LOG.error("document is null; isValid=" + this.isValid() + "; file=" + file2);
        }
        DocumentEx documentEx2 = document;
        if (documentEx2 == null) {
            RangeMarkerImpl.$$$reportNull$$$0(7);
        }
        return documentEx2;
    }

    DocumentEx getCachedDocument() {
        Object file2 = this.myDocumentOrFile;
        return file2 instanceof VirtualFile ? (DocumentEx)FileDocumentManager.getInstance().getCachedDocument((VirtualFile)file2) : (DocumentEx)file2;
    }

    public int getLayer() {
        return 0;
    }

    @Override
    public void setGreedyToLeft(boolean greedy) {
        if (!this.isValid() || greedy == this.isGreedyToLeft()) {
            return;
        }
        this.myNode.getTree().changeData(this, this.getStartOffset(), this.getEndOffset(), greedy, this.isGreedyToRight(), this.isStickingToRight(), this.getLayer());
    }

    @Override
    public void setGreedyToRight(boolean greedy) {
        if (!this.isValid() || greedy == this.isGreedyToRight()) {
            return;
        }
        this.myNode.getTree().changeData(this, this.getStartOffset(), this.getEndOffset(), this.isGreedyToLeft(), greedy, this.isStickingToRight(), this.getLayer());
    }

    public void setStickingToRight(boolean value) {
        if (!this.isValid() || value == this.isStickingToRight()) {
            return;
        }
        this.myNode.getTree().changeData(this, this.getStartOffset(), this.getEndOffset(), this.isGreedyToLeft(), this.isGreedyToRight(), value, this.getLayer());
    }

    @Override
    public boolean isGreedyToLeft() {
        RangeMarkerTree.RMNode<RangeMarkerEx> node2 = this.myNode;
        return node2 != null && node2.isGreedyToLeft();
    }

    @Override
    public boolean isGreedyToRight() {
        RangeMarkerTree.RMNode<RangeMarkerEx> node2 = this.myNode;
        return node2 != null && node2.isGreedyToRight();
    }

    public boolean isStickingToRight() {
        RangeMarkerTree.RMNode<RangeMarkerEx> node2 = this.myNode;
        return node2 != null && node2.isStickingToRight();
    }

    @Override
    public final void documentChanged(@NotNull DocumentEvent e) {
        int newEnd;
        int newStart;
        if (e == null) {
            RangeMarkerImpl.$$$reportNull$$$0(8);
        }
        int oldStart = this.intervalStart();
        int oldEnd = this.intervalEnd();
        int docLength = e.getDocument().getTextLength();
        if (!this.isValid()) {
            LOG.error("Invalid range marker " + (this.isGreedyToLeft() ? "[" : "(") + oldStart + ", " + oldEnd + (this.isGreedyToRight() ? "]" : ")") + ". Event = " + e + ". Doc length=" + docLength + "; " + this.getClass());
            return;
        }
        if (oldStart > oldEnd || oldStart < 0 || oldEnd > docLength - e.getNewLength() + e.getOldLength()) {
            LOG.error("RangeMarker" + (this.isGreedyToLeft() ? "[" : "(") + oldStart + ", " + oldEnd + (this.isGreedyToRight() ? "]" : ")") + " is invalid before update. Event = " + e + ". Doc length=" + docLength + "; " + this.getClass());
            this.invalidate(e);
            return;
        }
        this.changedUpdateImpl(e);
        if (this.isValid() && ((newStart = this.intervalStart()) > (newEnd = this.intervalEnd()) || newStart < 0 || newEnd > docLength)) {
            LOG.error("Update failed. Event = " + e + ". Doc length=" + docLength + "; " + this.getClass() + ". Before update: " + (this.isGreedyToLeft() ? "[" : "(") + oldStart + ", " + oldEnd + (this.isGreedyToRight() ? "]" : ")") + " After update: '" + this + "'");
            this.invalidate(e);
        }
    }

    protected void changedUpdateImpl(@NotNull DocumentEvent e) {
        if (e == null) {
            RangeMarkerImpl.$$$reportNull$$$0(9);
        }
        this.doChangeUpdate(e);
    }

    private void doChangeUpdate(@NotNull DocumentEvent e) {
        if (e == null) {
            RangeMarkerImpl.$$$reportNull$$$0(10);
        }
        if (!this.isValid()) {
            return;
        }
        TextRange newRange = RangeMarkerImpl.applyChange(e, this.intervalStart(), this.intervalEnd(), this.isGreedyToLeft(), this.isGreedyToRight(), this.isStickingToRight());
        if (newRange == null) {
            this.invalidate(e);
            return;
        }
        this.setRange(TextRangeScalarUtil.toScalarRange(newRange));
    }

    protected void persistentHighlighterUpdate(@NotNull DocumentEvent e, boolean wholeLineRange) {
        boolean viaDiff;
        if (e == null) {
            RangeMarkerImpl.$$$reportNull$$$0(11);
        }
        int line = 0;
        DocumentEventImpl event = (DocumentEventImpl)e;
        boolean bl = viaDiff = this.isValid() && PersistentRangeMarkerUtil.shouldTranslateViaDiff(event, this.getStartOffset(), this.getEndOffset());
        if (viaDiff) {
            try {
                line = event.getLineNumberBeforeUpdate(this.getStartOffset());
                line = this.translatedViaDiff(event, line);
            }
            catch (FilesTooBigForDiffException exception) {
                viaDiff = false;
            }
        }
        if (!viaDiff) {
            this.doChangeUpdate(e);
            if (this.isValid()) {
                int startOffset = this.getStartOffset();
                line = this.getDocument().getLineNumber(startOffset);
                int endLine = this.getDocument().getLineNumber(this.getEndOffset());
                if (endLine != line) {
                    this.setRange(TextRangeScalarUtil.toScalarRange(startOffset, this.getDocument().getLineEndOffset(line)));
                }
            }
        }
        if (this.isValid() && wholeLineRange) {
            int newStart = DocumentUtil.getFirstNonSpaceCharOffset(this.getDocument(), line);
            int newEnd = this.getDocument().getLineEndOffset(line);
            this.setRange(TextRangeScalarUtil.toScalarRange(newStart, newEnd));
        }
    }

    private int translatedViaDiff(@NotNull DocumentEventImpl e, int line) throws FilesTooBigForDiffException {
        if (e == null) {
            RangeMarkerImpl.$$$reportNull$$$0(12);
        }
        if ((line = e.translateLineViaDiff(line)) < 0 || line >= this.getDocument().getLineCount()) {
            this.invalidate(e);
        } else {
            DocumentEx document = this.getDocument();
            this.setRange(TextRangeScalarUtil.toScalarRange(document.getLineStartOffset(line), document.getLineEndOffset(line)));
        }
        return line;
    }

    protected void onReTarget(@NotNull DocumentEvent e) {
        if (e == null) {
            RangeMarkerImpl.$$$reportNull$$$0(13);
        }
    }

    @Nullable
    static TextRange applyChange(@NotNull DocumentEvent e, int intervalStart, int intervalEnd, boolean isGreedyToLeft, boolean isGreedyToRight, boolean isStickingToRight) {
        if (e == null) {
            RangeMarkerImpl.$$$reportNull$$$0(14);
        }
        if (intervalStart == intervalEnd) {
            return RangeMarkerImpl.processIfOnePoint(e, intervalStart, isGreedyToRight, isStickingToRight);
        }
        int offset2 = e.getOffset();
        int oldLength = e.getOldLength();
        int newLength = e.getNewLength();
        if (intervalEnd < offset2) {
            return new UnfairTextRange(intervalStart, intervalEnd);
        }
        if (!isGreedyToRight && intervalEnd == offset2) {
            if (e instanceof DocumentEventImpl && oldLength == 0 && ((DocumentEventImpl)e).getInitialStartOffset() < offset2) {
                return new UnfairTextRange(intervalStart, intervalEnd + newLength);
            }
            return new UnfairTextRange(intervalStart, intervalEnd);
        }
        if (intervalStart > offset2 + oldLength) {
            return new UnfairTextRange(intervalStart + newLength - oldLength, intervalEnd + newLength - oldLength);
        }
        if (!isGreedyToLeft && intervalStart == offset2 + oldLength) {
            if (e instanceof DocumentEventImpl && oldLength == 0 && ((DocumentEventImpl)e).getInitialStartOffset() + ((DocumentEventImpl)e).getInitialOldLength() > offset2) {
                return new UnfairTextRange(intervalStart, intervalEnd + newLength);
            }
            return new UnfairTextRange(intervalStart + newLength - oldLength, intervalEnd + newLength - oldLength);
        }
        if (intervalStart <= offset2 && intervalEnd >= offset2 + oldLength) {
            return new ProperTextRange(intervalStart, intervalEnd + newLength - oldLength);
        }
        if (intervalStart >= offset2 && intervalStart <= offset2 + oldLength && intervalEnd > offset2 + oldLength) {
            return new ProperTextRange(offset2 + newLength, intervalEnd + newLength - oldLength);
        }
        if (intervalEnd <= offset2 + oldLength && intervalStart < offset2) {
            return new UnfairTextRange(intervalStart, offset2);
        }
        return null;
    }

    @Nullable
    private static TextRange processIfOnePoint(@NotNull DocumentEvent e, int intervalStart, boolean greedyRight, boolean stickyRight) {
        if (e == null) {
            RangeMarkerImpl.$$$reportNull$$$0(15);
        }
        int offset2 = e.getOffset();
        int oldLength = e.getOldLength();
        int oldEnd = offset2 + oldLength;
        if (offset2 < intervalStart && intervalStart < oldEnd) {
            return null;
        }
        if (offset2 == intervalStart && oldLength == 0) {
            if (greedyRight) {
                return new UnfairTextRange(intervalStart, intervalStart + e.getNewLength());
            }
            if (stickyRight) {
                return new UnfairTextRange(intervalStart + e.getNewLength(), intervalStart + e.getNewLength());
            }
        }
        if (intervalStart > oldEnd || intervalStart == oldEnd && oldLength > 0) {
            return new UnfairTextRange(intervalStart + e.getNewLength() - oldLength, intervalStart + e.getNewLength() - oldLength);
        }
        return new UnfairTextRange(intervalStart, intervalStart);
    }

    @Override
    @NonNls
    public String toString() {
        return "RangeMarker" + (this.isGreedyToLeft() ? "[" : "(") + (this.isValid() ? "" : "invalid:") + this.getStartOffset() + "," + this.getEndOffset() + (this.isGreedyToRight() ? "]" : ")") + " " + this.getId();
    }

    void setRange(long scalarRange) {
        this.myNode.setRange(scalarRange);
    }

    @Override
    public boolean isValid() {
        RangeMarkerTree.RMNode<RangeMarkerEx> node2 = this.myNode;
        if (node2 == null || !node2.isValid()) {
            return false;
        }
        Object file2 = this.myDocumentOrFile;
        return file2 instanceof Document || RangeMarkerImpl.canHaveDocument((VirtualFile)file2);
    }

    private static boolean canHaveDocument(@NotNull VirtualFile file2) {
        Document document;
        if (file2 == null) {
            RangeMarkerImpl.$$$reportNull$$$0(16);
        }
        if ((document = FileDocumentManager.getInstance().getCachedDocument(file2)) != null) {
            return true;
        }
        if (!file2.isValid() || file2.isDirectory() || RangeMarkerImpl.isBinaryWithoutDecompiler(file2)) {
            return false;
        }
        return !file2.getFileType().isBinary() || !FileUtilRt.isTooLarge(file2.getLength());
    }

    private static boolean isBinaryWithoutDecompiler(@NotNull VirtualFile file2) {
        FileType fileType;
        if (file2 == null) {
            RangeMarkerImpl.$$$reportNull$$$0(17);
        }
        return (fileType = file2.getFileType()).isBinary() && BinaryFileTypeDecompilers.getInstance().forFileType(fileType) == null;
    }

    protected boolean setValid(boolean value) {
        RangeMarkerTree.RMNode<RangeMarkerEx> node2 = this.myNode;
        return node2 == null || node2.setValid(value);
    }

    public int intervalStart() {
        RangeMarkerTree.RMNode<RangeMarkerEx> node2 = this.myNode;
        if (node2 == null) {
            return -1;
        }
        return node2.intervalStart();
    }

    public int intervalEnd() {
        RangeMarkerTree.RMNode<RangeMarkerEx> node2 = this.myNode;
        if (node2 == null) {
            return -1;
        }
        return node2.intervalEnd();
    }

    long toScalarRange() {
        RangeMarkerTree.RMNode<RangeMarkerEx> node2 = this.myNode;
        if (node2 == null) {
            return -1L;
        }
        return node2.toScalarRange();
    }

    public RangeMarker findRangeMarkerAfter() {
        return this.myNode.getTree().findRangeMarkerAfter(this);
    }

    public RangeMarker findRangeMarkerBefore() {
        return this.myNode.getTree().findRangeMarkerBefore(this);
    }

    void reRegister(@NotNull DocumentImpl document, int tabSize) {
        int endOffset;
        int startOffset;
        if (document == null) {
            RangeMarkerImpl.$$$reportNull$$$0(18);
        }
        if ((startOffset = this.getStartOffset()) <= (endOffset = this.getEndOffset()) && endOffset <= document.getTextLength()) {
            document.registerRangeMarker(this, startOffset, endOffset, this.isGreedyToLeft(), this.isGreedyToRight(), 0);
        } else {
            this.invalidate("document was gc-ed and re-created with invalid offsets: (" + startOffset + "," + endOffset + "): " + document.getTextLength());
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 7: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "documentOrFile";
                break;
            }
            case 4: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/editor/impl/RangeMarkerImpl";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reason";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/editor/impl/RangeMarkerImpl";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getTextRange";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getDocument";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "estimateDocumentLength";
                break;
            }
            case 4: 
            case 5: 
            case 7: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "invalidate";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "documentChanged";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "changedUpdateImpl";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "doChangeUpdate";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "persistentHighlighterUpdate";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "translatedViaDiff";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "onReTarget";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "applyChange";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "processIfOnePoint";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "canHaveDocument";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "isBinaryWithoutDecompiler";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "reRegister";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 4: 
            case 5: 
            case 7: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

