/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.openapi.editor.TextChange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.text.CharArrayUtil;
import org.jetbrains.annotations.NotNull;

public class TextChangeImpl
implements TextChange {
    private final StringBuilder myText;
    private char[] myChars;
    private int myStart;
    private int myEnd;

    public TextChangeImpl(@NotNull CharSequence text2, int start) throws IllegalArgumentException {
        if (text2 == null) {
            TextChangeImpl.$$$reportNull$$$0(0);
        }
        this(text2, start, start);
    }

    public TextChangeImpl(@NotNull CharSequence text2, int start, int end) throws IllegalArgumentException {
        if (text2 == null) {
            TextChangeImpl.$$$reportNull$$$0(1);
        }
        this.myText = new StringBuilder();
        if (start < 0) {
            throw new IllegalArgumentException(String.format("Can't construct new %s object. Reason: given start index (%d) is negative. End index: %d, text: '%s'", this.getClass().getName(), start, end, text2));
        }
        if (end < start) {
            throw new IllegalArgumentException(String.format("Can't construct new %s object. Reason: given end index (%d) is less than start index (%d). Text: '%s'", this.getClass().getName(), end, start, text2));
        }
        this.myText.append(text2);
        this.myStart = start;
        this.myEnd = end;
    }

    @Override
    public int getStart() {
        return this.myStart;
    }

    public void setStart(int start) {
        assert (start >= 0) : start;
        this.myStart = start;
    }

    @Override
    public int getEnd() {
        return this.myEnd;
    }

    public void setEnd(int end) {
        this.myEnd = end;
    }

    @Override
    @NotNull
    public CharSequence getText() {
        StringBuilder stringBuilder = this.myText;
        if (stringBuilder == null) {
            TextChangeImpl.$$$reportNull$$$0(2);
        }
        return stringBuilder;
    }

    @Override
    public char @NotNull [] getChars() {
        char[] chars = this.myChars;
        if (chars == null) {
            this.myChars = chars = CharArrayUtil.fromSequence(this.myText);
        }
        if (chars == null) {
            TextChangeImpl.$$$reportNull$$$0(3);
        }
        return chars;
    }

    public int getDiff() {
        return this.myText.length() - this.myEnd + this.myStart;
    }

    public void advance(int offset2) throws IllegalArgumentException {
        if (offset2 == 0) {
            return;
        }
        int newStart = this.myStart + offset2;
        if (newStart < 0) {
            throw new IllegalArgumentException(String.format("Can't apply given offset (%d) to the current text change object (%s). Reason: new start index becomes negative after that (%d)", offset2, this, newStart));
        }
        this.setStart(newStart);
        this.setEnd(this.myEnd + offset2);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TextChangeImpl that = (TextChangeImpl)o;
        return this.myStart == that.myStart && this.myEnd == that.myEnd && StringUtil.equals(this.myText, that.myText);
    }

    public int hashCode() {
        int result2 = StringUtil.stringHashCode(this.myText);
        result2 = 31 * result2 + this.myStart;
        return 31 * result2 + this.myEnd;
    }

    public String toString() {
        return String.format("%d-%d: '%s'", this.myStart, this.myEnd, this.myText);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/editor/impl/TextChangeImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/editor/impl/TextChangeImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getChars";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

