/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.richcopy;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.colors.FontPreferences;
import com.intellij.openapi.editor.impl.FontInfo;
import com.intellij.util.ReflectionUtil;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.font.FontRenderContext;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public final class FontMapper {
    private static final Logger LOG = Logger.getInstance(FontMapper.class);
    private static final String[] logicalFontsToMap = new String[]{"Dialog", "DialogInput", "Monospaced", "Serif", "SansSerif"};
    private static final Map<String, String> logicalToPhysicalMapping = new HashMap<String, String>();
    private static final Map<String, Boolean> monospacedMapping = new HashMap<String, Boolean>();

    @NotNull
    public static String getPhysicalFontName(@NotNull String logicalFontName) {
        String mapped;
        if (logicalFontName == null) {
            FontMapper.$$$reportNull$$$0(0);
        }
        String string2 = (mapped = logicalToPhysicalMapping.get(logicalFontName)) == null ? logicalFontName : mapped;
        if (string2 == null) {
            FontMapper.$$$reportNull$$$0(1);
        }
        return string2;
    }

    public static boolean isMonospaced(@NotNull String fontName) {
        Boolean result2;
        if (fontName == null) {
            FontMapper.$$$reportNull$$$0(2);
        }
        if ((result2 = monospacedMapping.get(fontName)) == null) {
            FontMetrics metrics = FontInfo.getFontMetrics((Font)new Font(fontName, 0, FontPreferences.DEFAULT_FONT_SIZE), (FontRenderContext)new FontRenderContext(null, false, false));
            result2 = metrics.charWidth('l') == metrics.charWidth('W');
            monospacedMapping.put(fontName, result2);
        }
        return result2;
    }

    static {
        try {
            Object fontManager = Class.forName("sun.font.FontManagerFactory").getMethod("getInstance", new Class[0]).invoke(null, new Object[0]);
            Method findFontMethod = Class.forName("sun.font.FontManager").getMethod("findFont2D", String.class, Integer.TYPE, Integer.TYPE);
            for (String logicalFont : logicalFontsToMap) {
                Object font2D = findFontMethod.invoke(fontManager, logicalFont, 0, 0);
                if (font2D == null) continue;
                String fontClassName = font2D.getClass().getName();
                String physicalFont = null;
                if ("sun.font.CompositeFont".equals(fontClassName)) {
                    Object physicalFontObject = Class.forName("sun.font.CompositeFont").getMethod("getSlotFont", Integer.TYPE).invoke(font2D, 0);
                    physicalFont = (String)Class.forName("sun.font.Font2D").getMethod("getFamilyName", Locale.class).invoke(physicalFontObject, Locale.getDefault());
                } else if ("sun.font.CFont".equals(fontClassName)) {
                    physicalFont = ReflectionUtil.getField(Class.forName("sun.font.CFont"), font2D, String.class, "nativeFontName");
                }
                if (physicalFont == null) continue;
                logicalToPhysicalMapping.put(logicalFont, physicalFont);
            }
        }
        catch (Throwable e) {
            LOG.warn("Failed to determine logical to physical font mappings", e);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logicalFontName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/editor/richcopy/FontMapper";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fontName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/editor/richcopy/FontMapper";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getPhysicalFontName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getPhysicalFontName";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isMonospaced";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 1 -> new IllegalStateException(string2);
        };
    }
}

