/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.richcopy;

import com.intellij.ide.highlighter.HighlighterFactory;
import com.intellij.lang.Language;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.colors.ColorKey;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.colors.impl.DelegateColorScheme;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.markup.EffectType;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.editor.richcopy.SyntaxInfoBuilder;
import com.intellij.openapi.editor.richcopy.model.SyntaxInfo;
import com.intellij.openapi.editor.richcopy.view.HtmlSyntaxInfoReader;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.ui.ColorUtil;
import java.awt.Color;
import java.io.IOException;
import java.util.Objects;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class HtmlSyntaxInfoUtil {
    private HtmlSyntaxInfoUtil() {
    }

    @NotNull
    public static String getStyledSpan(@Nullable String value, String ... properties) {
        if (properties == null) {
            HtmlSyntaxInfoUtil.$$$reportNull$$$0(0);
        }
        String string2 = HtmlSyntaxInfoUtil.appendStyledSpan(new StringBuilder(), value, properties).toString();
        if (string2 == null) {
            HtmlSyntaxInfoUtil.$$$reportNull$$$0(1);
        }
        return string2;
    }

    @NotNull
    public static String getStyledSpan(@NotNull TextAttributesKey attributesKey, @Nullable String value, float saturationFactor) {
        if (attributesKey == null) {
            HtmlSyntaxInfoUtil.$$$reportNull$$$0(2);
        }
        String string2 = HtmlSyntaxInfoUtil.appendStyledSpan(new StringBuilder(), attributesKey, value, saturationFactor).toString();
        if (string2 == null) {
            HtmlSyntaxInfoUtil.$$$reportNull$$$0(3);
        }
        return string2;
    }

    @NotNull
    public static String getStyledSpan(@NotNull TextAttributes attributes, @Nullable String value, float saturationFactor) {
        if (attributes == null) {
            HtmlSyntaxInfoUtil.$$$reportNull$$$0(4);
        }
        String string2 = HtmlSyntaxInfoUtil.appendStyledSpan(new StringBuilder(), attributes, value, saturationFactor).toString();
        if (string2 == null) {
            HtmlSyntaxInfoUtil.$$$reportNull$$$0(5);
        }
        return string2;
    }

    @NotNull
    public static String getHighlightedByLexerAndEncodedAsHtmlCodeSnippet(@NotNull Project project2, @NotNull Language language, @Nullable String codeSnippet, float saturationFactor) {
        if (project2 == null) {
            HtmlSyntaxInfoUtil.$$$reportNull$$$0(6);
        }
        if (language == null) {
            HtmlSyntaxInfoUtil.$$$reportNull$$$0(7);
        }
        String string2 = HtmlSyntaxInfoUtil.appendHighlightedByLexerAndEncodedAsHtmlCodeSnippet(new StringBuilder(), project2, language, codeSnippet, saturationFactor).toString();
        if (string2 == null) {
            HtmlSyntaxInfoUtil.$$$reportNull$$$0(8);
        }
        return string2;
    }

    @NotNull
    public static StringBuilder appendStyledSpan(@NotNull StringBuilder buffer, @Nullable String value, String ... properties) {
        if (buffer == null) {
            HtmlSyntaxInfoUtil.$$$reportNull$$$0(9);
        }
        if (properties == null) {
            HtmlSyntaxInfoUtil.$$$reportNull$$$0(10);
        }
        HtmlChunk.span().style(StringUtil.join(properties, ";")).addRaw(StringUtil.notNullize(value)).appendTo(buffer);
        StringBuilder stringBuilder = buffer;
        if (stringBuilder == null) {
            HtmlSyntaxInfoUtil.$$$reportNull$$$0(11);
        }
        return stringBuilder;
    }

    @NotNull
    public static StringBuilder appendStyledSpan(@NotNull StringBuilder buffer, @NotNull TextAttributesKey attributesKey, @Nullable String value, float saturationFactor) {
        if (buffer == null) {
            HtmlSyntaxInfoUtil.$$$reportNull$$$0(12);
        }
        if (attributesKey == null) {
            HtmlSyntaxInfoUtil.$$$reportNull$$$0(13);
        }
        HtmlSyntaxInfoUtil.appendStyledSpan(buffer, Objects.requireNonNull(EditorColorsManager.getInstance().getGlobalScheme().getAttributes(attributesKey)), value, saturationFactor);
        StringBuilder stringBuilder = buffer;
        if (stringBuilder == null) {
            HtmlSyntaxInfoUtil.$$$reportNull$$$0(14);
        }
        return stringBuilder;
    }

    @NotNull
    public static StringBuilder appendStyledSpan(@NotNull StringBuilder buffer, @NotNull TextAttributes attributes, @Nullable String value, float saturationFactor) {
        if (buffer == null) {
            HtmlSyntaxInfoUtil.$$$reportNull$$$0(15);
        }
        if (attributes == null) {
            HtmlSyntaxInfoUtil.$$$reportNull$$$0(16);
        }
        HtmlSyntaxInfoUtil.createHtmlSpanBlockStyledAsTextAttributes(attributes, saturationFactor).addRaw(StringUtil.notNullize(value)).appendTo(buffer);
        StringBuilder stringBuilder = buffer;
        if (stringBuilder == null) {
            HtmlSyntaxInfoUtil.$$$reportNull$$$0(17);
        }
        return stringBuilder;
    }

    @NotNull
    public static StringBuilder appendHighlightedByLexerAndEncodedAsHtmlCodeSnippet(@NotNull StringBuilder buffer, @NotNull Project project2, @NotNull Language language, @Nullable String codeSnippet, float saturationFactor) {
        if (buffer == null) {
            HtmlSyntaxInfoUtil.$$$reportNull$$$0(18);
        }
        if (project2 == null) {
            HtmlSyntaxInfoUtil.$$$reportNull$$$0(19);
        }
        if (language == null) {
            HtmlSyntaxInfoUtil.$$$reportNull$$$0(20);
        }
        return HtmlSyntaxInfoUtil.appendHighlightedByLexerAndEncodedAsHtmlCodeSnippet(buffer, project2, language, codeSnippet, true, saturationFactor);
    }

    @NotNull
    public static StringBuilder appendHighlightedByLexerAndEncodedAsHtmlCodeSnippet(@NotNull StringBuilder buffer, @NotNull Project project2, @NotNull Language language, @Nullable String codeSnippet, boolean doTrimIndent, float saturationFactor) {
        if (buffer == null) {
            HtmlSyntaxInfoUtil.$$$reportNull$$$0(21);
        }
        if (project2 == null) {
            HtmlSyntaxInfoUtil.$$$reportNull$$$0(22);
        }
        if (language == null) {
            HtmlSyntaxInfoUtil.$$$reportNull$$$0(23);
        }
        codeSnippet = StringUtil.notNullize(codeSnippet);
        String trimmed = doTrimIndent ? StringsKt.trimIndent((String)codeSnippet) : codeSnippet;
        String zeroIndentCode = trimmed.replace("\t", "    ");
        if (!zeroIndentCode.isEmpty()) {
            PsiFile fakePsiFile = PsiFileFactory.getInstance(project2).createFileFromText(language, (CharSequence)codeSnippet);
            ColorsSchemeWithChangedSaturation scheme = new ColorsSchemeWithChangedSaturation(EditorColorsManager.getInstance().getGlobalScheme(), saturationFactor);
            buffer.append(HtmlSyntaxInfoUtil.getHtmlContent(fakePsiFile, zeroIndentCode, null, (EditorColorsScheme)scheme, 0, zeroIndentCode.length()));
        }
        StringBuilder stringBuilder = buffer;
        if (stringBuilder == null) {
            HtmlSyntaxInfoUtil.$$$reportNull$$$0(24);
        }
        return stringBuilder;
    }

    @Nullable
    public static CharSequence getHtmlContent(@NotNull PsiFile file2, @NotNull CharSequence text2, @Nullable SyntaxInfoBuilder.RangeIterator ownRangeIterator, @NotNull EditorColorsScheme schemeToUse, int startOffset, int endOffset) {
        if (file2 == null) {
            HtmlSyntaxInfoUtil.$$$reportNull$$$0(25);
        }
        if (text2 == null) {
            HtmlSyntaxInfoUtil.$$$reportNull$$$0(26);
        }
        if (schemeToUse == null) {
            HtmlSyntaxInfoUtil.$$$reportNull$$$0(27);
        }
        EditorHighlighter highlighter = HighlighterFactory.createHighlighter((VirtualFile)file2.getViewProvider().getVirtualFile(), (EditorColorsScheme)schemeToUse, (Project)file2.getProject());
        highlighter.setText(text2);
        SyntaxInfoBuilder.HighlighterRangeIterator highlighterRangeIterator = new SyntaxInfoBuilder.HighlighterRangeIterator(highlighter, startOffset, endOffset);
        ownRangeIterator = ownRangeIterator == null ? highlighterRangeIterator : new SyntaxInfoBuilder.CompositeRangeIterator(schemeToUse, highlighterRangeIterator, ownRangeIterator);
        return HtmlSyntaxInfoUtil.getHtmlContent(text2, ownRangeIterator, schemeToUse, endOffset);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static CharSequence getHtmlContent(@NotNull CharSequence text2, @NotNull SyntaxInfoBuilder.RangeIterator ownRangeIterator, @NotNull EditorColorsScheme schemeToUse, int stopOffset) {
        CharSequence charSequence;
        if (text2 == null) {
            HtmlSyntaxInfoUtil.$$$reportNull$$$0(28);
        }
        if (ownRangeIterator == null) {
            HtmlSyntaxInfoUtil.$$$reportNull$$$0(29);
        }
        if (schemeToUse == null) {
            HtmlSyntaxInfoUtil.$$$reportNull$$$0(30);
        }
        SyntaxInfoBuilder.Context context2 = new SyntaxInfoBuilder.Context(text2, schemeToUse, 0);
        SyntaxInfoBuilder.MyMarkupIterator iterator2 = new SyntaxInfoBuilder.MyMarkupIterator(text2, ownRangeIterator, schemeToUse);
        try {
            context2.iterate(iterator2, stopOffset);
        }
        finally {
            iterator2.dispose();
        }
        SyntaxInfo info2 = context2.finish();
        SimpleHtmlSyntaxInfoReader data2 = new SimpleHtmlSyntaxInfoReader(info2);
        try {
            data2.setRawText(text2.toString());
            charSequence = data2.getBuffer();
        }
        catch (Throwable throwable) {
            try {
                try {
                    data2.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                Logger.getInstance(HtmlSyntaxInfoUtil.class).error(e);
                return null;
            }
        }
        data2.close();
        return charSequence;
    }

    @NotNull
    private static HtmlChunk.Element createHtmlSpanBlockStyledAsTextAttributes(@NotNull TextAttributes attributes, float saturationFactor) {
        if (attributes == null) {
            HtmlSyntaxInfoUtil.$$$reportNull$$$0(31);
        }
        StringBuilder style = new StringBuilder();
        Color foregroundColor = attributes.getForegroundColor();
        Color backgroundColor = attributes.getBackgroundColor();
        Color effectTypeColor = attributes.getEffectColor();
        if (foregroundColor != null) {
            foregroundColor = HtmlSyntaxInfoUtil.tuneSaturationEspeciallyGrey(foregroundColor, 1, saturationFactor);
        }
        if (backgroundColor != null) {
            backgroundColor = HtmlSyntaxInfoUtil.tuneSaturationEspeciallyGrey(backgroundColor, 1, saturationFactor);
        }
        if (effectTypeColor != null) {
            effectTypeColor = HtmlSyntaxInfoUtil.tuneSaturationEspeciallyGrey(effectTypeColor, 1, saturationFactor);
        }
        if (foregroundColor != null) {
            HtmlSyntaxInfoUtil.appendProperty(style, "color", ColorUtil.toHtmlColor(foregroundColor));
        }
        if (backgroundColor != null) {
            HtmlSyntaxInfoUtil.appendProperty(style, "background-color", ColorUtil.toHtmlColor(backgroundColor));
        }
        switch (attributes.getFontType()) {
            case 1: {
                HtmlSyntaxInfoUtil.appendProperty(style, "font-weight", "bold");
                break;
            }
            case 2: {
                HtmlSyntaxInfoUtil.appendProperty(style, "font-style", "italic");
            }
        }
        EffectType effectType = attributes.getEffectType();
        if (attributes.hasEffects() && effectType != null) {
            switch (effectType) {
                case LINE_UNDERSCORE: {
                    HtmlSyntaxInfoUtil.appendProperty(style, "text-decoration-line", "underline");
                    break;
                }
                case WAVE_UNDERSCORE: {
                    HtmlSyntaxInfoUtil.appendProperty(style, "text-decoration-line", "underline");
                    HtmlSyntaxInfoUtil.appendProperty(style, "text-decoration-style", "wavy");
                    break;
                }
                case BOLD_LINE_UNDERSCORE: {
                    HtmlSyntaxInfoUtil.appendProperty(style, "text-decoration-line", "underline");
                    HtmlSyntaxInfoUtil.appendProperty(style, "text-decoration-thickness", "2px");
                    break;
                }
                case BOLD_DOTTED_LINE: {
                    HtmlSyntaxInfoUtil.appendProperty(style, "text-decoration-line", "underline");
                    HtmlSyntaxInfoUtil.appendProperty(style, "text-decoration-thickness", "2px");
                    HtmlSyntaxInfoUtil.appendProperty(style, "text-decoration-style", "dotted");
                    break;
                }
                case STRIKEOUT: {
                    HtmlSyntaxInfoUtil.appendProperty(style, "text-decoration-line", "line-through");
                    break;
                }
                case BOXED: 
                case SLIGHTLY_WIDER_BOX: 
                case SEARCH_MATCH: {
                    HtmlSyntaxInfoUtil.appendProperty(style, "border", "1px solid");
                    break;
                }
                case ROUNDED_BOX: {
                    HtmlSyntaxInfoUtil.appendProperty(style, "border", "1px solid");
                    HtmlSyntaxInfoUtil.appendProperty(style, "border-radius", "2px");
                }
            }
        }
        if (attributes.hasEffects() && effectType != null && effectTypeColor != null) {
            switch (effectType) {
                case LINE_UNDERSCORE: 
                case WAVE_UNDERSCORE: 
                case BOLD_LINE_UNDERSCORE: 
                case BOLD_DOTTED_LINE: 
                case STRIKEOUT: {
                    HtmlSyntaxInfoUtil.appendProperty(style, "text-decoration-color", ColorUtil.toHtmlColor(effectTypeColor));
                    break;
                }
                case BOXED: 
                case SLIGHTLY_WIDER_BOX: 
                case SEARCH_MATCH: 
                case ROUNDED_BOX: {
                    HtmlSyntaxInfoUtil.appendProperty(style, "border-color", ColorUtil.toHtmlColor(effectTypeColor));
                }
            }
        }
        HtmlChunk.Element element = HtmlChunk.span().style(style.toString());
        if (element == null) {
            HtmlSyntaxInfoUtil.$$$reportNull$$$0(32);
        }
        return element;
    }

    private static void appendProperty(@NotNull StringBuilder builder2, @NotNull String name, @NotNull String value) {
        if (builder2 == null) {
            HtmlSyntaxInfoUtil.$$$reportNull$$$0(33);
        }
        if (name == null) {
            HtmlSyntaxInfoUtil.$$$reportNull$$$0(34);
        }
        if (value == null) {
            HtmlSyntaxInfoUtil.$$$reportNull$$$0(35);
        }
        builder2.append(name);
        builder2.append(":");
        builder2.append(value);
        builder2.append(";");
    }

    @NotNull
    private static Color tuneSaturationEspeciallyGrey(@NotNull Color color, int howMuch, float saturationFactor) {
        if (color == null) {
            HtmlSyntaxInfoUtil.$$$reportNull$$$0(36);
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            Color color2 = color;
            if (color2 == null) {
                HtmlSyntaxInfoUtil.$$$reportNull$$$0(37);
            }
            return color2;
        }
        Color color3 = ColorUtil.tuneSaturationEspeciallyGrey(color, howMuch, saturationFactor);
        if (color3 == null) {
            HtmlSyntaxInfoUtil.$$$reportNull$$$0(38);
        }
        return color3;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 3, 5, 8, 11, 14, 17, 24, 32, 37, 38 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "properties";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 8: 
            case 11: 
            case 14: 
            case 17: 
            case 24: 
            case 32: 
            case 37: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/editor/richcopy/HtmlSyntaxInfoUtil";
                break;
            }
            case 2: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributesKey";
                break;
            }
            case 4: 
            case 16: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributes";
                break;
            }
            case 6: 
            case 19: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 7: 
            case 20: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
            case 9: 
            case 12: 
            case 15: 
            case 18: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buffer";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 26: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 27: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "schemeToUse";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ownRangeIterator";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "color";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/editor/richcopy/HtmlSyntaxInfoUtil";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getStyledSpan";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getHighlightedByLexerAndEncodedAsHtmlCodeSnippet";
                break;
            }
            case 11: 
            case 14: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "appendStyledSpan";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "appendHighlightedByLexerAndEncodedAsHtmlCodeSnippet";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "createHtmlSpanBlockStyledAsTextAttributes";
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "tuneSaturationEspeciallyGrey";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getStyledSpan";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 8: 
            case 11: 
            case 14: 
            case 17: 
            case 24: 
            case 32: 
            case 37: 
            case 38: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getHighlightedByLexerAndEncodedAsHtmlCodeSnippet";
                break;
            }
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "appendStyledSpan";
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "appendHighlightedByLexerAndEncodedAsHtmlCodeSnippet";
                break;
            }
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "getHtmlContent";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "createHtmlSpanBlockStyledAsTextAttributes";
                break;
            }
            case 33: 
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "appendProperty";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "tuneSaturationEspeciallyGrey";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 1, 3, 5, 8, 11, 14, 17, 24, 32, 37, 38 -> new IllegalStateException(string2);
        };
    }

    private static final class ColorsSchemeWithChangedSaturation
    extends DelegateColorScheme {
        private final float mySaturationFactor;

        private ColorsSchemeWithChangedSaturation(@NotNull EditorColorsScheme delegate2, float saturationFactor) {
            if (delegate2 == null) {
                ColorsSchemeWithChangedSaturation.$$$reportNull$$$0(0);
            }
            super((EditorColorsScheme)delegate2.clone());
            this.mySaturationFactor = saturationFactor;
        }

        @NotNull
        public Color getDefaultBackground() {
            Color color = this.tuneColor(super.getDefaultBackground());
            if (color == null) {
                ColorsSchemeWithChangedSaturation.$$$reportNull$$$0(1);
            }
            return color;
        }

        @NotNull
        public Color getDefaultForeground() {
            Color color = this.tuneColor(super.getDefaultForeground());
            if (color == null) {
                ColorsSchemeWithChangedSaturation.$$$reportNull$$$0(2);
            }
            return color;
        }

        @Nullable
        public Color getColor(ColorKey key) {
            Color color = super.getColor(key);
            return color != null ? this.tuneColor(color) : null;
        }

        public void setColor(ColorKey key, @Nullable Color color) {
            super.setColor(key, color != null ? this.tuneColor(color) : null);
        }

        public TextAttributes getAttributes(TextAttributesKey key) {
            return this.tuneAttributes(super.getAttributes(key));
        }

        public void setAttributes(@NotNull TextAttributesKey key, TextAttributes attributes) {
            if (key == null) {
                ColorsSchemeWithChangedSaturation.$$$reportNull$$$0(3);
            }
            super.setAttributes(key, this.tuneAttributes(attributes));
        }

        private Color tuneColor(Color color) {
            return HtmlSyntaxInfoUtil.tuneSaturationEspeciallyGrey(color, 1, this.mySaturationFactor);
        }

        private TextAttributes tuneAttributes(TextAttributes attributes) {
            if (attributes != null) {
                attributes = attributes.clone();
                Color foregroundColor = attributes.getForegroundColor();
                Color backgroundColor = attributes.getBackgroundColor();
                if (foregroundColor != null) {
                    attributes.setForegroundColor(this.tuneColor(foregroundColor));
                }
                if (backgroundColor != null) {
                    attributes.setBackgroundColor(this.tuneColor(backgroundColor));
                }
            }
            return attributes;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "delegate";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/editor/richcopy/HtmlSyntaxInfoUtil$ColorsSchemeWithChangedSaturation";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "key";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/editor/richcopy/HtmlSyntaxInfoUtil$ColorsSchemeWithChangedSaturation";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDefaultBackground";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDefaultForeground";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "setAttributes";
                    break;
                }
            }
            String string2 = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string2);
                case 1, 2 -> new IllegalStateException(string2);
            };
        }
    }

    private static final class SimpleHtmlSyntaxInfoReader
    extends HtmlSyntaxInfoReader {
        private SimpleHtmlSyntaxInfoReader(SyntaxInfo info2) {
            super(info2, 2);
        }

        @Override
        protected void appendCloseTags() {
        }

        @Override
        protected void appendStartTags() {
        }

        @Override
        protected void defineBackground(int id, @NotNull StringBuilder styleBuffer) {
            if (styleBuffer == null) {
                SimpleHtmlSyntaxInfoReader.$$$reportNull$$$0(0);
            }
        }

        @Override
        protected void appendFontFamilyRule(@NotNull StringBuilder styleBuffer, int fontFamilyId) {
            if (styleBuffer == null) {
                SimpleHtmlSyntaxInfoReader.$$$reportNull$$$0(1);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "styleBuffer";
            objectArray2[1] = "com/intellij/openapi/editor/richcopy/HtmlSyntaxInfoUtil$SimpleHtmlSyntaxInfoReader";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "defineBackground";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "appendFontFamilyRule";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

