/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.richcopy.model;

import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractRegistry<T> {
    @NotNull
    private final Int2ObjectOpenHashMap<T> myDataById = new Int2ObjectOpenHashMap();
    private transient Object2IntMap<T> myIdsByData = new Object2IntOpenHashMap<T>();

    @NotNull
    public T dataById(int id) throws IllegalArgumentException {
        T result2 = this.myDataById.get(id);
        if (result2 == null) {
            throw new IllegalArgumentException("No data is registered for id " + id);
        }
        T t = result2;
        if (t == null) {
            AbstractRegistry.$$$reportNull$$$0(0);
        }
        return t;
    }

    public int getId(@NotNull T data2) throws IllegalStateException {
        if (data2 == null) {
            AbstractRegistry.$$$reportNull$$$0(1);
        }
        if (this.myIdsByData == null) {
            throw new IllegalStateException(String.format("Can't register data '%s'. Reason: the %s registry is already sealed", data2, this.getClass().getName()));
        }
        int id = this.myIdsByData.getInt(data2);
        if (id <= 0) {
            id = this.myIdsByData.size() + 1;
            this.myDataById.put(id, data2);
            this.myIdsByData.put(data2, id);
        }
        return id;
    }

    public int[] getAllIds() {
        int[] result2 = this.myDataById.keySet().toIntArray();
        Arrays.sort(result2);
        return result2;
    }

    public int size() {
        return this.myDataById.size();
    }

    public void seal() {
        this.myIdsByData = null;
        this.myDataById.trim();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/editor/richcopy/model/AbstractRegistry";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "dataById";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/editor/richcopy/model/AbstractRegistry";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getId";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string2);
            case 1 -> new IllegalArgumentException(string2);
        };
    }
}

