/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.richcopy.view;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.richcopy.model.SyntaxInfo;
import com.intellij.openapi.editor.richcopy.view.RawTextWithMarkup;
import com.intellij.openapi.util.registry.Registry;
import java.awt.datatransfer.DataFlavor;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class AbstractSyntaxAwareInputStreamTransferableData
extends InputStream
implements RawTextWithMarkup {
    private static final Logger LOG = Logger.getInstance(AbstractSyntaxAwareInputStreamTransferableData.class);
    String myRawText;
    @NotNull
    final SyntaxInfo mySyntaxInfo;
    @NotNull
    private final DataFlavor myDataFlavor;
    @Nullable
    private transient InputStream myDelegate;

    AbstractSyntaxAwareInputStreamTransferableData(@NotNull SyntaxInfo syntaxInfo, @NotNull DataFlavor flavor) {
        if (syntaxInfo == null) {
            AbstractSyntaxAwareInputStreamTransferableData.$$$reportNull$$$0(0);
        }
        if (flavor == null) {
            AbstractSyntaxAwareInputStreamTransferableData.$$$reportNull$$$0(1);
        }
        this.mySyntaxInfo = syntaxInfo;
        this.myDataFlavor = flavor;
    }

    @Nullable
    public DataFlavor getFlavor() {
        return this.myDataFlavor;
    }

    @Override
    public int read() throws IOException {
        return this.getDelegate().read();
    }

    @Override
    public int read(byte @NotNull [] b, int off, int len) throws IOException {
        if (b == null) {
            AbstractSyntaxAwareInputStreamTransferableData.$$$reportNull$$$0(2);
        }
        return this.getDelegate().read(b, off, len);
    }

    @Override
    public void close() throws IOException {
        this.myDelegate = null;
    }

    @Override
    public void setRawText(String rawText) {
        this.myRawText = rawText;
    }

    @NotNull
    private InputStream getDelegate() {
        if (this.myDelegate != null) {
            InputStream inputStream = this.myDelegate;
            if (inputStream == null) {
                AbstractSyntaxAwareInputStreamTransferableData.$$$reportNull$$$0(3);
            }
            return inputStream;
        }
        int maxLength = Registry.intValue("editor.richcopy.max.size.megabytes") * 0x100000;
        StringBuilder buffer = new StringBuilder();
        try {
            this.build(buffer, maxLength);
        }
        catch (Exception e) {
            LOG.error(e);
        }
        String s = buffer.toString();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Resulting text: \n" + s);
        }
        try {
            this.myDelegate = new ByteArrayInputStream(s.getBytes(this.getCharset()));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        InputStream inputStream = this.myDelegate;
        if (inputStream == null) {
            AbstractSyntaxAwareInputStreamTransferableData.$$$reportNull$$$0(4);
        }
        return inputStream;
    }

    protected abstract void build(@NotNull StringBuilder var1, int var2);

    @NotNull
    protected abstract String getCharset();

    @Override
    public synchronized void mark(int readlimit) {
        this.getDelegate().mark(readlimit);
    }

    @Override
    public synchronized void reset() throws IOException {
        this.getDelegate().reset();
    }

    @Override
    public boolean markSupported() {
        return this.getDelegate().markSupported();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "syntaxInfo";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "flavor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "b";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/editor/richcopy/view/AbstractSyntaxAwareInputStreamTransferableData";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/editor/richcopy/view/AbstractSyntaxAwareInputStreamTransferableData";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getDelegate";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "read";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 3, 4 -> new IllegalStateException(string2);
        };
    }
}

