/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileEditor;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.EditorDataProvider;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorComposite;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.fileEditor.FileEditorNavigatable;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import java.awt.Color;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.border.Border;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class FileEditorManager {
    public static final Key<Boolean> USE_CURRENT_WINDOW = Key.create("OpenFile.searchForOpen");
    public static final Key<Boolean> SEPARATOR_DISABLED = Key.create("FileEditorSeparatorDisabled");
    public static final Key<Border> SEPARATOR_BORDER = Key.create("FileEditorSeparatorBorder");
    public static final Key<Color> SEPARATOR_COLOR = Key.create("FileEditorSeparatorColor");

    public static FileEditorManager getInstance(@NotNull Project project2) {
        if (project2 == null) {
            FileEditorManager.$$$reportNull$$$0(0);
        }
        return project2.getService(FileEditorManager.class);
    }

    @Nullable
    public abstract FileEditorComposite getComposite(@NotNull VirtualFile var1);

    public abstract FileEditor @NotNull [] openFile(@NotNull VirtualFile var1, boolean var2);

    @NotNull
    public abstract @NotNull List<@NotNull FileEditor> openFile(@NotNull VirtualFile var1);

    public FileEditor @NotNull [] openFile(@NotNull VirtualFile file2, boolean focusEditor, boolean searchForOpen) {
        if (file2 == null) {
            FileEditorManager.$$$reportNull$$$0(1);
        }
        throw new UnsupportedOperationException("Not implemented");
    }

    public abstract void closeFile(@NotNull VirtualFile var1);

    @Nullable
    public abstract Editor openTextEditor(@NotNull OpenFileDescriptor var1, boolean var2);

    @Deprecated(forRemoval=true)
    public void navigateToTextEditor(@NotNull OpenFileDescriptor descriptor2, boolean focusEditor) {
        if (descriptor2 == null) {
            FileEditorManager.$$$reportNull$$$0(2);
        }
        this.openTextEditor(descriptor2, focusEditor);
    }

    @RequiresEdt
    @Nullable
    public abstract Editor getSelectedTextEditor();

    @ApiStatus.Experimental
    public Editor @NotNull [] getSelectedTextEditorWithRemotes() {
        Editor[] editorArray;
        Editor editor2 = this.getSelectedTextEditor();
        if (editor2 != null) {
            Editor[] editorArray2 = new Editor[1];
            editorArray = editorArray2;
            editorArray2[0] = editor2;
        } else {
            editorArray = Editor.EMPTY_ARRAY;
        }
        if (editorArray == null) {
            FileEditorManager.$$$reportNull$$$0(3);
        }
        return editorArray;
    }

    public abstract boolean isFileOpen(@NotNull VirtualFile var1);

    @ApiStatus.Experimental
    public boolean isFileOpenWithRemotes(@NotNull VirtualFile file2) {
        if (file2 == null) {
            FileEditorManager.$$$reportNull$$$0(4);
        }
        return this.isFileOpen(file2);
    }

    public abstract VirtualFile @NotNull [] getOpenFiles();

    @ApiStatus.Experimental
    @NotNull
    public abstract List<VirtualFile> getOpenFilesWithRemotes();

    public boolean hasOpenFiles() {
        return this.getOpenFiles().length > 0;
    }

    public abstract VirtualFile @NotNull [] getSelectedFiles();

    public abstract FileEditor @NotNull [] getSelectedEditors();

    @ApiStatus.Experimental
    public FileEditor @NotNull [] getSelectedEditorWithRemotes() {
        FileEditor[] fileEditorArray = this.getSelectedEditors();
        if (fileEditorArray == null) {
            FileEditorManager.$$$reportNull$$$0(5);
        }
        return fileEditorArray;
    }

    @Nullable
    public FileEditor getSelectedEditor() {
        VirtualFile[] files2 = this.getSelectedFiles();
        return files2.length == 0 ? null : this.getSelectedEditor(files2[0]);
    }

    @Nullable
    public abstract FileEditor getSelectedEditor(@NotNull VirtualFile var1);

    public abstract FileEditor @NotNull [] getEditors(@NotNull VirtualFile var1);

    public abstract FileEditor @NotNull [] getAllEditors(@NotNull VirtualFile var1);

    public abstract FileEditor @NotNull [] getAllEditors();

    public abstract void addTopComponent(@NotNull FileEditor var1, @NotNull JComponent var2);

    public abstract void removeTopComponent(@NotNull FileEditor var1, @NotNull JComponent var2);

    public abstract void addBottomComponent(@NotNull FileEditor var1, @NotNull JComponent var2);

    public abstract void removeBottomComponent(@NotNull FileEditor var1, @NotNull JComponent var2);

    @Deprecated
    public void addFileEditorManagerListener(@NotNull FileEditorManagerListener listener2) {
        if (listener2 == null) {
            FileEditorManager.$$$reportNull$$$0(6);
        }
    }

    @Deprecated
    public void removeFileEditorManagerListener(@NotNull FileEditorManagerListener listener2) {
        if (listener2 == null) {
            FileEditorManager.$$$reportNull$$$0(7);
        }
    }

    @NotNull
    public final List<FileEditor> openEditor(@NotNull OpenFileDescriptor descriptor2, boolean focusEditor) {
        if (descriptor2 == null) {
            FileEditorManager.$$$reportNull$$$0(8);
        }
        List<FileEditor> list2 = this.openFileEditor(descriptor2, focusEditor);
        if (list2 == null) {
            FileEditorManager.$$$reportNull$$$0(9);
        }
        return list2;
    }

    @NotNull
    public abstract List<FileEditor> openFileEditor(@NotNull FileEditorNavigatable var1, boolean var2);

    @NotNull
    public abstract Project getProject();

    public abstract void registerExtraEditorDataProvider(@NotNull EditorDataProvider var1, @Nullable Disposable var2);

    @Nullable
    public abstract Object getData(@NotNull String var1, @NotNull Editor var2, @NotNull Caret var3);

    public abstract void setSelectedEditor(@NotNull VirtualFile var1, @NotNull String var2);

    public abstract void runWhenLoaded(@NotNull Editor var1, @NotNull Runnable var2);

    public void updateFilePresentation(@NotNull VirtualFile file2) {
        if (file2 == null) {
            FileEditorManager.$$$reportNull$$$0(10);
        }
    }

    public void updateFileColor(@NotNull VirtualFile file2) {
        if (file2 == null) {
            FileEditorManager.$$$reportNull$$$0(11);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 5, 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 3: 
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/fileEditor/FileEditorManager";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/fileEditor/FileEditorManager";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedTextEditorWithRemotes";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedEditorWithRemotes";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "openEditor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "openFile";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "navigateToTextEditor";
                break;
            }
            case 3: 
            case 5: 
            case 9: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isFileOpenWithRemotes";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "addFileEditorManagerListener";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "removeFileEditorManagerListener";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "openEditor";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "updateFilePresentation";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "updateFileColor";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 3, 5, 9 -> new IllegalStateException(string2);
        };
    }
}

