/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileEditor.impl;

import com.intellij.analysis.AnalysisBundle;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.util.IntentionFamilyName;
import com.intellij.codeStyle.AbstractConvertLineSeparatorsAction;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.impl.LoadTextUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class InconsistentLineSeparatorsInspection
extends LocalInspectionTool {
    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            InconsistentLineSeparatorsInspection.$$$reportNull$$$0(0);
        }
        return new PsiElementVisitor(){

            @Override
            public void visitFile(@NotNull PsiFile file2) {
                if (file2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (!file2.getLanguage().equals(file2.getViewProvider().getBaseLanguage())) {
                    return;
                }
                VirtualFile virtualFile2 = file2.getVirtualFile();
                if (virtualFile2 == null || !AbstractConvertLineSeparatorsAction.shouldProcess((VirtualFile)virtualFile2)) {
                    return;
                }
                Project project2 = holder.getProject();
                String projectLineSeparator = FileDocumentManager.getInstance().getLineSeparator(null, project2);
                Set<String> allLineSeparators = LoadTextUtil.detectAllLineSeparators(virtualFile2);
                if (allLineSeparators.size() > 1 || !allLineSeparators.isEmpty() && !allLineSeparators.contains(projectLineSeparator)) {
                    List<String> allSorted = ContainerUtil.sorted(allLineSeparators);
                    String presentableSeparators = StringUtil.join(allSorted, sep -> StringUtil.escapeStringCharacters(sep), ", ");
                    holder.registerProblem((PsiElement)file2, AnalysisBundle.message("inspection.message.line.separators.in.current.file.differ.from.project.defaults", presentableSeparators, StringUtil.escapeStringCharacters(projectLineSeparator)), new ChangeLineSeparatorFix());
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/fileEditor/impl/InconsistentLineSeparatorsInspection$1", "visitFile"));
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/openapi/fileEditor/impl/InconsistentLineSeparatorsInspection", "buildVisitor"));
    }

    private static class ChangeLineSeparatorFix
    implements LocalQuickFix {
        private ChangeLineSeparatorFix() {
        }

        @Override
        @NotNull
        @IntentionFamilyName
        public String getFamilyName() {
            String string2 = AnalysisBundle.message("intention.family.name.convert.to.project.line.separators", new Object[0]);
            if (string2 == null) {
                ChangeLineSeparatorFix.$$$reportNull$$$0(0);
            }
            return string2;
        }

        @Override
        public void applyFix(@NotNull Project project2, @NotNull ProblemDescriptor descriptor2) {
            PsiElement psiElement;
            if (project2 == null) {
                ChangeLineSeparatorFix.$$$reportNull$$$0(1);
            }
            if (descriptor2 == null) {
                ChangeLineSeparatorFix.$$$reportNull$$$0(2);
            }
            if (!((psiElement = descriptor2.getPsiElement()) instanceof PsiFile)) {
                return;
            }
            String lineSeparator = FileDocumentManager.getInstance().getLineSeparator(null, project2);
            VirtualFile virtualFile2 = ((PsiFile)psiElement).getVirtualFile();
            if (virtualFile2 != null) {
                AbstractConvertLineSeparatorsAction.changeLineSeparators((Project)project2, (VirtualFile)virtualFile2, (String)lineSeparator);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/fileEditor/impl/InconsistentLineSeparatorsInspection$ChangeLineSeparatorFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/fileEditor/impl/InconsistentLineSeparatorsInspection$ChangeLineSeparatorFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string2);
                case 1, 2 -> new IllegalArgumentException(string2);
            };
        }
    }
}

