/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileEditor.impl;

import com.intellij.ide.PowerSaveMode;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.fileEditor.impl.EditorWindow;
import com.intellij.openapi.fileEditor.impl.FileEditorManagerImpl;
import com.intellij.openapi.fileEditor.impl.text.TextEditorPsiDataProvider;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.problems.ProblemListener;
import com.intellij.problems.WolfTheProblemSolver;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import com.intellij.util.ui.EdtInvocationManager;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001:\u0001\u0016B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0010\u001a\u00020\u0011H\u0016R#\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\f\u0010\r\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0017"}, d2={"Lcom/intellij/openapi/fileEditor/impl/PsiAwareFileEditorManagerImpl;", "Lcom/intellij/openapi/fileEditor/impl/FileEditorManagerImpl;", "project", "Lcom/intellij/openapi/project/Project;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "(Lcom/intellij/openapi/project/Project;Lkotlinx/coroutines/CoroutineScope;)V", "problemSolver", "Lcom/intellij/problems/WolfTheProblemSolver;", "kotlin.jvm.PlatformType", "getProblemSolver", "()Lcom/intellij/problems/WolfTheProblemSolver;", "problemSolver$delegate", "Lkotlin/Lazy;", "getFileTooltipText", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "window", "Lcom/intellij/openapi/fileEditor/impl/EditorWindow;", "isProblem", "", "MyProblemListener", "intellij.platform.lang.impl"})
public class PsiAwareFileEditorManagerImpl
extends FileEditorManagerImpl {
    @NotNull
    private final Lazy problemSolver$delegate;

    public PsiAwareFileEditorManagerImpl(@NotNull Project project2, @NotNull CoroutineScope coroutineScope) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        super(project2, coroutineScope);
        this.problemSolver$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, (Function0)((Function0)new Function0<WolfTheProblemSolver>(this){
            final /* synthetic */ PsiAwareFileEditorManagerImpl this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final WolfTheProblemSolver invoke() {
                return WolfTheProblemSolver.getInstance(this.this$0.getProject());
            }
        }));
        this.registerExtraEditorDataProvider(new TextEditorPsiDataProvider(), null);
        MessageBusConnection connection = project2.getMessageBus().connect((Disposable)((Object)this));
        Topic<PowerSaveMode.Listener> topic = PowerSaveMode.TOPIC;
        Intrinsics.checkNotNullExpressionValue(topic, (String)"TOPIC");
        connection.subscribe(topic, PsiAwareFileEditorManagerImpl::_init_$lambda$1);
        Topic<ProblemListener> topic2 = ProblemListener.TOPIC;
        Intrinsics.checkNotNullExpressionValue(topic2, (String)"TOPIC");
        connection.subscribe(topic2, new MyProblemListener());
    }

    private final WolfTheProblemSolver getProblemSolver() {
        Lazy lazy = this.problemSolver$delegate;
        return (WolfTheProblemSolver)lazy.getValue();
    }

    public boolean isProblem(@NotNull VirtualFile file2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        return this.getProblemSolver().isProblemFile(file2);
    }

    @NotNull
    public String getFileTooltipText(@NotNull VirtualFile file2, @NotNull EditorWindow window) {
        Module module2;
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Intrinsics.checkNotNullParameter((Object)window, (String)"window");
        StringBuilder tooltipText = new StringBuilder();
        if (Registry.is("ide.tab.tooltip.module", false) && (module2 = ModuleUtilCore.findModuleForFile(file2, this.getProject())) != null && ModuleManager.Companion.getInstance(this.getProject()).getModules().length > 1) {
            tooltipText.append('[');
            tooltipText.append(module2.getName());
            tooltipText.append("] ");
        }
        tooltipText.append(super.getFileTooltipText(file2, window));
        String string2 = tooltipText.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"tooltipText.toString()");
        return string2;
    }

    private static final void lambda$1$lambda$0() {
        Editor[] editorArray = EditorFactory.getInstance().getAllEditors();
        Intrinsics.checkNotNullExpressionValue((Object)editorArray, (String)"getInstance().allEditors");
        for (Editor editor2 : editorArray) {
            Intrinsics.checkNotNull((Object)editor2, (String)"null cannot be cast to non-null type com.intellij.openapi.editor.ex.EditorEx");
            ((EditorEx)editor2).reinitSettings();
        }
    }

    private static final void _init_$lambda$1() {
        EdtInvocationManager.invokeLaterIfNeeded(PsiAwareFileEditorManagerImpl::lambda$1$lambda$0);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u00a8\u0006\n"}, d2={"Lcom/intellij/openapi/fileEditor/impl/PsiAwareFileEditorManagerImpl$MyProblemListener;", "Lcom/intellij/problems/ProblemListener;", "(Lcom/intellij/openapi/fileEditor/impl/PsiAwareFileEditorManagerImpl;)V", "problemsAppeared", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "problemsChanged", "problemsDisappeared", "updateFile", "intellij.platform.lang.impl"})
    private final class MyProblemListener
    implements ProblemListener {
        @Override
        public void problemsAppeared(@NotNull VirtualFile file2) {
            Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
            this.updateFile(file2);
        }

        @Override
        public void problemsDisappeared(@NotNull VirtualFile file2) {
            Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
            this.updateFile(file2);
        }

        @Override
        public void problemsChanged(@NotNull VirtualFile file2) {
            Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
            this.updateFile(file2);
        }

        private final void updateFile(VirtualFile file2) {
            PsiAwareFileEditorManagerImpl.this.queueUpdateFile(file2);
        }
    }
}

