/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileEditor.impl;

import com.intellij.codeInsight.intention.preview.IntentionPreviewUtils;
import com.intellij.codeWithMe.ClientId;
import com.intellij.ide.highlighter.HighlighterFactory;
import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.client.ClientKind;
import com.intellij.openapi.client.ClientProjectSession;
import com.intellij.openapi.client.ClientSessionsManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.fileEditor.ClientFileEditorManager;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorComposite;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerEvent;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.fileEditor.FileEditorNavigatable;
import com.intellij.openapi.fileEditor.FileEditorPolicy;
import com.intellij.openapi.fileEditor.FileEditorProvider;
import com.intellij.openapi.fileEditor.FileEditorState;
import com.intellij.openapi.fileEditor.NavigatableFileEditor;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileEditor.ex.FileEditorManagerEx;
import com.intellij.openapi.fileEditor.ex.FileEditorWithProvider;
import com.intellij.openapi.fileEditor.impl.EditorComposite;
import com.intellij.openapi.fileEditor.impl.EditorWindow;
import com.intellij.openapi.fileEditor.impl.EditorsSplitters;
import com.intellij.openapi.fileEditor.impl.FileEditorOpenOptions;
import com.intellij.openapi.fileEditor.impl.TestEditorComposite;
import com.intellij.openapi.fileEditor.impl.TestEditorManagerImpl;
import com.intellij.openapi.fileEditor.impl.TestEditorSplitter;
import com.intellij.openapi.fileEditor.impl.text.TextEditorImpl;
import com.intellij.openapi.fileEditor.impl.text.TextEditorProvider;
import com.intellij.openapi.fileEditor.impl.text.TextEditorPsiDataProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectCloseListener;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileDeleteEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.pom.Navigatable;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlinx.coroutines.flow.StateFlow;
import kotlinx.coroutines.flow.StateFlowKt;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u00dc\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\t\b\u0000\u0018\u0000 \u0087\u00012\u00020\u00012\u00020\u0002:\u0004\u0087\u0001\u0088\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0018\u0010>\u001a\u00020?2\u0006\u0010@\u001a\u00020 2\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0018\u0010A\u001a\u00020?2\u0006\u0010@\u001a\u00020 2\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\b\u0010B\u001a\u00020?H\u0016J\b\u0010C\u001a\u00020?H\u0016J\u0010\u0010D\u001a\u00020?2\u0006\u0010E\u001a\u00020\u0007H\u0016J\u0018\u0010D\u001a\u00020?2\u0006\u0010E\u001a\u00020\u00072\u0006\u0010F\u001a\u00020\nH\u0016J\b\u0010G\u001a\u00020HH\u0002J\u001a\u0010I\u001a\u00020?2\u0006\u0010J\u001a\u00020\u001a2\b\u0010F\u001a\u0004\u0018\u00010\nH\u0016J\b\u0010K\u001a\u00020?H\u0016J\u0010\u0010L\u001a\u0002062\u0006\u0010M\u001a\u00020NH\u0002J\b\u0010O\u001a\u00020PH\u0002J\u0013\u0010Q\u001a\b\u0012\u0004\u0012\u00020 0;H\u0016\u00a2\u0006\u0002\u0010RJ\u001b\u0010Q\u001a\b\u0012\u0004\u0012\u00020 0;2\u0006\u0010E\u001a\u00020\u0007H\u0016\u00a2\u0006\u0002\u0010SJ\u0012\u0010T\u001a\u0004\u0018\u00010U2\u0006\u0010E\u001a\u00020\u0007H\u0016J\u0010\u0010V\u001a\u0004\u0018\u0001062\u0006\u0010E\u001a\u00020\u0007J\u001b\u0010W\u001a\b\u0012\u0004\u0012\u00020 0;2\u0006\u0010E\u001a\u00020\u0007H\u0016\u00a2\u0006\u0002\u0010SJ(\u0010X\u001a\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020 0;\u0012\n\u0012\b\u0012\u0004\u0012\u00020Z0;0Y2\u0006\u0010E\u001a\u00020\u0007H\u0016J\u0012\u0010[\u001a\u0004\u0018\u00010\n2\u0006\u0010F\u001a\u00020\nH\u0016J\u0013\u0010\\\u001a\b\u0012\u0004\u0012\u00020\u00070;H\u0016\u00a2\u0006\u0002\u0010]J\u000e\u0010^\u001a\b\u0012\u0004\u0012\u00020\u00070\u000eH\u0016J\u0012\u0010_\u001a\u0004\u0018\u00010\n2\u0006\u0010F\u001a\u00020\nH\u0016J\b\u0010`\u001a\u00020\u0004H\u0016J\u0012\u0010a\u001a\u0004\u0018\u00010b2\u0006\u0010E\u001a\u00020\u0007H\u0016J\u0013\u0010c\u001a\b\u0012\u0004\u0012\u00020 0;H\u0016\u00a2\u0006\u0002\u0010RJ\u0013\u0010d\u001a\b\u0012\u0004\u0012\u00020 0;H\u0016\u00a2\u0006\u0002\u0010RJ\u0013\u0010e\u001a\b\u0012\u0004\u0012\u00020\u00070;H\u0016\u00a2\u0006\u0002\u0010]J\n\u0010f\u001a\u0004\u0018\u000106H\u0016J\u0013\u0010g\u001a\b\u0012\u0004\u0012\u0002060;H\u0016\u00a2\u0006\u0002\u0010hJ\u0016\u0010i\u001a\b\u0012\u0004\u0012\u00020\u00070\u000e2\u0006\u0010E\u001a\u00020\u0007H\u0016J\u0012\u0010j\u001a\u0004\u0018\u00010/2\u0006\u0010\u0015\u001a\u00020kH\u0016J\b\u0010l\u001a\u00020*H\u0016J\b\u0010m\u001a\u00020*H\u0016J\u0010\u0010n\u001a\u00020*2\u0006\u0010@\u001a\u00020oH\u0016J\u0010\u0010p\u001a\u00020*2\u0006\u0010E\u001a\u00020\u0007H\u0016J\u0010\u0010q\u001a\u00020*2\u0006\u0010E\u001a\u00020\u0007H\u0016J\u0010\u0010r\u001a\u00020?2\u0006\u0010s\u001a\u00020tH\u0002J\u0010\u0010u\u001a\u00020?2\u0006\u0010v\u001a\u00020tH\u0016J\"\u0010w\u001a\u00020U2\u0006\u0010E\u001a\u00020\u00072\b\u0010F\u001a\u0004\u0018\u00010\n2\u0006\u0010x\u001a\u00020yH\u0016J\u001e\u0010z\u001a\b\u0012\u0004\u0012\u00020 0\u000e2\u0006\u0010M\u001a\u00020N2\u0006\u0010{\u001a\u00020*H\u0016J(\u0010|\u001a\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020 0;\u0012\n\u0012\b\u0012\u0004\u0012\u00020Z0;0Y2\u0006\u0010}\u001a\u00020NH\u0002J\u0010\u0010~\u001a\u00020U2\u0006\u0010M\u001a\u00020NH\u0002J\u001b\u0010\u007f\u001a\u0004\u0018\u0001062\u0007\u0010M\u001a\u00030\u0080\u00012\u0006\u0010{\u001a\u00020*H\u0016J\u0019\u0010\u0081\u0001\u001a\u00020?2\u0006\u0010@\u001a\u00020 2\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0019\u0010\u0082\u0001\u001a\u00020?2\u0006\u0010@\u001a\u00020 2\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u001a\u0010\u0083\u0001\u001a\u00020?2\u0006\u0010E\u001a\u00020\u00072\u0007\u0010\u0084\u0001\u001a\u00020HH\u0016J\t\u0010\u0085\u0001\u001a\u00020?H\u0016J\t\u0010\u0086\u0001\u001a\u00020?H\u0016R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\n0\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u001a\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0016\u0010\u0012\u001a\u0004\u0018\u00010\u000f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0016\u0010\u0015\u001a\u0004\u0018\u00010\u00168VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u001b\u001a\u0004\u0018\u00010\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001dR\u001c\u0010\u001e\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010 0\u001f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"R(\u0010$\u001a\u0004\u0018\u00010\n2\b\u0010#\u001a\u0004\u0018\u00010\n8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b%\u0010&\"\u0004\b'\u0010(R\u0014\u0010)\u001a\u00020*8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b)\u0010+R\u0016\u0010,\u001a\u0004\u0018\u00010\u00168VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b-\u0010\u0018R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010.\u001a\u00020/8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b0\u00101R\u000e\u00102\u001a\u000203X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u00104\u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0006\u0012\u0004\u0018\u00010605X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u00107\u001a\u00020\u001a8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b8\u00109R\u001a\u0010:\u001a\b\u0012\u0004\u0012\u00020\n0;8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b<\u0010=\u00a8\u0006\u0089\u0001"}, d2={"Lcom/intellij/openapi/fileEditor/impl/TestEditorManagerImpl;", "Lcom/intellij/openapi/fileEditor/ex/FileEditorManagerEx;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "activeFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "activeWindow", "Ljava/util/concurrent/CompletableFuture;", "Lcom/intellij/openapi/fileEditor/impl/EditorWindow;", "getActiveWindow", "()Ljava/util/concurrent/CompletableFuture;", "allClientFileEditorManagers", "", "Lcom/intellij/openapi/fileEditor/ClientFileEditorManager;", "getAllClientFileEditorManagers", "()Ljava/util/List;", "clientFileEditorManager", "getClientFileEditorManager", "()Lcom/intellij/openapi/fileEditor/ClientFileEditorManager;", "component", "Ljavax/swing/JComponent;", "getComponent", "()Ljavax/swing/JComponent;", "counter", "", "currentFile", "getCurrentFile", "()Lcom/intellij/openapi/vfs/VirtualFile;", "currentFileEditorFlow", "Lkotlinx/coroutines/flow/StateFlow;", "Lcom/intellij/openapi/fileEditor/FileEditor;", "getCurrentFileEditorFlow", "()Lkotlinx/coroutines/flow/StateFlow;", "<anonymous parameter 0>", "currentWindow", "getCurrentWindow", "()Lcom/intellij/openapi/fileEditor/impl/EditorWindow;", "setCurrentWindow", "(Lcom/intellij/openapi/fileEditor/impl/EditorWindow;)V", "isInSplitter", "", "()Z", "preferredFocusedComponent", "getPreferredFocusedComponent", "splitters", "Lcom/intellij/openapi/fileEditor/impl/EditorsSplitters;", "getSplitters", "()Lcom/intellij/openapi/fileEditor/impl/EditorsSplitters;", "testEditorSplitter", "Lcom/intellij/openapi/fileEditor/impl/TestEditorSplitter;", "virtualFileToEditor", "Ljava/util/HashMap;", "Lcom/intellij/openapi/editor/Editor;", "windowSplitCount", "getWindowSplitCount", "()I", "windows", "", "getWindows", "()[Lcom/intellij/openapi/fileEditor/impl/EditorWindow;", "addBottomComponent", "", "editor", "addTopComponent", "changeSplitterOrientation", "closeAllFiles", "closeFile", "file", "window", "createNewTabbedContainerName", "", "createSplitter", "orientation", "dispose", "doOpenTextEditor", "descriptor", "Lcom/intellij/openapi/fileEditor/FileEditorNavigatable;", "eventPublisher", "Lcom/intellij/openapi/fileEditor/FileEditorManagerListener;", "getAllEditors", "()[Lcom/intellij/openapi/fileEditor/FileEditor;", "(Lcom/intellij/openapi/vfs/VirtualFile;)[Lcom/intellij/openapi/fileEditor/FileEditor;", "getComposite", "Lcom/intellij/openapi/fileEditor/FileEditorComposite;", "getEditor", "getEditors", "getEditorsWithProviders", "Lcom/intellij/openapi/util/Pair;", "Lcom/intellij/openapi/fileEditor/FileEditorProvider;", "getNextWindow", "getOpenFiles", "()[Lcom/intellij/openapi/vfs/VirtualFile;", "getOpenFilesWithRemotes", "getPrevWindow", "getProject", "getSelectedEditorWithProvider", "Lcom/intellij/openapi/fileEditor/ex/FileEditorWithProvider;", "getSelectedEditorWithRemotes", "getSelectedEditors", "getSelectedFiles", "getSelectedTextEditor", "getSelectedTextEditorWithRemotes", "()[Lcom/intellij/openapi/editor/Editor;", "getSiblings", "getSplittersFor", "Ljava/awt/Component;", "hasOpenedFile", "hasSplitOrUndockedWindows", "isChanged", "Lcom/intellij/openapi/fileEditor/impl/EditorComposite;", "isFileOpen", "isFileOpenWithRemotes", "modifyTabWell", "tabWellModification", "Ljava/lang/Runnable;", "notifyPublisher", "runnable", "openFile", "options", "Lcom/intellij/openapi/fileEditor/impl/FileEditorOpenOptions;", "openFileEditor", "focusEditor", "openFileImpl3", "openFileDescriptor", "openFileInCommand", "openTextEditor", "Lcom/intellij/openapi/fileEditor/OpenFileDescriptor;", "removeBottomComponent", "removeTopComponent", "setSelectedEditor", "fileEditorProviderId", "unsplitAllWindow", "unsplitWindow", "Companion", "MyLightVirtualFile", "intellij.platform.lang.impl"})
@SourceDebugExtension(value={"SMAP\nTestEditorManagerImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TestEditorManagerImpl.kt\ncom/intellij/openapi/fileEditor/impl/TestEditorManagerImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 4 ArrayIntrinsics.kt\nkotlin/ArrayIntrinsicsKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 6 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,517:1\n1549#2:518\n1620#2,3:519\n1549#2:524\n1620#2,3:525\n1747#2,3:533\n1603#2,9:544\n1855#2:553\n1856#2:555\n1612#2:556\n37#3,2:522\n37#3,2:528\n37#3,2:531\n37#3,2:536\n37#3,2:538\n37#3,2:540\n37#3,2:542\n37#3,2:557\n26#4:530\n1#5:554\n1#5:559\n10#6:560\n*S KotlinDebug\n*F\n+ 1 TestEditorManagerImpl.kt\ncom/intellij/openapi/fileEditor/impl/TestEditorManagerImpl\n*L\n113#1:518\n113#1:519,3\n114#1:524\n114#1:525,3\n290#1:533,3\n398#1:544,9\n398#1:553\n398#1:555\n398#1:556\n113#1:522,2\n114#1:528,2\n275#1:531,2\n352#1:536,2\n359#1:538,2\n380#1:540,2\n388#1:542,2\n405#1:557,2\n267#1:530\n398#1:554\n48#1:560\n*E\n"})
public final class TestEditorManagerImpl
extends FileEditorManagerEx
implements Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final TestEditorSplitter testEditorSplitter;
    private int counter;
    @NotNull
    private final HashMap<VirtualFile, Editor> virtualFileToEditor;
    @Nullable
    private VirtualFile activeFile;
    @NotNull
    private static final Logger LOG;
    @NotNull
    private static final MyLightVirtualFile LIGHT_VIRTUAL_FILE;

    public TestEditorManagerImpl(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        this.project = project2;
        this.testEditorSplitter = new TestEditorSplitter();
        this.virtualFileToEditor = new HashMap();
        this.registerExtraEditorDataProvider(new TextEditorPsiDataProvider(), null);
        ApplicationManager.getApplication().getMessageBus().connect(this).subscribe(ProjectCloseListener.TOPIC, new ProjectCloseListener(){

            @Override
            public void projectClosed(@NotNull Project project2) {
                Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
                if (project == project2) {
                    this.closeAllFiles();
                }
            }
        });
        MessageBusConnection messageBusConnection = this.project.getMessageBus().connect(this);
        Topic<BulkFileListener> topic = VirtualFileManager.VFS_CHANGES;
        Intrinsics.checkNotNullExpressionValue(topic, (String)"VFS_CHANGES");
        messageBusConnection.subscribe(topic, new BulkFileListener(){

            @Override
            public void before(@NotNull List<? extends VFileEvent> events) {
                Intrinsics.checkNotNullParameter(events, (String)"events");
                for (VFileEvent vFileEvent : events) {
                    if (!(vFileEvent instanceof VFileDeleteEvent)) continue;
                    for (VirtualFile file2 : this.getOpenFiles()) {
                        if (!VfsUtilCore.isAncestor(((VFileDeleteEvent)vFileEvent).getFile(), file2, false)) continue;
                        this.closeFile(file2);
                    }
                }
            }
        });
    }

    @NotNull
    public FileEditorComposite openFile(@NotNull VirtualFile file2, @Nullable EditorWindow window, @NotNull FileEditorOpenOptions options2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Intrinsics.checkNotNullParameter((Object)options2, (String)"options");
        return this.openFileInCommand(new OpenFileDescriptor(this.project, file2));
    }

    /*
     * WARNING - void declaration
     */
    private final Pair<FileEditor[], FileEditorProvider[]> openFileImpl3(FileEditorNavigatable openFileDescriptor) {
        VirtualFile virtualFile2 = openFileDescriptor.getFile();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile2, (String)"openFileDescriptor.file");
        VirtualFile file2 = virtualFile2;
        if (!ClientId.Companion.isCurrentlyUnderLocalId()) {
            void $this$toTypedArray$iv;
            void $this$mapTo$iv$iv;
            void $this$toTypedArray$iv2;
            Collection collection;
            void $this$mapTo$iv$iv2;
            ClientFileEditorManager clientFileEditorManager = this.getClientFileEditorManager();
            if (clientFileEditorManager == null) {
                Pair.NonNull<FileEditor[], FileEditorProvider[]> nonNull = Pair.createNonNull(FileEditor.EMPTY_ARRAY, FileEditorProvider.EMPTY_ARRAY);
                Intrinsics.checkNotNullExpressionValue(nonNull, (String)"createNonNull(FileEditor\u2026itorProvider.EMPTY_ARRAY)");
                return nonNull;
            }
            ClientFileEditorManager clientManager = clientFileEditorManager;
            List result2 = clientManager.openFile(file2, false);
            Iterable $this$map$iv = result2;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                void it;
                FileEditorWithProvider fileEditorWithProvider = (FileEditorWithProvider)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getFileEditor());
            }
            $this$map$iv = (List)destination$iv$iv;
            boolean $i$f$toTypedArray = false;
            void thisCollection$iv = $this$toTypedArray$iv2;
            FileEditor[] fileEditors = thisCollection$iv.toArray(new FileEditor[0]);
            Iterable $this$map$iv2 = result2;
            boolean $i$f$map2 = false;
            destination$iv$iv = $this$map$iv2;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                FileEditorWithProvider bl = (FileEditorWithProvider)item$iv$iv;
                collection = destination$iv$iv2;
                boolean bl2 = false;
                collection.add(it.getProvider());
            }
            $this$map$iv2 = (List)destination$iv$iv2;
            boolean $i$f$toTypedArray2 = false;
            void thisCollection$iv2 = $this$toTypedArray$iv;
            FileEditorProvider[] providers = thisCollection$iv2.toArray(new FileEditorProvider[0]);
            Pair.NonNull<FileEditor[], FileEditorProvider[]> nonNull = Pair.createNonNull(fileEditors, providers);
            Intrinsics.checkNotNullExpressionValue(nonNull, (String)"createNonNull(fileEditors, providers)");
            return nonNull;
        }
        boolean isNewEditor = !this.virtualFileToEditor.containsKey(file2);
        FileEditorProvider provider2 = file2.getUserData(FileEditorProvider.KEY);
        Pair<FileEditor[], FileEditor[]> result3 = null;
        FileEditor fileEditor = null;
        Editor editor2 = null;
        if (provider2 != null && provider2.accept(this.project, file2)) {
            FileEditor fileEditor2 = provider2.createEditor(this.project, file2);
            Intrinsics.checkNotNullExpressionValue((Object)fileEditor2, (String)"provider.createEditor(project, file)");
            fileEditor = fileEditor2;
            if (fileEditor instanceof TextEditor) {
                editor2 = ((TextEditor)fileEditor).getEditor();
                TextEditorProvider.putTextEditor((Editor)editor2, (TextEditor)((TextEditor)fileEditor));
            } else {
                editor2 = null;
            }
        } else {
            editor2 = this.doOpenTextEditor(openFileDescriptor);
            TextEditor textEditor = TextEditorProvider.getInstance().getTextEditor(editor2);
            Intrinsics.checkNotNullExpressionValue((Object)textEditor, (String)"getInstance().getTextEditor(editor)");
            fileEditor = (FileEditor)textEditor;
            provider2 = TestEditorManagerImpl.Companion.getStubProvider();
        }
        Object[] objectArray = new FileEditor[]{fileEditor};
        FileEditor[] fileEditorArray = objectArray;
        objectArray = new FileEditorProvider[]{provider2};
        Pair<FileEditor[], FileEditor[]> pair = Pair.create(fileEditorArray, objectArray);
        Intrinsics.checkNotNullExpressionValue(pair, (String)"create(arrayOf(fileEditor), arrayOf(provider))");
        result3 = pair;
        this.virtualFileToEditor.put(file2, editor2);
        this.activeFile = file2;
        if (editor2 != null) {
            editor2.getSelectionModel().removeSelection();
            if (openFileDescriptor instanceof OpenFileDescriptor) {
                ((OpenFileDescriptor)openFileDescriptor).navigateIn(editor2);
            }
        }
        this.modifyTabWell(() -> TestEditorManagerImpl.openFileImpl3$lambda$2(this, file2, result3, isNewEditor));
        return result3;
    }

    private final void modifyTabWell(Runnable tabWellModification) {
        if (this.project.isDisposed()) {
            return;
        }
        FileEditor lastFocusedEditor = this.testEditorSplitter.getFocusedFileEditor();
        VirtualFile lastFocusedFile = this.testEditorSplitter.getFocusedFile();
        FileEditorProvider oldProvider = this.testEditorSplitter.getProviderFromFocused();
        tabWellModification.run();
        FileEditor currentlyFocusedEditor = this.testEditorSplitter.getFocusedFileEditor();
        VirtualFile currentlyFocusedFile = this.testEditorSplitter.getFocusedFile();
        FileEditorProvider newProvider = this.testEditorSplitter.getProviderFromFocused();
        FileEditorManagerEvent event = new FileEditorManagerEvent((FileEditorManager)((Object)this), lastFocusedFile, lastFocusedEditor, oldProvider, currentlyFocusedFile, currentlyFocusedEditor, newProvider);
        this.eventPublisher().selectionChanged(event);
    }

    private final FileEditorManagerListener eventPublisher() {
        MessageBus messageBus = this.project.getMessageBus();
        Topic<FileEditorManagerListener> topic = FileEditorManagerListener.FILE_EDITOR_MANAGER;
        Intrinsics.checkNotNullExpressionValue(topic, (String)"FILE_EDITOR_MANAGER");
        FileEditorManagerListener fileEditorManagerListener = messageBus.syncPublisher(topic);
        Intrinsics.checkNotNullExpressionValue((Object)fileEditorManagerListener, (String)"project.messageBus.syncP\u2026ener.FILE_EDITOR_MANAGER)");
        return fileEditorManagerListener;
    }

    public void notifyPublisher(@NotNull Runnable runnable) {
        Intrinsics.checkNotNullParameter((Object)runnable, (String)"runnable");
        runnable.run();
    }

    @Nullable
    public EditorsSplitters getSplittersFor(@NotNull Component component2) {
        Intrinsics.checkNotNullParameter((Object)component2, (String)"component");
        return null;
    }

    public void createSplitter(int orientation, @Nullable EditorWindow window) {
        String containerName = this.createNewTabbedContainerName();
        this.testEditorSplitter.setActiveTabGroup(containerName);
    }

    private final String createNewTabbedContainerName() {
        int n = this.counter;
        this.counter = n + 1;
        return "SplitTabContainer" + this.counter;
    }

    public void changeSplitterOrientation() {
    }

    public boolean isInSplitter() {
        return false;
    }

    public boolean hasOpenedFile() {
        return false;
    }

    @Nullable
    public VirtualFile getCurrentFile() {
        if (!ClientId.Companion.isCurrentlyUnderLocalId()) {
            ClientFileEditorManager clientFileEditorManager = this.getClientFileEditorManager();
            if (clientFileEditorManager == null) {
                return null;
            }
            ClientFileEditorManager clientManager = clientFileEditorManager;
            return clientManager.getSelectedFile();
        }
        return this.activeFile;
    }

    private final ClientFileEditorManager getClientFileEditorManager() {
        ClientProjectSession session;
        ClientId clientId = ClientId.Companion.getCurrent();
        LOG.assertTrue(!ClientId.Companion.isLocal(clientId), "Trying to get ClientFileEditorManager for local ClientId");
        ClientProjectSession clientProjectSession = session = ClientSessionsManager.Companion.getProjectSession(this.project, clientId);
        return clientProjectSession != null ? (ClientFileEditorManager)clientProjectSession.getService(ClientFileEditorManager.class) : null;
    }

    @Nullable
    public FileEditorWithProvider getSelectedEditorWithProvider(@NotNull VirtualFile file2) {
        FileEditorWithProvider fileEditorWithProvider;
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        if (!ClientId.Companion.isCurrentlyUnderLocalId()) {
            ClientFileEditorManager clientFileEditorManager = this.getClientFileEditorManager();
            if (clientFileEditorManager == null) {
                return null;
            }
            ClientFileEditorManager clientManager = clientFileEditorManager;
            EditorComposite editorComposite = clientManager.getComposite(file2);
            return editorComposite != null ? editorComposite.getSelectedWithProvider() : null;
        }
        Pair<FileEditor, FileEditorProvider> pair = this.testEditorSplitter.getEditorAndProvider(file2);
        if (pair != null) {
            Pair<FileEditor, FileEditorProvider> it = pair;
            boolean bl = false;
            fileEditorWithProvider = new FileEditorWithProvider((FileEditor)it.first, (FileEditorProvider)it.second);
        } else {
            fileEditorWithProvider = null;
        }
        return fileEditorWithProvider;
    }

    public boolean isChanged(@NotNull EditorComposite editor2) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        return false;
    }

    @Nullable
    public EditorWindow getNextWindow(@NotNull EditorWindow window) {
        Intrinsics.checkNotNullParameter((Object)window, (String)"window");
        return null;
    }

    @Nullable
    public EditorWindow getPrevWindow(@NotNull EditorWindow window) {
        Intrinsics.checkNotNullParameter((Object)window, (String)"window");
        return null;
    }

    public void addTopComponent(@NotNull FileEditor editor2, @NotNull JComponent component2) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)component2, (String)"component");
    }

    public void removeTopComponent(@NotNull FileEditor editor2, @NotNull JComponent component2) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)component2, (String)"component");
    }

    public void addBottomComponent(@NotNull FileEditor editor2, @NotNull JComponent component2) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)component2, (String)"component");
    }

    public void removeBottomComponent(@NotNull FileEditor editor2, @NotNull JComponent component2) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)component2, (String)"component");
    }

    public void closeAllFiles() {
        for (VirtualFile file2 : this.getOpenFiles()) {
            this.closeFile(file2);
        }
    }

    @NotNull
    public StateFlow<FileEditor> getCurrentFileEditorFlow() {
        return StateFlowKt.MutableStateFlow(null);
    }

    @Nullable
    public EditorWindow getCurrentWindow() {
        return null;
    }

    public void setCurrentWindow(@Nullable EditorWindow editorWindow) {
    }

    @NotNull
    public CompletableFuture<EditorWindow> getActiveWindow() {
        CompletableFuture<Object> completableFuture = CompletableFuture.completedFuture(null);
        Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"completedFuture(null)");
        return completableFuture;
    }

    public void unsplitWindow() {
    }

    public void unsplitAllWindow() {
    }

    @NotNull
    public EditorWindow[] getWindows() {
        boolean $i$f$emptyArray = false;
        return new EditorWindow[0];
    }

    @NotNull
    public FileEditor[] getSelectedEditorWithRemotes() {
        List result2 = new ArrayList();
        FileEditor[] fileEditorArray = this.getSelectedEditors();
        Collections.addAll(result2, Arrays.copyOf(fileEditorArray, fileEditorArray.length));
        for (ClientFileEditorManager m : this.getAllClientFileEditorManagers()) {
            result2.addAll(m.getSelectedEditors());
        }
        Collection $this$toTypedArray$iv = result2;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new FileEditor[0]);
    }

    public boolean isFileOpen(@NotNull VirtualFile file2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        if (!ClientId.Companion.isCurrentlyUnderLocalId()) {
            ClientFileEditorManager clientFileEditorManager = this.getClientFileEditorManager();
            if (clientFileEditorManager == null) {
                return false;
            }
            ClientFileEditorManager clientManager = clientFileEditorManager;
            return clientManager.isFileOpen(file2);
        }
        return this.getEditor(file2) != null;
    }

    public boolean isFileOpenWithRemotes(@NotNull VirtualFile file2) {
        boolean bl;
        block4: {
            Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
            if (this.isFileOpen(file2)) {
                return true;
            }
            Iterable $this$any$iv = this.getAllClientFileEditorManagers();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    ClientFileEditorManager it = (ClientFileEditorManager)element$iv;
                    boolean bl2 = false;
                    if (!it.isFileOpen(file2)) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        return bl;
    }

    @NotNull
    public FileEditor[] getEditors(@NotNull VirtualFile file2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        FileEditor[] fileEditorArray = new FileEditor[1];
        if (this.getSelectedEditor(file2) == null) {
            FileEditor cfr_ignored_0 = fileEditorArray[0];
            Intrinsics.checkNotNullExpressionValue((Object)FileEditor.EMPTY_ARRAY, (String)"EMPTY_ARRAY");
            return FileEditor.EMPTY_ARRAY;
        }
        return fileEditorArray;
    }

    @NotNull
    public FileEditor[] getAllEditors(@NotNull VirtualFile file2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        ArrayList result2 = new ArrayList();
        CollectionsKt.addAll((Collection)result2, (Object[])this.getEditors(file2));
        for (ClientFileEditorManager clientManager : this.getAllClientFileEditorManagers()) {
            result2.addAll(clientManager.getEditors(file2));
        }
        FileEditor[] fileEditorArray = result2.toArray(FileEditor.EMPTY_ARRAY);
        Intrinsics.checkNotNullExpressionValue((Object)fileEditorArray, (String)"result.toArray(FileEditor.EMPTY_ARRAY)");
        return fileEditorArray;
    }

    @NotNull
    public List<VirtualFile> getOpenFilesWithRemotes() {
        return SequencesKt.toList((Sequence)SequencesKt.plus((Sequence)ArraysKt.asSequence((Object[])this.getOpenFiles()), (Sequence)SequencesKt.flatMapIterable((Sequence)CollectionsKt.asSequence((Iterable)this.getAllClientFileEditorManagers()), (Function1)getOpenFilesWithRemotes.1.INSTANCE)));
    }

    @NotNull
    public List<VirtualFile> getSiblings(@NotNull VirtualFile file2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        throw new UnsupportedOperationException();
    }

    @Override
    public void dispose() {
        this.closeAllFiles();
        LIGHT_VIRTUAL_FILE.clearUserDataOnDispose();
    }

    public void closeFile(@NotNull VirtualFile file2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        if (!ClientId.Companion.isCurrentlyUnderLocalId()) {
            ClientFileEditorManager clientFileEditorManager = this.getClientFileEditorManager();
            if (clientFileEditorManager == null) {
                return;
            }
            ClientFileEditorManager clientManager = clientFileEditorManager;
            clientManager.closeFile(file2, false);
            return;
        }
        Editor editor2 = this.virtualFileToEditor.remove(file2);
        Pair<FileEditor, FileEditorProvider> pair = this.testEditorSplitter.getEditorAndProvider(file2);
        if (pair != null) {
            Pair<FileEditor, FileEditorProvider> it = pair;
            boolean bl = false;
            FileEditor fileEditor = (FileEditor)it.first;
            FileEditorProvider provider2 = (FileEditorProvider)it.second;
            provider2.disposeEditor(fileEditor);
            if (editor2 != null && !editor2.isDisposed()) {
                EditorFactory.getInstance().releaseEditor(editor2);
            }
            if (!this.project.isDisposed()) {
                this.eventPublisher().fileClosed((FileEditorManager)((Object)this), file2);
            }
        }
        if (Intrinsics.areEqual((Object)file2, (Object)this.activeFile)) {
            this.activeFile = null;
        }
        this.modifyTabWell(() -> TestEditorManagerImpl.closeFile$lambda$6(this, file2));
    }

    public void closeFile(@NotNull VirtualFile file2, @NotNull EditorWindow window) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Intrinsics.checkNotNullParameter((Object)window, (String)"window");
        this.closeFile(file2);
    }

    @NotNull
    public VirtualFile[] getSelectedFiles() {
        VirtualFile[] virtualFileArray;
        if (!ClientId.Companion.isCurrentlyUnderLocalId()) {
            ClientFileEditorManager clientFileEditorManager = this.getClientFileEditorManager();
            if (clientFileEditorManager == null) {
                Intrinsics.checkNotNullExpressionValue((Object)VirtualFile.EMPTY_ARRAY, (String)"EMPTY_ARRAY");
                return VirtualFile.EMPTY_ARRAY;
            }
            ClientFileEditorManager clientManager = clientFileEditorManager;
            Collection $this$toTypedArray$iv = clientManager.getSelectedFiles();
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            return thisCollection$iv.toArray(new VirtualFile[0]);
        }
        if (this.activeFile == null) {
            virtualFileArray = VirtualFile.EMPTY_ARRAY;
            Intrinsics.checkNotNullExpressionValue((Object)VirtualFile.EMPTY_ARRAY, (String)"EMPTY_ARRAY");
        } else {
            VirtualFile[] virtualFileArray2 = new VirtualFile[1];
            Intrinsics.checkNotNull((Object)this.activeFile);
            virtualFileArray = virtualFileArray2;
        }
        return virtualFileArray;
    }

    @NotNull
    public FileEditor[] getSelectedEditors() {
        FileEditor[] fileEditorArray;
        if (!ClientId.Companion.isCurrentlyUnderLocalId()) {
            ClientFileEditorManager clientFileEditorManager = this.getClientFileEditorManager();
            if (clientFileEditorManager == null) {
                return FileEditor.EMPTY_ARRAY;
            }
            Collection $this$toTypedArray$iv = clientFileEditorManager.getSelectedEditors();
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            return thisCollection$iv.toArray(new FileEditor[0]);
        }
        if (this.activeFile == null) {
            fileEditorArray = FileEditor.EMPTY_ARRAY;
            Intrinsics.checkNotNullExpressionValue((Object)FileEditor.EMPTY_ARRAY, (String)"EMPTY_ARRAY");
        } else {
            VirtualFile virtualFile2 = this.activeFile;
            Intrinsics.checkNotNull((Object)virtualFile2);
            fileEditorArray = this.getEditors(virtualFile2);
        }
        return fileEditorArray;
    }

    @Nullable
    public Editor getSelectedTextEditor() {
        if (!ClientId.Companion.isCurrentlyUnderLocalId()) {
            ClientFileEditorManager clientFileEditorManager = this.getClientFileEditorManager();
            if (clientFileEditorManager == null) {
                return null;
            }
            ClientFileEditorManager clientManager = clientFileEditorManager;
            FileEditor selectedEditor = clientManager.getSelectedEditor();
            return selectedEditor instanceof TextEditor ? ((TextEditor)selectedEditor).getEditor() : null;
        }
        Editor editor2 = IntentionPreviewUtils.getPreviewEditor();
        if (editor2 == null) {
            VirtualFile virtualFile2 = this.activeFile;
            if (virtualFile2 == null) {
                return null;
            }
            editor2 = this.getEditor(virtualFile2);
        }
        return editor2;
    }

    @NotNull
    public Editor[] getSelectedTextEditorWithRemotes() {
        ArrayList<Editor> result2 = new ArrayList<Editor>();
        for (FileEditor e : this.getSelectedEditorWithRemotes()) {
            if (!(e instanceof TextEditor)) continue;
            result2.add(((TextEditor)e).getEditor());
        }
        Collection $this$toTypedArray$iv = result2;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new Editor[0]);
    }

    @Nullable
    public JComponent getComponent() {
        return null;
    }

    @NotNull
    public VirtualFile[] getOpenFiles() {
        if (!ClientId.Companion.isCurrentlyUnderLocalId()) {
            ClientFileEditorManager clientFileEditorManager = this.getClientFileEditorManager();
            if (clientFileEditorManager == null) {
                return VirtualFile.EMPTY_ARRAY;
            }
            Collection $this$toTypedArray$iv = clientFileEditorManager.getAllFiles();
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            return thisCollection$iv.toArray(new VirtualFile[0]);
        }
        VirtualFile[] virtualFileArray = VfsUtilCore.toVirtualFileArray((Collection<? extends VirtualFile>)this.virtualFileToEditor.keySet());
        Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray, (String)"toVirtualFileArray(virtualFileToEditor.keys)");
        return virtualFileArray;
    }

    @Nullable
    public final Editor getEditor(@NotNull VirtualFile file2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        return this.virtualFileToEditor.get(file2);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public FileEditor[] getAllEditors() {
        void $this$mapNotNullTo$iv$iv;
        ArrayList result2 = new ArrayList();
        Collection collection = result2;
        Set<VirtualFile> set2 = this.virtualFileToEditor.keySet();
        Intrinsics.checkNotNullExpressionValue(set2, (String)"virtualFileToEditor.keys");
        Iterable $this$mapNotNull$iv = set2;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            FileEditor it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            VirtualFile it = (VirtualFile)element$iv$iv;
            boolean bl2 = false;
            Pair<FileEditor, FileEditorProvider> pair = this.testEditorSplitter.getEditorAndProvider(it);
            if ((pair != null ? (FileEditor)pair.first : null) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        $this$mapNotNull$iv = (List)destination$iv$iv;
        CollectionsKt.addAll((Collection)collection, (Iterable)$this$mapNotNull$iv);
        for (ClientFileEditorManager clientManager : this.getAllClientFileEditorManagers()) {
            CollectionsKt.addAll((Collection)result2, (Iterable)clientManager.getAllEditors());
        }
        Collection $this$toTypedArray$iv = result2;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new FileEditor[0]);
    }

    private final List<ClientFileEditorManager> getAllClientFileEditorManagers() {
        List<ClientFileEditorManager> list2 = this.project.getServices(ClientFileEditorManager.class, ClientKind.REMOTE);
        Intrinsics.checkNotNullExpressionValue(list2, (String)"project.getServices(Clie\u2026.java, ClientKind.REMOTE)");
        return list2;
    }

    @Nullable
    public Editor openTextEditor(@NotNull OpenFileDescriptor descriptor2, boolean focusEditor) {
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        FileEditorComposite pair = this.openFileInCommand(descriptor2);
        for (FileEditor editor2 : pair.getAllEditors()) {
            if (!(editor2 instanceof TextEditor)) continue;
            return ((TextEditor)editor2).getEditor();
        }
        return null;
    }

    private final FileEditorComposite openFileInCommand(FileEditorNavigatable descriptor2) {
        Ref.ObjectRef result2 = new Ref.ObjectRef();
        CommandProcessor.getInstance().executeCommand(this.project, () -> TestEditorManagerImpl.openFileInCommand$lambda$8(this, descriptor2, result2), "", null);
        Object object = result2.element;
        Intrinsics.checkNotNull((Object)object);
        return (FileEditorComposite)object;
    }

    private final Editor doOpenTextEditor(FileEditorNavigatable descriptor2) {
        VirtualFile virtualFile2 = descriptor2.getFile();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile2, (String)"descriptor.file");
        VirtualFile file2 = virtualFile2;
        Editor editor2 = this.virtualFileToEditor.get(file2);
        if (editor2 != null) {
            Editor it = editor2;
            boolean bl = false;
            return it;
        }
        Document document = FileDocumentManager.getInstance().getDocument(file2);
        LOG.assertTrue(document != null, file2);
        EditorFactory editorFactory = EditorFactory.getInstance();
        Document document2 = document;
        Intrinsics.checkNotNull((Object)document2);
        Editor editor3 = editorFactory.createEditor(document2, this.project);
        try {
            EditorEx editorEx;
            EditorHighlighter editorHighlighter = HighlighterFactory.createHighlighter((Project)this.project, (VirtualFile)file2);
            Intrinsics.checkNotNullExpressionValue((Object)editorHighlighter, (String)"createHighlighter(project, file)");
            EditorHighlighter highlighter = editorHighlighter;
            Language language = TextEditorImpl.getDocumentLanguage((Editor)editor3);
            editor3.getSettings().setLanguageSupplier(() -> TestEditorManagerImpl.doOpenTextEditor$lambda$10(language));
            EditorEx editorEx2 = editorEx = (EditorEx)editor3;
            Intrinsics.checkNotNull((Object)editorEx2);
            editorEx2.setHighlighter(highlighter);
            editorEx.setFile(file2);
        }
        catch (Throwable e) {
            editorFactory.releaseEditor(editor3);
            throw e;
        }
        Editor editor4 = editor3;
        Intrinsics.checkNotNull((Object)editor4);
        return editor4;
    }

    @NotNull
    public List<FileEditor> openFileEditor(@NotNull FileEditorNavigatable descriptor2, boolean focusEditor) {
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        return this.openFileInCommand(descriptor2).getAllEditors();
    }

    @NotNull
    public Project getProject() {
        return this.project;
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return null;
    }

    @NotNull
    public Pair<FileEditor[], FileEditorProvider[]> getEditorsWithProviders(@NotNull VirtualFile file2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        return EditorComposite.Companion.retrofit(this.getComposite(file2));
    }

    @Nullable
    public FileEditorComposite getComposite(@NotNull VirtualFile file2) {
        TestEditorComposite testEditorComposite;
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        if (!ClientId.Companion.isCurrentlyUnderLocalId()) {
            ClientFileEditorManager clientFileEditorManager = this.getClientFileEditorManager();
            return (FileEditorComposite)(clientFileEditorManager != null ? clientFileEditorManager.getComposite(file2) : null);
        }
        Pair<FileEditor, FileEditorProvider> pair = this.testEditorSplitter.getEditorAndProvider(file2);
        if (pair != null) {
            Pair<FileEditor, FileEditorProvider> it = pair;
            boolean bl = false;
            Object a = it.first;
            Intrinsics.checkNotNullExpressionValue(a, (String)"it.first");
            FileEditor fileEditor = (FileEditor)a;
            Object b = it.second;
            Intrinsics.checkNotNullExpressionValue(b, (String)"it.second");
            testEditorComposite = new TestEditorComposite(fileEditor, (FileEditorProvider)b);
        } else {
            testEditorComposite = null;
        }
        return testEditorComposite;
    }

    public int getWindowSplitCount() {
        return 0;
    }

    public boolean hasSplitOrUndockedWindows() {
        return false;
    }

    @NotNull
    public EditorsSplitters getSplitters() {
        throw new IncorrectOperationException();
    }

    public void setSelectedEditor(@NotNull VirtualFile file2, @NotNull String fileEditorProviderId) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Intrinsics.checkNotNullParameter((Object)fileEditorProviderId, (String)"fileEditorProviderId");
        if (!ClientId.Companion.isCurrentlyUnderLocalId()) {
            ClientFileEditorManager clientFileEditorManager = this.getClientFileEditorManager();
            if (clientFileEditorManager != null) {
                clientFileEditorManager.setSelectedEditor(file2, fileEditorProviderId);
            }
            return;
        }
        if (this.virtualFileToEditor.containsKey(file2)) {
            this.modifyTabWell(() -> TestEditorManagerImpl.setSelectedEditor$lambda$12(this, file2));
        }
    }

    private static final void openFileImpl3$lambda$2(TestEditorManagerImpl this$0, VirtualFile $file, Pair $result, boolean $isNewEditor) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$file, (String)"$file");
        Intrinsics.checkNotNullParameter((Object)$result, (String)"$result");
        this$0.testEditorSplitter.openAndFocusTab($file, ((FileEditor[])$result.first)[0], ((FileEditorProvider[])$result.second)[0]);
        if ($isNewEditor) {
            this$0.eventPublisher().fileOpened((FileEditorManager)((Object)this$0), $file);
        }
    }

    private static final void closeFile$lambda$6(TestEditorManagerImpl this$0, VirtualFile $file) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$file, (String)"$file");
        this$0.testEditorSplitter.closeFile($file);
    }

    private static final void openFileInCommand$lambda$8(TestEditorManagerImpl this$0, FileEditorNavigatable $descriptor, Ref.ObjectRef $result) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$descriptor, (String)"$descriptor");
        Intrinsics.checkNotNullParameter((Object)$result, (String)"$result");
        Pair<FileEditor[], FileEditorProvider[]> editWithProvider = this$0.openFileImpl3($descriptor);
        FileEditor[] editors2 = (FileEditor[])editWithProvider.first;
        int n = editors2.length;
        for (int i2 = 0; i2 < n; ++i2) {
            FileEditor editor2 = editors2[i2];
            if (!(editor2 instanceof NavigatableFileEditor) || !Intrinsics.areEqual((Object)$descriptor.getFile(), (Object)((NavigatableFileEditor)editor2).getFile())) continue;
            if (!((NavigatableFileEditor)editor2).canNavigateTo((Navigatable)$descriptor)) break;
            VirtualFile virtualFile2 = $descriptor.getFile();
            Intrinsics.checkNotNullExpressionValue((Object)virtualFile2, (String)"descriptor.file");
            String string2 = ((FileEditorProvider[])editWithProvider.second)[i2].getEditorTypeId();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"editWithProvider.second[i].editorTypeId");
            this$0.setSelectedEditor(virtualFile2, string2);
            ((NavigatableFileEditor)editor2).navigateTo((Navigatable)$descriptor);
            break;
        }
        $result.element = FileEditorComposite.Companion.fromPair(editWithProvider);
    }

    private static final Language doOpenTextEditor$lambda$10(Language $language) {
        return $language;
    }

    private static final void setSelectedEditor$lambda$12(TestEditorManagerImpl this$0, VirtualFile $file) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$file, (String)"$file");
        this$0.activeFile = $file;
        this$0.testEditorSplitter.setFocusedFile($file);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(TestEditorManagerImpl.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(T::class.java)");
        LOG = logger;
        LIGHT_VIRTUAL_FILE = new MyLightVirtualFile();
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0005\u001a\u00070\u0006\u00a2\u0006\u0002\b\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\t8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lcom/intellij/openapi/fileEditor/impl/TestEditorManagerImpl$Companion;", "", "()V", "LIGHT_VIRTUAL_FILE", "Lcom/intellij/openapi/fileEditor/impl/TestEditorManagerImpl$MyLightVirtualFile;", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "stubProvider", "Lcom/intellij/openapi/fileEditor/FileEditorProvider;", "getStubProvider", "()Lcom/intellij/openapi/fileEditor/FileEditorProvider;", "intellij.platform.lang.impl"})
    public static final class Companion {
        private Companion() {
        }

        private final FileEditorProvider getStubProvider() {
            return new FileEditorProvider(){

                public boolean accept(@NotNull Project project2, @NotNull VirtualFile file2) {
                    Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
                    Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
                    return false;
                }

                @NotNull
                public FileEditor createEditor(@NotNull Project project2, @NotNull VirtualFile file2) {
                    Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
                    Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
                    throw new IncorrectOperationException();
                }

                public void disposeEditor(@NotNull FileEditor editor2) {
                    Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
                    Disposer.dispose((Disposable)editor2);
                }

                @NotNull
                public FileEditorState readState(@NotNull Element sourceElement, @NotNull Project project2, @NotNull VirtualFile file2) {
                    Intrinsics.checkNotNullParameter((Object)sourceElement, (String)"sourceElement");
                    Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
                    Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
                    throw new IncorrectOperationException();
                }

                @NotNull
                public String getEditorTypeId() {
                    return "";
                }

                @NotNull
                public FileEditorPolicy getPolicy() {
                    throw new IncorrectOperationException();
                }
            };
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0003\u001a\u00020\u0004\u00a8\u0006\u0005"}, d2={"Lcom/intellij/openapi/fileEditor/impl/TestEditorManagerImpl$MyLightVirtualFile;", "Lcom/intellij/testFramework/LightVirtualFile;", "()V", "clearUserDataOnDispose", "", "intellij.platform.lang.impl"})
    private static final class MyLightVirtualFile
    extends LightVirtualFile {
        public MyLightVirtualFile() {
            super("Dummy.java");
        }

        public final void clearUserDataOnDispose() {
            this.clearUserData();
        }
    }
}

