/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileEditor.impl;

import com.intellij.filename.UniqueNameBuilder;
import com.intellij.ide.lightEdit.LightEdit;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.UniqueVFilePathBuilder;
import com.intellij.openapi.fileEditor.impl.EditorHistoryManager;
import com.intellij.openapi.fileEditor.impl.FileEditorManagerImpl;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFilePathWrapper;
import com.intellij.openapi.vfs.newvfs.persistent.FSRecords;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.indexing.DumbModeAccessType;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexEx;
import com.intellij.util.indexing.FileBasedIndexExtension;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class UniqueVFilePathBuilderImpl
extends UniqueVFilePathBuilder {
    private static final Key<CachedValue<Map<GlobalSearchScope, Map<String, UniqueNameBuilder<VirtualFile>>>>> ourShortNameBuilderCacheKey = Key.create("project's.short.file.name.builder");
    private static final Key<CachedValue<Map<GlobalSearchScope, Map<String, UniqueNameBuilder<VirtualFile>>>>> ourShortNameOpenedBuilderCacheKey = Key.create("project's.short.file.name.opened.builder");
    private static final UniqueNameBuilder<VirtualFile> ourEmptyBuilder = new UniqueNameBuilder(null, null);

    UniqueVFilePathBuilderImpl() {
    }

    @NotNull
    public String getUniqueVirtualFilePath(@NotNull Project project2, @NotNull VirtualFile file2, @NotNull GlobalSearchScope scope) {
        if (project2 == null) {
            UniqueVFilePathBuilderImpl.$$$reportNull$$$0(0);
        }
        if (file2 == null) {
            UniqueVFilePathBuilderImpl.$$$reportNull$$$0(1);
        }
        if (scope == null) {
            UniqueVFilePathBuilderImpl.$$$reportNull$$$0(2);
        }
        String string2 = UniqueVFilePathBuilderImpl.getUniqueVirtualFilePath(project2, file2, false, scope);
        if (string2 == null) {
            UniqueVFilePathBuilderImpl.$$$reportNull$$$0(3);
        }
        return string2;
    }

    @NotNull
    public String getUniqueVirtualFilePath(@NotNull Project project2, @NotNull VirtualFile vFile) {
        if (project2 == null) {
            UniqueVFilePathBuilderImpl.$$$reportNull$$$0(4);
        }
        if (vFile == null) {
            UniqueVFilePathBuilderImpl.$$$reportNull$$$0(5);
        }
        String string2 = this.getUniqueVirtualFilePath(project2, vFile, GlobalSearchScope.projectScope(project2));
        if (string2 == null) {
            UniqueVFilePathBuilderImpl.$$$reportNull$$$0(6);
        }
        return string2;
    }

    @NotNull
    public String getUniqueVirtualFilePathWithinOpenedFileEditors(@NotNull Project project2, @NotNull VirtualFile vFile) {
        if (project2 == null) {
            UniqueVFilePathBuilderImpl.$$$reportNull$$$0(7);
        }
        if (vFile == null) {
            UniqueVFilePathBuilderImpl.$$$reportNull$$$0(8);
        }
        String string2 = UniqueVFilePathBuilderImpl.getUniqueVirtualFilePath(project2, vFile, true, GlobalSearchScope.projectScope(project2));
        if (string2 == null) {
            UniqueVFilePathBuilderImpl.$$$reportNull$$$0(9);
        }
        return string2;
    }

    @NotNull
    private static String getName(@NotNull VirtualFile file2) {
        if (file2 == null) {
            UniqueVFilePathBuilderImpl.$$$reportNull$$$0(10);
        }
        String string2 = file2 instanceof VirtualFilePathWrapper ? file2.getPresentableName() : file2.getName();
        if (string2 == null) {
            UniqueVFilePathBuilderImpl.$$$reportNull$$$0(11);
        }
        return string2;
    }

    private static String getUniqueVirtualFilePath(@NotNull Project project2, @NotNull VirtualFile file2, boolean skipNonOpenedFiles, @NotNull GlobalSearchScope scope) {
        UniqueNameBuilder<VirtualFile> builder2;
        if (project2 == null) {
            UniqueVFilePathBuilderImpl.$$$reportNull$$$0(12);
        }
        if (file2 == null) {
            UniqueVFilePathBuilderImpl.$$$reportNull$$$0(13);
        }
        if (scope == null) {
            UniqueVFilePathBuilderImpl.$$$reportNull$$$0(14);
        }
        if ((builder2 = UniqueVFilePathBuilderImpl.getUniqueVirtualFileNameBuilder(project2, file2, skipNonOpenedFiles, scope)) != null) {
            return builder2.getShortPath(file2);
        }
        return UniqueVFilePathBuilderImpl.getName(file2);
    }

    @Nullable
    private static UniqueNameBuilder<VirtualFile> getUniqueVirtualFileNameBuilder(@NotNull Project project2, @NotNull VirtualFile file2, boolean skipNonOpenedFiles, @NotNull GlobalSearchScope scope) {
        String fileName;
        UniqueNameBuilder<VirtualFile> builder2;
        ConcurrentMap scope2ValueMap;
        Map valueMap;
        Key<CachedValue<Map<GlobalSearchScope, Map<String, UniqueNameBuilder<VirtualFile>>>>> key;
        CachedValue<Map<GlobalSearchScope, Map<String, UniqueNameBuilder<VirtualFile>>>> data2;
        if (project2 == null) {
            UniqueVFilePathBuilderImpl.$$$reportNull$$$0(15);
        }
        if (file2 == null) {
            UniqueVFilePathBuilderImpl.$$$reportNull$$$0(16);
        }
        if (scope == null) {
            UniqueVFilePathBuilderImpl.$$$reportNull$$$0(17);
        }
        if ((data2 = project2.getUserData(key = skipNonOpenedFiles ? ourShortNameOpenedBuilderCacheKey : ourShortNameBuilderCacheKey)) == null) {
            data2 = CachedValuesManager.getManager(project2).createCachedValue(() -> new CachedValueProvider.Result(new ConcurrentHashMap(2), DumbService.getInstance(project2), UniqueVFilePathBuilderImpl.getFilenameIndexModificationTracker(project2), FileEditorManagerImpl.OPEN_FILE_SET_MODIFICATION_COUNT), false);
            project2.putUserData(key, data2);
        }
        if ((valueMap = (Map)(scope2ValueMap = (ConcurrentMap)data2.getValue()).get(scope)) == null) {
            valueMap = ConcurrencyUtil.cacheOrGet(scope2ValueMap, scope, ContainerUtil.createConcurrentSoftValueMap());
        }
        if ((builder2 = (UniqueNameBuilder<VirtualFile>)valueMap.get(fileName = UniqueVFilePathBuilderImpl.getName(file2))) == null) {
            UniqueVFilePathBuilderImpl.createAndCacheBuilders(project2, file2, valueMap, skipNonOpenedFiles, scope);
            builder2 = ObjectUtils.nullizeIfDefaultValue((UniqueNameBuilder)valueMap.get(fileName), ourEmptyBuilder);
        } else if (builder2 == ourEmptyBuilder) {
            builder2 = null;
        }
        if (builder2 != null && builder2.contains(file2)) {
            return builder2;
        }
        return null;
    }

    @NotNull
    private static ModificationTracker getFilenameIndexModificationTracker(@NotNull Project project2) {
        if (project2 == null) {
            UniqueVFilePathBuilderImpl.$$$reportNull$$$0(18);
        }
        if (FileBasedIndexExtension.USE_VFS_FOR_FILENAME_INDEX) {
            ModificationTracker modificationTracker = FSRecords::getNamesIndexModCount;
            if (modificationTracker == null) {
                UniqueVFilePathBuilderImpl.$$$reportNull$$$0(19);
            }
            return modificationTracker;
        }
        ModificationTracker modificationTracker = () -> UniqueVFilePathBuilderImpl.disableIndexUpToDateCheckInEdt(() -> FileBasedIndex.getInstance().getIndexModificationStamp(FilenameIndex.NAME, project2));
        if (modificationTracker == null) {
            UniqueVFilePathBuilderImpl.$$$reportNull$$$0(20);
        }
        return modificationTracker;
    }

    private static void createAndCacheBuilders(@NotNull Project project2, @NotNull VirtualFile requiredFile, @NotNull Map<String, UniqueNameBuilder<VirtualFile>> valueMap, boolean skipNonOpenedFiles, @NotNull GlobalSearchScope scope) {
        if (project2 == null) {
            UniqueVFilePathBuilderImpl.$$$reportNull$$$0(21);
        }
        if (requiredFile == null) {
            UniqueVFilePathBuilderImpl.$$$reportNull$$$0(22);
        }
        if (valueMap == null) {
            UniqueVFilePathBuilderImpl.$$$reportNull$$$0(23);
        }
        if (scope == null) {
            UniqueVFilePathBuilderImpl.$$$reportNull$$$0(24);
        }
        boolean useIndex = !skipNonOpenedFiles && !LightEdit.owns((Project)project2);
        VirtualFile[] openFiles2 = FileEditorManager.getInstance(project2).getOpenFiles();
        List recentFiles = EditorHistoryManager.getInstance((Project)project2).getFileList();
        MultiMap<String, VirtualFile> multiMap = MultiMap.createSet();
        if (useIndex) {
            Set<String> names = JBIterable.of(requiredFile).append((VirtualFile)openFiles2).append((VirtualFile)((Object)recentFiles)).map(UniqueVFilePathBuilderImpl::getName).toSet();
            ThrowableComputable query2 = () -> FilenameIndex.processFilesByNames((Set)names, (boolean)true, (GlobalSearchScope)scope, null, file2 -> {
                String name = UniqueVFilePathBuilderImpl.getName(file2);
                if (names.contains(name)) {
                    multiMap.putValue(name, (VirtualFile)file2);
                }
                return true;
            });
            if (DumbService.isDumb(project2)) {
                DumbModeAccessType.RELIABLE_DATA_ONLY.ignoreDumbMode(query2);
            } else {
                UniqueVFilePathBuilderImpl.disableIndexUpToDateCheckInEdt(query2);
            }
        }
        String requiredFileName = UniqueVFilePathBuilderImpl.getName(requiredFile);
        for (VirtualFile file2 : JBIterable.of(openFiles2).append((VirtualFile)((Object)(skipNonOpenedFiles ? Collections.emptyList() : recentFiles)))) {
            if (!UniqueVFilePathBuilderImpl.getName(file2).equals(requiredFileName)) continue;
            multiMap.putValue(requiredFileName, file2);
        }
        for (String fileName : multiMap.keySet()) {
            Collection files2 = multiMap.get(fileName);
            if (files2.size() < 2) {
                valueMap.put(fileName, ourEmptyBuilder);
                continue;
            }
            String path2 = project2.getBasePath();
            path2 = path2 == null ? "" : FileUtil.toSystemIndependentName(path2);
            UniqueNameBuilder<VirtualFile> builder2 = new UniqueNameBuilder<VirtualFile>(path2, File.separator);
            for (VirtualFile virtualFile2 : files2) {
                String presentablePath = virtualFile2 instanceof VirtualFilePathWrapper ? ((VirtualFilePathWrapper)((Object)virtualFile2)).getPresentablePath() : virtualFile2.getPath();
                builder2.addPath(virtualFile2, presentablePath);
            }
            valueMap.put(fileName, builder2);
        }
    }

    private static <T, E extends Throwable> T disableIndexUpToDateCheckInEdt(@NotNull ThrowableComputable<T, E> computable) throws E {
        if (computable == null) {
            UniqueVFilePathBuilderImpl.$$$reportNull$$$0(25);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        return (T)(ApplicationManager.getApplication().isDispatchThread() ? FileBasedIndexEx.disableUpToDateCheckIn(computable) : computable.compute());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 6, 9, 11, 19, 20 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 10: 
            case 13: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: 
            case 14: 
            case 17: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 3: 
            case 6: 
            case 9: 
            case 11: 
            case 19: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/fileEditor/impl/UniqueVFilePathBuilderImpl";
                break;
            }
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vFile";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requiredFile";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "valueMap";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "computable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/fileEditor/impl/UniqueVFilePathBuilderImpl";
                break;
            }
            case 3: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getUniqueVirtualFilePath";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getUniqueVirtualFilePathWithinOpenedFileEditors";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilenameIndexModificationTracker";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getUniqueVirtualFilePath";
                break;
            }
            case 3: 
            case 6: 
            case 9: 
            case 11: 
            case 19: 
            case 20: {
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getUniqueVirtualFilePathWithinOpenedFileEditors";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getName";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getUniqueVirtualFileNameBuilder";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getFilenameIndexModificationTracker";
                break;
            }
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "createAndCacheBuilders";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "disableIndexUpToDateCheckInEdt";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 3, 6, 9, 11, 19, 20 -> new IllegalStateException(string2);
        };
    }
}

