/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileEditor.impl.text;

import com.intellij.codeHighlighting.BackgroundEditorHighlighter;
import com.intellij.codeInsight.codeVision.CodeVisionInitializer;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.daemon.impl.TextEditorBackgroundHighlighter;
import com.intellij.codeInsight.documentation.render.DocRenderManager;
import com.intellij.codeInsight.documentation.render.DocRenderPassFactory;
import com.intellij.codeInsight.folding.CodeFoldingManager;
import com.intellij.codeInsight.hints.HintsBuffer;
import com.intellij.codeInsight.hints.InlayHintsPassFactory;
import com.intellij.codeInsight.hints.codeVision.CodeVisionPassFactory;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.codeInsight.lookup.impl.LookupImpl;
import com.intellij.openapi.actionSystem.CompositeDataProvider;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.diagnostic.ControlFlowException;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.impl.text.AsyncEditorLoader;
import com.intellij.openapi.fileEditor.impl.text.CodeFoldingState;
import com.intellij.openapi.fileEditor.impl.text.FocusModePassFactory;
import com.intellij.openapi.fileEditor.impl.text.TextEditorComponent;
import com.intellij.openapi.fileEditor.impl.text.TextEditorImpl;
import com.intellij.openapi.fileEditor.impl.text.TextEditorProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import java.util.List;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiAwareTextEditorImpl
extends TextEditorImpl {
    private TextEditorBackgroundHighlighter myBackgroundHighlighter;
    private static final Logger LOG = Logger.getInstance(PsiAwareTextEditorImpl.class);

    public PsiAwareTextEditorImpl(@NotNull Project project2, @NotNull VirtualFile file2, @NotNull TextEditorProvider provider2) {
        if (project2 == null) {
            PsiAwareTextEditorImpl.$$$reportNull$$$0(0);
        }
        if (file2 == null) {
            PsiAwareTextEditorImpl.$$$reportNull$$$0(1);
        }
        if (provider2 == null) {
            PsiAwareTextEditorImpl.$$$reportNull$$$0(2);
        }
        super(project2, file2, provider2);
    }

    public PsiAwareTextEditorImpl(@NotNull Project project2, @NotNull VirtualFile file2, @NotNull TextEditorProvider provider2, @NotNull EditorImpl editor2) {
        if (project2 == null) {
            PsiAwareTextEditorImpl.$$$reportNull$$$0(3);
        }
        if (file2 == null) {
            PsiAwareTextEditorImpl.$$$reportNull$$$0(4);
        }
        if (provider2 == null) {
            PsiAwareTextEditorImpl.$$$reportNull$$$0(5);
        }
        if (editor2 == null) {
            PsiAwareTextEditorImpl.$$$reportNull$$$0(6);
        }
        super(project2, file2, provider2, editor2);
    }

    @NotNull
    protected Runnable loadEditorInBackground() {
        Runnable baseResult = super.loadEditorInBackground();
        PsiFile psiFile = PsiManager.getInstance(this.myProject).findFile(this.myFile);
        Document document = FileDocumentManager.getInstance().getDocument(this.myFile);
        boolean shouldBuildInitialFoldings = document != null && !this.myProject.isDefault() && PsiDocumentManager.getInstance(this.myProject).isCommitted(document);
        CodeFoldingState foldingState = PsiAwareTextEditorImpl.catchingExceptions(() -> shouldBuildInitialFoldings ? CodeFoldingManager.getInstance(this.myProject).buildInitialFoldings(document) : null);
        List focusZones = PsiAwareTextEditorImpl.catchingExceptions(() -> FocusModePassFactory.calcFocusZones(psiFile));
        Editor editor2 = this.getEditor();
        DocRenderPassFactory.Items items2 = document != null && psiFile != null && DocRenderManager.isDocRenderingEnabled(this.getEditor()) ? PsiAwareTextEditorImpl.catchingExceptions(() -> DocRenderPassFactory.calculateItemsToRender(editor2, psiFile)) : null;
        HintsBuffer buffer = psiFile != null ? PsiAwareTextEditorImpl.catchingExceptions(() -> InlayHintsPassFactory.Companion.collectPlaceholders(psiFile, editor2)) : null;
        List placeholders = PsiAwareTextEditorImpl.catchingExceptions(() -> CodeVisionInitializer.Companion.getInstance(this.myProject).getCodeVisionHost().collectPlaceholders(editor2, psiFile));
        Runnable runnable = () -> {
            baseResult.run();
            if (foldingState != null) {
                foldingState.setToEditor(editor2);
            }
            if (focusZones != null) {
                FocusModePassFactory.setToEditor(focusZones, editor2);
                if (editor2 instanceof EditorImpl) {
                    ((EditorImpl)editor2).applyFocusMode();
                }
            }
            if (items2 != null) {
                DocRenderPassFactory.applyItemsToRender(editor2, this.myProject, items2, true);
            }
            if (buffer != null) {
                InlayHintsPassFactory.Companion.applyPlaceholders(psiFile, editor2, buffer);
            }
            if (placeholders != null && !placeholders.isEmpty()) {
                CodeVisionPassFactory.applyPlaceholders(editor2, placeholders);
            }
            if (psiFile != null && psiFile.isValid()) {
                DaemonCodeAnalyzer.getInstance(this.myProject).restart(psiFile);
            }
        };
        if (runnable == null) {
            PsiAwareTextEditorImpl.$$$reportNull$$$0(7);
        }
        return runnable;
    }

    @Nullable
    private static <T> T catchingExceptions(Supplier<T> computable) {
        try {
            return computable.get();
        }
        catch (Throwable e) {
            if (e instanceof ControlFlowException) {
                throw e;
            }
            LOG.warn("Exception during editor loading", e);
            return null;
        }
    }

    @NotNull
    protected TextEditorComponent createEditorComponent(@NotNull Project project2, @NotNull VirtualFile file2, @NotNull EditorImpl editor2) {
        if (project2 == null) {
            PsiAwareTextEditorImpl.$$$reportNull$$$0(8);
        }
        if (file2 == null) {
            PsiAwareTextEditorImpl.$$$reportNull$$$0(9);
        }
        if (editor2 == null) {
            PsiAwareTextEditorImpl.$$$reportNull$$$0(10);
        }
        return new PsiAwareTextEditorComponent(project2, file2, this, editor2);
    }

    public BackgroundEditorHighlighter getBackgroundHighlighter() {
        if (!AsyncEditorLoader.isEditorLoaded((Editor)this.getEditor())) {
            return null;
        }
        if (this.myBackgroundHighlighter == null) {
            this.myBackgroundHighlighter = new TextEditorBackgroundHighlighter(this.myProject, this.getEditor());
        }
        return this.myBackgroundHighlighter;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 6: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/fileEditor/impl/text/PsiAwareTextEditorImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/fileEditor/impl/text/PsiAwareTextEditorImpl";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "loadEditorInBackground";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 7: {
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "createEditorComponent";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 7 -> new IllegalStateException(string2);
        };
    }

    private static final class PsiAwareTextEditorComponent
    extends TextEditorComponent {
        private final Project myProject;

        private PsiAwareTextEditorComponent(@NotNull Project project2, @NotNull VirtualFile file2, @NotNull TextEditorImpl textEditor, @NotNull EditorImpl editor2) {
            if (project2 == null) {
                PsiAwareTextEditorComponent.$$$reportNull$$$0(0);
            }
            if (file2 == null) {
                PsiAwareTextEditorComponent.$$$reportNull$$$0(1);
            }
            if (textEditor == null) {
                PsiAwareTextEditorComponent.$$$reportNull$$$0(2);
            }
            if (editor2 == null) {
                PsiAwareTextEditorComponent.$$$reportNull$$$0(3);
            }
            super(project2, file2, textEditor, editor2);
            this.myProject = project2;
        }

        public void dispose() {
            super.dispose();
            CodeFoldingManager foldingManager = this.myProject.getServiceIfCreated(CodeFoldingManager.class);
            if (foldingManager != null) {
                foldingManager.releaseFoldings((Editor)this.getEditor());
            }
        }

        @Nullable
        public DataProvider createBackgroundDataProvider() {
            DataProvider superProvider = super.createBackgroundDataProvider();
            if (superProvider == null) {
                return null;
            }
            return CompositeDataProvider.compose(dataId -> {
                LookupImpl lookup2;
                if (PlatformDataKeys.DOMINANT_HINT_AREA_RECTANGLE.is(dataId) && (lookup2 = (LookupImpl)LookupManager.getInstance(this.myProject).getActiveLookup()) != null && lookup2.isVisible()) {
                    return lookup2.getBounds();
                }
                return null;
            }, (DataProvider)superProvider);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "project";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "file";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "textEditor";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[0] = "editor";
                    break;
                }
            }
            objectArray[1] = "com/intellij/openapi/fileEditor/impl/text/PsiAwareTextEditorImpl$PsiAwareTextEditorComponent";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

