/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileEditor.impl.text;

import com.intellij.codeHighlighting.BackgroundEditorHighlighter;
import com.intellij.codeInsight.daemon.impl.TextEditorBackgroundHighlighter;
import com.intellij.codeInsight.folding.CodeFoldingManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorState;
import com.intellij.openapi.fileEditor.FileEditorStateLevel;
import com.intellij.openapi.fileEditor.impl.text.AsyncEditorLoader;
import com.intellij.openapi.fileEditor.impl.text.CodeFoldingState;
import com.intellij.openapi.fileEditor.impl.text.PsiAwareTextEditorImpl;
import com.intellij.openapi.fileEditor.impl.text.TextEditorProvider;
import com.intellij.openapi.fileEditor.impl.text.TextEditorState;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import java.util.function.Supplier;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class PsiAwareTextEditorProvider
extends TextEditorProvider {
    @NonNls
    private static final String FOLDING_ELEMENT = "folding";

    @NotNull
    public FileEditor createEditor(@NotNull Project project2, @NotNull VirtualFile file2) {
        if (project2 == null) {
            PsiAwareTextEditorProvider.$$$reportNull$$$0(0);
        }
        if (file2 == null) {
            PsiAwareTextEditorProvider.$$$reportNull$$$0(1);
        }
        return new PsiAwareTextEditorImpl(project2, file2, this);
    }

    @NotNull
    public FileEditorState readState(@NotNull Element element, @NotNull Project project2, @NotNull VirtualFile file2) {
        if (element == null) {
            PsiAwareTextEditorProvider.$$$reportNull$$$0(2);
        }
        if (project2 == null) {
            PsiAwareTextEditorProvider.$$$reportNull$$$0(3);
        }
        if (file2 == null) {
            PsiAwareTextEditorProvider.$$$reportNull$$$0(4);
        }
        TextEditorState state = (TextEditorState)super.readState(element, project2, file2);
        Element child = element.getChild(FOLDING_ELEMENT);
        if (child != null) {
            Document document = FileDocumentManager.getInstance().getCachedDocument(file2);
            if (document == null) {
                state.setDelayedFoldState((Supplier)new MyDelayedFoldingState(project2, file2, child));
            } else {
                state.setFoldingState(CodeFoldingManager.getInstance(project2).readFoldingState(child, document));
            }
        }
        TextEditorState textEditorState = state;
        if (textEditorState == null) {
            PsiAwareTextEditorProvider.$$$reportNull$$$0(5);
        }
        return textEditorState;
    }

    public void writeState(@NotNull FileEditorState _state, @NotNull Project project2, @NotNull Element element) {
        if (_state == null) {
            PsiAwareTextEditorProvider.$$$reportNull$$$0(6);
        }
        if (project2 == null) {
            PsiAwareTextEditorProvider.$$$reportNull$$$0(7);
        }
        if (element == null) {
            PsiAwareTextEditorProvider.$$$reportNull$$$0(8);
        }
        super.writeState(_state, project2, element);
        TextEditorState state = (TextEditorState)_state;
        CodeFoldingState foldingState = state.getFoldingState();
        if (foldingState != null) {
            Element e = new Element(FOLDING_ELEMENT);
            try {
                CodeFoldingManager.getInstance(project2).writeFoldingState(foldingState, e);
            }
            catch (WriteExternalException writeExternalException) {
                // empty catch block
            }
            if (!JDOMUtil.isEmpty(e)) {
                element.addContent(e);
            }
        } else {
            Supplier delayedProducer = state.getDelayedFoldState();
            if (delayedProducer instanceof MyDelayedFoldingState) {
                element.addContent(((MyDelayedFoldingState)delayedProducer).getSerializedState());
            }
        }
    }

    @NotNull
    protected TextEditorState getStateImpl(Project project2, @NotNull Editor editor2, @NotNull FileEditorStateLevel level) {
        if (editor2 == null) {
            PsiAwareTextEditorProvider.$$$reportNull$$$0(9);
        }
        if (level == null) {
            PsiAwareTextEditorProvider.$$$reportNull$$$0(10);
        }
        TextEditorState state = super.getStateImpl(project2, editor2, level);
        if (FileEditorStateLevel.FULL == level) {
            if (project2 != null && !project2.isDisposed() && !editor2.isDisposed() && project2.isInitialized()) {
                state.setFoldingState(CodeFoldingManager.getInstance(project2).saveFoldingState(editor2));
            } else {
                state.setFoldingState(null);
            }
        }
        TextEditorState textEditorState = state;
        if (textEditorState == null) {
            PsiAwareTextEditorProvider.$$$reportNull$$$0(11);
        }
        return textEditorState;
    }

    protected void setStateImpl(Project project2, Editor editor2, TextEditorState state, boolean exactState) {
        super.setStateImpl(project2, editor2, state, exactState);
        CodeFoldingState foldState = state.getFoldingState();
        if (project2 != null && foldState != null && AsyncEditorLoader.isEditorLoaded((Editor)editor2)) {
            if (!PsiDocumentManager.getInstance(project2).isCommitted(editor2.getDocument())) {
                PsiDocumentManager.getInstance(project2).commitDocument(editor2.getDocument());
                LOG.error("File should be parsed when changing editor state, otherwise UI might be frozen for a considerable time");
            }
            editor2.getFoldingModel().runBatchFoldingOperation(() -> CodeFoldingManager.getInstance(project2).restoreFoldingState(editor2, foldState));
        }
    }

    @NotNull
    protected TextEditorProvider.EditorWrapper createWrapperForEditor(@NotNull Editor editor2) {
        if (editor2 == null) {
            PsiAwareTextEditorProvider.$$$reportNull$$$0(12);
        }
        return new PsiAwareEditorWrapper(editor2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 11 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 5: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/fileEditor/impl/text/PsiAwareTextEditorProvider";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "_state";
                break;
            }
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "level";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/fileEditor/impl/text/PsiAwareTextEditorProvider";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "readState";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getStateImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createEditor";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "readState";
                break;
            }
            case 5: 
            case 11: {
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "writeState";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getStateImpl";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "createWrapperForEditor";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 5, 11 -> new IllegalStateException(string2);
        };
    }

    private static final class MyDelayedFoldingState
    implements Supplier<CodeFoldingState> {
        private final Project myProject;
        private final VirtualFile myFile;
        private final Element mySerializedState;

        private MyDelayedFoldingState(Project project2, VirtualFile file2, Element state) {
            this.myProject = project2;
            this.myFile = file2;
            this.mySerializedState = JDOMUtil.internElement(state);
        }

        @Override
        public CodeFoldingState get() {
            Document document = FileDocumentManager.getInstance().getCachedDocument(this.myFile);
            return document == null ? null : CodeFoldingManager.getInstance(this.myProject).readFoldingState(this.mySerializedState, document);
        }

        private Element getSerializedState() {
            return this.mySerializedState.clone();
        }
    }

    private final class PsiAwareEditorWrapper
    extends TextEditorProvider.EditorWrapper {
        private final TextEditorBackgroundHighlighter myBackgroundHighlighter;

        private PsiAwareEditorWrapper(Editor editor2) {
            if (editor2 == null) {
                PsiAwareEditorWrapper.$$$reportNull$$$0(0);
            }
            super((TextEditorProvider)PsiAwareTextEditorProvider.this, editor2);
            Project project2 = editor2.getProject();
            this.myBackgroundHighlighter = project2 == null ? null : new TextEditorBackgroundHighlighter(project2, editor2);
        }

        public BackgroundEditorHighlighter getBackgroundHighlighter() {
            return this.myBackgroundHighlighter;
        }

        public boolean isValid() {
            return !this.getEditor().isDisposed();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/openapi/fileEditor/impl/text/PsiAwareTextEditorProvider$PsiAwareEditorWrapper", "<init>"));
        }
    }
}

