/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileTypes.impl;

import com.intellij.CommonBundle;
import com.intellij.codeInsight.hint.HintUtil;
import com.intellij.icons.AllIcons;
import com.intellij.ide.highlighter.custom.SyntaxTable;
import com.intellij.lang.LangBundle;
import com.intellij.lang.Language;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.fileTypes.FileNameMatcher;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.fileTypes.FileTypesBundle;
import com.intellij.openapi.fileTypes.UserFileType;
import com.intellij.openapi.fileTypes.impl.AbstractFileType;
import com.intellij.openapi.fileTypes.impl.FileTypeAssocTable;
import com.intellij.openapi.fileTypes.impl.FileTypeConfigurableInteractions;
import com.intellij.openapi.fileTypes.impl.FileTypeManagerImpl;
import com.intellij.openapi.fileTypes.impl.FileTypePanel;
import com.intellij.openapi.fileTypes.impl.FileTypePatternDialog;
import com.intellij.openapi.fileTypes.impl.FileTypeSelectable;
import com.intellij.openapi.fileTypes.impl.FileTypeWithDescriptorRenderer;
import com.intellij.openapi.fileTypes.impl.HashBangFileTypeDetector;
import com.intellij.openapi.fileTypes.impl.IgnoredFilesAndFoldersPanel;
import com.intellij.openapi.fileTypes.impl.TypeEditor;
import com.intellij.openapi.fileTypes.impl.associate.OSAssociateFileTypesUtil;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.ui.DialogBuilder;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.psi.templateLanguages.TemplateDataLanguagePatterns;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.DoubleClickListener;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.JBColor;
import com.intellij.ui.JBSplitter;
import com.intellij.ui.ListUtil;
import com.intellij.ui.ScrollingUtil;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.SpeedSearchBase;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.JBList;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.components.JBTabbedPane;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class FileTypeConfigurable
implements SearchableConfigurable,
Configurable.NoScroll,
FileTypeSelectable {
    private static final Insets TITLE_INSETS = JBUI.insetsTop(8);
    private RecognizedFileTypesPanel myRecognizedFileType;
    private PatternsPanel myPatterns;
    private HashBangPanel myHashBangs;
    private FileTypePanel myFileTypePanel;
    private Set<FileTypeManagerImpl.FileTypeWithDescriptor> myTempFileTypes;
    private FileTypeAssocTable<FileTypeManagerImpl.FileTypeWithDescriptor> myTempPatternsTable;
    private FileTypeAssocTable<Language> myTempTemplateDataLanguages;
    private final Map<UserFileType<?>, UserFileType<?>> myOriginalToEditedMap = new HashMap();
    private FileType myFileTypeToPreselect;
    private IgnoredFilesAndFoldersPanel myIgnoreFilesPanel;
    private final FileTypeManagerImpl myFileTypeManager = (FileTypeManagerImpl)FileTypeManager.getInstance();

    public String getDisplayName() {
        return FileTypesBundle.message((String)"filetype.settings.title", (Object[])new Object[0]);
    }

    public JComponent createComponent() {
        JBTabbedPane tabbedPane = new JBTabbedPane();
        this.myFileTypePanel = new FileTypePanel();
        this.myRecognizedFileType = new RecognizedFileTypesPanel();
        JBSplitter splitter = new JBSplitter(false, 0.3f);
        splitter.setFirstComponent((JComponent)this.myRecognizedFileType);
        JPanel rightPanel = new JPanel(new BorderLayout());
        this.myPatterns = new PatternsPanel();
        this.myHashBangs = new HashBangPanel();
        rightPanel.add((Component)this.myPatterns, "Center");
        rightPanel.add((Component)this.myHashBangs, "South");
        splitter.setSecondComponent((JComponent)rightPanel);
        this.myFileTypePanel.myUpperPanel.add((Component)splitter, "Center");
        this.myRecognizedFileType.myFileTypesList.addListSelectionListener(__ -> this.updateExtensionList());
        this.myFileTypePanel.myAssociatePanel.setVisible(OSAssociateFileTypesUtil.isAvailable());
        this.myFileTypePanel.myAssociatePanel.setBorder(JBUI.Borders.emptyTop(16));
        this.myFileTypePanel.myAssociateButton.setText(FileTypesBundle.message((String)"filetype.associate.button", (Object[])new Object[]{ApplicationNamesInfo.getInstance().getFullProductName()}));
        this.myFileTypePanel.myAssociateButton.addActionListener(__ -> OSAssociateFileTypesUtil.chooseAndAssociate(new OSAssociateFileTypesUtil.Callback(){

            @Override
            public void beforeStart() {
                ApplicationManager.getApplication().invokeLater(() -> {
                    FileTypeConfigurable.this.myFileTypePanel.myAssociateButton.setEnabled(false);
                    FileTypeConfigurable.this.updateAssociateMessageLabel(FileTypesBundle.message((String)"filetype.associate.message.updating", (Object[])new Object[0]), null);
                }, ModalityState.any());
            }

            @Override
            public void onSuccess(boolean isOsRestartRequired) {
                ApplicationManager.getApplication().invokeLater(() -> {
                    FileTypeConfigurable.this.myFileTypePanel.myAssociateButton.setEnabled(true);
                    if (isOsRestartRequired) {
                        FileTypeConfigurable.this.updateAssociateMessageLabel(FileTypesBundle.message((String)"filetype.associate.message.os.restart", (Object[])new Object[0]), AllIcons.General.Warning);
                    } else {
                        FileTypeConfigurable.this.updateAssociateMessageLabel("", null);
                    }
                    FileTypeConfigurable.this.showAssociationBalloon(FileTypesBundle.message((String)"filetype.associate.success.message", (Object[])new Object[]{ApplicationInfo.getInstance().getFullApplicationName()}), HintUtil.getInformationColor());
                }, ModalityState.any());
            }

            @Override
            public void onFailure(@NotNull @Nls String errorMessage) {
                if (errorMessage == null) {
                    1.$$$reportNull$$$0(0);
                }
                ApplicationManager.getApplication().invokeLater(() -> {
                    FileTypeConfigurable.this.myFileTypePanel.myAssociateButton.setEnabled(true);
                    FileTypeConfigurable.this.updateAssociateMessageLabel("", null);
                    FileTypeConfigurable.this.showAssociationBalloon(errorMessage, HintUtil.getErrorColor());
                }, ModalityState.any());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errorMessage", "com/intellij/openapi/fileTypes/impl/FileTypeConfigurable$1", "onFailure"));
            }
        }));
        tabbedPane.add(FileTypesBundle.message((String)"filetype.recognized.group", (Object[])new Object[0]), (Component)this.myFileTypePanel.myWholePanel);
        this.myIgnoreFilesPanel = new IgnoredFilesAndFoldersPanel();
        tabbedPane.add(FileTypesBundle.message((String)"filetype.ignore.group", (Object[])new Object[0]), (Component)this.myIgnoreFilesPanel);
        return tabbedPane;
    }

    private void updateAssociateMessageLabel(@NotNull @Nls String message, @Nullable Icon icon2) {
        if (message == null) {
            FileTypeConfigurable.$$$reportNull$$$0(0);
        }
        this.myFileTypePanel.myAssociateMessageLabel.setText(message);
        this.myFileTypePanel.myAssociateMessageLabel.setIcon(icon2);
    }

    private void showAssociationBalloon(@NotNull @Nls String message, @NotNull Color color) {
        if (message == null) {
            FileTypeConfigurable.$$$reportNull$$$0(1);
        }
        if (color == null) {
            FileTypeConfigurable.$$$reportNull$$$0(2);
        }
        Balloon balloon = JBPopupFactory.getInstance().createBalloonBuilder((JComponent)new JLabel(message)).setFillColor(color).setHideOnKeyOutside(true).createBalloon();
        JButton component2 = this.myFileTypePanel.myAssociateButton;
        RelativePoint relativePoint = new RelativePoint(component2, new Point(component2.getWidth() / 2, component2.getHeight() - JBUI.scale(10)));
        balloon.show(relativePoint, Balloon.Position.below);
    }

    private void updateFileTypeList() {
        List<FileTypeManagerImpl.FileTypeWithDescriptor> types = ContainerUtil.sorted(ContainerUtil.filter(this.myTempFileTypes, ftd -> !ftd.fileType.isReadOnly()), (o1, o2) -> o1.fileType.getDescription().compareToIgnoreCase(o2.fileType.getDescription()));
        this.myRecognizedFileType.setFileTypes(types);
    }

    @NotNull
    private Set<FileTypeManagerImpl.FileTypeWithDescriptor> getRegisteredFilesTypes() {
        return new HashSet<FileTypeManagerImpl.FileTypeWithDescriptor>(this.myFileTypeManager.getRegisteredFileTypeWithDescriptors());
    }

    public void apply() {
        this.copyTypeMap();
        ApplicationManager.getApplication().runWriteAction(() -> {
            if (!this.myFileTypeManager.isIgnoredFilesListEqualToCurrent(this.myIgnoreFilesPanel.getValues())) {
                this.myFileTypeManager.setIgnoredFilesList(this.myIgnoreFilesPanel.getValues());
            }
            this.myFileTypeManager.setPatternsTable(this.myTempFileTypes, this.myTempPatternsTable);
            TemplateDataLanguagePatterns.getInstance().setAssocTable(this.myTempTemplateDataLanguages);
        });
    }

    private void copyTypeMap() {
        Set<UserFileType<?>> modifiedUserTypes = this.myOriginalToEditedMap.keySet();
        for (UserFileType<?> oldType : modifiedUserTypes) {
            oldType.copyFrom(this.myOriginalToEditedMap.get(oldType));
        }
        this.myOriginalToEditedMap.clear();
    }

    public void reset() {
        this.myTempPatternsTable = this.myFileTypeManager.getExtensionMap().copy();
        this.myTempTemplateDataLanguages = TemplateDataLanguagePatterns.getInstance().getAssocTable();
        this.myTempFileTypes = this.getRegisteredFilesTypes();
        this.myOriginalToEditedMap.clear();
        FileTypeManagerImpl.FileTypeWithDescriptor lastSelectedFileType = this.myRecognizedFileType.getSelectedFileType();
        this.updateFileTypeList();
        this.updateExtensionList();
        this.myIgnoreFilesPanel.setValues(this.myFileTypeManager.getIgnoredFilesList());
        if (this.myFileTypeToPreselect != null) {
            this.myRecognizedFileType.selectFileType(this.myFileTypeToPreselect);
        } else if (lastSelectedFileType != null) {
            this.myRecognizedFileType.selectFileType(lastSelectedFileType.fileType);
        }
    }

    public boolean isModified() {
        if (!this.myFileTypeManager.isIgnoredFilesListEqualToCurrent(this.myIgnoreFilesPanel.getValues())) {
            return true;
        }
        return !this.myTempPatternsTable.equals((Object)this.myFileTypeManager.getExtensionMap()) || !this.myTempFileTypes.equals(this.getRegisteredFilesTypes()) || !this.myOriginalToEditedMap.isEmpty() || !this.myTempTemplateDataLanguages.equals(TemplateDataLanguagePatterns.getInstance().getAssocTable());
    }

    public void disposeUIResources() {
        if (this.myFileTypePanel != null) {
            this.myRecognizedFileType.setFileTypes(Collections.emptyList());
            this.myPatterns.clearList();
            this.myHashBangs.clearList();
        }
        this.myFileTypePanel = null;
        this.myRecognizedFileType = null;
        this.myPatterns = null;
        this.myHashBangs = null;
    }

    private void updateExtensionList() {
        FileTypeManagerImpl.FileTypeWithDescriptor ftd = this.myRecognizedFileType.getSelectedFileType();
        if (ftd == null) {
            return;
        }
        this.myPatterns.refill(this.myTempPatternsTable.getAssociations((Object)ftd));
        this.myHashBangs.refill(this.myTempPatternsTable.getHashBangPatterns((Object)ftd));
    }

    private void editFileType() {
        TypeEditor editor2;
        FileTypeManagerImpl.FileTypeWithDescriptor ftd = this.myRecognizedFileType.getSelectedFileType();
        if (ftd == null || !FileTypeConfigurable.canBeModified(ftd.fileType)) {
            return;
        }
        UserFileType userFileType = (UserFileType)ftd.fileType;
        UserFileType ftToEdit = this.myOriginalToEditedMap.get(userFileType);
        if (ftToEdit == null) {
            ftToEdit = userFileType.clone();
        }
        if ((editor2 = new TypeEditor(this.myRecognizedFileType.myFileTypesList, ftToEdit, FileTypesBundle.message((String)"filetype.edit.existing.title", (Object[])new Object[0]))).showAndGet()) {
            FileTypeConfigurableInteractions.fileTypeEdited.log();
            if (userFileType.equals(ftToEdit)) {
                this.myOriginalToEditedMap.remove(userFileType);
            } else {
                this.myOriginalToEditedMap.put(userFileType, ftToEdit);
            }
            this.myRecognizedFileType.myCellRenderer.resetDuplicates();
        }
    }

    private void removeFileType() {
        FileTypeManagerImpl.FileTypeWithDescriptor ftd = this.myRecognizedFileType.getSelectedFileType();
        if (ftd == null) {
            return;
        }
        FileType fileType = ftd.fileType;
        FileTypeConfigurableInteractions.fileTypeRemoved.log();
        int index2 = this.myRecognizedFileType.myFileTypesList.getSelectedIndex();
        this.myTempFileTypes.remove(ftd);
        if (fileType instanceof UserFileType) {
            this.myOriginalToEditedMap.remove(fileType);
        }
        List matchers = this.myTempPatternsTable.getAssociations((Object)ftd);
        this.myTempPatternsTable.removeAllAssociations((Object)ftd);
        for (FileNameMatcher matcher : matchers) {
            this.myTempTemplateDataLanguages.removeAssociation(matcher, null);
        }
        this.updateFileTypeList();
        this.updateExtensionList();
        index2 = Math.min(index2, this.myRecognizedFileType.myFileTypesList.getModel().getSize() - 1);
        ScrollingUtil.selectItem(this.myRecognizedFileType.myFileTypesList, (int)index2);
    }

    private static boolean canBeModified(@Nullable FileType fileType) {
        return fileType instanceof AbstractFileType;
    }

    private void addFileType() {
        AbstractFileType type = new AbstractFileType(new SyntaxTable());
        TypeEditor editor2 = new TypeEditor(this.myRecognizedFileType.myFileTypesList, (UserFileType<?>)type, FileTypesBundle.message((String)"filetype.edit.new.title", (Object[])new Object[0]));
        if (editor2.showAndGet()) {
            FileTypeConfigurableInteractions.fileTypeAdded.log();
            this.myTempFileTypes.add(FileTypeManagerImpl.coreDescriptorFor((FileType)type));
            this.updateFileTypeList();
            this.updateExtensionList();
            this.myRecognizedFileType.selectFileType((FileType)type);
        }
    }

    private void editPattern() {
        Pair<FileNameMatcher, Language> item = this.myPatterns.getSelectedItem();
        if (item != null) {
            this.editPattern(item);
        }
    }

    private void editPattern(@Nullable(value="null means new") @Nullable(value="null means new") Pair<FileNameMatcher, Language> item) {
        FileTypeManagerImpl.FileTypeWithDescriptor ftd = this.myRecognizedFileType.getSelectedFileType();
        if (ftd == null) {
            return;
        }
        FileType type = ftd.fileType;
        if (item == null) {
            FileTypeConfigurableInteractions.patternAdded.log((Object)type);
        } else {
            FileTypeConfigurableInteractions.patternEdited.log((Object)type);
        }
        String title = FileTypesBundle.message((String)(item == null ? "filetype.edit.add.pattern.title" : "filetype.edit.edit.pattern.title"), (Object[])new Object[0]);
        Language oldLanguage = item == null ? null : (Language)item.second;
        String oldPattern = item == null ? null : ((FileNameMatcher)item.first).getPresentableString();
        FileTypePatternDialog dialog = new FileTypePatternDialog(oldPattern, type, oldLanguage);
        DialogBuilder builder2 = new DialogBuilder(this.myPatterns.myList);
        builder2.setPreferredFocusComponent((JComponent)dialog.getPatternField());
        builder2.setCenterPanel((JComponent)dialog.getMainPanel());
        builder2.setTitle(title);
        builder2.showModal(true);
        if (builder2.getDialogWrapper().isOK()) {
            String pattern = dialog.getPatternField().getText();
            if (StringUtil.isEmpty(pattern)) {
                return;
            }
            FileNameMatcher matcher = FileTypeManager.parseFromString((String)pattern);
            FileTypeManagerImpl.FileTypeWithDescriptor registeredFtd = this.findExistingFileType(matcher);
            if (registeredFtd != null && registeredFtd.fileType != type) {
                FileType registeredFileType = registeredFtd.fileType;
                if (registeredFileType.isReadOnly()) {
                    Messages.showMessageDialog(this.myPatterns.myList, (String)FileTypesBundle.message((String)"filetype.edit.add.pattern.exists.error", (Object[])new Object[]{registeredFileType.getDescription()}), (String)title, (Icon)Messages.getErrorIcon());
                    return;
                }
                int ret = Messages.showOkCancelDialog(this.myPatterns.myList, (String)FileTypesBundle.message((String)"filetype.edit.add.pattern.exists.message", (Object[])new Object[]{registeredFileType.getDescription()}), (String)FileTypesBundle.message((String)"filetype.edit.add.pattern.exists.title", (Object[])new Object[0]), (String)FileTypesBundle.message((String)"filetype.edit.add.pattern.reassign.button", (Object[])new Object[0]), (String)CommonBundle.getCancelButtonText(), (Icon)Messages.getQuestionIcon());
                if (ret == 0) {
                    this.myTempPatternsTable.removeAssociation(matcher, (Object)registeredFtd);
                    this.myTempTemplateDataLanguages.removeAssociation(matcher, null);
                } else {
                    return;
                }
            }
            if (item != null) {
                this.myTempPatternsTable.removeAssociation((FileNameMatcher)item.first, (Object)ftd);
                this.myTempTemplateDataLanguages.removeAssociation((FileNameMatcher)item.first, (Object)((Language)item.second));
            }
            this.myTempPatternsTable.addAssociation(matcher, (Object)ftd);
            Language language = dialog.getTemplateDataLanguage();
            if (language != null) {
                this.myTempTemplateDataLanguages.addAssociation(matcher, (Object)language);
            }
            this.updateExtensionList();
            this.myPatterns.select(pattern);
            IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus(this.myPatterns.myList, true));
        }
    }

    private void addPattern() {
        this.editPattern(null);
    }

    @Nullable
    private FileTypeManagerImpl.FileTypeWithDescriptor findExistingFileType(@NotNull FileNameMatcher matcher) {
        FileTypeManagerImpl.FileTypeWithDescriptor ftd;
        if (matcher == null) {
            FileTypeConfigurable.$$$reportNull$$$0(3);
        }
        if ((ftd = (FileTypeManagerImpl.FileTypeWithDescriptor)this.myTempPatternsTable.findAssociatedFileType(matcher)) != null && ftd.fileType != FileTypes.UNKNOWN) {
            return ftd;
        }
        // Could not load outer class - annotation placement on inner may be incorrect
        @NotNull FileTypeManagerImpl.FileTypeWithDescriptor registeredFtd = this.myFileTypeManager.getFileTypeWithDescriptorByExtension(matcher.getPresentableString());
        if (registeredFtd.fileType != FileTypes.UNKNOWN && registeredFtd.fileType.isReadOnly()) {
            return registeredFtd;
        }
        return null;
    }

    private void removePattern() {
        FileTypeManagerImpl.FileTypeWithDescriptor ftd = this.myRecognizedFileType.getSelectedFileType();
        if (ftd == null) {
            return;
        }
        FileTypeConfigurableInteractions.patternRemoved.log((Object)ftd.fileType);
        Pair<FileNameMatcher, Language> removed = this.myPatterns.removeSelected();
        if (removed == null) {
            return;
        }
        this.myTempPatternsTable.removeAssociation((FileNameMatcher)removed.first, (Object)ftd);
        this.myTempTemplateDataLanguages.removeAssociation((FileNameMatcher)removed.first, (Object)((Language)removed.second));
        IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus(this.myPatterns.myList, true));
    }

    private void removeHashBang() {
        FileTypeManagerImpl.FileTypeWithDescriptor ftd = this.myRecognizedFileType.getSelectedFileType();
        if (ftd == null) {
            return;
        }
        FileTypeConfigurableInteractions.hashbangRemoved.log((Object)ftd.fileType);
        String extension2 = this.myHashBangs.removeSelected();
        if (extension2 == null) {
            return;
        }
        this.myTempPatternsTable.removeHashBangPattern(extension2, (Object)ftd);
        IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus(this.myHashBangs.myList, true));
    }

    @NotNull
    public String getHelpTopic() {
        return "preferences.fileTypes";
    }

    public void selectFileType(@NotNull FileType fileType) {
        if (fileType == null) {
            FileTypeConfigurable.$$$reportNull$$$0(4);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (this.myRecognizedFileType == null) {
            this.myFileTypeToPreselect = fileType;
        } else {
            this.myRecognizedFileType.selectFileType(fileType);
        }
    }

    private void editHashBang() {
        String item = this.myHashBangs.getSelectedItem();
        if (item == null) {
            return;
        }
        this.editHashBang(item);
    }

    private void editHashBang(@Nullable(value="null means new") @Nullable(value="null means new") String oldHashBang) {
        FileTypeManagerImpl.FileTypeWithDescriptor ftd = this.myRecognizedFileType.getSelectedFileType();
        if (ftd == null) {
            return;
        }
        FileType type = ftd.fileType;
        if (oldHashBang == null) {
            FileTypeConfigurableInteractions.hashbangAdded.log((Object)type);
        } else {
            FileTypeConfigurableInteractions.hashbangEdited.log((Object)type);
        }
        String title = FileTypesBundle.message((String)(oldHashBang == null ? "filetype.add.hashbang.title" : "filetype.edit.hashbang.title"), (Object[])new Object[0]);
        String hashbang = Messages.showInputDialog(this.myHashBangs.myList, (String)FileTypesBundle.message((String)"filetype.edit.hashbang.prompt", (Object[])new Object[0]), (String)title, null, (String)oldHashBang, null);
        if (StringUtil.isEmpty(hashbang)) {
            return;
        }
        HashBangConflict conflict = this.checkHashBangConflict(hashbang);
        if (conflict != null && conflict.fileType.fileType != type) {
            FileTypeManagerImpl.FileTypeWithDescriptor existingFtd = conflict.fileType;
            FileType existingFileType = existingFtd.fileType;
            if (!conflict.writeable) {
                String message = conflict.exact ? FileTypesBundle.message((String)"filetype.edit.hashbang.exists.exact.error", (Object[])new Object[]{existingFileType.getDescription()}) : FileTypesBundle.message((String)"filetype.edit.hashbang.exists.similar.error", (Object[])new Object[]{existingFileType.getDescription(), conflict.existingHashBang});
                Messages.showMessageDialog(this.myHashBangs.myList, (String)message, (String)title, (Icon)Messages.getErrorIcon());
                return;
            }
            String message = conflict.exact ? FileTypesBundle.message((String)"filetype.edit.hashbang.exists.exact.message", (Object[])new Object[]{existingFileType.getDescription()}) : FileTypesBundle.message((String)"filetype.edit.hashbang.exists.similar.message", (Object[])new Object[]{existingFileType.getDescription(), conflict.existingHashBang});
            int ret = Messages.showOkCancelDialog(this.myHashBangs.myList, (String)message, (String)FileTypesBundle.message((String)"filetype.edit.hashbang.exists.title", (Object[])new Object[0]), (String)FileTypesBundle.message((String)"filetype.edit.hashbang.reassign.button", (Object[])new Object[0]), (String)CommonBundle.getCancelButtonText(), (Icon)Messages.getQuestionIcon());
            if (ret != 0) {
                return;
            }
            this.myTempPatternsTable.removeHashBangPattern(hashbang, (Object)existingFtd);
            this.myTempPatternsTable.removeHashBangPattern(conflict.existingHashBang, (Object)conflict.fileType);
        }
        if (oldHashBang != null) {
            this.myTempPatternsTable.removeHashBangPattern(oldHashBang, (Object)ftd);
        }
        this.myTempPatternsTable.addHashBangPattern(hashbang, (Object)ftd);
        this.updateExtensionList();
        this.myHashBangs.select(hashbang);
        IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus(this.myPatterns.myList, true));
    }

    private boolean isStandardFileType(@NotNull FileType fileType) {
        if (fileType == null) {
            FileTypeConfigurable.$$$reportNull$$$0(5);
        }
        return this.myFileTypeManager.getStdFileType(fileType.getName()) == fileType;
    }

    private HashBangConflict checkHashBangConflict(@NotNull String hashbang) {
        String existingHashBang;
        if (hashbang == null) {
            FileTypeConfigurable.$$$reportNull$$$0(6);
        }
        for (Map.Entry entry : this.myTempPatternsTable.getInternalRawHashBangPatterns().entrySet()) {
            existingHashBang = (String)entry.getKey();
            if (!hashbang.contains(existingHashBang) && !existingHashBang.contains(hashbang)) continue;
            FileTypeManagerImpl.FileTypeWithDescriptor ftd = (FileTypeManagerImpl.FileTypeWithDescriptor)entry.getValue();
            boolean exact2 = existingHashBang.equals(hashbang);
            boolean writeable = !ftd.fileType.isReadOnly() && !this.isStandardFileType(ftd.fileType);
            return new HashBangConflict(ftd, exact2, writeable, existingHashBang);
        }
        for (FileTypeRegistry.FileTypeDetector detector : FileTypeRegistry.FileTypeDetector.EP_NAME.getIterable()) {
            if (!(detector instanceof HashBangFileTypeDetector) || !hashbang.contains(existingHashBang = ((HashBangFileTypeDetector)detector).getMarker()) && !existingHashBang.contains(hashbang)) continue;
            FileType fileType = ((HashBangFileTypeDetector)detector).getFileType();
            boolean exact3 = existingHashBang.equals(hashbang);
            boolean writeable = false;
            FileTypeManagerImpl.FileTypeWithDescriptor ftd = FileTypeManagerImpl.detectPluginDescriptor((FileType)fileType);
            return new HashBangConflict(ftd, exact3, writeable, existingHashBang);
        }
        return null;
    }

    @NotNull
    public String getId() {
        String string2 = this.getHelpTopic();
        if (string2 == null) {
            FileTypeConfigurable.$$$reportNull$$$0(7);
        }
        return string2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "color";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "matcher";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileType";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hashbang";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/fileTypes/impl/FileTypeConfigurable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/fileTypes/impl/FileTypeConfigurable";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "updateAssociateMessageLabel";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "showAssociationBalloon";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findExistingFileType";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "selectFileType";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isStandardFileType";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "checkHashBangConflict";
                break;
            }
            case 7: {
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 7 -> new IllegalStateException(string2);
        };
    }

    class RecognizedFileTypesPanel
    extends JPanel {
        private final JList<FileTypeManagerImpl.FileTypeWithDescriptor> myFileTypesList = new JBList(new DefaultListModel());
        private final FileTypeWithDescriptorRenderer<FileTypeManagerImpl.FileTypeWithDescriptor> myCellRenderer;

        RecognizedFileTypesPanel() {
            this.setLayout(new BorderLayout());
            this.myFileTypesList.setSelectionMode(0);
            this.myCellRenderer = new FileTypeWithDescriptorRenderer(this.myFileTypesList.getModel(), ftd -> {
                FileType fileType = ftd.fileType;
                UserFileType<?> modified = FileTypeConfigurable.this.myOriginalToEditedMap.get(fileType);
                return modified != null ? modified : fileType;
            });
            this.myFileTypesList.setCellRenderer((ListCellRenderer<FileTypeManagerImpl.FileTypeWithDescriptor>)this.myCellRenderer);
            new DoubleClickListener(){

                protected boolean onDoubleClick(@NotNull MouseEvent e) {
                    if (e == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    FileTypeConfigurable.this.editFileType();
                    return true;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/fileTypes/impl/FileTypeConfigurable$RecognizedFileTypesPanel$1", "onDoubleClick"));
                }
            }.installOn(this.myFileTypesList);
            ToolbarDecorator toolbarDecorator = ToolbarDecorator.createDecorator(this.myFileTypesList).setScrollPaneBorder((Border)JBUI.Borders.empty()).setPanelBorder(JBUI.Borders.customLine(JBColor.border(), 1, 1, 0, 1)).setAddAction(__ -> FileTypeConfigurable.this.addFileType()).setRemoveAction(__ -> FileTypeConfigurable.this.removeFileType()).setEditAction(__ -> FileTypeConfigurable.this.editFileType()).setEditActionUpdater(e -> this.selectedTypeCanBeModified()).setRemoveActionUpdater(e -> this.selectedTypeCanBeModified()).disableUpDownActions();
            this.add((Component)toolbarDecorator.createPanel(), "North");
            JBScrollPane scrollPane = new JBScrollPane(this.myFileTypesList);
            this.add((Component)scrollPane, "Center");
            scrollPane.setBorder(JBUI.Borders.customLine(JBColor.border(), 0, 1, 1, 1));
            new MySpeedSearch(this.myFileTypesList);
        }

        private boolean selectedTypeCanBeModified() {
            FileTypeManagerImpl.FileTypeWithDescriptor ftd = this.getSelectedFileType();
            if (ftd == null) {
                return false;
            }
            return FileTypeConfigurable.canBeModified(ftd.fileType);
        }

        FileTypeManagerImpl.FileTypeWithDescriptor getSelectedFileType() {
            return this.myFileTypesList.getSelectedValue();
        }

        void setFileTypes(@NotNull Collection<FileTypeManagerImpl.FileTypeWithDescriptor> types) {
            if (types == null) {
                RecognizedFileTypesPanel.$$$reportNull$$$0(0);
            }
            DefaultListModel listModel = (DefaultListModel)this.myFileTypesList.getModel();
            listModel.clear();
            for (FileTypeManagerImpl.FileTypeWithDescriptor type : types) {
                if (type.fileType == FileTypes.UNKNOWN) continue;
                listModel.addElement(type);
            }
            ScrollingUtil.ensureSelectionExists(this.myFileTypesList);
        }

        void selectFileType(@NotNull FileType fileType) {
            if (fileType == null) {
                RecognizedFileTypesPanel.$$$reportNull$$$0(1);
            }
            this.myFileTypesList.setSelectedValue(FileTypeManagerImpl.FileTypeWithDescriptor.allFor((FileType)fileType), true);
            IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus(this.myFileTypesList, true));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "types";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fileType";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/fileTypes/impl/FileTypeConfigurable$RecognizedFileTypesPanel";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setFileTypes";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "selectFileType";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }

        private final class MySpeedSearch
        extends SpeedSearchBase<JList<FileTypeManagerImpl.FileTypeWithDescriptor>> {
            private final List<Condition<Pair<Object, String>>> myOrderedConverters;
            private Object myCurrentType;
            private String myExtension;

            private MySpeedSearch(JList<FileTypeManagerImpl.FileTypeWithDescriptor> component2) {
                if (component2 == null) {
                    MySpeedSearch.$$$reportNull$$$0(0);
                }
                super(component2);
                this.myOrderedConverters = Arrays.asList(p -> {
                    String value = p.first.toString();
                    if (p.first instanceof FileTypeManagerImpl.FileTypeWithDescriptor) {
                        value = ((FileTypeManagerImpl.FileTypeWithDescriptor)p.first).fileType.getDescription();
                    }
                    return this.getComparator().matchingFragments((String)p.second, value) != null;
                }, p -> p.first instanceof FileTypeManagerImpl.FileTypeWithDescriptor && this.myCurrentType != null && this.myCurrentType.equals(p.first));
            }

            protected boolean isMatchingElement(Object element, String pattern) {
                for (Condition<Pair<Object, String>> convertor : this.myOrderedConverters) {
                    boolean matched = convertor.value(Pair.pair(element, pattern));
                    if (!matched) continue;
                    return true;
                }
                return false;
            }

            @Nullable
            protected String getElementText(Object element) {
                throw new IllegalStateException();
            }

            protected int getSelectedIndex() {
                return ((JList)this.myComponent).getSelectedIndex();
            }

            protected int getElementCount() {
                return ((JList)this.myComponent).getModel().getSize();
            }

            protected Object getElementAt(int viewIndex) {
                return ((JList)this.myComponent).getModel().getElementAt(viewIndex);
            }

            protected void selectElement(Object element, String selectedText) {
                if (element != null) {
                    ScrollingUtil.selectItem((JList)((JList)this.myComponent), (Object)((FileTypeManagerImpl.FileTypeWithDescriptor)element));
                    if (element.equals(this.myCurrentType)) {
                        FileTypeConfigurable.this.myPatterns.select(this.myExtension);
                    }
                }
            }

            protected void onSearchFieldUpdated(String s) {
                super.onSearchFieldUpdated((String)s);
                if (FileTypeConfigurable.this.myTempPatternsTable == null) {
                    return;
                }
                int index2 = ((String)s).lastIndexOf(46);
                if (index2 < 0) {
                    s = "." + (String)s;
                }
                this.myCurrentType = FileTypeConfigurable.this.myTempPatternsTable.findAssociatedFileType((CharSequence)s);
                this.myExtension = this.myCurrentType != null ? s : null;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/openapi/fileTypes/impl/FileTypeConfigurable$RecognizedFileTypesPanel$MySpeedSearch", "<init>"));
            }
        }
    }

    class PatternsPanel
    extends JPanel {
        private final JBList<Pair<FileNameMatcher, Language>> myList = new JBList(new DefaultListModel());

        PatternsPanel() {
            this.setLayout(new BorderLayout());
            this.myList.setSelectionMode(0);
            this.myList.setCellRenderer((ListCellRenderer)((Object)new ExtensionRenderer()));
            this.myList.getEmptyText().setText(FileTypesBundle.message((String)"filetype.settings.no.patterns", (Object[])new Object[0]));
            this.myList.setBorder((Border)JBUI.Borders.empty());
            ToolbarDecorator decorator = ToolbarDecorator.createDecorator(this.myList).setScrollPaneBorder((Border)JBUI.Borders.empty()).setPanelBorder(JBUI.Borders.customLine(JBColor.border(), 1, 1, 0, 1)).setAddAction(__ -> FileTypeConfigurable.this.addPattern()).setEditAction(__ -> FileTypeConfigurable.this.editPattern()).setRemoveAction(__ -> FileTypeConfigurable.this.removePattern()).disableUpDownActions();
            this.add((Component)decorator.createPanel(), "North");
            JBScrollPane scrollPane = new JBScrollPane(this.myList);
            scrollPane.setBorder(JBUI.Borders.customLine(JBColor.border(), 0, 1, 1, 1));
            this.add((Component)scrollPane, "Center");
            this.setBorder((Border)IdeBorderFactory.createTitledBorder((String)FileTypesBundle.message((String)"filetype.registered.patterns.group", (Object[])new Object[0]), (boolean)false, (Insets)TITLE_INSETS).setShowLine(false));
        }

        void clearList() {
            ((DefaultListModel)this.myList.getModel()).clear();
            this.myList.clearSelection();
        }

        void select(@NotNull String pattern) {
            if (pattern == null) {
                PatternsPanel.$$$reportNull$$$0(0);
            }
            for (int i2 = 0; i2 < this.myList.getItemsCount(); ++i2) {
                Pair at = (Pair)this.myList.getModel().getElementAt(i2);
                if (!((FileNameMatcher)at.first).acceptsCharSequence((CharSequence)pattern)) continue;
                ScrollingUtil.selectItem(this.myList, (int)i2);
                return;
            }
        }

        Pair<FileNameMatcher, Language> removeSelected() {
            Pair<FileNameMatcher, Language> selectedValue = this.getSelectedItem();
            if (selectedValue == null) {
                return null;
            }
            ListUtil.removeSelectedItems(this.myList);
            return selectedValue;
        }

        Pair<FileNameMatcher, Language> getSelectedItem() {
            return (Pair)this.myList.getSelectedValue();
        }

        private void refill(@NotNull List<? extends FileNameMatcher> matchers) {
            if (matchers == null) {
                PatternsPanel.$$$reportNull$$$0(1);
            }
            this.clearList();
            ArrayList<? extends FileNameMatcher> copy2 = new ArrayList<FileNameMatcher>(matchers);
            copy2.sort(Comparator.comparing(FileNameMatcher::getPresentableString));
            DefaultListModel model2 = (DefaultListModel)this.myList.getModel();
            for (FileNameMatcher fileNameMatcher : copy2) {
                Language language = (Language)FileTypeConfigurable.this.myTempTemplateDataLanguages.findAssociatedFileType(fileNameMatcher);
                model2.addElement(Pair.create(fileNameMatcher, language));
            }
            ScrollingUtil.ensureSelectionExists(this.myList);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "pattern";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "matchers";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/fileTypes/impl/FileTypeConfigurable$PatternsPanel";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "select";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "refill";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    class HashBangPanel
    extends JPanel {
        private final JBList<String> myList = new JBList(new DefaultListModel());

        HashBangPanel() {
            this.setLayout(new BorderLayout());
            this.myList.setSelectionMode(0);
            this.myList.setCellRenderer((ListCellRenderer)((Object)new HashBangRenderer()));
            this.myList.setEmptyText(FileTypesBundle.message((String)"filetype.settings.no.patterns", (Object[])new Object[0]));
            this.myList.setBorder((Border)JBUI.Borders.empty());
            ToolbarDecorator decorator = ToolbarDecorator.createDecorator(this.myList).setScrollPaneBorder((Border)JBUI.Borders.empty()).setPanelBorder(JBUI.Borders.customLine(JBColor.border(), 1, 1, 0, 1)).setAddAction(__ -> FileTypeConfigurable.this.editHashBang(null)).setAddActionName(LangBundle.message("action.HashBangPanel.add.hashbang.pattern.text", new Object[0])).setEditAction(__ -> FileTypeConfigurable.this.editHashBang()).setRemoveAction(__ -> FileTypeConfigurable.this.removeHashBang()).disableUpDownActions();
            this.add((Component)decorator.createPanel(), "North");
            JBScrollPane scrollPane = new JBScrollPane(this.myList);
            this.add((Component)scrollPane, "Center");
            scrollPane.setBorder(JBUI.Borders.customLine(JBColor.border(), 0, 1, 1, 1));
            this.setBorder((Border)IdeBorderFactory.createTitledBorder((String)FileTypesBundle.message((String)"filetype.hashbang.group", (Object[])new Object[0]), (boolean)false, (Insets)TITLE_INSETS).setShowLine(false));
        }

        void clearList() {
            ((DefaultListModel)this.myList.getModel()).clear();
            this.myList.clearSelection();
        }

        void select(@NotNull String pattern) {
            if (pattern == null) {
                HashBangPanel.$$$reportNull$$$0(0);
            }
            ScrollingUtil.selectItem(this.myList, (Object)pattern);
        }

        String removeSelected() {
            String selectedValue = this.getSelectedItem();
            if (selectedValue == null) {
                return null;
            }
            ListUtil.removeSelectedItems(this.myList);
            return selectedValue;
        }

        String getSelectedItem() {
            return (String)this.myList.getSelectedValue();
        }

        private void refill(@NotNull List<String> patterns) {
            if (patterns == null) {
                HashBangPanel.$$$reportNull$$$0(1);
            }
            this.clearList();
            DefaultListModel model2 = (DefaultListModel)this.myList.getModel();
            for (String pattern : ContainerUtil.sorted(patterns)) {
                model2.addElement(pattern);
            }
            ScrollingUtil.ensureSelectionExists(this.myList);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "pattern";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "patterns";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/fileTypes/impl/FileTypeConfigurable$HashBangPanel";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "select";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "refill";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private record HashBangConflict(@NotNull FileTypeManagerImpl.FileTypeWithDescriptor fileType, boolean exact, boolean writeable, @NotNull String existingHashBang) {
        @NotNull
        private final FileTypeManagerImpl.FileTypeWithDescriptor fileType;
        @NotNull
        private final String existingHashBang;

        private HashBangConflict(@NotNull FileTypeManagerImpl.FileTypeWithDescriptor fileType, boolean exact2, boolean writeable, @NotNull String existingHashBang) {
            if (fileType == null) {
                HashBangConflict.$$$reportNull$$$0(0);
            }
            if (existingHashBang == null) {
                HashBangConflict.$$$reportNull$$$0(1);
            }
        }

        @NotNull
        public FileTypeManagerImpl.FileTypeWithDescriptor fileType() {
            FileTypeManagerImpl.FileTypeWithDescriptor fileTypeWithDescriptor = this.fileType;
            if (fileTypeWithDescriptor == null) {
                HashBangConflict.$$$reportNull$$$0(2);
            }
            return fileTypeWithDescriptor;
        }

        @NotNull
        public String existingHashBang() {
            String string2 = this.existingHashBang;
            if (string2 == null) {
                HashBangConflict.$$$reportNull$$$0(3);
            }
            return string2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fileType";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "existingHashBang";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/fileTypes/impl/FileTypeConfigurable$HashBangConflict";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/fileTypes/impl/FileTypeConfigurable$HashBangConflict";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "fileType";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "existingHashBang";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string2 = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string2);
                case 2, 3 -> new IllegalStateException(string2);
            };
        }
    }

    private static class HashBangRenderer
    extends ColoredListCellRenderer<String> {
        private HashBangRenderer() {
        }

        protected void customizeCellRenderer(@NotNull JList<? extends String> list2, String value, int index2, boolean selected, boolean hasFocus) {
            if (list2 == null) {
                HashBangRenderer.$$$reportNull$$$0(0);
            }
            this.append("#!*", SimpleTextAttributes.GRAYED_ATTRIBUTES);
            this.append(value);
            this.append("*", SimpleTextAttributes.GRAYED_ATTRIBUTES);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/openapi/fileTypes/impl/FileTypeConfigurable$HashBangRenderer", "customizeCellRenderer"));
        }
    }

    private static class ExtensionRenderer
    extends ColoredListCellRenderer<Pair<FileNameMatcher, Language>> {
        private ExtensionRenderer() {
        }

        protected void customizeCellRenderer(@NotNull JList<? extends Pair<FileNameMatcher, Language>> list2, Pair<FileNameMatcher, Language> value, int index2, boolean selected, boolean hasFocus) {
            if (list2 == null) {
                ExtensionRenderer.$$$reportNull$$$0(0);
            }
            this.append(((FileNameMatcher)value.first).getPresentableString());
            if (value.second != null) {
                this.append(" (" + ((Language)value.second).getDisplayName() + ")", SimpleTextAttributes.GRAYED_ATTRIBUTES, false);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/openapi/fileTypes/impl/FileTypeConfigurable$ExtensionRenderer", "customizeCellRenderer"));
        }
    }
}

