/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileTypes.impl;

import com.intellij.DynamicBundle;
import com.intellij.lang.Language;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.fileTypes.TemplateLanguageFileType;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.psi.templateLanguages.TemplateDataLanguageMappings;
import com.intellij.ui.SimpleListCellRenderer;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.Comparator;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class FileTypePatternDialog {
    private JTextField myPatternField;
    private ComboBox<Language> myLanguageCombo;
    private JLabel myTemplateDataLanguageButton;
    private JPanel myMainPanel;

    FileTypePatternDialog(@Nullable String initialPatterns, @NotNull FileType fileType, Language templateDataLanguage) {
        if (fileType == null) {
            FileTypePatternDialog.$$$reportNull$$$0(0);
        }
        this.$$$setupUI$$$();
        this.myPatternField.setText(initialPatterns);
        if (fileType instanceof TemplateLanguageFileType) {
            DefaultComboBoxModel model2 = (DefaultComboBoxModel)this.myLanguageCombo.getModel();
            model2.addElement(null);
            List<Language> languages = ContainerUtil.sorted(TemplateDataLanguageMappings.getTemplateableLanguages(), Comparator.comparing(Language::getDisplayName));
            for (Language language : languages) {
                model2.addElement(language);
            }
            this.myLanguageCombo.setSwingPopup(false);
            this.myLanguageCombo.setRenderer((ListCellRenderer)SimpleListCellRenderer.create((label2, value, index2) -> {
                LanguageFileType type;
                label2.setText(value == null ? "" : value.getDisplayName());
                if (value != null && (type = value.getAssociatedFileType()) != null) {
                    label2.setIcon(type.getIcon());
                }
            }));
            this.myLanguageCombo.setSelectedItem((Object)templateDataLanguage);
        } else {
            this.myLanguageCombo.setVisible(false);
            this.myTemplateDataLanguageButton.setVisible(false);
        }
    }

    @NotNull
    JTextField getPatternField() {
        JTextField jTextField = this.myPatternField;
        if (jTextField == null) {
            FileTypePatternDialog.$$$reportNull$$$0(1);
        }
        return jTextField;
    }

    @NotNull
    JPanel getMainPanel() {
        JPanel jPanel = this.myMainPanel;
        if (jPanel == null) {
            FileTypePatternDialog.$$$reportNull$$$0(2);
        }
        return jPanel;
    }

    Language getTemplateDataLanguage() {
        return (Language)this.myLanguageCombo.getSelectedItem();
    }

    private /* synthetic */ void $$$setupUI$$$() {
        ComboBox comboBox;
        JLabel jLabel;
        JTextField jTextField;
        JPanel jPanel;
        this.myMainPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myPatternField = jTextField = new JTextField();
        jPanel.add((Component)jTextField, new GridConstraints(0, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        JLabel jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, DynamicBundle.getBundle("messages/FileTypesBundle", FileTypePatternDialog.class).getString("filetype.edit.add.pattern.prompt"));
        jPanel.add((Component)jLabel2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myTemplateDataLanguageButton = jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, DynamicBundle.getBundle("messages/LangBundle", FileTypePatternDialog.class).getString("label.template.data.language"));
        jPanel.add((Component)jLabel, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myLanguageCombo = comboBox = new ComboBox();
        jPanel.add((Component)comboBox, new GridConstraints(1, 1, 1, 1, 8, 1, 2, 0, null, null, null));
        jLabel2.setLabelFor(jTextField);
        jLabel.setLabelFor((Component)comboBox);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c2 = '\u0000';
        int n = -1;
        for (int j = 0; j < string2.length(); ++j) {
            if (string2.charAt(j) == '&') {
                if (++j == string2.length()) break;
                if (!bl && string2.charAt(j) != '&') {
                    bl = true;
                    c2 = string2.charAt(j);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string2.charAt(j));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c2);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileType";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/fileTypes/impl/FileTypePatternDialog";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/fileTypes/impl/FileTypePatternDialog";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getPatternField";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getMainPanel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 1, 2 -> new IllegalStateException(string2);
        };
    }
}

