/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileTypes.impl.associate.macos;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.impl.associate.OSFileAssociationException;
import com.intellij.openapi.util.Key;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SystemProperties;
import java.io.IOException;
import java.io.StringReader;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.jetbrains.annotations.NotNull;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class PListBuddyWrapper {
    public static final String UTIL_PATH = "/usr/libexec/PListBuddy";
    public static final String PLIST_PATH = SystemProperties.getUserHome() + "/Library/Preferences/com.apple.LaunchServices/com.apple.launchservices.secure.plist";
    private static final Logger LOG = Logger.getInstance(PListBuddyWrapper.class);

    CommandResult runCommand(@NotNull String command2) throws OSFileAssociationException {
        if (command2 == null) {
            PListBuddyWrapper.$$$reportNull$$$0(0);
        }
        return this.runCommand(OutputType.DEFAULT, command2);
    }

    CommandResult runCommand(@NotNull OutputType outputType, String ... commands) throws OSFileAssociationException {
        if (outputType == null) {
            PListBuddyWrapper.$$$reportNull$$$0(1);
        }
        GeneralCommandLine commandLine = new GeneralCommandLine();
        commandLine.setExePath(UTIL_PATH);
        for (String command2 : commands) {
            if (OutputType.XML.equals((Object)outputType)) {
                commandLine.addParameter("-x");
            }
            commandLine.addParameter("-c");
            commandLine.addParameter(command2);
        }
        commandLine.addParameter(PLIST_PATH);
        final StringBuilder errorMessage = new StringBuilder();
        final StringBuilder output = new StringBuilder();
        try {
            OSProcessHandler processHandler = new OSProcessHandler(commandLine);
            processHandler.addProcessListener((ProcessListener)new ProcessAdapter(){

                @Override
                public void onTextAvailable(@NotNull ProcessEvent event, @NotNull Key outputType) {
                    if (event == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (outputType == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    if (ProcessOutputTypes.STDOUT.equals(outputType)) {
                        output.append(event.getText());
                    }
                    if (ProcessOutputTypes.STDERR.equals(outputType)) {
                        errorMessage.append(event.getText());
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[0] = "event";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[0] = "outputType";
                            break;
                        }
                    }
                    objectArray[1] = "com/intellij/openapi/fileTypes/impl/associate/macos/PListBuddyWrapper$1";
                    objectArray[2] = "onTextAvailable";
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
            processHandler.startNotify();
            if (!processHandler.waitFor(1000L)) {
                throw new OSFileAssociationException("Failed to run update-mime-database in 1 sec");
            }
            if (errorMessage.length() > 0) {
                throw new OSFileAssociationException("PListBuddy returned: " + errorMessage.toString());
            }
            return new CommandResult(ObjectUtils.notNull(processHandler.getExitCode(), -1), output.toString());
        }
        catch (ExecutionException exe) {
            throw new OSFileAssociationException("Can't run PListBuddy: " + exe.getLocalizedMessage());
        }
    }

    @NotNull
    Document readData(@NotNull String dataId) throws OSFileAssociationException {
        if (dataId == null) {
            PListBuddyWrapper.$$$reportNull$$$0(2);
        }
        CommandResult result2 = this.runCommand(OutputType.XML, "Print " + dataId);
        if (result2.retCode != 0) {
            throw new OSFileAssociationException("PListBuddy returned " + result2.retCode);
        }
        if (result2.output != null && !result2.output.startsWith("<?xml")) {
            throw new OSFileAssociationException("Unexpected output: " + PListBuddyWrapper.truncateOutput(result2.output, 20));
        }
        if (result2.output == null) {
            throw new OSFileAssociationException("Empty output for Print " + dataId + " command");
        }
        Document document = this.parseXml(result2.output);
        if (document == null) {
            PListBuddyWrapper.$$$reportNull$$$0(3);
        }
        return document;
    }

    @NotNull
    Document parseXml(@NotNull String xmlString) throws OSFileAssociationException {
        Document document;
        if (xmlString == null) {
            PListBuddyWrapper.$$$reportNull$$$0(4);
        }
        DocumentBuilderFactory factory2 = DocumentBuilderFactory.newDefaultInstance();
        try {
            DocumentBuilder builder2 = factory2.newDocumentBuilder();
            StringReader stringReader = new StringReader(xmlString);
            InputSource source = new InputSource(stringReader);
            document = builder2.parse(source);
        }
        catch (ParserConfigurationException e) {
            LOG.error(e);
        }
        catch (IOException | SAXException e) {
            throw new OSFileAssociationException("XML read error: " + e.getMessage());
        }
        if (document == null) {
            PListBuddyWrapper.$$$reportNull$$$0(5);
        }
        return document;
        throw new OSFileAssociationException("XML parsing error, logged.");
    }

    private static String truncateOutput(@NotNull String output, int maxChars) {
        if (output == null) {
            PListBuddyWrapper.$$$reportNull$$$0(6);
        }
        return output.length() < maxChars ? output : output.substring(0, maxChars) + "...";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputType";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataId";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/fileTypes/impl/associate/macos/PListBuddyWrapper";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "xmlString";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "output";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/fileTypes/impl/associate/macos/PListBuddyWrapper";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "readData";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "parseXml";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "runCommand";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "readData";
                break;
            }
            case 3: 
            case 5: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "parseXml";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "truncateOutput";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 3, 5 -> new IllegalStateException(string2);
        };
    }

    static enum OutputType {
        DEFAULT,
        XML;

    }

    static class CommandResult {
        int retCode;
        String output;

        private CommandResult(int retCode, String output) {
            this.retCode = retCode;
            this.output = output;
        }
    }
}

