/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileTypes.impl.associate.macos;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.impl.associate.OSAssociateFileTypesUtil;
import com.intellij.openapi.fileTypes.impl.associate.OSFileAssociationException;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class UniformIdentifierUtil {
    private static final Map<String, String[]> TYPE_MAP = new HashMap<String, String[]>();
    public static final String CONTENT_TYPE_ATTR = "kMDItemContentType";

    UniformIdentifierUtil() {
    }

    private static void mapType(@NotNull String ijType, String ... macType) {
        if (ijType == null) {
            UniformIdentifierUtil.$$$reportNull$$$0(0);
        }
        TYPE_MAP.put(ijType, macType);
    }

    static String @NotNull [] getURIs(@NotNull FileType fileType) throws OSFileAssociationException {
        String[] stringArray;
        String[] uris;
        if (fileType == null) {
            UniformIdentifierUtil.$$$reportNull$$$0(1);
        }
        if ((uris = TYPE_MAP.get(fileType.getName())) != null) {
            if (uris == null) {
                UniformIdentifierUtil.$$$reportNull$$$0(2);
            }
            return uris;
        }
        try {
            ArrayList<String> uriList = new ArrayList<String>();
            for (String ext : OSAssociateFileTypesUtil.getExtensions(fileType)) {
                String uri = UniformIdentifierUtil.getUriByExtension(ext);
                if (uri == null) continue;
                uriList.add(uri);
            }
            stringArray = ArrayUtil.toStringArray(uriList);
        }
        catch (ExecutionException | IOException e) {
            throw new OSFileAssociationException(e.getMessage());
        }
        if (stringArray == null) {
            UniformIdentifierUtil.$$$reportNull$$$0(3);
        }
        return stringArray;
    }

    @Nullable
    private static String getUriByExtension(@NotNull String extension2) throws IOException, ExecutionException, OSFileAssociationException {
        if (extension2 == null) {
            UniformIdentifierUtil.$$$reportNull$$$0(4);
        }
        File file2 = FileUtil.createTempFile("content_", "." + extension2);
        GeneralCommandLine commandLine = new GeneralCommandLine();
        commandLine.setExePath("/usr/bin/mdls");
        commandLine.addParameter("-name");
        commandLine.addParameter(CONTENT_TYPE_ATTR);
        commandLine.addParameter(file2.getPath());
        final Ref contentTypeValue = Ref.create();
        OSProcessHandler handler2 = new OSProcessHandler(commandLine);
        final StringBuilder errMessage = new StringBuilder();
        handler2.addProcessListener((ProcessListener)new ProcessAdapter(){

            @Override
            public void onTextAvailable(@NotNull ProcessEvent event, @NotNull Key outputType) {
                String text2;
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (outputType == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (ProcessOutputTypes.STDERR.equals(outputType)) {
                    errMessage.append(event.getText());
                } else if (ProcessOutputTypes.STDOUT.equals(outputType) && (text2 = event.getText()).contains(UniformIdentifierUtil.CONTENT_TYPE_ATTR)) {
                    contentTypeValue.set(UniformIdentifierUtil.extractContentTypeValue(text2));
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "event";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "outputType";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/openapi/fileTypes/impl/associate/macos/UniformIdentifierUtil$1";
                objectArray[2] = "onTextAvailable";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        handler2.startNotify();
        if (!handler2.waitFor(1000L)) {
            throw new OSFileAssociationException("Failed to run mdls within 1 sec");
        }
        if (handler2.getExitCode() != null && handler2.getExitCode() != 0) {
            throw new OSFileAssociationException("mdls failed with exit code " + handler2.getExitCode() + ", error message: " + errMessage);
        }
        return (String)contentTypeValue.get();
    }

    @Nullable
    private static String extractContentTypeValue(@NotNull String contentType) {
        int eqPos;
        if (contentType == null) {
            UniformIdentifierUtil.$$$reportNull$$$0(5);
        }
        if ((eqPos = contentType.indexOf("=")) > 0) {
            String result2 = contentType.substring(eqPos + 1).trim();
            result2 = StringUtil.trimStart(result2, "\"");
            if (!(result2 = StringUtil.trimEnd(result2, "\"")).startsWith("dyn.")) {
                return result2;
            }
        }
        return null;
    }

    static {
        UniformIdentifierUtil.mapType("PLAIN_TEXT", "public.plain-text");
        UniformIdentifierUtil.mapType("HTML", "public.html");
        UniformIdentifierUtil.mapType("XML", "public.xml");
        UniformIdentifierUtil.mapType("ObjectiveC", "public.objective-c-source", "public.objective-c-plus-plus-source", "public.c-plus-plus-source", "public.c-source", "public.c-header", "public.c-plus-plus-header");
        UniformIdentifierUtil.mapType("JAVA", "com.sun.java-source");
        UniformIdentifierUtil.mapType("JavaScript", "com.netscape.javascript-source");
        UniformIdentifierUtil.mapType("Shell Script", "public.shell-script");
        UniformIdentifierUtil.mapType("Python", "public.python-script");
        UniformIdentifierUtil.mapType("Ruby", "public.ruby-script");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ijType";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileType";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/fileTypes/impl/associate/macos/UniformIdentifierUtil";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extension";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contentType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/fileTypes/impl/associate/macos/UniformIdentifierUtil";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getURIs";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "mapType";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getURIs";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getUriByExtension";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "extractContentTypeValue";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 2, 3 -> new IllegalStateException(string2);
        };
    }
}

