/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileTypes.impl.associate.win;

import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.execution.util.ExecUtil;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.fileTypes.ExtensionFileNameMatcher;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.impl.associate.OSAssociateFileTypesUtil;
import com.intellij.openapi.fileTypes.impl.associate.OSFileAssociationException;
import com.intellij.openapi.fileTypes.impl.associate.SystemFileTypeAssociator;
import com.intellij.openapi.fileTypes.impl.associate.win.WinFileTypeAssociator;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.system.CpuArch;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0017B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0016J\b\u0010\b\u001a\u00020\tH\u0002J\u0016\u0010\n\u001a\u00020\t2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u0006H\u0002J\b\u0010\r\u001a\u00020\tH\u0002J\u001e\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\t2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\t0\u0011H\u0002J\u001a\u0010\u0012\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0002\u00a8\u0006\u0018"}, d2={"Lcom/intellij/openapi/fileTypes/impl/associate/win/WinFileTypeAssociator;", "Lcom/intellij/openapi/fileTypes/impl/associate/SystemFileTypeAssociator;", "()V", "associateFileTypes", "", "fileTypes", "", "Lcom/intellij/openapi/fileTypes/FileType;", "createAssignCommandLineToFiletypeCommand", "", "createCmdScriptText", "extensions", "Lcom/intellij/openapi/fileTypes/impl/associate/win/WinFileTypeAssociator$Extension;", "getUniqueFileType", "runCmdCommandWithSudo", "cmdCommand", "errorMessageProvider", "Lkotlin/Function0;", "stringify", "commandLine", "Lcom/intellij/execution/configurations/GeneralCommandLine;", "processOutput", "Lcom/intellij/execution/process/ProcessOutput;", "Extension", "intellij.platform.lang.impl"})
@SourceDebugExtension(value={"SMAP\nWinFileTypeAssociator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WinFileTypeAssociator.kt\ncom/intellij/openapi/fileTypes/impl/associate/win/WinFileTypeAssociator\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,97:1\n1549#2:98\n1620#2,3:99\n1549#2:102\n1620#2,3:103\n1549#2:106\n1620#2,3:107\n*S KotlinDebug\n*F\n+ 1 WinFileTypeAssociator.kt\ncom/intellij/openapi/fileTypes/impl/associate/win/WinFileTypeAssociator\n*L\n35#1:98\n35#1:99,3\n37#1:102\n37#1:103,3\n44#1:106\n44#1:107,3\n*E\n"})
public final class WinFileTypeAssociator
implements SystemFileTypeAssociator {
    @Override
    public void associateFileTypes(@NotNull List<? extends FileType> fileTypes) throws OSFileAssociationException {
        ExtensionFileNameMatcher it;
        Collection collection;
        Iterable $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(fileTypes, (String)"fileTypes");
        Iterable $this$map$iv = fileTypes;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            FileType fileType = (FileType)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(OSAssociateFileTypesUtil.getMatchers((FileType)it));
        }
        $this$map$iv = CollectionsKt.filterIsInstance((Iterable)CollectionsKt.flatten((Iterable)((List)destination$iv$iv)), ExtensionFileNameMatcher.class);
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (ExtensionFileNameMatcher)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            String string2 = it.getExtension();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"it.extension");
            collection.add(new Extension(string2));
        }
        List extensions2 = (List)destination$iv$iv;
        this.runCmdCommandWithSudo(this.createCmdScriptText(extensions2), (Function0<String>)((Function0)associateFileTypes.1.INSTANCE));
    }

    /*
     * WARNING - void declaration
     */
    private final String createCmdScriptText(List<Extension> extensions2) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = extensions2;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Extension extension2 = (Extension)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add("assoc " + it.dotExtension() + "=" + this.getUniqueFileType());
        }
        List assocCommands = (List)destination$iv$iv;
        List allCommands = CollectionsKt.plus((Collection)CollectionsKt.listOf((Object)this.createAssignCommandLineToFiletypeCommand()), (Iterable)assocCommands);
        return CollectionsKt.joinToString$default((Iterable)allCommands, (CharSequence)" && ", null, null, (int)0, null, (Function1)createCmdScriptText.1.INSTANCE, (int)30, null);
    }

    private final String createAssignCommandLineToFiletypeCommand() throws OSFileAssociationException {
        String scriptName = ApplicationNamesInfo.getInstance().getScriptName();
        String suffix = CpuArch.isIntel64() ? "64" : "";
        Path path2 = PathManager.findBinFile(scriptName + suffix + ".exe");
        if (path2 == null) {
            Object[] objectArray = new Object[]{PathManager.getBinPath()};
            throw new OSFileAssociationException(ApplicationBundle.message((String)"desktop.entry.script.missing", (Object[])objectArray));
        }
        Path scriptPath = path2;
        return "ftype " + this.getUniqueFileType() + "=" + StringUtil.wrapWithDoubleQuote(((Object)scriptPath).toString()) + " \"%1\" %*";
    }

    private final void runCmdCommandWithSudo(String cmdCommand, Function0<String> errorMessageProvider) {
        String[] stringArray = new String[]{"cmd.exe", "/d", "/c", GeneralCommandLine.inescapableQuote((String)cmdCommand)};
        GeneralCommandLine commandLine = new GeneralCommandLine(stringArray);
        try {
            GeneralCommandLine sudoCommandLine = ExecUtil.sudoCommand((GeneralCommandLine)commandLine, (String)"");
            ProcessOutput processOutput = ExecUtil.execAndGetOutput((GeneralCommandLine)sudoCommandLine, (int)30000);
            if (processOutput.getExitCode() != 0 || processOutput.isCancelled() || processOutput.isTimeout()) {
                throw new OSFileAssociationException((String)errorMessageProvider.invoke(), new Exception(this.stringify(sudoCommandLine, processOutput)));
            }
        }
        catch (Exception e) {
            throw new OSFileAssociationException((String)errorMessageProvider.invoke(), new Exception(this.stringify(commandLine, null), e));
        }
    }

    private final String stringify(GeneralCommandLine commandLine, ProcessOutput processOutput) {
        Object[] objectArray = new String[]{"command line: " + commandLine.getCommandLineString(), "working directory: " + commandLine.getWorkDirectory()};
        List result2 = CollectionsKt.listOf((Object[])objectArray);
        if (processOutput != null) {
            objectArray = new String[]{"exit code: " + processOutput.getExitCode(), "timeout: " + processOutput.isTimeout(), "cancelled: " + processOutput.isCancelled(), "stdout: " + processOutput.getStdout(), "stderr: " + processOutput.getStderr()};
            result2 = CollectionsKt.plus((Collection)result2, (Iterable)CollectionsKt.listOf((Object[])objectArray));
        }
        return CollectionsKt.joinToString$default((Iterable)result2, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
    }

    private final String getUniqueFileType() {
        String string2 = ApplicationNamesInfo.getInstance().getFullProductName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getInstance().fullProductName");
        return StringsKt.replace$default((String)string2, (String)" ", (String)"_", (boolean)false, (int)4, null);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0005\u001a\u00020\u0003H\u00c2\u0003J\u0013\u0010\u0006\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0006\u0010\u0007\u001a\u00020\u0003J\u0013\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u000b\u001a\u00020\fH\u00d6\u0001J\t\u0010\r\u001a\u00020\u0003H\u00d6\u0001R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/intellij/openapi/fileTypes/impl/associate/win/WinFileTypeAssociator$Extension;", "", "extension", "", "(Ljava/lang/String;)V", "component1", "copy", "dotExtension", "equals", "", "other", "hashCode", "", "toString", "intellij.platform.lang.impl"})
    private static final class Extension {
        @NotNull
        private final String extension;

        public Extension(@NotNull String extension2) {
            Intrinsics.checkNotNullParameter((Object)extension2, (String)"extension");
            this.extension = extension2;
        }

        @NotNull
        public final String dotExtension() {
            return StringsKt.startsWith$default((String)this.extension, (String)".", (boolean)false, (int)2, null) ? this.extension : "." + this.extension;
        }

        private final String component1() {
            return this.extension;
        }

        @NotNull
        public final Extension copy(@NotNull String extension2) {
            Intrinsics.checkNotNullParameter((Object)extension2, (String)"extension");
            return new Extension(extension2);
        }

        public static /* synthetic */ Extension copy$default(Extension extension2, String string2, int n, Object object) {
            if ((n & 1) != 0) {
                string2 = extension2.extension;
            }
            return extension2.copy(string2);
        }

        @NotNull
        public String toString() {
            return "Extension(extension=" + this.extension + ")";
        }

        public int hashCode() {
            return this.extension.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Extension)) {
                return false;
            }
            Extension extension2 = (Extension)other;
            return Intrinsics.areEqual((Object)this.extension, (Object)extension2.extension);
        }
    }
}

