/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.module;

import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.JdkOrderEntry;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModuleOrderEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.util.PathUtilRt;
import com.intellij.util.graph.Graph;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ModuleUtilCore {
    public static final Key<Module> KEY_MODULE = new Key("Module");

    public static boolean projectContainsFile(@NotNull Project project2, @NotNull VirtualFile file2, boolean isLibraryElement) {
        if (project2 == null) {
            ModuleUtilCore.$$$reportNull$$$0(0);
        }
        if (file2 == null) {
            ModuleUtilCore.$$$reportNull$$$0(1);
        }
        ProjectFileIndex projectFileIndex = ProjectFileIndex.getInstance(project2);
        if (isLibraryElement) {
            List<OrderEntry> orders = projectFileIndex.getOrderEntriesForFile(file2);
            for (OrderEntry orderEntry2 : orders) {
                if (!(orderEntry2 instanceof JdkOrderEntry) && !(orderEntry2 instanceof LibraryOrderEntry)) continue;
                return true;
            }
            return false;
        }
        return projectFileIndex.isInContent(file2);
    }

    @NotNull
    public static String getModuleNameInReadAction(@NotNull Module module2) {
        if (module2 == null) {
            ModuleUtilCore.$$$reportNull$$$0(2);
        }
        String string2 = ReadAction.compute(module2::getName);
        if (string2 == null) {
            ModuleUtilCore.$$$reportNull$$$0(3);
        }
        return string2;
    }

    public static boolean isModuleDisposed(@NotNull PsiElement element) {
        Module module2;
        if (element == null) {
            ModuleUtilCore.$$$reportNull$$$0(4);
        }
        if (!element.isValid()) {
            return true;
        }
        Project project2 = element.getProject();
        ProjectFileIndex projectFileIndex = ProjectFileIndex.getInstance(project2);
        PsiFile file2 = element.getContainingFile();
        if (file2 == null) {
            return true;
        }
        VirtualFile vFile = file2.getVirtualFile();
        Module module3 = module2 = vFile == null ? null : projectFileIndex.getModuleForFile(vFile);
        return module2 == null ? !projectFileIndex.isInLibraryClasses(vFile) : module2.isDisposed();
    }

    @Nullable
    public static Module findModuleForFile(@Nullable PsiFile containingFile) {
        VirtualFile vFile;
        if (containingFile != null && (vFile = containingFile.getVirtualFile()) != null) {
            return ModuleUtilCore.findModuleForFile(vFile, containingFile.getProject());
        }
        return null;
    }

    @Nullable
    public static Module findModuleForFile(@NotNull VirtualFile file2, @NotNull Project project2) {
        if (file2 == null) {
            ModuleUtilCore.$$$reportNull$$$0(5);
        }
        if (project2 == null) {
            ModuleUtilCore.$$$reportNull$$$0(6);
        }
        if (project2.isDefault()) {
            return null;
        }
        return ReadAction.compute(() -> ProjectFileIndex.getInstance(project2).getModuleForFile(file2));
    }

    @Nullable
    public static Module findModuleForPsiElement(@NotNull PsiElement element) {
        PsiFile containingFile;
        PsiElement highestPsi;
        if (element == null) {
            ModuleUtilCore.$$$reportNull$$$0(7);
        }
        PsiElement psiElement = highestPsi = (containingFile = element.getContainingFile()) == null ? element : containingFile;
        if (!highestPsi.isValid()) {
            return null;
        }
        Project project2 = highestPsi.getProject();
        if (project2.isDefault()) {
            return null;
        }
        ProjectFileIndex fileIndex = ProjectFileIndex.getInstance(project2);
        if (element instanceof PsiFileSystemItem && (!(element instanceof PsiFile) || element.getContext() == null)) {
            VirtualFile vFile = ((PsiFileSystemItem)element).getVirtualFile();
            if (vFile == null) {
                VirtualFile virtualFile2 = vFile = containingFile == null ? null : containingFile.getOriginalFile().getVirtualFile();
                if (vFile == null) {
                    return element.getUserData(KEY_MODULE);
                }
            }
            if (fileIndex.isInLibrary(vFile)) {
                List<OrderEntry> orderEntries = fileIndex.getOrderEntriesForFile(vFile);
                if (orderEntries.isEmpty()) {
                    return null;
                }
                if (orderEntries.size() == 1) {
                    return orderEntries.get(0).getOwnerModule();
                }
                HashSet<Module> modules2 = new HashSet<Module>();
                for (OrderEntry orderEntry2 : orderEntries) {
                    modules2.add(orderEntry2.getOwnerModule());
                }
                Module[] candidates = modules2.toArray(Module.EMPTY_ARRAY);
                Arrays.sort(candidates, ModuleManager.getInstance(project2).moduleDependencyComparator());
                return candidates[0];
            }
            return fileIndex.getModuleForFile(vFile);
        }
        if (containingFile != null) {
            PsiFile file2;
            PsiElement context2;
            while ((context2 = containingFile.getContext()) != null && (file2 = context2.getContainingFile()) != null) {
                containingFile = file2;
            }
            if (containingFile.getUserData(KEY_MODULE) != null) {
                return containingFile.getUserData(KEY_MODULE);
            }
            PsiFile originalFile = containingFile.getOriginalFile();
            if (originalFile.getUserData(KEY_MODULE) != null) {
                return originalFile.getUserData(KEY_MODULE);
            }
            VirtualFile virtualFile3 = originalFile.getVirtualFile();
            if (virtualFile3 != null) {
                return fileIndex.getModuleForFile(virtualFile3);
            }
        }
        return element.getUserData(KEY_MODULE);
    }

    public static void getDependencies(@NotNull Module module2, @NotNull Set<? super Module> modules2) {
        Module[] dependencies;
        if (module2 == null) {
            ModuleUtilCore.$$$reportNull$$$0(8);
        }
        if (modules2 == null) {
            ModuleUtilCore.$$$reportNull$$$0(9);
        }
        if (modules2.contains(module2)) {
            return;
        }
        modules2.add(module2);
        for (Module dependency : dependencies = ModuleRootManager.getInstance(module2).getDependencies()) {
            ModuleUtilCore.getDependencies(dependency, modules2);
        }
    }

    public static void collectModulesDependsOn(@NotNull Module module2, @NotNull Set<? super Module> result2) {
        if (module2 == null) {
            ModuleUtilCore.$$$reportNull$$$0(10);
        }
        if (result2 == null) {
            ModuleUtilCore.$$$reportNull$$$0(11);
        }
        if (!result2.add(module2)) {
            return;
        }
        ModuleManager moduleManager = ModuleManager.getInstance(module2.getProject());
        List<Module> dependentModules = moduleManager.getModuleDependentModules(module2);
        block0: for (Module dependentModule : dependentModules) {
            OrderEntry[] orderEntries;
            for (OrderEntry o : orderEntries = ModuleRootManager.getInstance(dependentModule).getOrderEntries()) {
                ModuleOrderEntry orderEntry2;
                if (!(o instanceof ModuleOrderEntry) || (orderEntry2 = (ModuleOrderEntry)o).getModule() != module2) continue;
                if (orderEntry2.isExported()) {
                    ModuleUtilCore.collectModulesDependsOn(dependentModule, result2);
                    continue block0;
                }
                result2.add(dependentModule);
                continue block0;
            }
        }
    }

    @NotNull
    public static List<Module> getAllDependentModules(@NotNull Module module2) {
        if (module2 == null) {
            ModuleUtilCore.$$$reportNull$$$0(12);
        }
        ArrayList<Module> list2 = new ArrayList<Module>();
        Graph<Module> graph2 = ModuleManager.getInstance(module2.getProject()).moduleGraph();
        Iterator<Module> i2 = graph2.getOut(module2);
        while (i2.hasNext()) {
            list2.add(i2.next());
        }
        ArrayList<Module> arrayList = list2;
        if (arrayList == null) {
            ModuleUtilCore.$$$reportNull$$$0(13);
        }
        return arrayList;
    }

    public static boolean visitMeAndDependentModules(@NotNull Module module2, @NotNull ModuleVisitor visitor2) {
        if (module2 == null) {
            ModuleUtilCore.$$$reportNull$$$0(14);
        }
        if (visitor2 == null) {
            ModuleUtilCore.$$$reportNull$$$0(15);
        }
        if (!visitor2.visit(module2)) {
            return false;
        }
        List<Module> list2 = ModuleUtilCore.getAllDependentModules(module2);
        for (Module dependentModule : list2) {
            if (visitor2.visit(dependentModule)) continue;
            return false;
        }
        return true;
    }

    public static boolean moduleContainsFile(@NotNull Module module2, @NotNull VirtualFile file2, boolean isLibraryElement) {
        if (module2 == null) {
            ModuleUtilCore.$$$reportNull$$$0(16);
        }
        if (file2 == null) {
            ModuleUtilCore.$$$reportNull$$$0(17);
        }
        ModuleRootManager moduleRootManager = ModuleRootManager.getInstance(module2);
        if (isLibraryElement) {
            OrderEntry orderEntry2 = moduleRootManager.getFileIndex().getOrderEntryForFile(file2);
            return orderEntry2 instanceof JdkOrderEntry || orderEntry2 instanceof LibraryOrderEntry;
        }
        return moduleRootManager.getFileIndex().isInContent(file2);
    }

    public static boolean isModuleFile(@NotNull Module module2, @NotNull VirtualFile file2) {
        if (module2 == null) {
            ModuleUtilCore.$$$reportNull$$$0(18);
        }
        if (file2 == null) {
            ModuleUtilCore.$$$reportNull$$$0(19);
        }
        return VfsUtilCore.pathEqualsTo(file2, module2.getModuleFilePath());
    }

    public static boolean isModuleDir(@NotNull Module module2, @NotNull VirtualFile dir) {
        if (module2 == null) {
            ModuleUtilCore.$$$reportNull$$$0(20);
        }
        if (dir == null) {
            ModuleUtilCore.$$$reportNull$$$0(21);
        }
        return VfsUtilCore.pathEqualsTo(dir, ModuleUtilCore.getModuleDirPath(module2));
    }

    @NotNull
    public static String getModuleDirPath(@NotNull Module module2) {
        if (module2 == null) {
            ModuleUtilCore.$$$reportNull$$$0(22);
        }
        String string2 = PathUtilRt.getParentPath(module2.getModuleFilePath());
        if (string2 == null) {
            ModuleUtilCore.$$$reportNull$$$0(23);
        }
        return string2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 13, 23 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 5: 
            case 17: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: 
            case 8: 
            case 10: 
            case 12: 
            case 14: 
            case 16: 
            case 18: 
            case 20: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 3: 
            case 13: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/module/ModuleUtilCore";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modules";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/module/ModuleUtilCore";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getModuleNameInReadAction";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllDependentModules";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getModuleDirPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "projectContainsFile";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getModuleNameInReadAction";
                break;
            }
            case 3: 
            case 13: 
            case 23: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isModuleDisposed";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "findModuleForFile";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "findModuleForPsiElement";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getDependencies";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "collectModulesDependsOn";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getAllDependentModules";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "visitMeAndDependentModules";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "moduleContainsFile";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "isModuleFile";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "isModuleDir";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getModuleDirPath";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 3, 13, 23 -> new IllegalStateException(string2);
        };
    }

    @FunctionalInterface
    public static interface ModuleVisitor {
        public boolean visit(@NotNull Module var1);
    }
}

