/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.module.impl;

import com.intellij.ide.SaveAndSyncHandler;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationGroupManager;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.components.BaseState;
import com.intellij.openapi.components.SimplePersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.AutomaticModuleUnloader;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.UnloadedModuleDescription;
import com.intellij.openapi.module.impl.LoadedModulesListStorage;
import com.intellij.openapi.module.impl.UnloadedModulesListStorage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.roots.ui.configuration.ConfigureUnloadedModulesDialog;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.workspaceModel.ide.impl.legacyBridge.module.ModuleEntityUtils;
import com.intellij.workspaceModel.storage.EntityStorage;
import com.intellij.workspaceModel.storage.EntityStorageSnapshot;
import com.intellij.workspaceModel.storage.MutableEntityStorage;
import com.intellij.workspaceModel.storage.SymbolicEntityId;
import com.intellij.workspaceModel.storage.WorkspaceEntity;
import com.intellij.workspaceModel.storage.bridgeEntities.LibraryEntity;
import com.intellij.workspaceModel.storage.bridgeEntities.ModuleDependencyItem;
import com.intellij.workspaceModel.storage.bridgeEntities.ModuleEntity;
import com.intellij.workspaceModel.storage.bridgeEntities.ModuleId;
import com.intellij.xml.util.XmlStringUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="AutomaticModuleUnloader", storages={@Storage(value="$WORKSPACE_FILE$")})
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010!\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\b\u0004\b\u0001\u0018\u0000 $2\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003:\u0001$B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J*\u0010\u0007\u001a\u00020\b2\b\b\u0001\u0010\t\u001a\u00020\n2\u0018\u0010\u000b\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\r\u0012\u0004\u0012\u00020\u000e0\fJ$\u0010\u000f\u001a\u00020\u000e2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\n0\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\n0\u0011H\u0002J&\u0010\u0013\u001a\u00020\u000e2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\n0\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0017H\u0016J<\u0010\u0019\u001a\u00020\u000e2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001d2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\n0\u00152\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\n0!H\u0002J\u0016\u0010\"\u001a\u00020\u000e2\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\n0\u0011H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lcom/intellij/openapi/module/impl/AutomaticModuleUnloaderImpl;", "Lcom/intellij/openapi/components/SimplePersistentStateComponent;", "Lcom/intellij/openapi/module/impl/LoadedModulesListStorage;", "Lcom/intellij/openapi/module/AutomaticModuleUnloader;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "createAction", "Lcom/intellij/notification/NotificationAction;", "text", "", "action", "Lkotlin/Function1;", "", "", "fireNotifications", "modulesToLoad", "", "modulesToUnload", "processNewModules", "currentModules", "", "builder", "Lcom/intellij/workspaceModel/storage/MutableEntityStorage;", "unloadedEntityBuilder", "processTransitiveDependencies", "moduleId", "Lcom/intellij/workspaceModel/storage/bridgeEntities/ModuleId;", "storage", "Lcom/intellij/workspaceModel/storage/EntityStorage;", "unloadedEntitiesStorage", "explicitlyUnloaded", "result", "", "setLoadedModules", "modules", "Companion", "intellij.platform.lang.impl"})
@SourceDebugExtension(value={"SMAP\nAutomaticModuleUnloaderImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AutomaticModuleUnloaderImpl.kt\ncom/intellij/openapi/module/impl/AutomaticModuleUnloaderImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,169:1\n1726#2,3:170\n766#2:173\n857#2,2:174\n766#2:176\n857#2,2:177\n1855#2,2:181\n1295#3,2:179\n10#4:183\n*S KotlinDebug\n*F\n+ 1 AutomaticModuleUnloaderImpl.kt\ncom/intellij/openapi/module/impl/AutomaticModuleUnloaderImpl\n*L\n53#1:170,3\n62#1:173\n62#1:174,2\n63#1:176\n63#1:177,2\n95#1:181,2\n80#1:179,2\n159#1:183\n*E\n"})
public final class AutomaticModuleUnloaderImpl
extends SimplePersistentStateComponent<LoadedModulesListStorage>
implements AutomaticModuleUnloader {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private static final Logger LOG;

    public AutomaticModuleUnloaderImpl(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        super((BaseState)new LoadedModulesListStorage());
        this.project = project2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void processNewModules(@NotNull Set<String> currentModules, @NotNull MutableEntityStorage builder2, @NotNull MutableEntityStorage unloadedEntityBuilder) {
        void $this$filterTo$iv$iv;
        void $this$filterTo$iv$iv2;
        Object it;
        boolean bl;
        Set<String> unloadedModules;
        UnloadedModulesListStorage unloadedStorage;
        HashSet oldLoaded;
        block15: {
            Intrinsics.checkNotNullParameter(currentModules, (String)"currentModules");
            Intrinsics.checkNotNullParameter((Object)builder2, (String)"builder");
            Intrinsics.checkNotNullParameter((Object)unloadedEntityBuilder, (String)"unloadedEntityBuilder");
            if (currentModules.isEmpty()) {
                return;
            }
            oldLoaded = CollectionsKt.toHashSet((Iterable)((LoadedModulesListStorage)this.getState()).getModules());
            if (oldLoaded.isEmpty()) {
                return;
            }
            unloadedStorage = UnloadedModulesListStorage.getInstance(this.project);
            Set<String> set2 = unloadedStorage.getUnloadedModuleNames();
            Intrinsics.checkNotNullExpressionValue(set2, (String)"unloadedStorage.unloadedModuleNames");
            unloadedModules = set2;
            if (unloadedModules.isEmpty()) {
                return;
            }
            Iterable $this$all$iv = currentModules;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    it = (String)element$iv;
                    boolean bl2 = false;
                    if (oldLoaded.contains(it) || unloadedModules.contains(it)) continue;
                    bl = false;
                    break block15;
                }
                bl = true;
            }
        }
        if (bl) {
            return;
        }
        HashSet oldLoadedWithDependencies = new HashSet();
        for (String name : oldLoaded) {
            Intrinsics.checkNotNullExpressionValue((Object)name, (String)"name");
            this.processTransitiveDependencies(new ModuleId(name), (EntityStorage)builder2, (EntityStorage)unloadedEntityBuilder, unloadedModules, oldLoadedWithDependencies);
        }
        Iterable $this$filter$iv = currentModules;
        boolean $i$f$filter = false;
        it = $this$filter$iv;
        Iterable destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv2) {
            String it2 = (String)element$iv$iv;
            boolean bl3 = false;
            if (!(oldLoadedWithDependencies.contains(it2) && !oldLoaded.contains(it2))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List toLoad = (List)destination$iv$iv;
        Iterable $this$filter$iv2 = currentModules;
        boolean $i$f$filter2 = false;
        destination$iv$iv = $this$filter$iv2;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo2 = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            String it3 = (String)element$iv$iv;
            boolean bl4 = false;
            if (!(!oldLoadedWithDependencies.contains(it3) && !unloadedModules.contains(it3))) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        List toUnload = (List)destination$iv$iv2;
        if (!((Collection)toUnload).isEmpty()) {
            LOG.info("Old loaded modules: " + oldLoaded);
            LOG.info("Old unloaded modules: " + unloadedModules);
            LOG.info("New modules to unload: " + toUnload);
        }
        this.fireNotifications(toLoad, toUnload);
        unloadedStorage.addUnloadedModuleNames(toUnload);
        if (!((Collection)toUnload).isEmpty()) {
            Set toUnloadSet = CollectionsKt.toSet((Iterable)toUnload);
            EntityStorageSnapshot snapshot = builder2.toSnapshot();
            List moduleEntitiesToAdd2 = SequencesKt.toList((Sequence)SequencesKt.filter((Sequence)snapshot.entities(ModuleEntity.class), (Function1)((Function1)new Function1<ModuleEntity, Boolean>((Set<String>)toUnloadSet){
                final /* synthetic */ Set<String> $toUnloadSet;
                {
                    this.$toUnloadSet = $toUnloadSet;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(@NotNull ModuleEntity it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return this.$toUnloadSet.contains(it.getName());
                }
            })));
            List moduleEntitiesToRemove2 = SequencesKt.toList((Sequence)SequencesKt.filter((Sequence)builder2.entities(ModuleEntity.class), (Function1)((Function1)new Function1<ModuleEntity, Boolean>((Set<String>)toUnloadSet){
                final /* synthetic */ Set<String> $toUnloadSet;
                {
                    this.$toUnloadSet = $toUnloadSet;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(@NotNull ModuleEntity it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return this.$toUnloadSet.contains(it.getName());
                }
            })));
            for (ModuleEntity moduleEntity : moduleEntitiesToAdd2) {
                unloadedEntityBuilder.addEntity((WorkspaceEntity)moduleEntity);
                Sequence<LibraryEntity> $this$forEach$iv = ModuleEntityUtils.getModuleLevelLibraries(moduleEntity, (EntityStorage)snapshot);
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    LibraryEntity libraryEntity = (LibraryEntity)element$iv;
                    boolean bl5 = false;
                    unloadedEntityBuilder.addEntity((WorkspaceEntity)libraryEntity);
                }
            }
            for (ModuleEntity moduleEntity : moduleEntitiesToRemove2) {
                builder2.removeEntity((WorkspaceEntity)moduleEntity);
            }
        }
    }

    private final void processTransitiveDependencies(ModuleId moduleId, EntityStorage storage, EntityStorage unloadedEntitiesStorage, Set<String> explicitlyUnloaded, Set<String> result2) {
        if (explicitlyUnloaded.contains(moduleId.getName())) {
            return;
        }
        ModuleEntity moduleEntity = (ModuleEntity)storage.resolve((SymbolicEntityId)moduleId);
        if (moduleEntity == null && (moduleEntity = (ModuleEntity)unloadedEntitiesStorage.resolve((SymbolicEntityId)moduleId)) == null) {
            return;
        }
        ModuleEntity moduleEntity2 = moduleEntity;
        if (!result2.add(moduleEntity2.getName())) {
            return;
        }
        Iterable $this$forEach$iv = moduleEntity2.getDependencies();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ModuleDependencyItem it = (ModuleDependencyItem)element$iv;
            boolean bl = false;
            if (!(it instanceof ModuleDependencyItem.Exportable.ModuleDependency)) continue;
            this.processTransitiveDependencies(((ModuleDependencyItem.Exportable.ModuleDependency)it).getModule(), storage, unloadedEntitiesStorage, explicitlyUnloaded, result2);
        }
    }

    private final void fireNotifications(List<String> modulesToLoad, List<String> modulesToUnload) {
        Object text2;
        Object args2;
        Object object;
        if (modulesToLoad.isEmpty() && modulesToUnload.isEmpty()) {
            return;
        }
        List messages = new ArrayList();
        List actions = new ArrayList();
        if (!((Collection)modulesToUnload).isEmpty()) {
            object = new Object[]{modulesToUnload.size(), modulesToUnload.get(0), modulesToUnload.size() == 2 ? modulesToUnload.get(1) : Integer.valueOf(modulesToUnload.size() - 1)};
            args2 = object;
            ((Collection)messages).add(ProjectBundle.message((String)"auto.unloaded.notification", (Object[])Arrays.copyOf(args2, ((Object[])args2).length)));
            String string2 = ProjectBundle.message((String)(modulesToUnload.isEmpty() ? "auto.unloaded.revert.short" : "auto.unloaded.revert.full"), (Object[])Arrays.copyOf(args2, ((Object[])args2).length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(if (modulesToUnl\u2026aded.revert.full\", *args)");
            text2 = string2;
            ((Collection)actions).add(this.createAction((String)text2, (Function1<? super List<String>, Unit>)((Function1)new Function1<List<String>, Unit>(modulesToUnload){
                final /* synthetic */ List<String> $modulesToUnload;
                {
                    this.$modulesToUnload = $modulesToUnload;
                    super(1);
                }

                public final void invoke(@NotNull List<String> list2) {
                    Intrinsics.checkNotNullParameter(list2, (String)"list");
                    list2.removeAll((Collection)this.$modulesToUnload);
                }
            })));
        }
        if (!((Collection)modulesToLoad).isEmpty()) {
            text2 = new Object[]{modulesToLoad.size(), modulesToLoad.get(0), modulesToLoad.size() == 2 ? modulesToLoad.get(1) : Integer.valueOf(modulesToLoad.size() - 1)};
            args2 = text2;
            ((Collection)messages).add(ProjectBundle.message((String)"auto.loaded.notification", (Object[])Arrays.copyOf(args2, ((Object[])args2).length)));
            String string3 = ProjectBundle.message((String)(modulesToUnload.isEmpty() ? "auto.loaded.revert.short" : "auto.loaded.revert.full"), (Object[])Arrays.copyOf(args2, ((Object[])args2).length));
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(if (modulesToUnl\u2026aded.revert.full\", *args)");
            String action2 = string3;
            ((Collection)actions).add(this.createAction(action2, (Function1<? super List<String>, Unit>)((Function1)new Function1<List<String>, Unit>(modulesToLoad){
                final /* synthetic */ List<String> $modulesToLoad;
                {
                    this.$modulesToLoad = $modulesToLoad;
                    super(1);
                }

                public final void invoke(@NotNull List<String> list2) {
                    Intrinsics.checkNotNullParameter(list2, (String)"list");
                    list2.addAll((Collection<String>)this.$modulesToLoad);
                }
            })));
        }
        args2 = actions;
        object = ProjectBundle.message((String)"configure.unloaded.modules", (Object[])new Object[0]);
        args2.add(new NotificationAction(this, (String)object){
            final /* synthetic */ AutomaticModuleUnloaderImpl this$0;
            {
                this.this$0 = $receiver;
                super($super_call_param$1);
            }

            public void actionPerformed(@NotNull AnActionEvent e, @NotNull Notification notification) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                Intrinsics.checkNotNullParameter((Object)notification, (String)"notification");
                if (new ConfigureUnloadedModulesDialog(AutomaticModuleUnloaderImpl.access$getProject$p(this.this$0), null).showAndGet()) {
                    notification.expire();
                }
            }
        });
        String string4 = XmlStringUtil.wrapInHtml(CollectionsKt.joinToString$default((Iterable)messages, (CharSequence)"<br>", null, null, (int)0, null, null, (int)62, null));
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"wrapInHtml(messages.joinToString(\"<br>\"))");
        String content2 = string4;
        NotificationGroup notificationGroup = AutomaticModuleUnloaderImpl.Companion.getNOTIFICATION_GROUP();
        String string5 = ProjectBundle.message((String)"modules.added.notification.title", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"message(\"modules.added.notification.title\")");
        notificationGroup.createNotification(string5, content2, NotificationType.INFORMATION).addActions((Collection)actions).notify(this.project);
    }

    @NotNull
    public final NotificationAction createAction(@NlsContexts.NotificationContent @NotNull String text2, @NotNull Function1<? super List<String>, Unit> action2) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        Intrinsics.checkNotNullParameter(action2, (String)"action");
        return new NotificationAction(text2, this, action2){
            final /* synthetic */ AutomaticModuleUnloaderImpl this$0;
            final /* synthetic */ Function1<List<String>, Unit> $action;
            {
                this.this$0 = $receiver;
                this.$action = $action;
                super($text);
            }

            /*
             * WARNING - void declaration
             */
            public void actionPerformed(@NotNull AnActionEvent e, @NotNull Notification notification) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                Intrinsics.checkNotNullParameter((Object)notification, (String)"notification");
                ArrayList<String> unloaded = new ArrayList<String>();
                ModuleManager moduleManager = ModuleManager.Companion.getInstance(AutomaticModuleUnloaderImpl.access$getProject$p(this.this$0));
                Iterable $this$mapTo$iv = moduleManager.getUnloadedModuleDescriptions();
                boolean $i$f$mapTo = false;
                for (T item$iv : $this$mapTo$iv) {
                    void it;
                    UnloadedModuleDescription unloadedModuleDescription = (UnloadedModuleDescription)item$iv;
                    Collection collection = unloaded;
                    boolean bl = false;
                    collection.add(it.getName());
                }
                Collection cfr_ignored_0 = (Collection)unloaded;
                this.$action.invoke(unloaded);
                CoroutineScope coroutineScope = AutomaticModuleUnloaderImpl.access$getProject$p(this.this$0).getCoroutineScope();
                Intrinsics.checkNotNullExpressionValue((Object)coroutineScope, (String)"project.coroutineScope");
                BuildersKt.launch$default(coroutineScope, null, null, (Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(moduleManager, unloaded, null){
                    int label;
                    final /* synthetic */ ModuleManager $moduleManager;
                    final /* synthetic */ ArrayList<String> $unloaded;
                    {
                        this.$moduleManager = $moduleManager;
                        this.$unloaded = $unloaded;
                        super(2, $completion);
                    }

                    /*
                     * WARNING - void declaration
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    @Nullable
                    public final Object invokeSuspend(@NotNull Object object) {
                        Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)object);
                                this.label = 1;
                                Object object3 = this.$moduleManager.setUnloadedModules((List<String>)this.$unloaded, (Continuation<? super Unit>)((Continuation)this));
                                if (object3 != object2) return Unit.INSTANCE;
                                return object2;
                            }
                            case 1: {
                                void $result;
                                ResultKt.throwOnFailure((Object)$result);
                                Object object3 = $result;
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    @NotNull
                    public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    @Nullable
                    public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }, 3, null);
                notification.expire();
            }
        };
    }

    @Override
    public void setLoadedModules(@NotNull List<String> modules2) {
        Intrinsics.checkNotNullParameter(modules2, (String)"modules");
        List<String> list2 = ((LoadedModulesListStorage)this.getState()).getModules();
        list2.clear();
        list2.addAll((Collection<String>)modules2);
        SaveAndSyncHandler.Companion.getInstance().scheduleProjectSave(this.project, true);
    }

    public static final /* synthetic */ Project access$getProject$p(AutomaticModuleUnloaderImpl $this) {
        return $this.project;
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(AutomaticModuleUnloaderImpl.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(T::class.java)");
        LOG = logger;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Lcom/intellij/openapi/module/impl/AutomaticModuleUnloaderImpl$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "NOTIFICATION_GROUP", "Lcom/intellij/notification/NotificationGroup;", "getNOTIFICATION_GROUP", "()Lcom/intellij/notification/NotificationGroup;", "intellij.platform.lang.impl"})
    public static final class Companion {
        private Companion() {
        }

        private final NotificationGroup getNOTIFICATION_GROUP() {
            NotificationGroup notificationGroup = NotificationGroupManager.getInstance().getNotificationGroup("Automatic Module Unloading");
            Intrinsics.checkNotNullExpressionValue((Object)notificationGroup, (String)"getInstance().getNotific\u2026omatic Module Unloading\")");
            return notificationGroup;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

