/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.module.impl;

import com.intellij.ProjectTopics;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModulePointer;
import com.intellij.openapi.module.ModulePointerManager;
import com.intellij.openapi.module.impl.ModulePointerImpl;
import com.intellij.openapi.module.impl.ModuleRenamingHistoryState;
import com.intellij.openapi.project.ModuleListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.Function;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import java.io.Serializable;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@State(name="ModuleRenamingHistory", storages={@Storage(value="modules.xml")})
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u00012\b\u0012\u0004\u0012\u00020\u00030\u0002B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0011H\u0016J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u000bH\u0016J\b\u0010\u0018\u001a\u00020\u0003H\u0016J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u0003H\u0016J\u0016\u0010\u001c\u001a\u00020\u001a2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00110\u001eH\u0002J\u0018\u0010\u001f\u001a\u00020\u001a2\u0006\u0010\u0016\u001a\u00020\u00112\u0006\u0010 \u001a\u00020\u0012H\u0002J\u001a\u0010!\u001a\u00020\u001a2\u0012\u0010\"\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b0\u000eJ\u0010\u0010#\u001a\u00020\u001a2\u0006\u0010\u0016\u001a\u00020\u0011H\u0002J \u0010$\u001a\u00020\u001a2\u0006\u0010%\u001a\u00020\u000b2\u0006\u0010&\u001a\u00020\u000b2\u0006\u0010'\u001a\u00020(H\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000RV\u0010\t\u001aJ\u0012\f\u0012\n \f*\u0004\u0018\u00010\u000b0\u000b\u0012\f\u0012\n \f*\u0004\u0018\u00010\u000b0\u000b \f*#\u0012\f\u0012\n \f*\u0004\u0018\u00010\u000b0\u000b\u0012\f\u0012\n \f*\u0004\u0018\u00010\u000b0\u000b0\u000e\u00a2\u0006\u0002\b\r0\n\u00a2\u0006\u0002\b\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00120\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00120\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lcom/intellij/openapi/module/impl/ModulePointerManagerImpl;", "Lcom/intellij/openapi/module/ModulePointerManager;", "Lcom/intellij/openapi/components/PersistentStateComponent;", "Lcom/intellij/openapi/module/impl/ModuleRenamingHistoryState;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "lock", "Ljava/util/concurrent/locks/ReentrantReadWriteLock;", "oldToNewName", "", "", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "", "pointers", "Lcom/intellij/util/containers/MultiMap;", "Lcom/intellij/openapi/module/Module;", "Lcom/intellij/openapi/module/impl/ModulePointerImpl;", "unresolved", "create", "Lcom/intellij/openapi/module/ModulePointer;", "module", "moduleName", "getState", "loadState", "", "state", "modulesAppears", "modules", "", "registerPointer", "pointer", "setRenamingScheme", "renamingScheme", "unregisterPointer", "updateUnresolvedPointers", "oldName", "newName", "moduleManager", "Lcom/intellij/openapi/module/ModuleManager;", "intellij.platform.projectModel.impl"})
@SourceDebugExtension(value={"SMAP\nModulePointerManagerImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ModulePointerManagerImpl.kt\ncom/intellij/openapi/module/impl/ModulePointerManagerImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,173:1\n1855#2,2:174\n1855#2,2:176\n1855#2,2:178\n1855#2,2:180\n1855#2,2:183\n288#2,2:185\n1#3:182\n*S KotlinDebug\n*F\n+ 1 ModulePointerManagerImpl.kt\ncom/intellij/openapi/module/impl/ModulePointerManagerImpl\n*L\n69#1:174,2\n83#1:176,2\n99#1:178,2\n114#1:180,2\n134#1:183,2\n162#1:185,2\n*E\n"})
public final class ModulePointerManagerImpl
extends ModulePointerManager
implements PersistentStateComponent<ModuleRenamingHistoryState> {
    @NotNull
    private final Project project;
    @NotNull
    private final MultiMap<String, ModulePointerImpl> unresolved;
    @NotNull
    private final MultiMap<Module, ModulePointerImpl> pointers;
    @NotNull
    private final ReentrantReadWriteLock lock;
    @NotNull
    private final Map<String, String> oldToNewName;

    public ModulePointerManagerImpl(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        this.project = project2;
        this.unresolved = new MultiMap();
        this.pointers = new MultiMap();
        this.lock = new ReentrantReadWriteLock();
        Map map2 = CollectionFactory.createSmallMemoryFootprintMap();
        Intrinsics.checkNotNullExpressionValue(map2, (String)"createSmallMemoryFootprintMap<String, String>()");
        this.oldToNewName = map2;
        MessageBusConnection messageBusConnection = this.project.getMessageBus().connect();
        Topic<ModuleListener> topic = ProjectTopics.MODULES;
        Intrinsics.checkNotNullExpressionValue(topic, (String)"MODULES");
        messageBusConnection.subscribe(topic, new ModuleListener(){

            @Override
            public void beforeModuleRemoved(@NotNull Project project2, @NotNull Module module2) {
                Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
                Intrinsics.checkNotNullParameter((Object)module2, (String)"module");
                this.unregisterPointer(module2);
            }

            @Override
            public void modulesAdded(@NotNull Project project2, @NotNull List<? extends Module> modules2) {
                Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
                Intrinsics.checkNotNullParameter(modules2, (String)"modules");
                this.modulesAppears(modules2);
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public void modulesRenamed(@NotNull Project project2, @NotNull List<? extends Module> modules2, @NotNull Function<? super Module, String> oldNameProvider) {
                void $this$associateByTo$iv$iv;
                Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
                Intrinsics.checkNotNullParameter(modules2, (String)"modules");
                Intrinsics.checkNotNullParameter(oldNameProvider, (String)"oldNameProvider");
                this.modulesAppears(modules2);
                Iterable $this$associateBy$iv = modules2;
                boolean bl = false;
                int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
                Iterable iterable = $this$associateBy$iv;
                Map destination$iv$iv = new LinkedHashMap(capacity$iv);
                boolean $i$f$associateByTo = false;
                for (Object element$iv$iv : $this$associateByTo$iv$iv) {
                    Module module2 = (Module)element$iv$iv;
                    Map map2 = destination$iv$iv;
                    boolean bl2 = false;
                    Module it = (Module)element$iv$iv;
                    String string2 = oldNameProvider.fun(it);
                    boolean bl22 = false;
                    String string3 = it.getName();
                    map2.put(string2, string3);
                }
                Map renamedOldToNew = destination$iv$iv;
                for (Map.Entry entry : oldToNewName.entrySet()) {
                    String newValue = (String)renamedOldToNew.get(entry.getValue());
                    if (newValue == null) continue;
                    entry.setValue(newValue);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public ModuleRenamingHistoryState getState() {
        ModuleRenamingHistoryState moduleRenamingHistoryState;
        ModuleRenamingHistoryState $this$getState_u24lambda_u241 = moduleRenamingHistoryState = new ModuleRenamingHistoryState();
        boolean bl = false;
        ReentrantReadWriteLock.ReadLock readLock = this.lock.readLock();
        readLock.lock();
        try {
            boolean bl2 = false;
            $this$getState_u24lambda_u241.oldToNewName.putAll(this.oldToNewName);
            Unit unit = Unit.INSTANCE;
        }
        finally {
            readLock.unlock();
        }
        return moduleRenamingHistoryState;
    }

    @Override
    public void loadState(@NotNull ModuleRenamingHistoryState state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        this.setRenamingScheme((Map<String, String>)state.oldToNewName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setRenamingScheme(@NotNull Map<String, String> renamingScheme) {
        Intrinsics.checkNotNullParameter(renamingScheme, (String)"renamingScheme");
        ReentrantReadWriteLock reentrantReadWriteLock = this.lock;
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        int n = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
        for (int j = 0; j < n; ++j) {
            readLock.unlock();
        }
        ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
        writeLock.lock();
        try {
            boolean bl = false;
            this.oldToNewName.clear();
            this.oldToNewName.putAll(renamingScheme);
            ModuleManager moduleManager = ModuleManager.Companion.getInstance(this.project);
            Iterable $this$forEach$iv = renamingScheme.entrySet();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Map.Entry entry = (Map.Entry)element$iv;
                boolean bl2 = false;
                String oldName = (String)entry.getKey();
                String newName2 = (String)entry.getValue();
                Module oldModule = moduleManager.findModuleByName(oldName);
                if (oldModule != null) {
                    this.unregisterPointer(oldModule);
                }
                this.updateUnresolvedPointers(oldName, newName2, moduleManager);
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            for (int j = 0; j < n; ++j) {
                readLock.lock();
            }
            writeLock.unlock();
        }
    }

    private final void updateUnresolvedPointers(String oldName, String newName2, ModuleManager moduleManager) {
        block2: {
            Collection<ModulePointerImpl> pointers2;
            Collection<ModulePointerImpl> collection = pointers2 = this.unresolved.remove(oldName);
            if (collection == null) break block2;
            Iterable $this$forEach$iv = collection;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                ModulePointerImpl pointer = (ModulePointerImpl)element$iv;
                boolean bl = false;
                pointer.renameUnresolved$intellij_platform_projectModel_impl(newName2);
                Module module2 = moduleManager.findModuleByName(newName2);
                if (module2 != null) {
                    pointer.moduleAdded$intellij_platform_projectModel_impl(module2);
                    Intrinsics.checkNotNullExpressionValue((Object)pointer, (String)"pointer");
                    this.registerPointer(module2, pointer);
                    continue;
                }
                this.unresolved.putValue(newName2, pointer);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void modulesAppears(List<? extends Module> modules2) {
        ReentrantReadWriteLock reentrantReadWriteLock = this.lock;
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        int n = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
        for (int j = 0; j < n; ++j) {
            readLock.unlock();
        }
        ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
        writeLock.lock();
        try {
            boolean bl = false;
            for (Module module2 : modules2) {
                Collection<ModulePointerImpl> collection;
                Collection<ModulePointerImpl> collection2 = collection = this.unresolved.remove(module2.getName());
                if (collection2 == null) continue;
                Intrinsics.checkNotNullExpressionValue(collection2, (String)"remove(module.name)");
                Iterable $this$forEach$iv = collection;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    ModulePointerImpl it = (ModulePointerImpl)element$iv;
                    boolean bl2 = false;
                    it.moduleAdded$intellij_platform_projectModel_impl(module2);
                    Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                    this.registerPointer(module2, it);
                }
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            for (int j = 0; j < n; ++j) {
                readLock.lock();
            }
            writeLock.unlock();
        }
    }

    private final void registerPointer(Module module2, ModulePointerImpl pointer) {
        this.pointers.putValue(module2, pointer);
        Disposer.register(module2, () -> ModulePointerManagerImpl.registerPointer$lambda$7(this, module2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void unregisterPointer(Module module2) {
        ReentrantReadWriteLock reentrantReadWriteLock = this.lock;
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        int n = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
        for (int j = 0; j < n; ++j) {
            readLock.unlock();
        }
        ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
        writeLock.lock();
        try {
            Unit unit;
            Collection<ModulePointerImpl> collection;
            boolean bl = false;
            Collection<ModulePointerImpl> collection2 = collection = this.pointers.remove(module2);
            if (collection2 != null) {
                Intrinsics.checkNotNullExpressionValue(collection2, (String)"remove(module)");
                Iterable $this$forEach$iv = collection;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    ModulePointerImpl it = (ModulePointerImpl)element$iv;
                    boolean bl2 = false;
                    it.moduleRemoved$intellij_platform_projectModel_impl(module2);
                    this.unresolved.putValue(it.getModuleName(), it);
                }
                unit = Unit.INSTANCE;
            } else {
                unit = null;
            }
            Unit unit2 = unit;
        }
        finally {
            for (int j = 0; j < n; ++j) {
                readLock.lock();
            }
            writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public ModulePointer create(@NotNull Module module2) {
        ModulePointer modulePointer;
        ModulePointerImpl modulePointerImpl;
        Object object;
        Intrinsics.checkNotNullParameter((Object)module2, (String)"module");
        Serializable serializable = this.lock.readLock();
        ((ReentrantReadWriteLock.ReadLock)serializable).lock();
        try {
            boolean bl = false;
            Collection<ModulePointerImpl> collection = this.pointers.get(module2);
            Intrinsics.checkNotNullExpressionValue(collection, (String)"pointers.get(module)");
            object = (ModulePointerImpl)CollectionsKt.firstOrNull((Iterable)collection);
            modulePointerImpl = object;
        }
        finally {
            ((ReentrantReadWriteLock.ReadLock)serializable).unlock();
        }
        if (modulePointerImpl != null) {
            modulePointer = modulePointerImpl;
        } else {
            ModulePointerImpl modulePointerImpl2;
            serializable = this.lock;
            object = ((ReentrantReadWriteLock)serializable).readLock();
            int n = ((ReentrantReadWriteLock)serializable).getWriteHoldCount() == 0 ? ((ReentrantReadWriteLock)serializable).getReadHoldCount() : 0;
            for (int j = 0; j < n; ++j) {
                ((ReentrantReadWriteLock.ReadLock)object).unlock();
            }
            ReentrantReadWriteLock.WriteLock writeLock = ((ReentrantReadWriteLock)serializable).writeLock();
            writeLock.lock();
            try {
                ModulePointerImpl modulePointerImpl3;
                boolean bl = false;
                Collection<ModulePointerImpl> collection = this.pointers.get(module2);
                Intrinsics.checkNotNullExpressionValue(collection, (String)"pointers.get(module)");
                ModulePointerImpl modulePointerImpl4 = (ModulePointerImpl)CollectionsKt.firstOrNull((Iterable)collection);
                if (modulePointerImpl4 != null) {
                    ModulePointerImpl it = modulePointerImpl4;
                    boolean bl2 = false;
                    ModulePointer modulePointer2 = it;
                    return modulePointer2;
                }
                Collection<ModulePointerImpl> pointers2 = this.unresolved.remove(module2.getName());
                Collection<ModulePointerImpl> collection2 = pointers2;
                if (collection2 == null || collection2.isEmpty()) {
                    ModulePointerImpl pointer = new ModulePointerImpl(module2, this.lock);
                    this.registerPointer(module2, pointer);
                    modulePointerImpl3 = pointer;
                } else {
                    Iterable $this$forEach$iv = pointers2;
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        ModulePointerImpl it = (ModulePointerImpl)element$iv;
                        boolean bl3 = false;
                        it.moduleAdded$intellij_platform_projectModel_impl(module2);
                        Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                        this.registerPointer(module2, it);
                    }
                    modulePointerImpl3 = (ModulePointerImpl)CollectionsKt.first((Iterable)pointers2);
                }
                ModulePointerImpl modulePointerImpl5 = modulePointerImpl3;
                modulePointerImpl2 = modulePointerImpl5;
            }
            finally {
                for (int it = 0; it < n; ++it) {
                    ((ReentrantReadWriteLock.ReadLock)object).lock();
                }
                writeLock.unlock();
            }
            Intrinsics.checkNotNullExpressionValue((Object)modulePointerImpl2, (String)"lock.write {\n      point\u2026ers.first()\n      }\n    }");
            modulePointer = modulePointerImpl2;
        }
        return modulePointer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @NotNull
    public ModulePointer create(@NotNull String moduleName) {
        Module module2;
        String $i$a$-read-ModulePointerManagerImpl$create$newName$22;
        Intrinsics.checkNotNullParameter((Object)moduleName, (String)"moduleName");
        Module module3 = ModuleManager.Companion.getInstance(this.project).findModuleByName(moduleName);
        if (module3 != null) {
            Module it = module3;
            return this.create(it);
        }
        ReentrantReadWriteLock.ReadLock readLock = this.lock.readLock();
        readLock.lock();
        try {
            boolean $i$a$-read-ModulePointerManagerImpl$create$newName$22 = false;
            $i$a$-read-ModulePointerManagerImpl$create$newName$22 = this.oldToNewName.get(moduleName);
        }
        finally {
            readLock.unlock();
        }
        String newName2 = $i$a$-read-ModulePointerManagerImpl$create$newName$22;
        if (newName2 != null && (module2 = ModuleManager.Companion.getInstance(this.project).findModuleByName(newName2)) != null) {
            Module it = module2;
            return this.create(it);
        }
        readLock = this.lock.readLock();
        readLock.lock();
        try {
            boolean bl = false;
            Collection<ModulePointerImpl> collection = this.unresolved.get(moduleName);
            Intrinsics.checkNotNullExpressionValue(collection, (String)"unresolved.get(moduleName)");
            ModulePointerImpl modulePointerImpl = (ModulePointerImpl)CollectionsKt.firstOrNull((Iterable)collection);
            if (modulePointerImpl == null) {
                ReentrantReadWriteLock reentrantReadWriteLock = this.lock;
                ReentrantReadWriteLock.ReadLock readLock2 = reentrantReadWriteLock.readLock();
                int n = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
                for (int j = 0; j < n; ++j) {
                    readLock2.unlock();
                }
                ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
                writeLock.lock();
                try {
                    Object v5;
                    block23: {
                        boolean bl2 = false;
                        Collection<ModulePointerImpl> collection2 = this.unresolved.get(moduleName);
                        Intrinsics.checkNotNullExpressionValue(collection2, (String)"unresolved.get(moduleName)");
                        ModulePointerImpl modulePointerImpl2 = (ModulePointerImpl)CollectionsKt.firstOrNull((Iterable)collection2);
                        if (modulePointerImpl2 != null) {
                            ModulePointerImpl it = modulePointerImpl2;
                            boolean bl3 = false;
                            ModulePointer modulePointer = it;
                            ModulePointer modulePointer2 = modulePointer;
                            return modulePointer2;
                        }
                        Set<Module> set2 = this.pointers.keySet();
                        Intrinsics.checkNotNullExpressionValue(set2, (String)"pointers.keySet()");
                        Iterable $this$firstOrNull$iv = set2;
                        boolean $i$f$firstOrNull = false;
                        for (Object element$iv : $this$firstOrNull$iv) {
                            Module it = (Module)element$iv;
                            boolean bl4 = false;
                            if (!Intrinsics.areEqual((Object)it.getName(), (Object)moduleName)) continue;
                            v5 = element$iv;
                            break block23;
                        }
                        v5 = null;
                    }
                    Module module4 = v5;
                    if (module4 != null) {
                        Module it = module4;
                        boolean bl5 = false;
                        ModulePointer modulePointer = this.create(it);
                        ModulePointer modulePointer3 = modulePointer;
                        return modulePointer3;
                    }
                    ModulePointerImpl pointer = new ModulePointerImpl(moduleName, this.lock);
                    this.unresolved.putValue(moduleName, pointer);
                    ModulePointerImpl modulePointerImpl3 = pointer;
                    modulePointerImpl = modulePointerImpl3;
                }
                finally {
                    int it = 0;
                    while (true) {
                        if (it >= n) {
                            writeLock.unlock();
                        }
                        readLock2.lock();
                        ++it;
                    }
                }
            }
            ModulePointerImpl modulePointerImpl4 = modulePointerImpl;
            return modulePointerImpl4;
        }
        finally {
            readLock.unlock();
        }
    }

    private static final void registerPointer$lambda$7(ModulePointerManagerImpl this$0, Module $module) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$module, (String)"$module");
        this$0.unregisterPointer($module);
    }
}

