/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.module.impl;

import com.intellij.diagnostic.PluginException;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.module.EmptyModuleType;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.module.ModuleTypeEP;
import com.intellij.openapi.module.ModuleTypeManager;
import com.intellij.openapi.module.UnknownModuleType;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ModuleTypeManagerImpl
extends ModuleTypeManager {
    private static final Logger LOG = Logger.getInstance(ModuleTypeManagerImpl.class);
    @ApiStatus.Internal
    public static final ExtensionPointName<ModuleTypeEP> EP_NAME = new ExtensionPointName("com.intellij.moduleType");
    private final LinkedHashMap<ModuleType<?>, Boolean> myModuleTypes = new LinkedHashMap();

    public ModuleTypeManagerImpl() {
        this.registerModuleType(this.getDefaultModuleType(), true);
        EP_NAME.processWithPluginDescriptor((ep, pluginDescriptor) -> {
            if (ep.id == null) {
                LOG.error(new PluginException("'id' attribute isn't specified for <moduleType implementationClass='" + ep.implementationClass + "'> extension", pluginDescriptor.getPluginId()));
            }
        });
    }

    public void registerModuleType(@NotNull ModuleType type) {
        if (type == null) {
            ModuleTypeManagerImpl.$$$reportNull$$$0(0);
        }
        this.registerModuleType(type, false);
    }

    public void unregisterModuleType(@NotNull ModuleType<?> type) {
        if (type == null) {
            ModuleTypeManagerImpl.$$$reportNull$$$0(1);
        }
        this.myModuleTypes.remove(type);
    }

    public void registerModuleType(@NotNull ModuleType type, boolean classpathProvider) {
        if (type == null) {
            ModuleTypeManagerImpl.$$$reportNull$$$0(2);
        }
        for (ModuleType<?> oldType : this.myModuleTypes.keySet()) {
            if (!oldType.getId().equals(type.getId())) continue;
            PluginException.logPluginError(LOG, "Trying to register a module type that clashes with existing one. Old=" + oldType + ", new = " + type, null, type.getClass());
            return;
        }
        this.myModuleTypes.put(type, classpathProvider);
    }

    @NotNull
    public List<ModuleType<?>> getRegisteredTypes() {
        ArrayList result2 = new ArrayList(this.myModuleTypes.keySet());
        EP_NAME.forEachExtensionSafe(ep -> {
            ModuleType<?> moduleType = ep.getModuleType();
            if (!this.myModuleTypes.containsKey(moduleType)) {
                result2.add(moduleType);
            }
        });
        ArrayList arrayList = result2;
        if (arrayList == null) {
            ModuleTypeManagerImpl.$$$reportNull$$$0(3);
        }
        return arrayList;
    }

    @NotNull
    public ModuleType<?> findByID(@Nullable String moduleTypeId) {
        if (moduleTypeId == null) {
            ModuleType<?> moduleType = this.getDefaultModuleType();
            if (moduleType == null) {
                ModuleTypeManagerImpl.$$$reportNull$$$0(4);
            }
            return moduleType;
        }
        for (ModuleType<?> type : this.myModuleTypes.keySet()) {
            if (!type.getId().equals(moduleTypeId)) continue;
            ModuleType<?> moduleType = type;
            if (moduleType == null) {
                ModuleTypeManagerImpl.$$$reportNull$$$0(5);
            }
            return moduleType;
        }
        ModuleTypeEP result2 = EP_NAME.getByKey(moduleTypeId, ModuleTypeManagerImpl.class, it -> it.id);
        if (result2 != null) {
            ModuleType<?> moduleType = result2.getModuleType();
            if (moduleType == null) {
                ModuleTypeManagerImpl.$$$reportNull$$$0(6);
            }
            return moduleType;
        }
        return new UnknownModuleType(moduleTypeId, this.getDefaultModuleType());
    }

    public boolean isClasspathProvider(@NotNull ModuleType moduleType) {
        if (moduleType == null) {
            ModuleTypeManagerImpl.$$$reportNull$$$0(7);
        }
        for (ModuleTypeEP ep : EP_NAME.getExtensionList()) {
            if (!moduleType.getId().equals(ep.id)) continue;
            return ep.classpathProvider;
        }
        Boolean provider2 = this.myModuleTypes.get(moduleType);
        return provider2 != null && provider2 != false;
    }

    @NotNull
    public ModuleType<?> getDefaultModuleType() {
        EmptyModuleType emptyModuleType = EmptyModuleType.getInstance();
        if (emptyModuleType == null) {
            ModuleTypeManagerImpl.$$$reportNull$$$0(8);
        }
        return emptyModuleType;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 5, 6, 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/module/impl/ModuleTypeManagerImpl";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/module/impl/ModuleTypeManagerImpl";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getRegisteredTypes";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "findByID";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultModuleType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "registerModuleType";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "unregisterModuleType";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isClasspathProvider";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 3, 4, 5, 6, 8 -> new IllegalStateException(string2);
        };
    }
}

