/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.module.impl;

import com.intellij.CommonBundle;
import com.intellij.ide.plugins.IdeaPluginDescriptorImpl;
import com.intellij.ide.plugins.PluginFeatureService;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.plugins.PluginSet;
import com.intellij.ide.plugins.advertiser.FeaturePluginData;
import com.intellij.ide.plugins.advertiser.PluginData;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationGroupManager;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.module.ConfigurationErrorDescription;
import com.intellij.openapi.module.ConfigurationErrorType;
import com.intellij.openapi.module.ProjectLoadingErrorsNotifier;
import com.intellij.openapi.module.impl.RemoveInvalidElementsDialog;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.updateSettings.impl.pluginsAdvertisement.UnknownFeature;
import com.intellij.openapi.updateSettings.impl.pluginsAdvertisement.UnknownFeaturesCollector;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class ProjectLoadingErrorsNotifierImpl
extends ProjectLoadingErrorsNotifier {
    private final MultiMap<ConfigurationErrorType, ConfigurationErrorDescription> myErrors = new MultiMap();
    private final Object myLock = new Object();
    private final Project myProject;

    public ProjectLoadingErrorsNotifierImpl(Project project2) {
        this.myProject = project2;
    }

    @Override
    public void registerError(@NotNull ConfigurationErrorDescription errorDescription) {
        if (errorDescription == null) {
            ProjectLoadingErrorsNotifierImpl.$$$reportNull$$$0(0);
        }
        this.registerErrors(Collections.singletonList(errorDescription));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public void registerErrors(@NotNull Collection<? extends ConfigurationErrorDescription> errorDescriptions) {
        void first2;
        if (errorDescriptions == null) {
            ProjectLoadingErrorsNotifierImpl.$$$reportNull$$$0(1);
        }
        if (this.myProject.isDisposed() || this.myProject.isDefault() || errorDescriptions.isEmpty()) {
            return;
        }
        Object object = this.myLock;
        synchronized (object) {
            boolean first22 = this.myErrors.isEmpty();
            for (ConfigurationErrorDescription configurationErrorDescription : errorDescriptions) {
                this.myErrors.putValue(configurationErrorDescription.getErrorType(), configurationErrorDescription);
            }
        }
        if (this.myProject.isInitialized()) {
            this.fireNotifications();
        } else if (first2 != false) {
            StartupManager.getInstance(this.myProject).runAfterOpened(() -> this.fireNotifications());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireNotifications() {
        Map<ConfigurationErrorType, Collection<ConfigurationErrorDescription>> descriptionMap;
        Iterator<Map.Entry<ConfigurationErrorType, Collection<ConfigurationErrorDescription>>> iterator2 = this.myLock;
        synchronized (iterator2) {
            if (this.myErrors.isEmpty()) {
                return;
            }
            descriptionMap = this.myErrors.toHashMap();
            this.myErrors.clear();
        }
        for (Map.Entry<ConfigurationErrorType, Collection<ConfigurationErrorDescription>> entry : descriptionMap.entrySet()) {
            ArrayList<ConfigurationErrorDescription> descriptions = new ArrayList<ConfigurationErrorDescription>(entry.getValue());
            ConfigurationErrorType type = entry.getKey();
            String featureType = type.getFeatureType();
            if (featureType != null && IdeaPluginDescriptorImpl.isOnDemandEnabled()) {
                descriptions.removeIf(this.isConfigurableLater(featureType));
            }
            if (descriptions.isEmpty()) continue;
            String invalidElements = type.getErrorText(descriptions.size(), ((ConfigurationErrorDescription)descriptions.iterator().next()).getElementName());
            String errorText = ProjectBundle.message((String)"error.message.configuration.cannot.load", (Object[])new Object[]{invalidElements});
            NotificationGroupManager.getInstance().getNotificationGroup("Project Loading Error").createNotification(ProjectBundle.message((String)"notification.title.error.loading.project", (Object[])new Object[0]), errorText, NotificationType.ERROR).addAction((AnAction)NotificationAction.create((String)ProjectBundle.message((String)"error.message.configuration.cannot.load.button", (Object[])new Object[0]), (event, notification) -> {
                List<ConfigurationErrorDescription> validDescriptions = ContainerUtil.findAll(descriptions, ConfigurationErrorDescription::isValid);
                if (RemoveInvalidElementsDialog.showDialog(this.myProject, CommonBundle.getErrorTitle(), type, invalidElements, validDescriptions)) {
                    notification.expire();
                }
            })).notify(this.myProject);
        }
    }

    @NotNull
    private Predicate<? super ConfigurationErrorDescription> isConfigurableLater(@NotNull @NonNls String featureType) {
        if (featureType == null) {
            ProjectLoadingErrorsNotifierImpl.$$$reportNull$$$0(2);
        }
        PluginSet pluginSet = PluginManagerCore.getPluginSet();
        PluginFeatureService pluginFeatureService = PluginFeatureService.getInstance();
        UnknownFeaturesCollector featuresCollector = UnknownFeaturesCollector.getInstance((Project)this.myProject);
        LinkedHashSet<String> implementationNames = new LinkedHashSet<String>();
        for (UnknownFeature unknownFeature : featuresCollector.getUnknownFeaturesOfType(featureType)) {
            PluginData pluginData;
            IdeaPluginDescriptorImpl descriptor2;
            String implementationName = unknownFeature.getImplementationName();
            FeaturePluginData featurePluginData = pluginFeatureService.getPluginForFeature(unknownFeature.getFeatureType(), implementationName);
            if (featurePluginData == null || (descriptor2 = pluginSet.findInstalledPlugin((pluginData = featurePluginData.getPluginData()).getPluginId())) == null || !descriptor2.isOnDemand()) continue;
            implementationNames.add(implementationName);
        }
        Predicate<ConfigurationErrorDescription> predicate2 = description -> {
            String implementationName = description.getImplementationName();
            return implementationName != null && implementationNames.contains(implementationName);
        };
        if (predicate2 == null) {
            ProjectLoadingErrorsNotifierImpl.$$$reportNull$$$0(3);
        }
        return predicate2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errorDescription";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errorDescriptions";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "featureType";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/module/impl/ProjectLoadingErrorsNotifierImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/module/impl/ProjectLoadingErrorsNotifierImpl";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "isConfigurableLater";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "registerError";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "registerErrors";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isConfigurableLater";
                break;
            }
            case 3: {
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 3 -> new IllegalStateException(string2);
        };
    }
}

