/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.module.impl;

import com.intellij.openapi.module.ConfigurationErrorDescription;
import com.intellij.openapi.module.ConfigurationErrorType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.VerticalFlowLayout;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.xml.util.XmlStringUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public final class RemoveInvalidElementsDialog
extends DialogWrapper {
    private JPanel myContentPanel;
    private JPanel myMainPanel;
    private JLabel myDescriptionLabel;
    private final Map<JCheckBox, ConfigurationErrorDescription> myCheckboxes;

    private RemoveInvalidElementsDialog(@NlsContexts.DialogTitle String title, ConfigurationErrorType type, @Nls String invalidElements, Project project2, List<? extends ConfigurationErrorDescription> errors) {
        super(project2, true);
        this.$$$setupUI$$$();
        this.myCheckboxes = new HashMap<JCheckBox, ConfigurationErrorDescription>();
        this.setTitle(title);
        this.myDescriptionLabel.setText(ProjectBundle.message((String)(type.canIgnore() ? "label.text.0.cannot.be.loaded.ignore" : "label.text.0.cannot.be.loaded.remove"), (Object[])new Object[]{invalidElements}));
        this.myContentPanel.setLayout(new VerticalFlowLayout());
        for (ConfigurationErrorDescription configurationErrorDescription : errors) {
            JCheckBox checkBox = new JCheckBox(configurationErrorDescription.getElementName());
            checkBox.setSelected(true);
            this.myCheckboxes.put(checkBox, configurationErrorDescription);
            JPanel panel2 = new JPanel(new GridBagLayout());
            GridBagConstraints constraints = new GridBagConstraints();
            constraints.anchor = 18;
            constraints.ipadx = 5;
            panel2.add((Component)checkBox, constraints);
            constraints.anchor = 18;
            constraints.insets.top = 5;
            panel2.add((Component)new JLabel(XmlStringUtil.wrapInHtml(StringUtil.replace(configurationErrorDescription.getDescription(), "\n", "<br>"))), constraints);
            constraints.weightx = 1.0;
            panel2.add((Component)new JPanel(), constraints);
            this.myContentPanel.add(panel2);
        }
        this.init();
        this.setOKButtonText(ProjectBundle.message((String)(type.canIgnore() ? "button.text.ignore.selected" : "button.text.remove.selected"), (Object[])new Object[0]));
        this.setCancelButtonText(ProjectBundle.message((String)"button.text.keep.all", (Object[])new Object[0]));
    }

    public static boolean showDialog(@NotNull Project project2, @NlsContexts.DialogTitle @NotNull String title, @NotNull ConfigurationErrorType type, @Nls @NotNull String invalidElements, @NotNull List<? extends ConfigurationErrorDescription> errors) {
        if (project2 == null) {
            RemoveInvalidElementsDialog.$$$reportNull$$$0(0);
        }
        if (title == null) {
            RemoveInvalidElementsDialog.$$$reportNull$$$0(1);
        }
        if (type == null) {
            RemoveInvalidElementsDialog.$$$reportNull$$$0(2);
        }
        if (invalidElements == null) {
            RemoveInvalidElementsDialog.$$$reportNull$$$0(3);
        }
        if (errors == null) {
            RemoveInvalidElementsDialog.$$$reportNull$$$0(4);
        }
        if (errors.isEmpty()) {
            return true;
        }
        if (errors.size() == 1) {
            ConfigurationErrorDescription error2 = errors.get(0);
            String message = error2.getDescription() + "\n" + error2.getIgnoreConfirmationMessage();
            int answer = Messages.showYesNoDialog((Project)project2, (String)message, (String)title, (Icon)Messages.getErrorIcon());
            if (answer == 0) {
                error2.ignoreInvalidElement();
                return true;
            }
            return false;
        }
        RemoveInvalidElementsDialog dialog = new RemoveInvalidElementsDialog(title, type, invalidElements, project2, errors);
        if (dialog.showAndGet()) {
            for (ConfigurationErrorDescription errorDescription : dialog.getSelectedItems()) {
                errorDescription.ignoreInvalidElement();
            }
            return true;
        }
        return false;
    }

    private List<ConfigurationErrorDescription> getSelectedItems() {
        ArrayList<ConfigurationErrorDescription> items2 = new ArrayList<ConfigurationErrorDescription>();
        for (Map.Entry<JCheckBox, ConfigurationErrorDescription> entry : this.myCheckboxes.entrySet()) {
            if (!entry.getKey().isSelected()) continue;
            items2.add(entry.getValue());
        }
        return items2;
    }

    protected JComponent createCenterPanel() {
        return this.myMainPanel;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        JLabel jLabel;
        JPanel jPanel2;
        this.myMainPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myDescriptionLabel = jLabel = new JLabel();
        jLabel.setText("");
        jPanel2.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JBScrollPane jBScrollPane = new JBScrollPane();
        jPanel2.add((Component)jBScrollPane, new GridConstraints(1, 0, 1, 1, 0, 3, 7, 7, null, null, null));
        this.myContentPanel = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jBScrollPane.setViewportView(jPanel);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "title";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "type";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[0] = "invalidElements";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[0] = "errors";
                break;
            }
        }
        objectArray[1] = "com/intellij/openapi/module/impl/RemoveInvalidElementsDialog";
        objectArray[2] = "showDialog";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

