/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.module.impl.scopes;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.GlobalSearchScope;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class LibraryScopeBase
extends GlobalSearchScope {
    private final Object2IntMap<VirtualFile> myEntries;
    protected final ProjectFileIndex myIndex;

    public LibraryScopeBase(Project project2, VirtualFile[] classes, VirtualFile[] sources) {
        super(project2);
        this.myIndex = ProjectRootManager.getInstance(project2).getFileIndex();
        this.myEntries = new Object2IntOpenHashMap<VirtualFile>(classes.length + sources.length);
        this.myEntries.defaultReturnValue(Integer.MAX_VALUE);
        for (VirtualFile file2 : classes) {
            this.myEntries.putIfAbsent(file2, this.myEntries.size());
        }
        for (VirtualFile file2 : sources) {
            this.myEntries.putIfAbsent(file2, this.myEntries.size());
        }
    }

    @Override
    public boolean contains(@NotNull VirtualFile file2) {
        if (file2 == null) {
            LibraryScopeBase.$$$reportNull$$$0(0);
        }
        return this.myEntries.containsKey(this.getFileRoot(file2));
    }

    @Nullable
    protected VirtualFile getFileRoot(@NotNull VirtualFile file2) {
        if (file2 == null) {
            LibraryScopeBase.$$$reportNull$$$0(1);
        }
        if (this.myIndex.isInLibraryClasses(file2)) {
            return this.myIndex.getClassRootForFile(file2);
        }
        if (this.myIndex.isInLibrarySource(file2)) {
            return this.myIndex.getSourceRootForFile(file2);
        }
        return null;
    }

    @Override
    public int compare(@NotNull VirtualFile file1, @NotNull VirtualFile file2) {
        if (file1 == null) {
            LibraryScopeBase.$$$reportNull$$$0(2);
        }
        if (file2 == null) {
            LibraryScopeBase.$$$reportNull$$$0(3);
        }
        int pos1 = this.myEntries.getInt(this.getFileRoot(file1));
        int pos2 = this.myEntries.getInt(this.getFileRoot(file2));
        return Integer.compare(pos2, pos1);
    }

    @Override
    public boolean isSearchInModuleContent(@NotNull Module aModule) {
        if (aModule == null) {
            LibraryScopeBase.$$$reportNull$$$0(4);
        }
        return false;
    }

    @Override
    public boolean isSearchInLibraries() {
        return true;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof LibraryScopeBase)) {
            return false;
        }
        return ((Object)this.myEntries.keySet()).equals(((LibraryScopeBase)o).myEntries.keySet());
    }

    @Override
    public int calcHashCode() {
        return ((Object)this.myEntries.keySet()).hashCode();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file1";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file2";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aModule";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/module/impl/scopes/LibraryScopeBase";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "contains";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getFileRoot";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "compare";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "isSearchInModuleContent";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

