/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.module.impl.scopes;

import com.intellij.model.ModelBranch;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ModuleOrderEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ModuleSourceOrderEntry;
import com.intellij.openapi.roots.OrderEnumerator;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.OrderRootsEnumerator;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.impl.ProjectFileIndexImpl;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileWithId;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.impl.VirtualFileEnumeration;
import com.intellij.psi.search.impl.VirtualFileEnumerationAware;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.ArrayUtil;
import com.intellij.util.BitUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.IndexingBundle;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public final class ModuleWithDependenciesScope
extends GlobalSearchScope
implements VirtualFileEnumerationAware {
    public static final int COMPILE_ONLY = 1;
    public static final int LIBRARIES = 2;
    public static final int MODULES = 4;
    public static final int TESTS = 8;
    public static final int CONTENT = 32;
    private static final Key<CachedValue<ConcurrentMap<Integer, VirtualFileEnumeration>>> CACHED_FILE_ID_ENUMERATIONS_KEY = Key.create("CACHED_FILE_ID_ENUMERATIONS");
    private final Module myModule;
    @ScopeConstant
    private final int myOptions;
    private final ProjectFileIndexImpl myProjectFileIndex;
    private volatile Set<Module> myModules;
    private final Object2IntMap<VirtualFile> myRoots;
    private final UserDataHolderBase myUserDataHolderBase;
    private static final Key<Pair<Long, Object2IntMap<VirtualFile>>> BRANCH_ROOTS = Key.create("BRANCH_ROOTS");

    ModuleWithDependenciesScope(@NotNull Module module2, @ScopeConstant int options2) {
        if (module2 == null) {
            ModuleWithDependenciesScope.$$$reportNull$$$0(0);
        }
        super(module2.getProject());
        this.myUserDataHolderBase = new UserDataHolderBase();
        this.myModule = module2;
        this.myOptions = options2;
        this.myProjectFileIndex = (ProjectFileIndexImpl)ProjectRootManager.getInstance(module2.getProject()).getFileIndex();
        this.myRoots = this.calcRoots(null);
    }

    private Object2IntMap<VirtualFile> calcRoots(@Nullable ModelBranch branch) {
        LinkedHashSet<VirtualFile> roots2 = new LinkedHashSet<VirtualFile>();
        if (this.hasOption(32)) {
            Set<Module> modules2 = this.calcModules();
            this.myModules = new HashSet<Module>(modules2);
            for (Module m : modules2) {
                for (ContentEntry entry2 : ModuleRootManager.getInstance(m).getContentEntries()) {
                    ContainerUtil.addIfNotNull(roots2, branch == null ? entry2.getFile() : branch.findFileByUrl(entry2.getUrl()));
                }
            }
        } else {
            OrderRootsEnumerator en = this.getOrderEnumeratorForOptions().roots(entry -> {
                if (entry instanceof ModuleOrderEntry || entry instanceof ModuleSourceOrderEntry) {
                    return OrderRootType.SOURCES;
                }
                return OrderRootType.CLASSES;
            });
            if (branch == null) {
                Collections.addAll(roots2, en.getRoots());
            } else {
                roots2.addAll(ContainerUtil.mapNotNull(en.getUrls(), branch::findFileByUrl));
            }
        }
        int i2 = 1;
        Object2IntOpenHashMap<VirtualFile> map2 = new Object2IntOpenHashMap<VirtualFile>(roots2.size());
        for (VirtualFile root : roots2) {
            map2.put(root, i2++);
        }
        return map2;
    }

    private OrderEnumerator getOrderEnumeratorForOptions() {
        OrderEnumerator en = ModuleRootManager.getInstance(this.myModule).orderEntries();
        en.recursively();
        if (this.hasOption(1)) {
            en.exportedOnly().compileOnly();
        }
        if (!this.hasOption(2)) {
            en.withoutLibraries().withoutSdk();
        }
        if (!this.hasOption(4)) {
            en.withoutDepModules();
        }
        if (!this.hasOption(8)) {
            en.productionOnly();
        }
        return en;
    }

    @NotNull
    private Set<Module> calcModules() {
        LinkedHashSet<Module> modules2 = new LinkedHashSet<Module>();
        OrderEnumerator en = this.getOrderEnumeratorForOptions();
        en.forEach(each -> {
            if (each instanceof ModuleOrderEntry) {
                ContainerUtil.addIfNotNull(modules2, ((ModuleOrderEntry)each).getModule());
            } else if (each instanceof ModuleSourceOrderEntry) {
                ContainerUtil.addIfNotNull(modules2, each.getOwnerModule());
            }
            return true;
        });
        LinkedHashSet<Module> linkedHashSet = modules2;
        if (linkedHashSet == null) {
            ModuleWithDependenciesScope.$$$reportNull$$$0(1);
        }
        return linkedHashSet;
    }

    @NotNull
    public Module getModule() {
        Module module2 = this.myModule;
        if (module2 == null) {
            ModuleWithDependenciesScope.$$$reportNull$$$0(2);
        }
        return module2;
    }

    private boolean hasOption(@ScopeConstant int option) {
        return BitUtil.isSet(this.myOptions, option);
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string2 = this.hasOption(1) ? IndexingBundle.message((String)"search.scope.module", (Object[])new Object[]{this.myModule.getName()}) : IndexingBundle.message((String)"search.scope.module.runtime", (Object[])new Object[]{this.myModule.getName()});
        if (string2 == null) {
            ModuleWithDependenciesScope.$$$reportNull$$$0(3);
        }
        return string2;
    }

    @Override
    public boolean isSearchInModuleContent(@NotNull Module aModule) {
        Set<Module> allModules;
        if (aModule == null) {
            ModuleWithDependenciesScope.$$$reportNull$$$0(4);
        }
        if ((allModules = this.myModules) == null) {
            this.myModules = allModules = new HashSet<Module>(this.calcModules());
        }
        return allModules.contains(aModule);
    }

    @Override
    public boolean isSearchInModuleContent(@NotNull Module aModule, boolean testSources) {
        if (aModule == null) {
            ModuleWithDependenciesScope.$$$reportNull$$$0(5);
        }
        return this.isSearchInModuleContent(aModule) && (this.hasOption(8) || !testSources);
    }

    @Override
    public boolean isSearchInLibraries() {
        return this.hasOption(2);
    }

    @Override
    public boolean contains(@NotNull VirtualFile file2) {
        if (file2 == null) {
            ModuleWithDependenciesScope.$$$reportNull$$$0(6);
        }
        Object2IntMap<VirtualFile> roots2 = this.getRoots(file2);
        if (this.hasOption(32)) {
            return roots2.containsKey(this.myProjectFileIndex.getContentRootForFile(file2));
        }
        VirtualFile root = this.myProjectFileIndex.getModuleSourceOrLibraryClassesRoot(file2);
        return root != null && roots2.containsKey(root);
    }

    private Object2IntMap<VirtualFile> getRoots(@NotNull VirtualFile file2) {
        ModelBranch branch;
        if (file2 == null) {
            ModuleWithDependenciesScope.$$$reportNull$$$0(7);
        }
        return (branch = ModelBranch.getFileBranch(file2)) != null ? this.obtainBranchRoots(branch) : this.myRoots;
    }

    private Object2IntMap<VirtualFile> obtainBranchRoots(ModelBranch branch) {
        Pair<Long, Object2IntMap<VirtualFile>> pair = branch.getUserData(BRANCH_ROOTS);
        long modCount = branch.getBranchedVfsStructureModificationCount();
        if (pair == null || (Long)pair.first != modCount) {
            pair = Pair.create(modCount, this.calcRoots(branch));
        }
        return (Object2IntMap)pair.second;
    }

    @Override
    public int compare(@NotNull VirtualFile file1, @NotNull VirtualFile file2) {
        VirtualFile r2;
        VirtualFile r1;
        if (file1 == null) {
            ModuleWithDependenciesScope.$$$reportNull$$$0(8);
        }
        if (file2 == null) {
            ModuleWithDependenciesScope.$$$reportNull$$$0(9);
        }
        if (Comparing.equal(r1 = this.getFileRoot(file1), r2 = this.getFileRoot(file2))) {
            return 0;
        }
        if (r1 == null) {
            return -1;
        }
        if (r2 == null) {
            return 1;
        }
        Object2IntMap<VirtualFile> roots2 = this.getRoots(file1);
        int i1 = roots2.getInt(r1);
        int i2 = roots2.getInt(r2);
        if (i1 == 0 && i2 == 0) {
            return 0;
        }
        if (i1 > 0 && i2 > 0) {
            return i2 - i1;
        }
        return i1 > 0 ? 1 : -1;
    }

    @Nullable
    private VirtualFile getFileRoot(@NotNull VirtualFile file2) {
        if (file2 == null) {
            ModuleWithDependenciesScope.$$$reportNull$$$0(10);
        }
        if (this.hasOption(32)) {
            return this.myProjectFileIndex.getContentRootForFile(file2);
        }
        return this.myProjectFileIndex.getModuleSourceOrLibraryClassesRoot(file2);
    }

    @TestOnly
    public Collection<VirtualFile> getRoots() {
        ArrayList<VirtualFile> result2 = new ArrayList<VirtualFile>(this.myRoots.keySet());
        result2.sort(Comparator.comparingInt(this.myRoots::getInt));
        return result2;
    }

    @Override
    @Nullable
    public VirtualFileEnumeration extractFileEnumeration() {
        if (this.hasOption(4) || this.hasOption(2)) {
            return null;
        }
        CachedValueProvider provider2 = () -> CachedValueProvider.Result.create(new ConcurrentHashMap(), VirtualFileManager.VFS_STRUCTURE_MODIFICATIONS);
        CachedValuesManager cachedValuesManager = CachedValuesManager.getManager(this.myModule.getProject());
        ConcurrentMap cacheHolder = (ConcurrentMap)cachedValuesManager.getCachedValue(this.myUserDataHolderBase, CACHED_FILE_ID_ENUMERATIONS_KEY, provider2, false);
        return cacheHolder.computeIfAbsent(this.myOptions, key -> this.doExtractFilIdEnumeration());
    }

    @NotNull
    private VirtualFileEnumeration doExtractFilIdEnumeration() {
        IntOpenHashSet result2 = new IntOpenHashSet();
        for (VirtualFile file2 : this.myRoots.keySet()) {
            if (!(file2 instanceof VirtualFileWithId)) continue;
            int[] children2 = VirtualFileManager.getInstance().listAllChildIds(((VirtualFileWithId)((Object)file2)).getId());
            result2.addAll(IntList.of(children2));
        }
        return new MyVirtualFileEnumeration(result2);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ModuleWithDependenciesScope that = (ModuleWithDependenciesScope)o;
        return this.myOptions == that.myOptions && this.myModule.equals(that.myModule);
    }

    @Override
    public int calcHashCode() {
        return 31 * this.myModule.hashCode() + this.myOptions;
    }

    public String toString() {
        return "Module-with-dependencies:" + this.myModule.getName() + " compile-only:" + this.hasOption(1) + " include-libraries:" + this.hasOption(2) + " include-other-modules:" + this.hasOption(4) + " include-tests:" + this.hasOption(8);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/module/impl/scopes/ModuleWithDependenciesScope";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aModule";
                break;
            }
            case 6: 
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file1";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file2";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/module/impl/scopes/ModuleWithDependenciesScope";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "calcModules";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getModule";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isSearchInModuleContent";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "contains";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getRoots";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "compare";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getFileRoot";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 1, 2, 3 -> new IllegalStateException(string2);
        };
    }

    private static class MyVirtualFileEnumeration
    implements VirtualFileEnumeration {
        @NotNull
        private final IntSet myResult;

        MyVirtualFileEnumeration(@NotNull IntSet result2) {
            if (result2 == null) {
                MyVirtualFileEnumeration.$$$reportNull$$$0(0);
            }
            this.myResult = result2;
        }

        @Override
        public boolean contains(int fileId) {
            return this.myResult.contains(fileId);
        }

        @Override
        public int @NotNull [] asArray() {
            int[] nArray = this.myResult.toArray(ArrayUtil.EMPTY_INT_ARRAY);
            if (nArray == null) {
                MyVirtualFileEnumeration.$$$reportNull$$$0(1);
            }
            return nArray;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MyVirtualFileEnumeration that = (MyVirtualFileEnumeration)o;
            return this.myResult.equals(that.myResult);
        }

        public int hashCode() {
            return Objects.hash(this.myResult);
        }

        public String toString() {
            return Arrays.toString(this.myResult.toIntArray());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "result";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/module/impl/scopes/ModuleWithDependenciesScope$MyVirtualFileEnumeration";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/module/impl/scopes/ModuleWithDependenciesScope$MyVirtualFileEnumeration";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "asArray";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string2);
                case 1 -> new IllegalStateException(string2);
            };
        }
    }

    static @interface ScopeConstant {
    }
}

