/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.module.impl.scopes;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.UnloadedModuleDescription;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleOrderEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.TestSourcesFilter;
import com.intellij.openapi.roots.impl.DirectoryIndex;
import com.intellij.openapi.roots.impl.ProjectFileIndexImpl;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.containers.HashSetQueue;
import com.intellij.util.containers.MultiMap;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public final class ModuleWithDependentsScope
extends GlobalSearchScope {
    private final Set<Module> myRootModules;
    private final ProjectFileIndexImpl myProjectFileIndex;
    private final Set<Module> myModules;
    private final Set<Module> myProductionOnTestModules;

    ModuleWithDependentsScope(@NotNull Module module2) {
        if (module2 == null) {
            ModuleWithDependentsScope.$$$reportNull$$$0(0);
        }
        this(module2.getProject(), Collections.singleton(module2));
    }

    public ModuleWithDependentsScope(@NotNull Project project2, @NotNull Collection<? extends Module> modules2) {
        if (project2 == null) {
            ModuleWithDependentsScope.$$$reportNull$$$0(1);
        }
        if (modules2 == null) {
            ModuleWithDependentsScope.$$$reportNull$$$0(2);
        }
        super(project2);
        this.myModules = new HashSet<Module>();
        this.myProductionOnTestModules = new HashSet<Module>();
        this.myRootModules = new LinkedHashSet<Module>(modules2);
        this.myProjectFileIndex = (ProjectFileIndexImpl)ProjectRootManager.getInstance(project2).getFileIndex();
        this.myModules.addAll(this.myRootModules);
        ModuleIndex index2 = ModuleWithDependentsScope.getModuleIndex(project2);
        HashSetQueue walkingQueue = new HashSetQueue();
        walkingQueue.addAll(this.myRootModules);
        for (Module current : walkingQueue) {
            Collection<Module> usages = index2.allUsages.get(current);
            this.myModules.addAll(usages);
            walkingQueue.addAll(index2.exportingUsages.get(current));
            if (this.myProductionOnTestModules.contains(current)) {
                this.myProductionOnTestModules.addAll(usages);
            }
            this.myProductionOnTestModules.addAll(index2.productionOnTestUsages.get(current));
        }
    }

    @NotNull
    private static ModuleIndex getModuleIndex(@NotNull Project project2) {
        if (project2 == null) {
            ModuleWithDependentsScope.$$$reportNull$$$0(3);
        }
        ModuleIndex moduleIndex = (ModuleIndex)CachedValuesManager.getManager(project2).getCachedValue(project2, () -> {
            ModuleIndex index2 = new ModuleIndex();
            for (Module module2 : ModuleManager.getInstance(project2).getModules()) {
                for (OrderEntry orderEntry2 : ModuleRootManager.getInstance(module2).getOrderEntries()) {
                    Module referenced;
                    if (!(orderEntry2 instanceof ModuleOrderEntry) || (referenced = ((ModuleOrderEntry)orderEntry2).getModule()) == null) continue;
                    index2.allUsages.putValue(referenced, module2);
                    if (((ModuleOrderEntry)orderEntry2).isExported()) {
                        index2.exportingUsages.putValue(referenced, module2);
                    }
                    if (!((ModuleOrderEntry)orderEntry2).isProductionOnTestDependency()) continue;
                    index2.productionOnTestUsages.putValue(referenced, module2);
                }
            }
            return CachedValueProvider.Result.create(index2, ProjectRootManager.getInstance(project2));
        });
        if (moduleIndex == null) {
            ModuleWithDependentsScope.$$$reportNull$$$0(4);
        }
        return moduleIndex;
    }

    @Override
    public boolean contains(@NotNull VirtualFile file2) {
        if (file2 == null) {
            ModuleWithDependentsScope.$$$reportNull$$$0(5);
        }
        return this.contains(file2, false);
    }

    boolean contains(@NotNull VirtualFile file2, boolean fromTests) {
        Module moduleOfFile;
        if (file2 == null) {
            ModuleWithDependentsScope.$$$reportNull$$$0(6);
        }
        if ((moduleOfFile = this.myProjectFileIndex.getModuleForFile(file2)) == null || !this.myModules.contains(moduleOfFile)) {
            return false;
        }
        return !fromTests || this.myProductionOnTestModules.contains(moduleOfFile) || TestSourcesFilter.isTestSources(file2, moduleOfFile.getProject());
    }

    @Override
    public boolean isSearchInModuleContent(@NotNull Module module2) {
        if (module2 == null) {
            ModuleWithDependentsScope.$$$reportNull$$$0(7);
        }
        return this.myModules.contains(module2);
    }

    @Override
    public boolean isSearchInLibraries() {
        return false;
    }

    @Override
    @NotNull
    public Collection<UnloadedModuleDescription> getUnloadedModulesBelongingToScope() {
        Project project2 = this.getProject();
        ModuleManager moduleManager = ModuleManager.getInstance(Objects.requireNonNull(project2));
        Collection collection = this.myRootModules.stream().flatMap(module2 -> DirectoryIndex.getInstance(project2).getDependentUnloadedModules((Module)module2).stream()).map(moduleManager::getUnloadedModuleDescription).filter(Objects::nonNull).collect(Collectors.toList());
        if (collection == null) {
            ModuleWithDependentsScope.$$$reportNull$$$0(8);
        }
        return collection;
    }

    @NonNls
    public String toString() {
        return "Modules with dependents: (roots: [" + StringUtil.join(this.myRootModules, Module::getName, ", ") + "], including dependents: [" + StringUtil.join(this.myModules, Module::getName, ", ") + "])";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        return o instanceof ModuleWithDependentsScope && this.myModules.equals(((ModuleWithDependentsScope)o).myModules);
    }

    @Override
    public int calcHashCode() {
        return this.myModules.hashCode();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modules";
                break;
            }
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/module/impl/scopes/ModuleWithDependentsScope";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/module/impl/scopes/ModuleWithDependentsScope";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getModuleIndex";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnloadedModulesBelongingToScope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getModuleIndex";
                break;
            }
            case 4: 
            case 8: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "contains";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isSearchInModuleContent";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 4, 8 -> new IllegalStateException(string2);
        };
    }

    private static final class ModuleIndex {
        final MultiMap<Module, Module> allUsages = new MultiMap();
        final MultiMap<Module, Module> exportingUsages = new MultiMap();
        final MultiMap<Module, Module> productionOnTestUsages = new MultiMap();

        private ModuleIndex() {
        }
    }
}

