/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.paths;

import com.intellij.openapi.util.NullableLazyValue;
import com.intellij.psi.PsiElement;
import com.intellij.util.Function;
import com.intellij.util.NullableConstantFunction;
import com.intellij.util.NullableFunction;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PathReference {
    public static final NullableFunction<PathReference, Icon> NULL_ICON = new NullableConstantFunction<PathReference, Object>(null);
    private final String myPath;
    private final NullableLazyValue<Icon> myIcon;

    public PathReference(@NotNull String path2, final @NotNull Function<? super PathReference, ? extends Icon> icon2) {
        if (path2 == null) {
            PathReference.$$$reportNull$$$0(0);
        }
        if (icon2 == null) {
            PathReference.$$$reportNull$$$0(1);
        }
        this.myPath = path2;
        this.myIcon = new NullableLazyValue<Icon>(){

            @Override
            protected Icon compute() {
                return (Icon)icon2.fun(PathReference.this);
            }
        };
    }

    @NotNull
    public String getPath() {
        String string2 = this.myPath;
        if (string2 == null) {
            PathReference.$$$reportNull$$$0(2);
        }
        return string2;
    }

    @NotNull
    public String getTrimmedPath() {
        String string2 = PathReference.trimPath(this.myPath);
        if (string2 == null) {
            PathReference.$$$reportNull$$$0(3);
        }
        return string2;
    }

    @Nullable
    public Icon getIcon() {
        return this.myIcon.getValue();
    }

    @Nullable
    public PsiElement resolve() {
        return null;
    }

    public static String trimPath(String url) {
        for (int i2 = 0; i2 < url.length(); ++i2) {
            switch (url.charAt(i2)) {
                case '#': 
                case '?': {
                    return url.substring(0, i2);
                }
            }
        }
        return url;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "icon";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/paths/PathReference";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/paths/PathReference";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getPath";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getTrimmedPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 2, 3 -> new IllegalStateException(string2);
        };
    }

    public static class ResolveFunction
    implements NullableFunction<PathReference, Icon> {
        public static final ResolveFunction NULL_RESOLVE_FUNCTION = new ResolveFunction(null);
        private final Icon myDefaultIcon;

        public ResolveFunction(@Nullable Icon defaultValue) {
            this.myDefaultIcon = defaultValue;
        }

        @Override
        public Icon fun(PathReference pathReference) {
            PsiElement element = pathReference.resolve();
            return element == null ? this.myDefaultIcon : element.getIcon(2);
        }
    }
}

