/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.paths;

import com.intellij.analysis.AnalysisBundle;
import com.intellij.codeInsight.daemon.EmptyResolveMessageProvider;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixProvider;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementResolveResult;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.impl.source.resolve.reference.impl.PsiMultiReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceOwner;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.PsiFileReference;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiDynaReference<T extends PsiElement>
extends PsiReferenceBase<T>
implements FileReferenceOwner,
PsiPolyVariantReference,
LocalQuickFixProvider,
EmptyResolveMessageProvider {
    private final List<PsiReference> myReferences = new ArrayList<PsiReference>();
    private int myChosenOne = -1;
    private ResolveResult[] myCachedResult;
    @Nullable
    private TextRange myPredefinedRange = null;

    public PsiDynaReference(T psiElement) {
        super(psiElement, true);
    }

    public void addReferences(Collection<? extends PsiReference> references) {
        this.myReferences.addAll(references);
        for (PsiReference psiReference : references) {
            if (psiReference.isSoft()) continue;
            this.mySoft = false;
        }
    }

    public List<PsiReference> getReferences() {
        return this.myReferences;
    }

    public void addReference(PsiReference reference2) {
        this.myReferences.add(reference2);
        if (!reference2.isSoft()) {
            this.mySoft = false;
        }
    }

    @Override
    public void setRangeInElement(TextRange rangeInElement) {
        super.setRangeInElement(rangeInElement);
        this.myPredefinedRange = rangeInElement;
    }

    @Override
    @NotNull
    public TextRange getRangeInElement() {
        PsiReference resolved = null;
        PsiReference reference2 = this.myReferences.get(0);
        if (reference2.resolve() != null) {
            resolved = reference2;
        }
        TextRange range = reference2.getRangeInElement();
        int start = range.getStartOffset();
        int end = range.getEndOffset();
        for (int i2 = 1; i2 < this.myReferences.size(); ++i2) {
            reference2 = this.myReferences.get(i2);
            TextRange textRange = PsiMultiReference.getReferenceRange(reference2, this.myElement);
            start = Math.min(start, textRange.getStartOffset());
            if (resolved != null) continue;
            end = Math.max(end, textRange.getEndOffset());
        }
        if (this.myPredefinedRange != null && this.myPredefinedRange.containsRange(start, end)) {
            TextRange textRange = this.myPredefinedRange;
            if (textRange == null) {
                PsiDynaReference.$$$reportNull$$$0(0);
            }
            return textRange;
        }
        return new TextRange(start, end);
    }

    @Override
    public PsiElement resolve() {
        ResolveResult[] resolveResults = this.multiResolve(false);
        return resolveResults.length == 1 ? resolveResults[0].getElement() : null;
    }

    @Override
    @NotNull
    public String getCanonicalText() {
        PsiReference reference2 = this.chooseReference();
        String string2 = reference2 == null ? this.myReferences.get(0).getCanonicalText() : reference2.getCanonicalText();
        if (string2 == null) {
            PsiDynaReference.$$$reportNull$$$0(1);
        }
        return string2;
    }

    @Override
    public PsiElement handleElementRename(@NotNull String newElementName) throws IncorrectOperationException {
        PsiReference reference2;
        if (newElementName == null) {
            PsiDynaReference.$$$reportNull$$$0(2);
        }
        if ((reference2 = this.chooseReference()) != null) {
            return reference2.handleElementRename(newElementName);
        }
        return this.myElement;
    }

    @Override
    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            PsiDynaReference.$$$reportNull$$$0(3);
        }
        for (PsiReference reference2 : this.myReferences) {
            if (!(reference2 instanceof FileReference)) continue;
            return reference2.bindToElement(element);
        }
        return this.myElement;
    }

    @Override
    public boolean isReferenceTo(@NotNull PsiElement element) {
        if (element == null) {
            PsiDynaReference.$$$reportNull$$$0(4);
        }
        for (PsiReference reference2 : this.myReferences) {
            if (!reference2.isReferenceTo(element)) continue;
            return true;
        }
        return false;
    }

    @Override
    public ResolveResult @NotNull [] multiResolve(boolean incompleteCode) {
        if (this.myCachedResult == null) {
            this.myCachedResult = this.innerResolve(incompleteCode);
        }
        if (this.myCachedResult == null) {
            PsiDynaReference.$$$reportNull$$$0(5);
        }
        return this.myCachedResult;
    }

    protected ResolveResult[] innerResolve(boolean incompleteCode) {
        LinkedHashSet<ResolveResult> result2 = new LinkedHashSet<ResolveResult>();
        for (PsiReference reference2 : this.myReferences) {
            if (reference2 instanceof PsiPolyVariantReference) {
                for (ResolveResult rr : ((PsiPolyVariantReference)reference2).multiResolve(incompleteCode)) {
                    if (!rr.isValidResult()) continue;
                    result2.add(rr);
                }
                continue;
            }
            PsiElement resolved = reference2.resolve();
            if (resolved == null) continue;
            result2.add(new PsiElementResolveResult(resolved));
        }
        return result2.toArray(ResolveResult.EMPTY_ARRAY);
    }

    @Nullable
    private PsiReference chooseReference() {
        if (this.myChosenOne != -1) {
            return this.myReferences.get(this.myChosenOne);
        }
        boolean flag2 = false;
        for (int i2 = 0; i2 < this.myReferences.size(); ++i2) {
            PsiReference reference2 = this.myReferences.get(i2);
            if (reference2.isSoft() && flag2) continue;
            if (!reference2.isSoft() && !flag2) {
                this.myChosenOne = i2;
                flag2 = true;
                continue;
            }
            if (reference2.resolve() == null) continue;
            this.myChosenOne = i2;
        }
        return this.myChosenOne >= 0 ? this.myReferences.get(this.myChosenOne) : null;
    }

    @Override
    @NotNull
    public String getUnresolvedMessagePattern() {
        PsiReference reference2 = this.chooseReference();
        String string2 = reference2 instanceof EmptyResolveMessageProvider ? ((EmptyResolveMessageProvider)((Object)reference2)).getUnresolvedMessagePattern() : AnalysisBundle.message("cannot.resolve.symbol", new Object[0]);
        if (string2 == null) {
            PsiDynaReference.$$$reportNull$$$0(6);
        }
        return string2;
    }

    @Override
    public LocalQuickFix[] getQuickFixes() {
        ArrayList list2 = new ArrayList();
        for (PsiReference ref : this.myReferences) {
            if (!(ref instanceof LocalQuickFixProvider)) continue;
            ContainerUtil.addAll(list2, ((LocalQuickFixProvider)((Object)ref)).getQuickFixes());
        }
        return list2.toArray(LocalQuickFix.EMPTY_ARRAY);
    }

    @Override
    public String toString() {
        return "PsiDynaReference containing " + this.myReferences.toString();
    }

    @Override
    public PsiFileReference getLastFileReference() {
        for (PsiReference reference2 : this.myReferences) {
            if (!(reference2 instanceof FileReferenceOwner)) continue;
            return ((FileReferenceOwner)((Object)reference2)).getLastFileReference();
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 3, 4 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/paths/PsiDynaReference";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newElementName";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getRangeInElement";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getCanonicalText";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/paths/PsiDynaReference";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "multiResolve";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnresolvedMessagePattern";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "handleElementRename";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "bindToElement";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isReferenceTo";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string2);
            case 2, 3, 4 -> new IllegalArgumentException(string2);
        };
    }
}

