/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.paths;

import com.intellij.icons.AllIcons;
import com.intellij.model.Pointer;
import com.intellij.model.presentation.PresentableSymbol;
import com.intellij.model.presentation.SymbolPresentation;
import com.intellij.navigation.NavigatableSymbol;
import com.intellij.navigation.NavigationRequest;
import com.intellij.navigation.NavigationService;
import com.intellij.navigation.NavigationTarget;
import com.intellij.openapi.paths.UrlNavigatable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.platform.backend.presentation.TargetPresentation;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u00012\u00020\u00022\u00020\u00032\u00020\u0004B\u000f\u0012\b\b\u0001\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00000\u0001H\u0016J\b\u0010\t\u001a\u00020\u0000H\u0016J\u0016\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00040\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\n\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u0013H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/intellij/openapi/paths/UrlSymbol;", "Lcom/intellij/model/Pointer;", "Lcom/intellij/model/presentation/PresentableSymbol;", "Lcom/intellij/navigation/NavigatableSymbol;", "Lcom/intellij/navigation/NavigationTarget;", "url", "", "(Ljava/lang/String;)V", "createPointer", "dereference", "getNavigationTargets", "", "project", "Lcom/intellij/openapi/project/Project;", "getSymbolPresentation", "Lcom/intellij/model/presentation/SymbolPresentation;", "navigationRequest", "Lcom/intellij/navigation/NavigationRequest;", "presentation", "Lcom/intellij/platform/backend/presentation/TargetPresentation;", "intellij.platform.lang.impl"})
final class UrlSymbol
implements Pointer<UrlSymbol>,
PresentableSymbol,
NavigatableSymbol,
NavigationTarget {
    @NotNull
    private final String url;

    public UrlSymbol(@NlsSafe @NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        this.url = url;
    }

    @NotNull
    public Pointer<? extends UrlSymbol> createPointer() {
        return this;
    }

    @Override
    @NotNull
    public UrlSymbol dereference() {
        return this;
    }

    @Override
    @NotNull
    public SymbolPresentation getSymbolPresentation() {
        SymbolPresentation symbolPresentation = SymbolPresentation.create(AllIcons.General.Web, this.url, this.url);
        Intrinsics.checkNotNullExpressionValue((Object)symbolPresentation, (String)"create(AllIcons.General.Web, url, url)");
        return symbolPresentation;
    }

    @NotNull
    public Collection<NavigationTarget> getNavigationTargets(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        return CollectionsKt.listOf((Object)this);
    }

    @Override
    @NotNull
    public TargetPresentation presentation() {
        String string2 = "In all known cases the symbol doesn't appear in the disambiguation popup, because this symbol is usually alone, so no popup required. Implement this method when needed.";
        throw new NotImplementedError("An operation is not implemented: " + string2);
    }

    @Override
    @Nullable
    public NavigationRequest navigationRequest() {
        return NavigationService.Companion.instance().rawNavigationRequest(new UrlNavigatable(this.url));
    }
}

