/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.project;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.extensions.ExtensionPoint;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.ProjectExtensionPointName;
import com.intellij.openapi.extensions.impl.ExtensionPointImpl;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbModePermission;
import com.intellij.openapi.project.DumbModeTask;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.PossiblyDumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.messages.Topic;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DumbService {
    public static final Topic<DumbModeListener> DUMB_MODE = new Topic<DumbModeListener>("dumb mode", DumbModeListener.class, Topic.BroadcastDirection.NONE);

    public abstract ModificationTracker getModificationTracker();

    public abstract boolean isDumb();

    public static boolean isDumb(@NotNull Project project2) {
        if (project2 == null) {
            DumbService.$$$reportNull$$$0(0);
        }
        return DumbService.getInstance(project2).isDumb();
    }

    @NotNull
    public static <T> List<T> getDumbAwareExtensions(@NotNull Project project2, @NotNull ExtensionPointName<T> extensionPoint) {
        ExtensionPoint<T> point;
        int size;
        if (project2 == null) {
            DumbService.$$$reportNull$$$0(1);
        }
        if (extensionPoint == null) {
            DumbService.$$$reportNull$$$0(2);
        }
        if ((size = (point = extensionPoint.getPoint()).size()) == 0) {
            List list2 = Collections.emptyList();
            if (list2 == null) {
                DumbService.$$$reportNull$$$0(3);
            }
            return list2;
        }
        if (!DumbService.getInstance(project2).isDumb()) {
            List<T> list3 = point.getExtensionList();
            if (list3 == null) {
                DumbService.$$$reportNull$$$0(4);
            }
            return list3;
        }
        ArrayList result2 = new ArrayList(size);
        for (Object element : (ExtensionPointImpl)point) {
            if (!DumbService.isDumbAware(element)) continue;
            result2.add(element);
        }
        ArrayList arrayList = result2;
        if (arrayList == null) {
            DumbService.$$$reportNull$$$0(5);
        }
        return arrayList;
    }

    @NotNull
    public static <T> List<T> getDumbAwareExtensions(@NotNull Project project2, @NotNull ProjectExtensionPointName<T> extensionPoint) {
        if (project2 == null) {
            DumbService.$$$reportNull$$$0(6);
        }
        if (extensionPoint == null) {
            DumbService.$$$reportNull$$$0(7);
        }
        DumbService dumbService = DumbService.getInstance(project2);
        List<T> list2 = dumbService.filterByDumbAwareness(extensionPoint.getExtensions(project2));
        if (list2 == null) {
            DumbService.$$$reportNull$$$0(8);
        }
        return list2;
    }

    public abstract void runWhenSmart(@NotNull Runnable var1);

    public abstract void waitForSmartMode();

    public <T> T runReadActionInSmartMode(@NotNull Computable<T> r) {
        if (r == null) {
            DumbService.$$$reportNull$$$0(9);
        }
        Ref result2 = new Ref();
        this.runReadActionInSmartMode(() -> result2.set(r.compute()));
        return result2.get();
    }

    @Nullable
    public <T> T tryRunReadActionInSmartMode(@NotNull Computable<T> task2, @Nullable @NlsContexts.PopupContent String notification) {
        if (task2 == null) {
            DumbService.$$$reportNull$$$0(10);
        }
        if (ApplicationManager.getApplication().isReadAccessAllowed()) {
            try {
                return task2.compute();
            }
            catch (IndexNotReadyException e) {
                if (notification != null) {
                    this.showDumbModeNotification(notification);
                }
                return null;
            }
        }
        return this.runReadActionInSmartMode(task2);
    }

    public void runReadActionInSmartMode(@NotNull Runnable r) {
        boolean success;
        if (r == null) {
            DumbService.$$$reportNull$$$0(11);
        }
        if (ApplicationManager.getApplication().isReadAccessAllowed()) {
            r.run();
            return;
        }
        do {
            this.waitForSmartMode();
        } while (!(success = ReadAction.compute(() -> {
            if (this.getProject().isDisposed()) {
                throw new ProcessCanceledException();
            }
            if (this.isDumb()) {
                return false;
            }
            r.run();
            return true;
        }).booleanValue()));
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval
    public void repeatUntilPassesInSmartMode(@NotNull Runnable r) {
        if (r == null) {
            DumbService.$$$reportNull$$$0(12);
        }
        while (true) {
            this.waitForSmartMode();
            try {
                r.run();
                return;
            }
            catch (IndexNotReadyException indexNotReadyException) {
                continue;
            }
            break;
        }
    }

    public abstract void smartInvokeLater(@NotNull Runnable var1);

    public abstract void smartInvokeLater(@NotNull Runnable var1, @NotNull ModalityState var2);

    public static DumbService getInstance(@NotNull Project project2) {
        if (project2 == null) {
            DumbService.$$$reportNull$$$0(13);
        }
        return project2.getService(DumbService.class);
    }

    @NotNull
    public <T> List<T> filterByDumbAwareness(T @NotNull [] array) {
        if (array == null) {
            DumbService.$$$reportNull$$$0(14);
        }
        List<T> list2 = this.filterByDumbAwareness(Arrays.asList(array));
        if (list2 == null) {
            DumbService.$$$reportNull$$$0(15);
        }
        return list2;
    }

    @Contract(pure=true)
    @NotNull
    public <T> List<T> filterByDumbAwareness(@NotNull Collection<? extends T> collection) {
        if (collection == null) {
            DumbService.$$$reportNull$$$0(16);
        }
        if (this.isDumb()) {
            ArrayList<T> result2 = new ArrayList<T>(collection.size());
            for (T element : collection) {
                if (!DumbService.isDumbAware(element)) continue;
                result2.add(element);
            }
            ArrayList<T> arrayList = result2;
            if (arrayList == null) {
                DumbService.$$$reportNull$$$0(17);
            }
            return arrayList;
        }
        return collection instanceof List ? (List<Object>)collection : new ArrayList<T>(collection);
    }

    public abstract void queueTask(@NotNull DumbModeTask var1);

    public abstract void cancelTask(@NotNull DumbModeTask var1);

    @ApiStatus.Internal
    public abstract void cancelAllTasksAndWait();

    public abstract void completeJustSubmittedTasks();

    public abstract JComponent wrapGently(@NotNull JComponent var1, @NotNull Disposable var2);

    public abstract JComponent wrapWithSpoiler(@NotNull JComponent var1, @NotNull Runnable var2, @NotNull Disposable var3);

    public void makeDumbAware(final @NotNull JComponent componentToDisable, @NotNull Disposable parentDisposable) {
        if (componentToDisable == null) {
            DumbService.$$$reportNull$$$0(18);
        }
        if (parentDisposable == null) {
            DumbService.$$$reportNull$$$0(19);
        }
        componentToDisable.setEnabled(!this.isDumb());
        this.getProject().getMessageBus().connect(parentDisposable).subscribe(DUMB_MODE, new DumbModeListener(){

            @Override
            public void enteredDumbMode() {
                componentToDisable.setEnabled(false);
            }

            @Override
            public void exitDumbMode() {
                componentToDisable.setEnabled(true);
            }
        });
    }

    public abstract void showDumbModeNotification(@NotNull @NlsContexts.PopupContent String var1);

    public abstract void showDumbModeActionBalloon(@NotNull @NlsContexts.PopupContent String var1, @NotNull Runnable var2);

    public abstract Project getProject();

    @Contract(value="null -> false", pure=true)
    public static boolean isDumbAware(Object o) {
        if (o instanceof PossiblyDumbAware) {
            return ((PossiblyDumbAware)o).isDumbAware();
        }
        return o instanceof DumbAware;
    }

    @Deprecated
    public abstract void setAlternativeResolveEnabled(boolean var1);

    public void withAlternativeResolveEnabled(@NotNull Runnable runnable) {
        boolean isDumb;
        if (runnable == null) {
            DumbService.$$$reportNull$$$0(20);
        }
        if (isDumb = this.isDumb()) {
            this.setAlternativeResolveEnabled(true);
        }
        try {
            runnable.run();
        }
        finally {
            if (isDumb) {
                this.setAlternativeResolveEnabled(false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T, E extends Throwable> T computeWithAlternativeResolveEnabled(@NotNull ThrowableComputable<T, E> runnable) throws E {
        boolean isDumb;
        if (runnable == null) {
            DumbService.$$$reportNull$$$0(21);
        }
        if (isDumb = this.isDumb()) {
            this.setAlternativeResolveEnabled(true);
        }
        try {
            T t = runnable.compute();
            return t;
        }
        finally {
            if (isDumb) {
                this.setAlternativeResolveEnabled(false);
            }
        }
    }

    public <E extends Throwable> void runWithAlternativeResolveEnabled(@NotNull ThrowableRunnable<E> runnable) throws E {
        boolean isDumb;
        if (runnable == null) {
            DumbService.$$$reportNull$$$0(22);
        }
        if (isDumb = this.isDumb()) {
            this.setAlternativeResolveEnabled(true);
        }
        try {
            runnable.run();
        }
        finally {
            if (isDumb) {
                this.setAlternativeResolveEnabled(false);
            }
        }
    }

    public abstract boolean isAlternativeResolveEnabled();

    @Deprecated
    @ApiStatus.ScheduledForRemoval
    public static void allowStartingDumbModeInside(@NotNull DumbModePermission permission, @NotNull Runnable runnable) {
        if (permission == null) {
            DumbService.$$$reportNull$$$0(23);
        }
        if (runnable == null) {
            DumbService.$$$reportNull$$$0(24);
        }
        runnable.run();
    }

    public abstract void suspendIndexingAndRun(@NotNull @NlsContexts.ProgressText String var1, @NotNull Runnable var2);

    @ApiStatus.Internal
    public abstract AccessToken runWithWaitForSmartModeDisabled();

    @ApiStatus.Internal
    public abstract void unsafeRunWhenSmart(@NotNull Runnable var1);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 15: 
            case 17: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 15: 
            case 17: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extensionPoint";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 15: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/project/DumbService";
                break;
            }
            case 9: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "r";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "task";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "array";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "collection";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "componentToDisable";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 20: 
            case 21: 
            case 22: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "permission";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/project/DumbService";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getDumbAwareExtensions";
                break;
            }
            case 15: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "filterByDumbAwareness";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isDumb";
                break;
            }
            case 1: 
            case 2: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getDumbAwareExtensions";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 15: 
            case 17: {
                break;
            }
            case 9: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "runReadActionInSmartMode";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "tryRunReadActionInSmartMode";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "repeatUntilPassesInSmartMode";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 14: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "filterByDumbAwareness";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "makeDumbAware";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "withAlternativeResolveEnabled";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "computeWithAlternativeResolveEnabled";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "runWithAlternativeResolveEnabled";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "allowStartingDumbModeInside";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 15: 
            case 17: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    public static interface DumbModeListener {
        default public void enteredDumbMode() {
        }

        default public void exitDumbMode() {
        }
    }
}

