/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.project;

import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectCoreUtil;
import com.intellij.openapi.project.ProjectLocator;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.SmartList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class ProjectLocatorImpl
extends ProjectLocator {
    ProjectLocatorImpl() {
    }

    @Override
    @Nullable
    public Project guessProjectForFile(@Nullable(value="for plugin compatibility only; actually it should have been notnull") @Nullable(value="for plugin compatibility only; actually it should have been notnull") VirtualFile file2) {
        if (file2 == null) {
            return null;
        }
        Project project2 = ProjectCoreUtil.theOnlyOpenProject();
        if (project2 != null && !project2.isDisposed()) {
            return project2;
        }
        project2 = ProjectLocatorImpl.getPreferredProject(file2);
        if (project2 != null) {
            return project2;
        }
        ProjectManager projectManager = ProjectManager.getInstanceIfCreated();
        if (projectManager == null) {
            return null;
        }
        Project[] openProjects = projectManager.getOpenProjects();
        if (openProjects.length == 1) {
            return openProjects[0];
        }
        return ReadAction.compute(() -> {
            for (Project openProject2 : projectManager.getOpenProjects()) {
                if (!ProjectLocatorImpl.isUnder(openProject2, file2)) continue;
                return openProject2;
            }
            return null;
        });
    }

    private static boolean isUnder(@NotNull Project project2, @NotNull VirtualFile file2) {
        ProjectFileIndex fileIndex;
        if (project2 == null) {
            ProjectLocatorImpl.$$$reportNull$$$0(0);
        }
        if (file2 == null) {
            ProjectLocatorImpl.$$$reportNull$$$0(1);
        }
        return (fileIndex = ProjectRootManager.getInstance(project2).getFileIndex()).isInContent(file2) || fileIndex.isExcluded(file2);
    }

    @Override
    @NotNull
    public Collection<Project> getProjectsForFile(@NotNull VirtualFile file2) {
        ProjectManager projectManager;
        if (file2 == null) {
            ProjectLocatorImpl.$$$reportNull$$$0(2);
        }
        if ((projectManager = ProjectManager.getInstanceIfCreated()) == null) {
            List<Project> list2 = Collections.emptyList();
            if (list2 == null) {
                ProjectLocatorImpl.$$$reportNull$$$0(3);
            }
            return list2;
        }
        SmartList<Project> result2 = new SmartList<Project>();
        ReadAction.run(() -> {
            for (Project project2 : projectManager.getOpenProjects()) {
                if (!ProjectLocatorImpl.isUnder(project2, file2)) continue;
                result2.add(project2);
            }
        });
        SmartList<Project> smartList = result2;
        if (smartList == null) {
            ProjectLocatorImpl.$$$reportNull$$$0(4);
        }
        return smartList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/project/ProjectLocatorImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/project/ProjectLocatorImpl";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjectsForFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isUnder";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getProjectsForFile";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 3, 4 -> new IllegalStateException(string2);
        };
    }
}

