/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.projectRoots.impl;

import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkModel;
import com.intellij.openapi.projectRoots.SdkType;
import com.intellij.openapi.projectRoots.impl.ProjectJdkImpl;
import com.intellij.openapi.projectRoots.impl.SdkConfigurationUtil;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Ref;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Component;
import java.util.Arrays;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DependentSdkType
extends SdkType {
    public DependentSdkType(@NonNls @NotNull String name) {
        if (name == null) {
            DependentSdkType.$$$reportNull$$$0(0);
        }
        super(name);
    }

    protected boolean checkDependency(@NotNull SdkModel sdkModel) {
        if (sdkModel == null) {
            DependentSdkType.$$$reportNull$$$0(1);
        }
        return ContainerUtil.find(sdkModel.getSdks(), sdk2 -> this.isValidDependency((Sdk)sdk2)) != null;
    }

    protected abstract boolean isValidDependency(@NotNull Sdk var1);

    @NotNull
    @NlsContexts.DialogMessage
    public abstract String getUnsatisfiedDependencyMessage();

    public boolean supportsCustomCreateUI() {
        return true;
    }

    public void showCustomCreateUI(@NotNull SdkModel sdkModel, @NotNull JComponent parentComponent, @Nullable Sdk selectedSdk, @NotNull Consumer<? super Sdk> sdkCreatedCallback) {
        if (sdkModel == null) {
            DependentSdkType.$$$reportNull$$$0(2);
        }
        if (parentComponent == null) {
            DependentSdkType.$$$reportNull$$$0(3);
        }
        if (sdkCreatedCallback == null) {
            DependentSdkType.$$$reportNull$$$0(4);
        }
        if (!this.checkDependency(sdkModel)) {
            if (Messages.showOkCancelDialog((Component)parentComponent, (String)this.getUnsatisfiedDependencyMessage(), (String)ProjectBundle.message((String)"dialog.title.cannot.create.sdk", (Object[])new Object[0]), (Icon)Messages.getWarningIcon()) != 0) {
                return;
            }
            if (this.fixDependency(sdkModel, sdkCreatedCallback) == null) {
                return;
            }
        }
        DependentSdkType.createSdkOfType(sdkModel, this, sdkCreatedCallback);
    }

    @NotNull
    public abstract SdkType getDependencyType();

    protected Sdk fixDependency(@NotNull SdkModel sdkModel, @NotNull Consumer<? super Sdk> sdkCreatedCallback) {
        if (sdkModel == null) {
            DependentSdkType.$$$reportNull$$$0(5);
        }
        if (sdkCreatedCallback == null) {
            DependentSdkType.$$$reportNull$$$0(6);
        }
        return DependentSdkType.createSdkOfType(sdkModel, this.getDependencyType(), sdkCreatedCallback);
    }

    protected static Sdk createSdkOfType(@NotNull SdkModel sdkModel, @NotNull SdkType sdkType, @NotNull Consumer<? super Sdk> sdkCreatedCallback) {
        if (sdkModel == null) {
            DependentSdkType.$$$reportNull$$$0(7);
        }
        if (sdkType == null) {
            DependentSdkType.$$$reportNull$$$0(8);
        }
        if (sdkCreatedCallback == null) {
            DependentSdkType.$$$reportNull$$$0(9);
        }
        Ref<Object> result2 = new Ref<Object>(null);
        SdkConfigurationUtil.selectSdkHome(sdkType, home2 -> {
            ProjectJdkImpl newJdk = SdkConfigurationUtil.createSdk(Arrays.asList(sdkModel.getSdks()), home2, sdkType, null, null);
            sdkCreatedCallback.consume(newJdk);
            result2.set(newJdk);
        });
        return result2.get();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkModel";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentComponent";
                break;
            }
            case 4: 
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkCreatedCallback";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkType";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/projectRoots/impl/DependentSdkType";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "checkDependency";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "showCustomCreateUI";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "fixDependency";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "createSdkOfType";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

