/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.projectRoots.impl;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.projectRoots.JavaSdkType;
import com.intellij.openapi.projectRoots.JdkUtil;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.impl.DependentSdkType;
import com.intellij.openapi.projectRoots.impl.JavaHomeFinder;
import com.intellij.openapi.projectRoots.impl.JavaHomeFinderMac;
import com.intellij.openapi.projectRoots.impl.JavaHomeFinderWindows;
import com.intellij.openapi.projectRoots.impl.JavaHomeFinderWsl;
import com.intellij.openapi.projectRoots.impl.jdkDownloader.JdkInstaller;
import com.intellij.openapi.projectRoots.impl.jdkDownloader.JdkInstallerStore;
import com.intellij.openapi.util.text.StringUtilRt;
import com.intellij.util.ArrayUtil;
import com.intellij.util.SystemProperties;
import com.intellij.util.containers.ContainerUtil;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaHomeFinderBasic {
    private final Logger log;
    private final List<Supplier<? extends Set<String>>> myFinders;
    private final JavaHomeFinder.SystemInfoProvider mySystemInfo;
    private boolean myCheckDefaultInstallDir;
    private boolean myCheckUsedInstallDirs;
    private boolean myCheckConfiguredJdks;
    private boolean myCheckEmbeddedJava;
    @NotNull
    private @NotNull String @NotNull [] mySpecifiedPaths;

    public JavaHomeFinderBasic(@NotNull JavaHomeFinder.SystemInfoProvider systemInfo) {
        if (systemInfo == null) {
            JavaHomeFinderBasic.$$$reportNull$$$0(0);
        }
        this.log = Logger.getInstance(this.getClass());
        this.myFinders = new ArrayList<Supplier<? extends Set<String>>>();
        this.myCheckDefaultInstallDir = true;
        this.myCheckUsedInstallDirs = true;
        this.myCheckConfiguredJdks = true;
        this.myCheckEmbeddedJava = false;
        this.mySpecifiedPaths = ArrayUtil.EMPTY_STRING_ARRAY;
        this.mySystemInfo = systemInfo;
        this.myFinders.add(this::checkDefaultLocations);
        this.myFinders.add(this::findInPATH);
        this.myFinders.add(this::findInJavaHome);
        this.myFinders.add(this::findInSpecifiedPaths);
        this.myFinders.add(this::findJavaInstalledBySdkMan);
        this.myFinders.add(this::findJavaInstalledByAsdfJava);
        this.myFinders.add(this::findJavaInstalledByGradle);
        this.myFinders.add(() -> this.myCheckEmbeddedJava ? this.scanAll(JavaHomeFinderBasic.getJavaHome(), false) : Collections.emptySet());
    }

    @NotNull
    public JavaHomeFinderBasic checkDefaultInstallDir(boolean value) {
        this.myCheckDefaultInstallDir = value;
        JavaHomeFinderBasic javaHomeFinderBasic = this;
        if (javaHomeFinderBasic == null) {
            JavaHomeFinderBasic.$$$reportNull$$$0(1);
        }
        return javaHomeFinderBasic;
    }

    @NotNull
    public JavaHomeFinderBasic checkUsedInstallDirs(boolean value) {
        this.myCheckUsedInstallDirs = value;
        JavaHomeFinderBasic javaHomeFinderBasic = this;
        if (javaHomeFinderBasic == null) {
            JavaHomeFinderBasic.$$$reportNull$$$0(2);
        }
        return javaHomeFinderBasic;
    }

    @NotNull
    public JavaHomeFinderBasic checkConfiguredJdks(boolean value) {
        this.myCheckConfiguredJdks = value;
        JavaHomeFinderBasic javaHomeFinderBasic = this;
        if (javaHomeFinderBasic == null) {
            JavaHomeFinderBasic.$$$reportNull$$$0(3);
        }
        return javaHomeFinderBasic;
    }

    @NotNull
    public JavaHomeFinderBasic checkEmbeddedJava(boolean value) {
        this.myCheckEmbeddedJava = value;
        JavaHomeFinderBasic javaHomeFinderBasic = this;
        if (javaHomeFinderBasic == null) {
            JavaHomeFinderBasic.$$$reportNull$$$0(4);
        }
        return javaHomeFinderBasic;
    }

    @NotNull
    public JavaHomeFinderBasic checkSpecifiedPaths(String ... paths2) {
        if (paths2 == null) {
            JavaHomeFinderBasic.$$$reportNull$$$0(5);
        }
        this.mySpecifiedPaths = paths2;
        JavaHomeFinderBasic javaHomeFinderBasic = this;
        if (javaHomeFinderBasic == null) {
            JavaHomeFinderBasic.$$$reportNull$$$0(6);
        }
        return javaHomeFinderBasic;
    }

    protected JavaHomeFinder.SystemInfoProvider getSystemInfo() {
        return this.mySystemInfo;
    }

    @NotNull
    private Set<String> findInSpecifiedPaths() {
        Set<String> set2 = this.scanAll(ContainerUtil.map(this.mySpecifiedPaths, x$0 -> Paths.get(x$0, new String[0])), true);
        if (set2 == null) {
            JavaHomeFinderBasic.$$$reportNull$$$0(7);
        }
        return set2;
    }

    protected void registerFinder(@NotNull Supplier<? extends Set<String>> finder) {
        if (finder == null) {
            JavaHomeFinderBasic.$$$reportNull$$$0(8);
        }
        this.myFinders.add(finder);
    }

    @NotNull
    public final Set<String> findExistingJdks() {
        TreeSet<String> result2 = new TreeSet<String>();
        for (Supplier<? extends Set<String>> action2 : this.myFinders) {
            try {
                result2.addAll((Collection<String>)action2.get());
            }
            catch (Exception e) {
                this.log.warn("Failed to find Java Home. " + e.getMessage(), e);
            }
        }
        TreeSet<String> treeSet = result2;
        if (treeSet == null) {
            JavaHomeFinderBasic.$$$reportNull$$$0(9);
        }
        return treeSet;
    }

    @NotNull
    private Set<String> findInJavaHome() {
        String javaHome = this.mySystemInfo.getEnvironmentVariable("JAVA_HOME");
        Set<String> set2 = javaHome != null ? this.scanAll(this.mySystemInfo.getPath(javaHome, new String[0]), false) : Collections.emptySet();
        if (set2 == null) {
            JavaHomeFinderBasic.$$$reportNull$$$0(10);
        }
        return set2;
    }

    @NotNull
    private Set<String> findInPATH() {
        Set<String> set2;
        String pathVarString;
        block7: {
            pathVarString = this.mySystemInfo.getEnvironmentVariable("PATH");
            if (pathVarString != null && !pathVarString.isEmpty()) break block7;
            Set<String> set3 = Collections.emptySet();
            if (set3 == null) {
                JavaHomeFinderBasic.$$$reportNull$$$0(11);
            }
            return set3;
        }
        try {
            HashSet<Path> dirsToCheck = new HashSet<Path>();
            for (String p : pathVarString.split(this.mySystemInfo.getPathSeparator())) {
                Path parentFile;
                Path dir = this.mySystemInfo.getPath(p, new String[0]);
                if (!StringUtilRt.equal(dir.getFileName().toString(), "bin", this.mySystemInfo.isFileSystemCaseSensitive()) || (parentFile = dir.getParent()) == null) continue;
                dirsToCheck.addAll(this.listPossibleJdkInstallRootsFromHomes(parentFile));
            }
            set2 = this.scanAll(dirsToCheck, false);
        }
        catch (Exception e) {
            this.log.warn("Failed to scan PATH for JDKs. " + e.getMessage(), e);
            Set<String> set4 = Collections.emptySet();
            if (set4 == null) {
                JavaHomeFinderBasic.$$$reportNull$$$0(13);
            }
            return set4;
        }
        if (set2 == null) {
            JavaHomeFinderBasic.$$$reportNull$$$0(12);
        }
        return set2;
    }

    @NotNull
    private Set<String> checkDefaultLocations() {
        if (ApplicationManager.getApplication() == null) {
            Set<String> set2 = Collections.emptySet();
            if (set2 == null) {
                JavaHomeFinderBasic.$$$reportNull$$$0(14);
            }
            return set2;
        }
        HashSet<Path> paths2 = new HashSet<Path>();
        if (this.myCheckDefaultInstallDir) {
            paths2.add(JdkInstaller.getInstance().defaultInstallDir());
        }
        if (this.myCheckUsedInstallDirs) {
            paths2.addAll(JdkInstallerStore.getInstance().listJdkInstallHomes());
        }
        if (this.myCheckConfiguredJdks) {
            for (Sdk jdk : ProjectJdkTable.getInstance().getAllJdks()) {
                String homePath;
                if (!(jdk.getSdkType() instanceof JavaSdkType) || jdk.getSdkType() instanceof DependentSdkType || (homePath = jdk.getHomePath()) == null) continue;
                paths2.addAll(this.listPossibleJdkInstallRootsFromHomes(this.mySystemInfo.getPath(homePath, new String[0])));
            }
        }
        Set<String> set3 = this.scanAll(paths2, true);
        if (set3 == null) {
            JavaHomeFinderBasic.$$$reportNull$$$0(15);
        }
        return set3;
    }

    @NotNull
    protected Set<String> scanAll(@Nullable Path file2, boolean includeNestDirs) {
        if (file2 == null) {
            Set<String> set2 = Collections.emptySet();
            if (set2 == null) {
                JavaHomeFinderBasic.$$$reportNull$$$0(16);
            }
            return set2;
        }
        Set<String> set3 = this.scanAll(Collections.singleton(file2), includeNestDirs);
        if (set3 == null) {
            JavaHomeFinderBasic.$$$reportNull$$$0(17);
        }
        return set3;
    }

    @NotNull
    protected Set<String> scanAll(@NotNull Collection<? extends Path> files2, boolean includeNestDirs) {
        if (files2 == null) {
            JavaHomeFinderBasic.$$$reportNull$$$0(18);
        }
        HashSet<String> result2 = new HashSet<String>();
        for (Path path2 : new HashSet<Path>(files2)) {
            this.scanFolder(path2, includeNestDirs, result2);
        }
        HashSet<String> hashSet = result2;
        if (hashSet == null) {
            JavaHomeFinderBasic.$$$reportNull$$$0(19);
        }
        return hashSet;
    }

    protected void scanFolder(@NotNull Path folder, boolean includeNestDirs, @NotNull Collection<? super String> result2) {
        if (folder == null) {
            JavaHomeFinderBasic.$$$reportNull$$$0(20);
        }
        if (result2 == null) {
            JavaHomeFinderBasic.$$$reportNull$$$0(21);
        }
        if (JdkUtil.checkForJdk((Path)folder)) {
            result2.add(folder.toAbsolutePath().toString());
            return;
        }
        if (!includeNestDirs) {
            return;
        }
        try (Stream<Path> files2 = Files.list(folder);){
            files2.forEach(candidate -> {
                for (Path adjusted : this.listPossibleJdkHomesFromInstallRoot((Path)candidate)) {
                    this.scanFolder(adjusted, false, result2);
                }
            });
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @NotNull
    protected List<Path> listPossibleJdkHomesFromInstallRoot(@NotNull Path path2) {
        if (path2 == null) {
            JavaHomeFinderBasic.$$$reportNull$$$0(22);
        }
        List<Path> list2 = Collections.singletonList(path2);
        if (list2 == null) {
            JavaHomeFinderBasic.$$$reportNull$$$0(23);
        }
        return list2;
    }

    @NotNull
    protected List<Path> listPossibleJdkInstallRootsFromHomes(@NotNull Path file2) {
        if (file2 == null) {
            JavaHomeFinderBasic.$$$reportNull$$$0(24);
        }
        List<Path> list2 = Collections.singletonList(file2);
        if (list2 == null) {
            JavaHomeFinderBasic.$$$reportNull$$$0(25);
        }
        return list2;
    }

    @Nullable
    private static Path getJavaHome() {
        Path javaHome = Path.of(SystemProperties.getJavaHome(), new String[0]);
        return Files.isDirectory(javaHome, new LinkOption[0]) ? javaHome : null;
    }

    @NotNull
    private @NotNull Set<@NotNull String> findJavaInstalledBySdkMan() {
        Set<String> homes;
        Path javasDir;
        block9: {
            Path candidatesDir;
            block8: {
                Set<String> set2;
                try {
                    candidatesDir = this.findSdkManCandidatesDir();
                    if (candidatesDir != null) break block8;
                    set2 = Collections.emptySet();
                }
                catch (Exception e) {
                    this.log.warn("Unexpected exception while looking for Sdkman directory: " + e.getClass().getSimpleName() + ": " + e.getMessage(), e);
                    Set<String> set3 = Collections.emptySet();
                    if (set3 == null) {
                        JavaHomeFinderBasic.$$$reportNull$$$0(29);
                    }
                    return set3;
                }
                if (set2 == null) {
                    JavaHomeFinderBasic.$$$reportNull$$$0(26);
                }
                return set2;
            }
            javasDir = candidatesDir.resolve("java");
            if (Files.isDirectory(javasDir, new LinkOption[0])) break block9;
            Set<String> set4 = Collections.emptySet();
            if (set4 == null) {
                JavaHomeFinderBasic.$$$reportNull$$$0(27);
            }
            return set4;
        }
        Set<String> set5 = homes = this.listJavaHomeDirsInstalledBySdkMan(javasDir);
        if (set5 == null) {
            JavaHomeFinderBasic.$$$reportNull$$$0(28);
        }
        return set5;
    }

    @NotNull
    private Set<String> findJavaInstalledByGradle() {
        Path jdks = this.getPathInUserHome(".gradle/jdks");
        Set<String> set2 = jdks != null && Files.isDirectory(jdks, new LinkOption[0]) ? this.scanAll(jdks, true) : Collections.emptySet();
        if (set2 == null) {
            JavaHomeFinderBasic.$$$reportNull$$$0(30);
        }
        return set2;
    }

    @Nullable
    private Path findSdkManCandidatesDir() {
        Path candidates;
        Path candidatesDir;
        Path candidatesDir2;
        String candidatesPath = this.mySystemInfo.getEnvironmentVariable("SDKMAN_CANDIDATES_DIR");
        if (candidatesPath != null && Files.isDirectory(candidatesDir2 = this.mySystemInfo.getPath(candidatesPath, new String[0]), new LinkOption[0])) {
            return candidatesDir2;
        }
        String primaryPath = this.mySystemInfo.getEnvironmentVariable("SDKMAN_DIR");
        if (primaryPath != null && Files.isDirectory(candidatesDir = this.mySystemInfo.getPath(primaryPath, "candidates"), new LinkOption[0])) {
            return candidatesDir;
        }
        if (!(this instanceof JavaHomeFinderWindows) && (candidates = this.getPathInUserHome(".sdkman/candidates")) != null && Files.isDirectory(candidates, new LinkOption[0])) {
            return candidates;
        }
        return null;
    }

    @Nullable
    protected Path getPathInUserHome(@NotNull String relativePath) {
        Path userHome;
        if (relativePath == null) {
            JavaHomeFinderBasic.$$$reportNull$$$0(31);
        }
        return (userHome = this.mySystemInfo.getUserHome()) != null ? userHome.resolve(relativePath) : null;
    }

    @NotNull
    private @NotNull Set<@NotNull String> listJavaHomeDirsInstalledBySdkMan(@NotNull Path javasDir) {
        if (javasDir == null) {
            JavaHomeFinderBasic.$$$reportNull$$$0(32);
        }
        boolean mac = this instanceof JavaHomeFinderMac;
        HashSet<String> result2 = new HashSet<String>();
        try (Stream<Path> stream = Files.list(javasDir);){
            List<Path> innerDirectories = stream.filter(d -> Files.isDirectory(d, new LinkOption[0])).toList();
            for (Path innerDir : innerDirectories) {
                Path home2;
                block20: {
                    home2 = innerDir;
                    Path releaseFile = home2.resolve("release");
                    if (!this.safeExists(releaseFile)) continue;
                    if (mac) {
                        try {
                            if (!Files.isSymbolicLink(releaseFile)) break block20;
                            Path realReleaseFile = releaseFile.toRealPath(new LinkOption[0]);
                            if (!this.safeExists(realReleaseFile)) {
                                this.log.warn("Failed to resolve the target file (it doesn't exist) for: " + releaseFile);
                                continue;
                            }
                            Path realHome = realReleaseFile.getParent();
                            if (realHome == null) {
                                this.log.warn("Failed to resolve the target file (it has no parent dir) for: " + releaseFile);
                                continue;
                            }
                            home2 = realHome;
                        }
                        catch (IOException ioe) {
                            this.log.warn("Failed to resolve the target file for: " + releaseFile + ": " + ioe.getMessage());
                            continue;
                        }
                        catch (Exception e) {
                            this.log.warn("Failed to resolve the target file for: " + releaseFile + ": Unexpected exception " + e.getClass().getSimpleName() + ": " + e.getMessage());
                            continue;
                        }
                    }
                }
                result2.add(home2.toString());
            }
        }
        catch (IOException ioe) {
            this.log.warn("I/O exception while listing Java home directories installed by Sdkman: " + ioe.getMessage(), ioe);
            Set<String> set2 = Collections.emptySet();
            if (set2 == null) {
                JavaHomeFinderBasic.$$$reportNull$$$0(33);
            }
            return set2;
        }
        catch (Exception e) {
            this.log.warn("Unexpected exception while listing Java home directories installed by Sdkman: " + e.getClass().getSimpleName() + ": " + e.getMessage(), e);
            Set<String> set3 = Collections.emptySet();
            if (set3 == null) {
                JavaHomeFinderBasic.$$$reportNull$$$0(34);
            }
            return set3;
        }
        HashSet<String> hashSet = result2;
        if (hashSet == null) {
            JavaHomeFinderBasic.$$$reportNull$$$0(35);
        }
        return hashSet;
    }

    @NotNull
    private Set<String> findJavaInstalledByAsdfJava() {
        Path installsDir = this.findAsdfInstallsDir();
        if (installsDir == null) {
            Set<String> set2 = Collections.emptySet();
            if (set2 == null) {
                JavaHomeFinderBasic.$$$reportNull$$$0(36);
            }
            return set2;
        }
        Path javasDir = installsDir.resolve("java");
        Set<String> set3 = this.safeIsDirectory(javasDir) ? this.scanAll(javasDir, true) : Collections.emptySet();
        if (set3 == null) {
            JavaHomeFinderBasic.$$$reportNull$$$0(37);
        }
        return set3;
    }

    @Nullable
    private Path findAsdfInstallsDir() {
        Path installsDir;
        Path installsDir2;
        Path primaryDir;
        String dataDir = this.mySystemInfo.getEnvironmentVariable("ASDF_DATA_DIR");
        if (dataDir != null && this.safeIsDirectory(primaryDir = this.mySystemInfo.getPath(dataDir, new String[0])) && this.safeIsDirectory(installsDir2 = primaryDir.resolve("installs"))) {
            return installsDir2;
        }
        if (!(this instanceof JavaHomeFinderWindows) && !(this instanceof JavaHomeFinderWsl) && (installsDir = this.getPathInUserHome(".asdf/installs")) != null && this.safeIsDirectory(installsDir)) {
            return installsDir;
        }
        return null;
    }

    private boolean safeIsDirectory(@NotNull Path dir) {
        if (dir == null) {
            JavaHomeFinderBasic.$$$reportNull$$$0(38);
        }
        try {
            return Files.isDirectory(dir, new LinkOption[0]);
        }
        catch (SecurityException se) {
            return false;
        }
        catch (Exception e) {
            this.log.debug("Failed to check directory existence: unexpected exception " + e.getClass().getSimpleName() + ": " + e.getMessage(), e);
            return false;
        }
    }

    private boolean safeExists(@NotNull Path path2) {
        if (path2 == null) {
            JavaHomeFinderBasic.$$$reportNull$$$0(39);
        }
        try {
            return Files.exists(path2, new LinkOption[0]);
        }
        catch (Exception e) {
            this.log.debug("Failed to check file existence: unexpected exception " + e.getClass().getSimpleName() + ": " + e.getMessage(), e);
            return false;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3, 4, 6, 7, 9, 10, 11, 12, 13, 14, 15, 16, 17, 19, 23, 25, 26, 27, 28, 29, 30, 33, 34, 35, 36, 37 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "systemInfo";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 23: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/projectRoots/impl/JavaHomeFinderBasic";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "paths";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "finder";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "folder";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 22: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "relativePath";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "javasDir";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/projectRoots/impl/JavaHomeFinderBasic";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "checkDefaultInstallDir";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "checkUsedInstallDirs";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "checkConfiguredJdks";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "checkEmbeddedJava";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "checkSpecifiedPaths";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "findInSpecifiedPaths";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "findExistingJdks";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "findInJavaHome";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "findInPATH";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "checkDefaultLocations";
                break;
            }
            case 16: 
            case 17: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "scanAll";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "listPossibleJdkHomesFromInstallRoot";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "listPossibleJdkInstallRootsFromHomes";
                break;
            }
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "findJavaInstalledBySdkMan";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "findJavaInstalledByGradle";
                break;
            }
            case 33: 
            case 34: 
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "listJavaHomeDirsInstalledBySdkMan";
                break;
            }
            case 36: 
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "findJavaInstalledByAsdfJava";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 23: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "checkSpecifiedPaths";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "registerFinder";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "scanAll";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "scanFolder";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "listPossibleJdkHomesFromInstallRoot";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "listPossibleJdkInstallRootsFromHomes";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "getPathInUserHome";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "listJavaHomeDirsInstalledBySdkMan";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "safeIsDirectory";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "safeExists";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 1, 2, 3, 4, 6, 7, 9, 10, 11, 12, 13, 14, 15, 16, 17, 19, 23, 25, 26, 27, 28, 29, 30, 33, 34, 35, 36, 37 -> new IllegalStateException(string2);
        };
    }
}

