/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.projectRoots.impl;

import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.util.ExecUtil;
import com.intellij.openapi.projectRoots.impl.JavaHomeFinder;
import com.intellij.openapi.projectRoots.impl.JavaHomeFinderBasic;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.TreeSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaHomeFinderMac
extends JavaHomeFinderBasic {
    public static final String JAVA_HOME_FIND_UTIL = "/usr/libexec/java_home";
    static String defaultJavaLocation = "/Library/Java/JavaVirtualMachines";

    public JavaHomeFinderMac(@NotNull JavaHomeFinder.SystemInfoProvider systemInfoProvider) {
        if (systemInfoProvider == null) {
            JavaHomeFinderMac.$$$reportNull$$$0(0);
        }
        super(systemInfoProvider);
        this.registerFinder(() -> {
            TreeSet result2 = new TreeSet();
            Collection<@NotNull Path> roots2 = systemInfoProvider.getFsRoots();
            roots2.forEach(root -> result2.addAll(this.scanAll(root.resolve(defaultJavaLocation), true)));
            roots2.forEach(root -> result2.addAll(this.scanAll(root.resolve("System/Library/Java/JavaVirtualMachines"), true)));
            return result2;
        });
        this.registerFinder(() -> {
            Path jdk = this.getPathInUserHome("Library/Java/JavaVirtualMachines");
            return jdk != null ? this.scanAll(jdk, true) : Collections.emptySet();
        });
        this.registerFinder(() -> this.scanAll(this.getSystemDefaultJavaHome(), false));
    }

    @Nullable
    protected Path getSystemDefaultJavaHome() {
        String homePath = null;
        if (new File(JAVA_HOME_FIND_UTIL).canExecute()) {
            homePath = ExecUtil.execAndReadLine((GeneralCommandLine)new GeneralCommandLine(new String[]{JAVA_HOME_FIND_UTIL}));
        }
        if (homePath != null) {
            return Paths.get(homePath, new String[0]);
        }
        return null;
    }

    @Override
    @NotNull
    protected List<Path> listPossibleJdkHomesFromInstallRoot(@NotNull Path path2) {
        if (path2 == null) {
            JavaHomeFinderMac.$$$reportNull$$$0(1);
        }
        List<Path> list2 = Arrays.asList(path2, path2.resolve("/Home"), path2.resolve("Contents/Home"));
        if (list2 == null) {
            JavaHomeFinderMac.$$$reportNull$$$0(2);
        }
        return list2;
    }

    @Override
    @NotNull
    protected List<Path> listPossibleJdkInstallRootsFromHomes(@NotNull Path file2) {
        Path parentFile;
        if (file2 == null) {
            JavaHomeFinderMac.$$$reportNull$$$0(3);
        }
        ArrayList<Path> result2 = new ArrayList<Path>();
        result2.add(file2);
        Path home2 = file2.getFileName();
        if (home2 != null && home2.toString().equalsIgnoreCase("Home") && (parentFile = file2.getParent()) != null) {
            Path parentParentFile;
            result2.add(parentFile);
            Path contents = parentFile.getFileName();
            if (contents != null && contents.toString().equalsIgnoreCase("Contents") && (parentParentFile = parentFile.getParent()) != null) {
                result2.add(parentParentFile);
            }
        }
        ArrayList<Path> arrayList = result2;
        if (arrayList == null) {
            JavaHomeFinderMac.$$$reportNull$$$0(4);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "systemInfoProvider";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/projectRoots/impl/JavaHomeFinderMac";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/projectRoots/impl/JavaHomeFinderMac";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "listPossibleJdkHomesFromInstallRoot";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "listPossibleJdkInstallRootsFromHomes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "listPossibleJdkHomesFromInstallRoot";
                break;
            }
            case 2: 
            case 4: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "listPossibleJdkInstallRootsFromHomes";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 2, 4 -> new IllegalStateException(string2);
        };
    }
}

