/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.projectRoots.impl;

import com.intellij.execution.wsl.WSLDistribution;
import com.intellij.execution.wsl.WslDistributionManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.projectRoots.impl.JavaHomeFinder;
import com.intellij.openapi.projectRoots.impl.JavaHomeFinderBasic;
import com.intellij.openapi.projectRoots.impl.JavaHomeFinderWsl;
import com.intellij.openapi.util.Bitness;
import com.intellij.openapi.util.io.WindowsRegistryUtil;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.MatchGroup;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.RegexOption;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\u001f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u000e\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0002J\u0018\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0002J\u000e\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0002J\u000e\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0002J\u000e\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0002\u00a8\u0006\u0012"}, d2={"Lcom/intellij/openapi/projectRoots/impl/JavaHomeFinderWindows;", "Lcom/intellij/openapi/projectRoots/impl/JavaHomeFinderBasic;", "registeredJdks", "", "wslJdks", "systemInfoProvider", "Lcom/intellij/openapi/projectRoots/impl/JavaHomeFinder$SystemInfoProvider;", "(ZZLcom/intellij/openapi/projectRoots/impl/JavaHomeFinder$SystemInfoProvider;)V", "guessPossibleLocations", "", "", "readRegisteredLocations", "b", "Lcom/intellij/openapi/util/Bitness;", "readRegisteredLocationsOS32J32", "readRegisteredLocationsOS64J32", "readRegisteredLocationsOS64J64", "Companion", "intellij.platform.lang.impl"})
@SourceDebugExtension(value={"SMAP\nJavaHomeFinderWindows.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JavaHomeFinderWindows.kt\ncom/intellij/openapi/projectRoots/impl/JavaHomeFinderWindows\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,115:1\n1#2:116\n*E\n"})
public final class JavaHomeFinderWindows
extends JavaHomeFinderBasic {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String defaultJavaLocation = "C:\\Program Files";
    @NotNull
    private static final String regCommand = "reg query HKLM\\SOFTWARE\\JavaSoft\\JDK /s /v JavaHome";
    @NotNull
    private static final Regex javaHomePattern;
    @NotNull
    private static final Logger logger;

    public JavaHomeFinderWindows(boolean registeredJdks, boolean wslJdks, @NotNull JavaHomeFinder.SystemInfoProvider systemInfoProvider) {
        Intrinsics.checkNotNullParameter((Object)systemInfoProvider, (String)"systemInfoProvider");
        super(systemInfoProvider);
        if (registeredJdks) {
            boolean os64bit;
            CharSequence charSequence = systemInfoProvider.getEnvironmentVariable("ProgramFiles(x86)");
            boolean bl = os64bit = !(charSequence == null || StringsKt.isBlank((CharSequence)charSequence));
            if (os64bit) {
                this.registerFinder(this::readRegisteredLocationsOS64J64);
                this.registerFinder(this::readRegisteredLocationsOS64J32);
            } else {
                this.registerFinder(this::readRegisteredLocationsOS32J32);
            }
        }
        this.registerFinder(this::guessPossibleLocations);
        if (wslJdks) {
            for (WSLDistribution distro : WslDistributionManager.getInstance().getInstalledDistributions()) {
                JavaHomeFinderWsl wslFinder = new JavaHomeFinderWsl(distro);
                this.registerFinder(() -> JavaHomeFinderWindows._init_$lambda$0(wslFinder));
            }
        }
    }

    private final Set<String> readRegisteredLocationsOS64J64() {
        return this.readRegisteredLocations(Bitness.x64);
    }

    private final Set<String> readRegisteredLocationsOS64J32() {
        return this.readRegisteredLocations(Bitness.x32);
    }

    private final Set<String> readRegisteredLocationsOS32J32() {
        return this.readRegisteredLocations(null);
    }

    private final Set<String> readRegisteredLocations(Bitness b) {
        Bitness bitness = b;
        String cmd = switch (bitness == null ? -1 : WhenMappings.$EnumSwitchMapping$0[bitness.ordinal()]) {
            case -1 -> regCommand;
            case 1 -> "reg query HKLM\\SOFTWARE\\JavaSoft\\JDK /s /v JavaHome /reg:32";
            case 2 -> "reg query HKLM\\SOFTWARE\\JavaSoft\\JDK /s /v JavaHome /reg:64";
            default -> throw new NoWhenBranchMatchedException();
        };
        try {
            String string2 = WindowsRegistryUtil.readRegistry(cmd);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"readRegistry(cmd)");
            CharSequence registryLines = string2;
            Set<String> registeredPaths = Companion.gatherHomePaths(registryLines);
            Set folders = new TreeSet();
            for (String rp : registeredPaths) {
                Path r = Paths.get(rp, new String[0]);
                Path parent2 = r.getParent();
                if (parent2 != null) {
                    LinkOption[] linkOptionArray = new LinkOption[]{};
                    if (Files.exists(parent2, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
                        folders.add(parent2);
                        continue;
                    }
                }
                Intrinsics.checkNotNullExpressionValue((Object)r, (String)"r");
                LinkOption[] linkOptionArray = new LinkOption[]{};
                if (!Files.exists(r, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) continue;
                folders.add(r);
            }
            Set<String> set2 = this.scanAll(folders, true);
            Intrinsics.checkNotNullExpressionValue(set2, (String)"scanAll(folders, true)");
            return set2;
        }
        catch (InterruptedException ie) {
            return SetsKt.emptySet();
        }
        catch (Exception e) {
            logger.warn("Unable to detect registered JDK using the following command: " + cmd, e);
            return SetsKt.emptySet();
        }
    }

    private final Set<String> guessPossibleLocations() {
        Collection<Path> collection = this.getSystemInfo().getFsRoots();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"systemInfo.fsRoots");
        Collection<Path> fsRoots = collection;
        Set roots2 = new HashSet();
        for (Path root : fsRoots) {
            ProgressManager.checkCanceled();
            Intrinsics.checkNotNullExpressionValue((Object)root, (String)"root");
            LinkOption[] linkOptionArray = new LinkOption[]{};
            if (!Files.exists(root, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) continue;
            Path path2 = root.resolve("Program Files/Java");
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"root.resolve(\"Program Files/Java\")");
            roots2.add(path2);
            Path path3 = root.resolve("Program Files (x86)/Java");
            Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"root.resolve(\"Program Files (x86)/Java\")");
            roots2.add(path3);
            Path path4 = root.resolve("Java");
            Intrinsics.checkNotNullExpressionValue((Object)path4, (String)"root.resolve(\"Java\")");
            roots2.add(path4);
        }
        Path path5 = this.getPathInUserHome(".jdks");
        if (path5 != null) {
            Path it = path5;
            boolean bl = false;
            roots2.add(it);
        }
        Set<String> set2 = this.scanAll(roots2, true);
        Intrinsics.checkNotNullExpressionValue(set2, (String)"scanAll(roots, true)");
        return set2;
    }

    private static final Set _init_$lambda$0(JavaHomeFinderWsl $wslFinder) {
        Intrinsics.checkNotNullParameter((Object)$wslFinder, (String)"$wslFinder");
        return $wslFinder.findExistingJdks();
    }

    static {
        Object[] objectArray = new RegexOption[]{RegexOption.MULTILINE, RegexOption.IGNORE_CASE};
        javaHomePattern = new Regex("^\\s+JavaHome\\s+REG_SZ\\s+(\\S.+\\S)\\s*$", SetsKt.setOf((Object[])objectArray));
        Logger logger = Logger.getInstance(JavaHomeFinderWindows.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(JavaHomeFinderWindows::class.java)");
        JavaHomeFinderWindows.logger = logger;
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Bitness.values().length];
            try {
                nArray[Bitness.x32.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Bitness.x64.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0000\n\u0002\u0010\r\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00040\f2\u0006\u0010\r\u001a\u00020\u000eR\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\b\n\u0000\u0012\u0004\b\n\u0010\u0002\u00a8\u0006\u000f"}, d2={"Lcom/intellij/openapi/projectRoots/impl/JavaHomeFinderWindows$Companion;", "", "()V", "defaultJavaLocation", "", "javaHomePattern", "Lkotlin/text/Regex;", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "regCommand", "getRegCommand$annotations", "gatherHomePaths", "", "text", "", "intellij.platform.lang.impl"})
    @SourceDebugExtension(value={"SMAP\nJavaHomeFinderWindows.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JavaHomeFinderWindows.kt\ncom/intellij/openapi/projectRoots/impl/JavaHomeFinderWindows$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,115:1\n1#2:116\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        private static /* synthetic */ void getRegCommand$annotations() {
        }

        @NotNull
        public final Set<String> gatherHomePaths(@NotNull CharSequence text2) {
            Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
            TreeSet paths2 = new TreeSet();
            for (MatchResult m = Regex.find$default((Regex)javaHomePattern, (CharSequence)text2, (int)0, (int)2, null); m != null; m = m.next()) {
                MatchGroup $this$gatherHomePaths_u24lambda_u240;
                if (m.getGroups().get(1) == null) continue;
                boolean bl = false;
                ((Collection)paths2).add($this$gatherHomePaths_u24lambda_u240.getValue());
            }
            return paths2;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

