/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.projectRoots.impl;

import com.intellij.execution.wsl.WSLDistribution;
import com.intellij.openapi.projectRoots.impl.JavaHomeFinder;
import com.intellij.openapi.projectRoots.impl.JavaHomeFinderBasic;
import com.intellij.util.ArrayUtil;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class JavaHomeFinderWsl
extends JavaHomeFinderBasic {
    private static final Set<String> DEFAULT_PATHS = Set.of("/bin", "/usr/bin", "/usr/local/bin");
    private final WSLDistribution myDistro;

    JavaHomeFinderWsl(@NotNull WSLDistribution distro) {
        if (distro == null) {
            JavaHomeFinderWsl.$$$reportNull$$$0(0);
        }
        super(new WslSystemInfoProvider(distro));
        this.myDistro = distro;
        this.checkDefaultInstallDir(false);
        this.checkUsedInstallDirs(false);
        this.checkConfiguredJdks(false);
        this.checkSpecifiedPaths(JavaHomeFinderWsl.lookupPaths(distro));
    }

    private static String[] lookupPaths(WSLDistribution distro) {
        ArrayList<String> list2 = new ArrayList<String>();
        for (String defaultPath : JavaHomeFinder.DEFAULT_JAVA_LINUX_PATHS) {
            list2.add(distro.getWindowsPath(defaultPath));
        }
        String home2 = distro.getUserHome();
        if (home2 != null) {
            list2.add(distro.getWindowsPath(home2 + "/.jdks"));
        }
        return ArrayUtil.toStringArray(list2);
    }

    @Override
    @Nullable
    protected Path getPathInUserHome(@NotNull String relativePath) {
        String wslPath;
        if (relativePath == null) {
            JavaHomeFinderWsl.$$$reportNull$$$0(1);
        }
        if ((wslPath = this.myDistro.getUserHome()) != null) {
            return Path.of(this.myDistro.getWindowsPath(wslPath), relativePath);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "distro";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "relativePath";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/projectRoots/impl/JavaHomeFinderWsl";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getPathInUserHome";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class WslSystemInfoProvider
    extends JavaHomeFinder.SystemInfoProvider {
        @NotNull
        private final WSLDistribution myDistro;

        private WslSystemInfoProvider(@NotNull WSLDistribution distro) {
            if (distro == null) {
                WslSystemInfoProvider.$$$reportNull$$$0(0);
            }
            this.myDistro = distro;
        }

        @Override
        @Nullable
        public String getEnvironmentVariable(@NotNull String name) {
            String value;
            if (name == null) {
                WslSystemInfoProvider.$$$reportNull$$$0(1);
            }
            if ((value = this.myDistro.getEnvironmentVariable(name)) == null) {
                return null;
            }
            if (value.indexOf(58) < 0) {
                return this.myDistro.getWindowsPath(value);
            }
            String mntRoot = this.myDistro.getMntRoot();
            String converted = Stream.of(value.split(":")).filter(p -> !DEFAULT_PATHS.contains(p) && !p.startsWith(mntRoot)).map(arg_0 -> ((WSLDistribution)this.myDistro).getWindowsPath(arg_0)).collect(Collectors.joining(File.pathSeparator));
            return converted.isEmpty() ? null : converted;
        }

        @Override
        @Nullable
        public Path getUserHome() {
            String wslPath = this.myDistro.getUserHome();
            return wslPath != null ? Path.of(this.myDistro.getWindowsPath(wslPath), new String[0]) : null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "distro";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/projectRoots/impl/JavaHomeFinderWsl$WslSystemInfoProvider";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getEnvironmentVariable";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

