/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.projectRoots.impl;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkModificator;
import com.intellij.openapi.projectRoots.SdkType;
import com.intellij.openapi.projectRoots.SdkTypeId;
import com.intellij.openapi.projectRoots.impl.MockSdk;
import com.intellij.openapi.projectRoots.impl.UnknownInvalidSdkFix;
import com.intellij.openapi.projectRoots.impl.UnknownInvalidSdkFixDownload;
import com.intellij.openapi.projectRoots.impl.UnknownInvalidSdkFixLocal;
import com.intellij.openapi.projectRoots.impl.UnknownSdkFixActionBase;
import com.intellij.openapi.roots.ui.configuration.UnknownSdk;
import com.intellij.openapi.roots.ui.configuration.UnknownSdkDownloadableSdkFix;
import com.intellij.openapi.roots.ui.configuration.UnknownSdkLocalSdkFix;
import com.intellij.openapi.roots.ui.configuration.projectRoot.SdkDownloadTracker;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UnknownInvalidSdk
implements UnknownSdk {
    private static final Logger LOG = Logger.getInstance(UnknownInvalidSdk.class);
    @NotNull
    final Sdk mySdk;
    @NotNull
    final SdkType mySdkType;

    UnknownInvalidSdk(@NotNull Sdk sdk2, @NotNull SdkType sdkType) {
        if (sdk2 == null) {
            UnknownInvalidSdk.$$$reportNull$$$0(0);
        }
        if (sdkType == null) {
            UnknownInvalidSdk.$$$reportNull$$$0(1);
        }
        this.mySdk = sdk2;
        this.mySdkType = sdkType;
    }

    @Override
    @NotNull
    public SdkType getSdkType() {
        SdkType sdkType = this.mySdkType;
        if (sdkType == null) {
            UnknownInvalidSdk.$$$reportNull$$$0(2);
        }
        return sdkType;
    }

    @Override
    @NotNull
    public String getSdkName() {
        String string2 = this.mySdk.getName();
        if (string2 == null) {
            UnknownInvalidSdk.$$$reportNull$$$0(3);
        }
        return string2;
    }

    @Override
    @Nullable
    public String getExpectedVersionString() {
        return this.mySdk.getVersionString();
    }

    void copySdk(@NotNull String sdkFixVersionString, @NotNull String sdkHome) {
        if (sdkFixVersionString == null) {
            UnknownInvalidSdk.$$$reportNull$$$0(4);
        }
        if (sdkHome == null) {
            UnknownInvalidSdk.$$$reportNull$$$0(5);
        }
        WriteAction.run(() -> {
            SdkModificator mod = this.mySdk.getSdkModificator();
            mod.setVersionString(sdkFixVersionString);
            mod.setHomePath(sdkHome);
            mod.commitChanges();
            this.mySdkType.setupSdkPaths(this.mySdk);
        });
    }

    @NotNull
    static List<UnknownInvalidSdk> resolveInvalidSdks(@NotNull List<? extends Sdk> usedSdks) {
        if (usedSdks == null) {
            UnknownInvalidSdk.$$$reportNull$$$0(6);
        }
        ArrayList<UnknownInvalidSdk> result2 = new ArrayList<UnknownInvalidSdk>();
        for (Sdk sdk2 : usedSdks) {
            UnknownInvalidSdk invalidSdk;
            if (SdkDownloadTracker.getInstance().isDownloading(sdk2) || (invalidSdk = UnknownInvalidSdk.resolveInvalidSdk(sdk2)) == null) continue;
            result2.add(invalidSdk);
        }
        ArrayList<UnknownInvalidSdk> arrayList = result2;
        if (arrayList == null) {
            UnknownInvalidSdk.$$$reportNull$$$0(7);
        }
        return arrayList;
    }

    @Nullable
    private static UnknownInvalidSdk resolveInvalidSdk(@NotNull Sdk sdk2) {
        SdkTypeId type;
        if (sdk2 == null) {
            UnknownInvalidSdk.$$$reportNull$$$0(8);
        }
        if (!((type = sdk2.getSdkType()) instanceof SdkType)) {
            return null;
        }
        SdkType sdkType = (SdkType)type;
        if (ApplicationManager.getApplication().isUnitTestMode() && sdk2 instanceof MockSdk) {
            return null;
        }
        try {
            String homePath = sdk2.getHomePath();
            if (homePath != null && sdkType.isValidSdkHome(homePath)) {
                return null;
            }
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (Exception e) {
            LOG.warn("Failed to validate SDK " + sdk2 + ". " + e.getMessage(), e);
            return null;
        }
        return new UnknownInvalidSdk(sdk2, sdkType);
    }

    @NotNull
    public UnknownInvalidSdkFix buildFix(@NotNull Project project2, @Nullable UnknownSdkLocalSdkFix localSdkFix, @Nullable UnknownSdkDownloadableSdkFix downloadableSdkFix) {
        if (project2 == null) {
            UnknownInvalidSdk.$$$reportNull$$$0(9);
        }
        UnknownSdkFixActionBase action2 = null;
        if (localSdkFix != null) {
            action2 = new UnknownInvalidSdkFixLocal(this, localSdkFix);
        } else if (downloadableSdkFix != null) {
            action2 = new UnknownInvalidSdkFixDownload(this, downloadableSdkFix);
        }
        return new UnknownInvalidSdkFix(project2, this, action2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkType";
                break;
            }
            case 2: 
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/projectRoots/impl/UnknownInvalidSdk";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkFixVersionString";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkHome";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usedSdks";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/projectRoots/impl/UnknownInvalidSdk";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getSdkType";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getSdkName";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveInvalidSdks";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 7: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "copySdk";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "resolveInvalidSdks";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "resolveInvalidSdk";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "buildFix";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 2, 3, 7 -> new IllegalStateException(string2);
        };
    }
}

