/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.projectRoots.impl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.projectRoots.SdkType;
import com.intellij.openapi.projectRoots.impl.UnknownInvalidSdk;
import com.intellij.openapi.projectRoots.impl.UnknownSdkFix;
import com.intellij.openapi.projectRoots.impl.UnknownSdkFixAction;
import com.intellij.openapi.roots.ui.configuration.SdkPopupFactory;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.EditorNotificationPanel;
import java.util.Objects;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class UnknownInvalidSdkFix
implements UnknownSdkFix {
    private static final Logger LOG = Logger.getInstance(UnknownInvalidSdkFix.class);
    @NotNull
    private final Project myProject;
    @NotNull
    private final String mySdkName;
    @NotNull
    private final UnknownInvalidSdk mySdk;
    @Nullable
    private final UnknownSdkFixAction myAction;

    UnknownInvalidSdkFix(@NotNull Project project2, @NotNull UnknownInvalidSdk invalidSdk, @Nullable UnknownSdkFixAction action2) {
        if (project2 == null) {
            UnknownInvalidSdkFix.$$$reportNull$$$0(0);
        }
        if (invalidSdk == null) {
            UnknownInvalidSdkFix.$$$reportNull$$$0(1);
        }
        this.myProject = project2;
        this.mySdkName = invalidSdk.getSdkName();
        this.mySdk = invalidSdk;
        this.myAction = action2;
    }

    @Override
    public boolean isRelevantFor(@NotNull Project project2) {
        if (project2 == null) {
            UnknownInvalidSdkFix.$$$reportNull$$$0(2);
        }
        return this.myProject == project2;
    }

    @Override
    public boolean isRelevantFor(@NotNull Project project2, @NotNull VirtualFile file2) {
        if (project2 == null) {
            UnknownInvalidSdkFix.$$$reportNull$$$0(3);
        }
        if (file2 == null) {
            UnknownInvalidSdkFix.$$$reportNull$$$0(4);
        }
        return this.isRelevantFor(project2) && this.mySdk.getSdkType().isRelevantForFile(project2, file2);
    }

    @NotNull
    private SdkType getSdkType() {
        SdkType sdkType = this.mySdk.mySdkType;
        if (sdkType == null) {
            UnknownInvalidSdkFix.$$$reportNull$$$0(5);
        }
        return sdkType;
    }

    @Override
    @Nls
    @NotNull
    public String getConfigureActionText() {
        String string2 = ProjectBundle.message((String)"action.text.config.invalid.sdk.configure", (Object[])new Object[0]);
        if (string2 == null) {
            UnknownInvalidSdkFix.$$$reportNull$$$0(6);
        }
        return string2;
    }

    @Override
    @NotNull
    public EditorNotificationPanel.ActionHandler getConfigureActionHandler(@NotNull Project project2) {
        if (project2 == null) {
            UnknownInvalidSdkFix.$$$reportNull$$$0(7);
        }
        String sdkName = this.mySdk.mySdk.getName();
        EditorNotificationPanel.ActionHandler actionHandler = SdkPopupFactory.newBuilder().withProject(project2).withSdkFilter(sdk2 -> !Objects.equals(sdk2.getName(), sdkName)).withSdkTypeFilter(type -> Objects.equals(type, this.mySdk.mySdkType)).onSdkSelected(sdk2 -> {
            String homePath = sdk2.getHomePath();
            String versionString = sdk2.getVersionString();
            if (homePath != null && versionString != null) {
                this.mySdk.copySdk(versionString, homePath);
            } else {
                LOG.warn("Newly added SDK has invalid home or version: " + sdk2 + ", home=" + homePath + " version=" + versionString);
            }
        }).buildEditorNotificationPanelHandler();
        if (actionHandler == null) {
            UnknownInvalidSdkFix.$$$reportNull$$$0(8);
        }
        return actionHandler;
    }

    @Override
    @Nls
    @NotNull
    public String getIntentionActionText() {
        String sdkTypeName = this.mySdk.getSdkType().getPresentableName();
        String string2 = ProjectBundle.message((String)"config.invalid.sdk.configure.missing", (Object[])new Object[]{sdkTypeName, this.mySdkName});
        if (string2 == null) {
            UnknownInvalidSdkFix.$$$reportNull$$$0(9);
        }
        return string2;
    }

    @Override
    @Nullable
    public UnknownSdkFixAction getSuggestedFixAction() {
        return this.myAction;
    }

    @Override
    @Nls
    @NotNull
    public String getNotificationText() {
        String sdkTypeName = this.mySdk.getSdkType().getPresentableName();
        String string2 = ProjectBundle.message((String)"notification.text.config.invalid.sdk", (Object[])new Object[]{sdkTypeName, this.mySdkName});
        if (string2 == null) {
            UnknownInvalidSdkFix.$$$reportNull$$$0(10);
        }
        return string2;
    }

    @Override
    @Nls
    @NotNull
    public String getSdkTypeAndNameText() {
        String sdkTypeName = this.mySdk.getSdkType().getPresentableName();
        String string2 = ProjectBundle.message((String)"dialog.text.resolving.sdks.item", (Object[])new Object[]{sdkTypeName, this.mySdkName});
        if (string2 == null) {
            UnknownInvalidSdkFix.$$$reportNull$$$0(11);
        }
        return string2;
    }

    public String toString() {
        return "InvalidSdkFixInfo { name: " + this.mySdkName + ", " + this.myAction + "}";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 6, 8, 9, 10, 11 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "invalidSdk";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/projectRoots/impl/UnknownInvalidSdkFix";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/projectRoots/impl/UnknownInvalidSdkFix";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getSdkType";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigureActionText";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigureActionHandler";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getIntentionActionText";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getNotificationText";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getSdkTypeAndNameText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isRelevantFor";
                break;
            }
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getConfigureActionHandler";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 5, 6, 8, 9, 10, 11 -> new IllegalStateException(string2);
        };
    }
}

