/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.projectRoots.impl;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.impl.UnknownInvalidSdk;
import com.intellij.openapi.projectRoots.impl.UnknownSdkFixAction;
import com.intellij.openapi.projectRoots.impl.UnknownSdkFixActionLocalBase;
import com.intellij.openapi.roots.ui.configuration.SdkListPresenter;
import com.intellij.openapi.roots.ui.configuration.UnknownSdkLocalSdkFix;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class UnknownInvalidSdkFixLocal
extends UnknownSdkFixActionLocalBase
implements UnknownSdkFixAction {
    @NotNull
    private final UnknownInvalidSdk mySdk;
    @NotNull
    private final UnknownSdkLocalSdkFix myFix;

    UnknownInvalidSdkFixLocal(@NotNull UnknownInvalidSdk sdk2, @NotNull UnknownSdkLocalSdkFix localSdkFix) {
        if (sdk2 == null) {
            UnknownInvalidSdkFixLocal.$$$reportNull$$$0(0);
        }
        if (localSdkFix == null) {
            UnknownInvalidSdkFixLocal.$$$reportNull$$$0(1);
        }
        this.mySdk = sdk2;
        this.myFix = localSdkFix;
    }

    @Override
    @NotNull
    @Nls
    public String getActionShortText() {
        String sdkTypeName = this.mySdk.mySdkType.getPresentableName();
        String string2 = ProjectBundle.message((String)"config.unknown.sdk.local", (Object[])new Object[]{sdkTypeName, this.myFix.getPresentableVersionString()});
        if (string2 == null) {
            UnknownInvalidSdkFixLocal.$$$reportNull$$$0(2);
        }
        return string2;
    }

    @Override
    @Nullable
    @Nls
    public String getActionTooltipText() {
        return SdkListPresenter.presentDetectedSdkPath(this.myFix.getExistingSdkHome(), 90, 40);
    }

    @Override
    @Nullable
    public Sdk getRegisteredSdkPrototype() {
        return this.myFix.getRegisteredSdkPrototype();
    }

    @Override
    @NotNull
    @Nls
    public String getActionDetailedText() {
        String sdkTypeName = this.mySdk.mySdkType.getPresentableName();
        String string2 = ProjectBundle.message((String)"label.text.use.for.invalid.sdk", (Object[])new Object[]{sdkTypeName, this.myFix.getPresentableVersionString(), sdkTypeName, this.mySdk.mySdk.getName()});
        if (string2 == null) {
            UnknownInvalidSdkFixLocal.$$$reportNull$$$0(3);
        }
        return string2;
    }

    @Override
    @NotNull
    protected String getSuggestedSdkHome() {
        String string2 = this.myFix.getExistingSdkHome();
        if (string2 == null) {
            UnknownInvalidSdkFixLocal.$$$reportNull$$$0(4);
        }
        return string2;
    }

    @Override
    @NotNull
    protected Sdk applyLocalFix() {
        Sdk sdk2;
        ApplicationManager.getApplication().assertIsDispatchThread();
        try {
            String sdkFixVersionString = this.myFix.getVersionString();
            String sdkHome = this.myFix.getExistingSdkHome();
            this.mySdk.copySdk(sdkFixVersionString, sdkHome);
            this.myFix.configureSdk(this.mySdk.mySdk);
            sdk2 = this.mySdk.mySdk;
        }
        catch (Throwable t) {
            Logger.getInstance(this.getClass()).warn("Failed to configure " + this.mySdk.getSdkType().getPresentableName() + "  for " + this.mySdk + " for path " + this.myFix + ". " + t.getMessage(), t);
            throw t;
        }
        if (sdk2 == null) {
            UnknownInvalidSdkFixLocal.$$$reportNull$$$0(5);
        }
        return sdk2;
    }

    public String toString() {
        return this.myFix.toString();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localSdkFix";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/projectRoots/impl/UnknownInvalidSdkFixLocal";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/projectRoots/impl/UnknownInvalidSdkFixLocal";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionShortText";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionDetailedText";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuggestedSdkHome";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "applyLocalFix";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 2, 3, 4, 5 -> new IllegalStateException(string2);
        };
    }
}

