/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.projectRoots.impl;

import com.google.common.collect.MultimapBuilder;
import com.google.common.collect.SetMultimap;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkType;
import com.intellij.openapi.projectRoots.impl.MissingSdkInfo;
import com.intellij.openapi.projectRoots.impl.UnknownSdkBlockingCollector;
import com.intellij.openapi.projectRoots.impl.UnknownSdkCollectorKt;
import com.intellij.openapi.projectRoots.impl.UnknownSdkCollectorQueue;
import com.intellij.openapi.projectRoots.impl.UnknownSdkContributor;
import com.intellij.openapi.projectRoots.impl.UnknownSdkSnapshot;
import com.intellij.openapi.roots.ModuleJdkOrderEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.ui.configuration.UnknownSdk;
import com.intellij.util.concurrency.AppExecutorUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0003H\u0014J\u0016\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u0007\u001a\u00020\u0003H\u0014J\b\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\fH\u0002J\u000e\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\tH\u0014J'\u0010\u0010\u001a\u00020\u0011*\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\f0\u0016H\u0000\u00a2\u0006\u0002\b\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/intellij/openapi/projectRoots/impl/UnknownSdkCollector;", "Lcom/intellij/openapi/projectRoots/impl/UnknownSdkBlockingCollector;", "myProject", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "checkProjectSdk", "", "project", "collectModulesToCheckSdk", "", "Lcom/intellij/openapi/module/Module;", "collectSdksBlocking", "Lcom/intellij/openapi/projectRoots/impl/UnknownSdkSnapshot;", "collectSdksUnderReadAction", "getContributors", "Lcom/intellij/openapi/projectRoots/impl/UnknownSdkContributor;", "collectSdksPromise", "", "Lcom/intellij/openapi/projectRoots/impl/UnknownSdkCollectorQueue;", "lifetime", "Lcom/intellij/openapi/Disposable;", "onCompleted", "Ljava/util/function/Consumer;", "collectSdksPromise$intellij_platform_lang_impl", "Companion", "intellij.platform.lang.impl"})
@SourceDebugExtension(value={"SMAP\nUnknownSdkCollector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UnknownSdkCollector.kt\ncom/intellij/openapi/projectRoots/impl/UnknownSdkCollector\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,223:1\n4098#2,11:224\n1603#3,9:235\n1855#3:244\n1856#3:246\n1612#3:247\n1855#3,2:248\n1045#3:250\n1#4:245\n10#5:251\n*S KotlinDebug\n*F\n+ 1 UnknownSdkCollector.kt\ncom/intellij/openapi/projectRoots/impl/UnknownSdkCollector\n*L\n154#1:224,11\n191#1:235,9\n191#1:244\n191#1:246\n191#1:247\n193#1:248,2\n218#1:250\n191#1:245\n93#1:251\n*E\n"})
public class UnknownSdkCollector
implements UnknownSdkBlockingCollector {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project myProject;
    @NotNull
    private static final Logger LOG;

    public UnknownSdkCollector(@NotNull Project myProject) {
        Intrinsics.checkNotNullParameter((Object)myProject, (String)"myProject");
        this.myProject = myProject;
    }

    public final void collectSdksPromise$intellij_platform_lang_impl(@NotNull UnknownSdkCollectorQueue $this$collectSdksPromise, @NotNull Disposable lifetime, @NotNull Consumer<UnknownSdkSnapshot> onCompleted) {
        Intrinsics.checkNotNullParameter((Object)$this$collectSdksPromise, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        Intrinsics.checkNotNullParameter(onCompleted, (String)"onCompleted");
        Object[] objectArray = new Object[]{this.myProject, Reflection.getOrCreateKotlinClass(UnknownSdkCollector.class)};
        ReadAction.nonBlocking(() -> UnknownSdkCollector.collectSdksPromise$lambda$0(this)).expireWith(lifetime).expireWith(this.myProject).coalesceBy(objectArray).finishOnUiThread(ApplicationManager.getApplication().getDefaultModalityState(), onCompleted).submit(AppExecutorUtil.getAppExecutorService());
    }

    @Override
    @NotNull
    public UnknownSdkSnapshot collectSdksBlocking() {
        return (UnknownSdkSnapshot)ActionsKt.runReadAction((Function0)new Function0<UnknownSdkSnapshot>(this){
            final /* synthetic */ UnknownSdkCollector this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final UnknownSdkSnapshot invoke() {
                return UnknownSdkCollector.access$collectSdksUnderReadAction(this.this$0);
            }
        });
    }

    protected boolean checkProjectSdk(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        return true;
    }

    @NotNull
    protected List<Module> collectModulesToCheckSdk(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        return ArraysKt.toList((Object[])ModuleManager.Companion.getInstance(this.myProject).getModules());
    }

    /*
     * WARNING - void declaration
     */
    private final UnknownSdkSnapshot collectSdksUnderReadAction() {
        void $this$mapNotNullTo$iv$iv;
        Iterable sdkTypes;
        Set knownSdks = new LinkedHashSet();
        SetMultimap sdkToTypes = MultimapBuilder.treeKeys((Comparator)String.CASE_INSENSITIVE_ORDER).hashSetValues().build();
        ProgressManager.checkCanceled();
        if (this.checkProjectSdk(this.myProject)) {
            ProjectRootManager rootManager = ProjectRootManager.getInstance(this.myProject);
            Sdk projectSdk = rootManager.getProjectSdk();
            if (projectSdk == null) {
                String sdkName = rootManager.getProjectSdkName();
                String string2 = rootManager.getProjectSdkTypeName();
                if (sdkName != null) {
                    sdkToTypes.put((Object)sdkName, (Object)string2);
                }
            } else {
                ((Collection)knownSdks).add(projectSdk);
            }
        }
        for (Module module2 : this.collectModulesToCheckSdk(this.myProject)) {
            ModuleJdkOrderEntry moduleJdkOrderEntry;
            void $this$filterIsInstanceTo$iv$iv;
            void $this$filterIsInstance$iv;
            ProgressManager.checkCanceled();
            ModuleRootManager moduleRootManager = ModuleRootManager.getInstance(module2);
            if (moduleRootManager.getExternalSource() != null) continue;
            OrderEntry[] orderEntryArray = moduleRootManager.getOrderEntries();
            Intrinsics.checkNotNullExpressionValue((Object)orderEntryArray, (String)"moduleRootManager.orderEntries");
            Object[] objectArray = orderEntryArray;
            boolean $i$f$filterIsInstance = false;
            void var10_21 = $this$filterIsInstance$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof ModuleJdkOrderEntry)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            if ((ModuleJdkOrderEntry)CollectionsKt.firstOrNull((List)((List)destination$iv$iv)) == null) continue;
            Sdk moduleJdk = moduleJdkOrderEntry.getJdk();
            if (moduleJdk == null) {
                String jdkName = moduleJdkOrderEntry.getJdkName();
                String jdkTypeName = moduleJdkOrderEntry.getJdkTypeName();
                if (jdkName == null) continue;
                sdkToTypes.put((Object)jdkName, (Object)jdkTypeName);
                continue;
            }
            ((Collection)knownSdks).add(moduleJdk);
        }
        TreeSet<String> totallyUnknownSdks = new TreeSet<String>(StringsKt.getCASE_INSENSITIVE_ORDER((StringCompanionObject)StringCompanionObject.INSTANCE));
        List resolvableSdks = new ArrayList();
        Map map2 = sdkToTypes.asMap();
        Intrinsics.checkNotNullExpressionValue((Object)map2, (String)"sdkToTypes.asMap()");
        for (Map.Entry entry : map2.entrySet()) {
            String sdkName = (String)entry.getKey();
            sdkTypes = (Collection)entry.getValue();
            Intrinsics.checkNotNullExpressionValue((Object)sdkTypes, (String)"sdkTypes");
            String singleSdkTypeName = (String)CollectionsKt.singleOrNull((List)CollectionsKt.distinct((Iterable)CollectionsKt.filterNotNull((Iterable)sdkTypes)));
            if (singleSdkTypeName == null) {
                totallyUnknownSdks.add(sdkName);
                continue;
            }
            SdkType sdkType = SdkType.findByName((String)singleSdkTypeName);
            if (sdkType == null) continue;
            Intrinsics.checkNotNullExpressionValue((Object)sdkName, (String)"sdkName");
            resolvableSdks.add(new MissingSdkInfo(sdkName, sdkType));
        }
        Iterable iterable = resolvableSdks;
        boolean $i$f$mapNotNull = false;
        sdkTypes = iterable;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach32 = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            String it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv;
            element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            UnknownSdk it = (UnknownSdk)element$iv$iv;
            boolean bl2 = false;
            if (it.getSdkName() == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Set detectedUnknownSdkNames = CollectionsKt.toMutableSet((Iterable)((List)destination$iv$iv));
        Iterable iterable2 = this.getContributors();
        boolean $i$f$forEach2 = false;
        for (Object element$iv : iterable2) {
            Object $i$f$forEach32;
            UnknownSdkContributor it = (UnknownSdkContributor)element$iv;
            boolean bl = false;
            try {
                $i$f$forEach32 = it.contributeUnknownSdks(this.myProject);
            }
            catch (ProcessCanceledException e) {
                throw e;
            }
            catch (Throwable t) {
                LOG.warn("Failed to contribute SDKs with " + it.getClass().getName() + ". " + t.getMessage(), t);
                $i$f$forEach32 = CollectionsKt.emptyList();
            }
            List<UnknownSdk> contrib = $i$f$forEach32;
            for (UnknownSdk unknownSdk2 : contrib) {
                String name;
                if (unknownSdk2.getSdkName() == null) continue;
                Intrinsics.checkNotNullExpressionValue((Object)name, (String)"unknownSdk.sdkName ?: continue");
                if (!detectedUnknownSdkNames.add(name)) continue;
                ((Collection)resolvableSdks).add(unknownSdk2);
            }
            try {
                CollectionsKt.addAll((Collection)knownSdks, (Iterable)it.contributeKnownSdks(this.myProject));
            }
            catch (ProcessCanceledException e) {
                throw e;
            }
            catch (Throwable t) {
                LOG.warn("Failed to contribute SDKs with " + it.getClass().getName() + ". " + t.getMessage(), t);
            }
        }
        Iterable iterable3 = CollectionsKt.toList((Iterable)knownSdks);
        boolean $i$f$sortedBy = false;
        return new UnknownSdkSnapshot((Set<String>)totallyUnknownSdks, resolvableSdks, CollectionsKt.distinct((Iterable)CollectionsKt.sortedWith((Iterable)iterable3, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                Sdk it = (Sdk)a;
                boolean bl = false;
                Comparable comparable = (Comparable)((Object)it.getName());
                it = (Sdk)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.getName())));
            }
        })));
    }

    @NotNull
    protected List<UnknownSdkContributor> getContributors() {
        return UnknownSdkCollectorKt.access$getEP_NAME$p().getExtensionList();
    }

    private static final UnknownSdkSnapshot collectSdksPromise$lambda$0(UnknownSdkCollector this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        return this$0.collectSdksUnderReadAction();
    }

    public static final /* synthetic */ UnknownSdkSnapshot access$collectSdksUnderReadAction(UnknownSdkCollector $this) {
        return $this.collectSdksUnderReadAction();
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(UnknownSdkCollector.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(T::class.java)");
        LOG = logger;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/openapi/projectRoots/impl/UnknownSdkCollector$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "intellij.platform.lang.impl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

