/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.projectRoots.impl;

import com.intellij.ide.CommandLineInspectionProjectConfigurator;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.impl.UnknownSdkCollector;
import com.intellij.openapi.projectRoots.impl.UnknownSdkFix;
import com.intellij.openapi.projectRoots.impl.UnknownSdkFixAction;
import com.intellij.openapi.projectRoots.impl.UnknownSdkTracker;
import com.intellij.openapi.util.registry.Registry;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0018\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\u000bH\u0016J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0010"}, d2={"Lcom/intellij/openapi/projectRoots/impl/UnknownSdkInspectionCommandLineConfigurator;", "Lcom/intellij/ide/CommandLineInspectionProjectConfigurator;", "()V", "configureEnvironment", "", "context", "Lcom/intellij/ide/CommandLineInspectionProjectConfigurator$ConfiguratorContext;", "configureProject", "project", "Lcom/intellij/openapi/project/Project;", "getDescription", "", "getName", "isApplicable", "", "Companion", "intellij.platform.lang.impl"})
@SourceDebugExtension(value={"SMAP\nUnknownSdkInspectionCommandLineConfigurator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UnknownSdkInspectionCommandLineConfigurator.kt\ncom/intellij/openapi/projectRoots/impl/UnknownSdkInspectionCommandLineConfigurator\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,69:1\n10#2:70\n*S KotlinDebug\n*F\n+ 1 UnknownSdkInspectionCommandLineConfigurator.kt\ncom/intellij/openapi/projectRoots/impl/UnknownSdkInspectionCommandLineConfigurator\n*L\n16#1:70\n*E\n"})
public final class UnknownSdkInspectionCommandLineConfigurator
implements CommandLineInspectionProjectConfigurator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Logger LOG;

    @NotNull
    public String getName() {
        return "sdk";
    }

    @NotNull
    public String getDescription() {
        String string2 = ProjectBundle.message((String)"config.unknown.sdk.commandline.configure", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(\"config.unknown.\u2026k.commandline.configure\")");
        return string2;
    }

    public boolean isApplicable(@NotNull CommandLineInspectionProjectConfigurator.ConfiguratorContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        return !ApplicationManager.getApplication().isUnitTestMode();
    }

    public void configureEnvironment(@NotNull CommandLineInspectionProjectConfigurator.ConfiguratorContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Registry.get("unknown.sdk.auto").setValue(false);
    }

    public void configureProject(@NotNull Project project2, @NotNull CommandLineInspectionProjectConfigurator.ConfiguratorContext context2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        ProgressIndicator progressIndicator = context2.getProgressIndicator();
        Intrinsics.checkNotNullExpressionValue((Object)progressIndicator, (String)"context.progressIndicator");
        Companion.configureUnknownSdks(project2, progressIndicator);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(UnknownSdkInspectionCommandLineConfigurator.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(T::class.java)");
        LOG = logger;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/intellij/openapi/projectRoots/impl/UnknownSdkInspectionCommandLineConfigurator$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "configureUnknownSdks", "", "project", "Lcom/intellij/openapi/project/Project;", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "intellij.platform.lang.impl"})
    @SourceDebugExtension(value={"SMAP\nUnknownSdkInspectionCommandLineConfigurator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UnknownSdkInspectionCommandLineConfigurator.kt\ncom/intellij/openapi/projectRoots/impl/UnknownSdkInspectionCommandLineConfigurator$Companion\n+ 2 ProgressIndicatorEx.kt\ncom/intellij/openapi/progress/ProgressIndicatorForCollections\n*L\n1#1,69:1\n12#2,4:70\n12#2,8:74\n18#2,2:82\n*S KotlinDebug\n*F\n+ 1 UnknownSdkInspectionCommandLineConfigurator.kt\ncom/intellij/openapi/projectRoots/impl/UnknownSdkInspectionCommandLineConfigurator$Companion\n*L\n25#1:70,4\n44#1:74,8\n25#1:82,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void configureUnknownSdks(@NotNull Project project2, @NotNull ProgressIndicator indicator) {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
            if (!(!ApplicationManager.getApplication().isWriteIntentLockAcquired())) {
                boolean $i$a$-require-UnknownSdkInspectionCommandLineConfigurator$Companion$configureUnknownSdks$22 = false;
                String $i$a$-require-UnknownSdkInspectionCommandLineConfigurator$Companion$configureUnknownSdks$22 = "The code below uses the same GUI thread to complete operations. Running from EDT would deadlock";
                throw new IllegalArgumentException($i$a$-require-UnknownSdkInspectionCommandLineConfigurator$Companion$configureUnknownSdks$22.toString());
            }
            ApplicationManager.getApplication().assertIsNonDispatchThread();
            ProgressIndicator $this$withPushPop$iv = indicator;
            boolean $i$f$withPushPop = false;
            boolean wasIndeterminate$iv = $this$withPushPop$iv.isIndeterminate();
            $this$withPushPop$iv.pushState();
            try {
                boolean bl = false;
                indicator.setText(ProjectBundle.message((String)"config.unknown.progress.scanning", (Object[])new Object[0]));
                List<UnknownSdkFix> list2 = UnknownSdkTracker.getInstance(project2).collectUnknownSdks(new UnknownSdkCollector(project2), indicator);
                Intrinsics.checkNotNullExpressionValue(list2, (String)"getInstance(project)\n   \u2026ctor(project), indicator)");
                List<UnknownSdkFix> problems = list2;
                if (!problems.isEmpty()) {
                    indicator.setIndeterminate(false);
                    Iterator<UnknownSdkFix> iterator2 = problems.iterator();
                    int n = 0;
                    while (iterator2.hasNext()) {
                        int i2 = n++;
                        UnknownSdkFix problem = iterator2.next();
                        UnknownSdkFixAction fix2 = problem.getSuggestedFixAction();
                        if (fix2 == null) {
                            LOG.warn("Failed to resolve " + problem.getSdkTypeAndNameText() + ": " + problem.getNotificationText());
                            continue;
                        }
                        LOG.info("Resolving " + problem.getSdkTypeAndNameText());
                        ProgressIndicator $this$withPushPop$iv2 = indicator;
                        boolean $i$f$withPushPop2 = false;
                        boolean wasIndeterminate$iv2 = $this$withPushPop$iv2.isIndeterminate();
                        $this$withPushPop$iv2.pushState();
                        try {
                            boolean bl2 = false;
                            indicator.setFraction((double)i2 / (double)problems.size());
                            Object[] objectArray = new Object[]{problem.getSdkTypeAndNameText()};
                            indicator.setText(ProjectBundle.message((String)"config.unknown.progress.configuring", (Object[])objectArray));
                            Sdk sdk2 = fix2.applySuggestionBlocking(indicator);
                        }
                        finally {
                            $this$withPushPop$iv2.setIndeterminate(wasIndeterminate$iv2);
                            $this$withPushPop$iv2.popState();
                        }
                    }
                }
                Unit unit = Unit.INSTANCE;
            }
            finally {
                $this$withPushPop$iv.setIndeterminate(wasIndeterminate$iv);
                $this$withPushPop$iv.popState();
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

