/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.projectRoots.impl;

import com.intellij.ProjectTopics;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.extensions.ExtensionNotApplicableException;
import com.intellij.openapi.extensions.ExtensionPointListener;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ex.ProjectEx;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.impl.UnknownSdkTracker;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.roots.ModuleRootListener;
import com.intellij.openapi.roots.ex.ProjectRootManagerEx;
import com.intellij.openapi.roots.ui.configuration.UnknownSdkResolver;
import com.intellij.openapi.startup.ProjectActivity;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.SimpleMessageBusConnection;
import com.intellij.util.messages.Topic;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0019\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\b\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\t"}, d2={"Lcom/intellij/openapi/projectRoots/impl/UnknownSdkStartupChecker;", "Lcom/intellij/openapi/startup/ProjectActivity;", "()V", "checkUnknownSdks", "", "project", "Lcom/intellij/openapi/project/Project;", "execute", "(Lcom/intellij/openapi/project/Project;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "intellij.platform.lang.impl"})
@SourceDebugExtension(value={"SMAP\nUnknownSdkStartupChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UnknownSdkStartupChecker.kt\ncom/intellij/openapi/projectRoots/impl/UnknownSdkStartupChecker\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,72:1\n1#2:73\n*E\n"})
final class UnknownSdkStartupChecker
implements ProjectActivity {
    public UnknownSdkStartupChecker() {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            ExtensionNotApplicableException extensionNotApplicableException = ExtensionNotApplicableException.create();
            Intrinsics.checkNotNullExpressionValue((Object)extensionNotApplicableException, (String)"create()");
            throw (Throwable)extensionNotApplicableException;
        }
    }

    @Override
    @Nullable
    public Object execute(@NotNull Project project2, @NotNull Continuation<? super Unit> $completion) {
        this.checkUnknownSdks(project2);
        UnknownSdkResolver.EP_NAME.addExtensionPointListener(new ExtensionPointListener<UnknownSdkResolver>(this, project2){
            final /* synthetic */ UnknownSdkStartupChecker this$0;
            final /* synthetic */ Project $project;
            {
                this.this$0 = $receiver;
                this.$project = $project;
            }

            public void extensionAdded(@NotNull UnknownSdkResolver extension2, @NotNull PluginDescriptor pluginDescriptor) {
                Intrinsics.checkNotNullParameter((Object)extension2, (String)"extension");
                Intrinsics.checkNotNullParameter((Object)pluginDescriptor, (String)"pluginDescriptor");
                UnknownSdkStartupChecker.access$checkUnknownSdks(this.this$0, this.$project);
            }

            public void extensionRemoved(@NotNull UnknownSdkResolver extension2, @NotNull PluginDescriptor pluginDescriptor) {
                Intrinsics.checkNotNullParameter((Object)extension2, (String)"extension");
                Intrinsics.checkNotNullParameter((Object)pluginDescriptor, (String)"pluginDescriptor");
                UnknownSdkStartupChecker.access$checkUnknownSdks(this.this$0, this.$project);
            }
        }, project2);
        MessageBusConnection messageBusConnection = project2.getMessageBus().connect();
        Topic<ModuleRootListener> topic = ProjectTopics.PROJECT_ROOTS;
        Intrinsics.checkNotNullExpressionValue(topic, (String)"PROJECT_ROOTS");
        messageBusConnection.subscribe(topic, new ModuleRootListener(this){
            final /* synthetic */ UnknownSdkStartupChecker this$0;
            {
                this.this$0 = $receiver;
            }

            public void rootsChanged(@NotNull ModuleRootEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                Project project2 = event.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"event.project");
                UnknownSdkStartupChecker.access$checkUnknownSdks(this.this$0, project2);
            }
        });
        ProjectRootManagerEx.getInstanceEx(project2).addProjectJdkListener(() -> UnknownSdkStartupChecker.execute$lambda$0(this, project2));
        SimpleMessageBusConnection simpleMessageBusConnection = project2.getMessageBus().simpleConnect();
        Topic<ProjectJdkTable.Listener> topic2 = ProjectJdkTable.JDK_TABLE_TOPIC;
        Intrinsics.checkNotNullExpressionValue(topic2, (String)"JDK_TABLE_TOPIC");
        simpleMessageBusConnection.subscribe(topic2, new ProjectJdkTable.Listener(this, project2){
            final /* synthetic */ UnknownSdkStartupChecker this$0;
            final /* synthetic */ Project $project;
            {
                this.this$0 = $receiver;
                this.$project = $project;
            }

            public void jdkAdded(@NotNull Sdk jdk) {
                Intrinsics.checkNotNullParameter((Object)jdk, (String)"jdk");
                UnknownSdkStartupChecker.access$checkUnknownSdks(this.this$0, this.$project);
            }

            public void jdkRemoved(@NotNull Sdk jdk) {
                Intrinsics.checkNotNullParameter((Object)jdk, (String)"jdk");
                UnknownSdkStartupChecker.access$checkUnknownSdks(this.this$0, this.$project);
            }

            public void jdkNameChanged(@NotNull Sdk jdk, @NotNull String previousName) {
                Intrinsics.checkNotNullParameter((Object)jdk, (String)"jdk");
                Intrinsics.checkNotNullParameter((Object)previousName, (String)"previousName");
                UnknownSdkStartupChecker.access$checkUnknownSdks(this.this$0, this.$project);
            }
        });
        return Unit.INSTANCE;
    }

    private final void checkUnknownSdks(Project project2) {
        if (project2.isDisposed() || project2.isDefault()) {
            return;
        }
        if (project2 instanceof ProjectEx) {
            Object object;
            try {
                boolean bl = false;
                object = Result.constructor-impl((Object)((ProjectEx)project2).getEarlyDisposable());
            }
            catch (Throwable throwable) {
                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
            }
            if (Result.isFailure-impl((Object)object)) {
                return;
            }
        }
        UnknownSdkTracker.getInstance(project2).updateUnknownSdks();
    }

    private static final void execute$lambda$0(UnknownSdkStartupChecker this$0, Project $project) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$project, (String)"$project");
        this$0.checkUnknownSdks($project);
    }

    public static final /* synthetic */ void access$checkUnknownSdks(UnknownSdkStartupChecker $this, Project project2) {
        $this.checkUnknownSdks(project2);
    }
}

