/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.projectRoots.impl;

import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.ControlFlowException;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.PerformInBackgroundOption;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Progressive;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkType;
import com.intellij.openapi.projectRoots.SdkTypeId;
import com.intellij.openapi.projectRoots.impl.UnknownInvalidSdk;
import com.intellij.openapi.projectRoots.impl.UnknownMissingSdk;
import com.intellij.openapi.projectRoots.impl.UnknownMissingSdkFixLocal;
import com.intellij.openapi.projectRoots.impl.UnknownSdkBalloonNotification;
import com.intellij.openapi.projectRoots.impl.UnknownSdkBlockingCollector;
import com.intellij.openapi.projectRoots.impl.UnknownSdkCollector;
import com.intellij.openapi.projectRoots.impl.UnknownSdkEditorNotification;
import com.intellij.openapi.projectRoots.impl.UnknownSdkFix;
import com.intellij.openapi.projectRoots.impl.UnknownSdkFixAction;
import com.intellij.openapi.projectRoots.impl.UnknownSdkSnapshot;
import com.intellij.openapi.projectRoots.impl.UnknownSdkTrackerQueue;
import com.intellij.openapi.projectRoots.impl.UnknownSdkTrackerTask;
import com.intellij.openapi.roots.ui.configuration.UnknownSdk;
import com.intellij.openapi.roots.ui.configuration.UnknownSdkDownloadableSdkFix;
import com.intellij.openapi.roots.ui.configuration.UnknownSdkLocalSdkFix;
import com.intellij.openapi.roots.ui.configuration.UnknownSdkResolver;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.TripleFunction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
public final class UnknownSdkTracker {
    private static final Logger LOG = Logger.getInstance(UnknownSdkTracker.class);
    @NotNull
    private final Project myProject;
    private final Predicate<UnknownSdkSnapshot> myIsNewSnapshot;

    @NotNull
    public static UnknownSdkTracker getInstance(@NotNull Project project2) {
        if (project2 == null) {
            UnknownSdkTracker.$$$reportNull$$$0(0);
        }
        UnknownSdkTracker unknownSdkTracker = project2.getService(UnknownSdkTracker.class);
        if (unknownSdkTracker == null) {
            UnknownSdkTracker.$$$reportNull$$$0(1);
        }
        return unknownSdkTracker;
    }

    public UnknownSdkTracker(@NotNull Project project2) {
        if (project2 == null) {
            UnknownSdkTracker.$$$reportNull$$$0(2);
        }
        this.myIsNewSnapshot = new Predicate<UnknownSdkSnapshot>(){
            private UnknownSdkSnapshot myPreviousRequestCache = null;

            @Override
            public boolean test(UnknownSdkSnapshot snapshot) {
                if (snapshot.equals(this.myPreviousRequestCache)) {
                    return false;
                }
                this.myPreviousRequestCache = snapshot;
                return true;
            }
        };
        this.myProject = project2;
    }

    private static boolean isEnabled() {
        return Registry.is("unknown.sdk") && UnknownSdkResolver.EP_NAME.hasAnyExtensions();
    }

    @NotNull
    public List<UnknownSdkFix> collectUnknownSdks(@NotNull UnknownSdkBlockingCollector collector2, @NotNull ProgressIndicator indicator) {
        if (collector2 == null) {
            UnknownSdkTracker.$$$reportNull$$$0(3);
        }
        if (indicator == null) {
            UnknownSdkTracker.$$$reportNull$$$0(4);
        }
        if (!UnknownSdkTracker.isEnabled()) {
            List<UnknownSdkFix> list2 = List.of();
            if (list2 == null) {
                UnknownSdkTracker.$$$reportNull$$$0(5);
            }
            return list2;
        }
        UnknownSdkSnapshot snapshot = collector2.collectSdksBlocking();
        Function<ProgressIndicator, List<UnknownSdkFix>> action2 = this.createProcessSdksAction(snapshot);
        List<UnknownSdkFix> list3 = action2 == null ? List.of() : action2.apply(indicator);
        if (list3 == null) {
            UnknownSdkTracker.$$$reportNull$$$0(6);
        }
        return list3;
    }

    @NotNull
    private UnknownSdkTrackerTask newUpdateTask(final @NotNull ShowStatusCallback showStatus, final @NotNull Predicate<? super UnknownSdkSnapshot> shouldProcessSnapshot) {
        if (showStatus == null) {
            UnknownSdkTracker.$$$reportNull$$$0(7);
        }
        if (shouldProcessSnapshot == null) {
            UnknownSdkTracker.$$$reportNull$$$0(8);
        }
        return new UnknownSdkTrackerTask(){

            @Override
            @Nullable
            public UnknownSdkCollector createCollector() {
                if (!UnknownSdkTracker.isEnabled() || !Registry.is("unknown.sdk.auto")) {
                    showStatus.showEmptyStatus();
                    return null;
                }
                return new UnknownSdkCollector(UnknownSdkTracker.this.myProject);
            }

            @Override
            public void onLookupCompleted(@NotNull UnknownSdkSnapshot snapshot) {
                if (snapshot == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (!shouldProcessSnapshot.test(snapshot)) {
                    return;
                }
                final Progressive action2 = UnknownSdkTracker.this.createProcessSdksAction(snapshot, showStatus);
                if (action2 == null) {
                    return;
                }
                ProgressManager.getInstance().run(new Task.Backgroundable(UnknownSdkTracker.this.myProject, ProjectBundle.message((String)"progress.title.resolving.sdks", (Object[])new Object[0]), false, PerformInBackgroundOption.ALWAYS_BACKGROUND){

                    @Override
                    public void run(@NotNull ProgressIndicator indicator) {
                        if (indicator == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        action2.run(indicator);
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/openapi/projectRoots/impl/UnknownSdkTracker$1$1", "run"));
                    }
                });
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "snapshot", "com/intellij/openapi/projectRoots/impl/UnknownSdkTracker$1", "onLookupCompleted"));
            }
        };
    }

    public void updateUnknownSdks() {
        UnknownSdkTrackerQueue.getInstance(this.myProject).queue(this.newUpdateTask(new DefaultShowStatusCallbackAdapter(), this.myIsNewSnapshot));
    }

    private static boolean allowFixesFor(@NotNull SdkTypeId type) {
        if (type == null) {
            UnknownSdkTracker.$$$reportNull$$$0(9);
        }
        return UnknownSdkResolver.EP_NAME.findFirstSafe(it -> it.supportsResolution(type)) != null;
    }

    @NotNull
    private static <E extends UnknownSdk> List<E> filterOnlyAllowedEntries(@NotNull List<? extends E> input) {
        if (input == null) {
            UnknownSdkTracker.$$$reportNull$$$0(10);
        }
        ArrayList<UnknownSdk> copy2 = new ArrayList<UnknownSdk>();
        for (UnknownSdk item : input) {
            SdkType type = item.getSdkType();
            if (!UnknownSdkTracker.allowFixesFor((SdkTypeId)type)) continue;
            copy2.add(item);
        }
        ArrayList<UnknownSdk> arrayList = copy2;
        if (arrayList == null) {
            UnknownSdkTracker.$$$reportNull$$$0(11);
        }
        return arrayList;
    }

    @NotNull
    private static List<Sdk> filterOnlyAllowedSdkEntries(@NotNull List<? extends Sdk> input) {
        if (input == null) {
            UnknownSdkTracker.$$$reportNull$$$0(12);
        }
        ArrayList<Sdk> copy2 = new ArrayList<Sdk>();
        for (Sdk sdk2 : input) {
            SdkTypeId type = sdk2.getSdkType();
            if (!UnknownSdkTracker.allowFixesFor(type)) continue;
            copy2.add(sdk2);
        }
        ArrayList<Sdk> arrayList = copy2;
        if (arrayList == null) {
            UnknownSdkTracker.$$$reportNull$$$0(13);
        }
        return arrayList;
    }

    @Nullable
    private Function<ProgressIndicator, List<UnknownSdkFix>> createProcessSdksAction(@NotNull UnknownSdkSnapshot snapshot) {
        if (snapshot == null) {
            UnknownSdkTracker.$$$reportNull$$$0(14);
        }
        List<UnknownSdk> fixable = UnknownSdkTracker.filterOnlyAllowedEntries(snapshot.getResolvableSdks());
        List<Sdk> usedSdks = UnknownSdkTracker.filterOnlyAllowedSdkEntries(snapshot.getKnownSdks());
        if (fixable.isEmpty() && usedSdks.isEmpty()) {
            return null;
        }
        return indicator -> {
            try {
                List<Object> invalidSdks = new ArrayList();
                Map<Object, Object> localFixes = new HashMap();
                Map<Object, Object> downloadFixes = new HashMap();
                if (!usedSdks.isEmpty()) {
                    indicator.pushState();
                    indicator.setText(ProjectBundle.message((String)"progress.text.resolving.existing.sdks", (Object[])new Object[0]));
                    invalidSdks = UnknownInvalidSdk.resolveInvalidSdks(usedSdks);
                    fixable.addAll(invalidSdks);
                    indicator.popState();
                }
                if (!fixable.isEmpty()) {
                    indicator.pushState();
                    indicator.setText(ProjectBundle.message((String)"progress.text.resolving.missing.sdks", (Object[])new Object[0]));
                    List<UnknownSdkResolver.UnknownSdkLookup> lookups = this.collectSdkLookups((ProgressIndicator)indicator);
                    if (!lookups.isEmpty()) {
                        indicator.setText(ProjectBundle.message((String)"progress.text.looking.for.local.sdks", (Object[])new Object[0]));
                        localFixes = UnknownSdkTracker.findFixesAndRemoveFixable(indicator, fixable, lookups, UnknownSdkResolver.UnknownSdkLookup::proposeLocalFix);
                        if (!fixable.isEmpty()) {
                            indicator.setText(ProjectBundle.message((String)"progress.text.looking.for.downloadable.sdks", (Object[])new Object[0]));
                            downloadFixes = UnknownSdkTracker.findFixesAndRemoveFixable(indicator, fixable, lookups, UnknownSdkResolver.UnknownSdkLookup::proposeDownload);
                        }
                    }
                    indicator.popState();
                }
                ArrayList<UnknownSdkFix> fixProposals = new ArrayList<UnknownSdkFix>();
                fixable.removeAll(invalidSdks);
                for (UnknownInvalidSdk unknownInvalidSdk : invalidSdks) {
                    UnknownSdkLocalSdkFix localSdkFix = (UnknownSdkLocalSdkFix)localFixes.remove(unknownInvalidSdk);
                    UnknownSdkDownloadableSdkFix downloadableSdkFix = (UnknownSdkDownloadableSdkFix)downloadFixes.remove(unknownInvalidSdk);
                    fixProposals.add(unknownInvalidSdk.buildFix(this.myProject, localSdkFix, downloadableSdkFix));
                }
                HashSet missingSdkSets = new HashSet();
                missingSdkSets.addAll(downloadFixes.keySet());
                missingSdkSets.addAll(localFixes.keySet());
                missingSdkSets.addAll(fixable);
                Set<UnknownSdk> set2 = Set.copyOf(missingSdkSets);
                for (UnknownSdk unknownSdk2 : set2) {
                    String name = unknownSdk2.getSdkName();
                    if (name == null) continue;
                    UnknownSdkDownloadableSdkFix downloadFix = (UnknownSdkDownloadableSdkFix)downloadFixes.get(unknownSdk2);
                    UnknownSdkLocalSdkFix localSdkFix = (UnknownSdkLocalSdkFix)localFixes.get(unknownSdk2);
                    fixProposals.add(UnknownMissingSdk.createMissingSdkFix(this.myProject, unknownSdk2, localSdkFix, downloadFix));
                }
                return List.copyOf(fixProposals);
            }
            catch (Throwable t) {
                if (t instanceof ControlFlowException) {
                    ExceptionUtil.rethrow(t);
                }
                LOG.warn("Failed to complete SDKs lookup. " + t.getMessage(), t);
                return List.of();
            }
        };
    }

    @Nullable
    private Progressive createProcessSdksAction(@NotNull UnknownSdkSnapshot snapshot, @NotNull ShowStatusCallback showStatus) {
        Function<ProgressIndicator, List<UnknownSdkFix>> task2;
        if (snapshot == null) {
            UnknownSdkTracker.$$$reportNull$$$0(15);
        }
        if (showStatus == null) {
            UnknownSdkTracker.$$$reportNull$$$0(16);
        }
        if ((task2 = this.createProcessSdksAction(snapshot)) == null) {
            return null;
        }
        return indicator -> {
            try {
                List result2 = (List)task2.apply(indicator);
                showStatus.showStatus(result2, indicator);
            }
            catch (Throwable t) {
                if (t instanceof ControlFlowException) {
                    showStatus.showInterruptedStatus();
                    ExceptionUtil.rethrow(t);
                }
                LOG.warn("Failed to complete SDKs lookup. " + t.getMessage(), t);
                showStatus.showEmptyStatus();
            }
        };
    }

    @NotNull
    public List<UnknownSdkFix> applyAutoFixesAndNotify(@NotNull List<? extends UnknownSdkFix> fixes, @NotNull ProgressIndicator indicator) {
        if (fixes == null) {
            UnknownSdkTracker.$$$reportNull$$$0(17);
        }
        if (indicator == null) {
            UnknownSdkTracker.$$$reportNull$$$0(18);
        }
        ArrayList<UnknownSdkFix> otherFixes = new ArrayList<UnknownSdkFix>();
        ArrayList<UnknownMissingSdkFixLocal> localFixes = new ArrayList<UnknownMissingSdkFixLocal>();
        for (UnknownSdkFix unknownSdkFix : fixes) {
            UnknownSdkFixAction action2 = unknownSdkFix.getSuggestedFixAction();
            if (action2 instanceof UnknownMissingSdkFixLocal) {
                localFixes.add((UnknownMissingSdkFixLocal)action2);
                continue;
            }
            otherFixes.add(unknownSdkFix);
        }
        if (!localFixes.isEmpty()) {
            indicator.pushState();
            indicator.setText(ProjectBundle.message((String)"progress.text.configuring.sdks", (Object[])new Object[0]));
            for (UnknownMissingSdkFixLocal unknownMissingSdkFixLocal : new ArrayList(localFixes)) {
                try {
                    unknownMissingSdkFixLocal.applySuggestionBlocking(indicator);
                }
                catch (Throwable t) {
                    LOG.warn("Failed to apply SDK fix: " + unknownMissingSdkFixLocal + ". " + t.getMessage(), t);
                    localFixes.remove(unknownMissingSdkFixLocal);
                }
            }
            UnknownSdkBalloonNotification.getInstance(this.myProject).notifyFixedSdks(localFixes);
            indicator.popState();
        }
        ArrayList<UnknownSdkFix> arrayList = otherFixes;
        if (arrayList == null) {
            UnknownSdkTracker.$$$reportNull$$$0(19);
        }
        return arrayList;
    }

    public boolean isAutoFixAction(@Nullable UnknownSdkFixAction fix2) {
        return fix2 instanceof UnknownMissingSdkFixLocal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public Sdk applyAutoFixAndNotify(@NotNull UnknownSdkFixAction fix2, @NotNull ProgressIndicator indicator) throws IllegalArgumentException {
        if (fix2 == null) {
            UnknownSdkTracker.$$$reportNull$$$0(20);
        }
        if (indicator == null) {
            UnknownSdkTracker.$$$reportNull$$$0(21);
        }
        if (!this.isAutoFixAction(fix2)) {
            throw new IllegalArgumentException("The argument must pass #isAutoFixAction test");
        }
        assert (fix2 instanceof UnknownMissingSdkFixLocal) : "Invalid fix: " + fix2;
        indicator.pushState();
        indicator.setText(ProjectBundle.message((String)"progress.text.configuring.sdks", (Object[])new Object[0]));
        Sdk sdk2 = fix2.applySuggestionBlocking(indicator);
        Sdk sdk3 = sdk2;
        if (sdk3 == null) {
            UnknownSdkTracker.$$$reportNull$$$0(22);
        }
        return sdk3;
        finally {
            indicator.popState();
            UnknownSdkBalloonNotification.getInstance(this.myProject).notifyFixedSdks(List.of((UnknownMissingSdkFixLocal)fix2));
        }
    }

    @NotNull
    private List<UnknownSdkResolver.UnknownSdkLookup> collectSdkLookups(@NotNull ProgressIndicator indicator) {
        if (indicator == null) {
            UnknownSdkTracker.$$$reportNull$$$0(23);
        }
        ArrayList<UnknownSdkResolver.UnknownSdkLookup> lookups = new ArrayList<UnknownSdkResolver.UnknownSdkLookup>();
        UnknownSdkResolver.EP_NAME.forEachExtensionSafe(ext -> {
            UnknownSdkResolver.UnknownSdkLookup resolver = ext.createResolver(this.myProject, indicator);
            if (resolver != null) {
                lookups.add(resolver);
            }
        });
        ArrayList<UnknownSdkResolver.UnknownSdkLookup> arrayList = lookups;
        if (arrayList == null) {
            UnknownSdkTracker.$$$reportNull$$$0(24);
        }
        return arrayList;
    }

    @NotNull
    private static <R> Map<UnknownSdk, R> findFixesAndRemoveFixable(@NotNull ProgressIndicator indicator, @NotNull List<UnknownSdk> infos, @NotNull List<? extends UnknownSdkResolver.UnknownSdkLookup> lookups, @NotNull TripleFunction<? super UnknownSdkResolver.UnknownSdkLookup, ? super UnknownSdk, ? super ProgressIndicator, ? extends R> fun) {
        if (indicator == null) {
            UnknownSdkTracker.$$$reportNull$$$0(25);
        }
        if (infos == null) {
            UnknownSdkTracker.$$$reportNull$$$0(26);
        }
        if (lookups == null) {
            UnknownSdkTracker.$$$reportNull$$$0(27);
        }
        if (fun == null) {
            UnknownSdkTracker.$$$reportNull$$$0(28);
        }
        indicator.pushState();
        LinkedHashMap<UnknownSdk, R> result2 = new LinkedHashMap<UnknownSdk, R>();
        Iterator<UnknownSdk> iterator2 = infos.iterator();
        block0: while (iterator2.hasNext()) {
            UnknownSdk info2 = iterator2.next();
            for (UnknownSdkResolver.UnknownSdkLookup unknownSdkLookup : lookups) {
                indicator.pushState();
                R fix2 = fun.fun(unknownSdkLookup, info2, indicator);
                indicator.popState();
                if (fix2 == null) continue;
                result2.put(info2, fix2);
                iterator2.remove();
                continue block0;
            }
        }
        indicator.popState();
        LinkedHashMap<UnknownSdk, R> linkedHashMap = result2;
        if (linkedHashMap == null) {
            UnknownSdkTracker.$$$reportNull$$$0(29);
        }
        return linkedHashMap;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 5, 6, 11, 13, 19, 22, 24, 29 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 11: 
            case 13: 
            case 19: 
            case 22: 
            case 24: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/projectRoots/impl/UnknownSdkTracker";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "collector";
                break;
            }
            case 4: 
            case 18: 
            case 21: 
            case 23: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 7: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "showStatus";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "shouldProcessSnapshot";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "input";
                break;
            }
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "snapshot";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fixes";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fix";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "infos";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lookups";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fun";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/projectRoots/impl/UnknownSdkTracker";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "collectUnknownSdks";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "filterOnlyAllowedEntries";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "filterOnlyAllowedSdkEntries";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "applyAutoFixesAndNotify";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "applyAutoFixAndNotify";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "collectSdkLookups";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "findFixesAndRemoveFixable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 11: 
            case 13: 
            case 19: 
            case 22: 
            case 24: 
            case 29: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "collectUnknownSdks";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "newUpdateTask";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "allowFixesFor";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "filterOnlyAllowedEntries";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "filterOnlyAllowedSdkEntries";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "createProcessSdksAction";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "applyAutoFixesAndNotify";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "applyAutoFixAndNotify";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "collectSdkLookups";
                break;
            }
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "findFixesAndRemoveFixable";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 1, 5, 6, 11, 13, 19, 22, 24, 29 -> new IllegalStateException(string2);
        };
    }

    public static interface ShowStatusCallback {
        public void showStatus(@NotNull List<? extends UnknownSdkFix> var1, @NotNull ProgressIndicator var2);

        default public void showInterruptedStatus() {
            this.showStatus(Collections.emptyList(), new EmptyProgressIndicator());
        }

        default public void showEmptyStatus() {
            this.showStatus(Collections.emptyList(), new EmptyProgressIndicator());
        }
    }

    private class DefaultShowStatusCallbackAdapter
    implements ShowStatusCallback {
        private DefaultShowStatusCallbackAdapter() {
        }

        @Override
        public void showStatus(@NotNull List<? extends UnknownSdkFix> fixes, @NotNull ProgressIndicator indicator) {
            if (fixes == null) {
                DefaultShowStatusCallbackAdapter.$$$reportNull$$$0(0);
            }
            if (indicator == null) {
                DefaultShowStatusCallbackAdapter.$$$reportNull$$$0(1);
            }
            fixes = UnknownSdkTracker.this.applyAutoFixesAndNotify(fixes, indicator);
            UnknownSdkEditorNotification.getInstance(UnknownSdkTracker.this.myProject).showNotifications(fixes);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "fixes";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "indicator";
                    break;
                }
            }
            objectArray[1] = "com/intellij/openapi/projectRoots/impl/UnknownSdkTracker$DefaultShowStatusCallbackAdapter";
            objectArray[2] = "showStatus";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

