/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.projectRoots.impl.jdkDownloader;

import com.intellij.execution.wsl.WSLDistribution;
import com.intellij.execution.wsl.WslPath;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.projectRoots.JdkUtil;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkType;
import com.intellij.openapi.projectRoots.SdkTypeId;
import com.intellij.openapi.projectRoots.SimpleJavaSdkType;
import com.intellij.openapi.projectRoots.impl.MockSdk;
import com.intellij.openapi.projectRoots.impl.jdkDownloader.JarSdkConfigurator;
import com.intellij.openapi.projectRoots.impl.jdkDownloader.JdkAuto;
import com.intellij.openapi.projectRoots.impl.jdkDownloader.JdkAutoHint;
import com.intellij.openapi.projectRoots.impl.jdkDownloader.JdkAutoHintService;
import com.intellij.openapi.projectRoots.impl.jdkDownloader.JdkAutoHints;
import com.intellij.openapi.projectRoots.impl.jdkDownloader.JdkAutoKt;
import com.intellij.openapi.projectRoots.impl.jdkDownloader.JdkDownloaderBase;
import com.intellij.openapi.projectRoots.impl.jdkDownloader.JdkInstallRequest;
import com.intellij.openapi.projectRoots.impl.jdkDownloader.JdkInstaller;
import com.intellij.openapi.projectRoots.impl.jdkDownloader.JdkItem;
import com.intellij.openapi.projectRoots.impl.jdkDownloader.JdkListDownloader;
import com.intellij.openapi.projectRoots.impl.jdkDownloader.JdkPredicate;
import com.intellij.openapi.projectRoots.impl.jdkDownloader.JdkRequirement;
import com.intellij.openapi.projectRoots.impl.jdkDownloader.JdkRequirements;
import com.intellij.openapi.roots.ui.configuration.SdkDetector;
import com.intellij.openapi.roots.ui.configuration.UnknownSdk;
import com.intellij.openapi.roots.ui.configuration.UnknownSdkDownloadableSdkFix;
import com.intellij.openapi.roots.ui.configuration.UnknownSdkFixConfigurator;
import com.intellij.openapi.roots.ui.configuration.UnknownSdkLocalSdkFix;
import com.intellij.openapi.roots.ui.configuration.UnknownSdkResolver;
import com.intellij.openapi.roots.ui.configuration.projectRoot.SdkDownloadTask;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.lang.JavaVersion;
import com.intellij.util.text.StringKt;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.java.JdkVersionDetector;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002:\u0001\u000fB\u0005\u00a2\u0006\u0002\u0010\u0003J\u001c\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u001a\u0010\n\u001a\u0004\u0018\u00010\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\tJ\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016\u00a8\u0006\u0010"}, d2={"Lcom/intellij/openapi/projectRoots/impl/jdkDownloader/JdkAuto;", "Lcom/intellij/openapi/roots/ui/configuration/UnknownSdkResolver;", "Lcom/intellij/openapi/projectRoots/impl/jdkDownloader/JdkDownloaderBase;", "()V", "createResolver", "Lcom/intellij/openapi/roots/ui/configuration/UnknownSdkResolver$UnknownSdkLookup;", "project", "Lcom/intellij/openapi/project/Project;", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "createResolverImpl", "supportsResolution", "", "sdkTypeId", "Lcom/intellij/openapi/projectRoots/SdkTypeId;", "JavaLocalSdkFix", "intellij.platform.lang.impl"})
@SourceDebugExtension(value={"SMAP\nJdkAuto.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JdkAuto.kt\ncom/intellij/openapi/projectRoots/impl/jdkDownloader/JdkAuto\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,304:1\n3133#2,11:305\n*S KotlinDebug\n*F\n+ 1 JdkAuto.kt\ncom/intellij/openapi/projectRoots/impl/jdkDownloader/JdkAuto\n*L\n98#1:305,11\n*E\n"})
public final class JdkAuto
implements UnknownSdkResolver,
JdkDownloaderBase {
    @Override
    public boolean supportsResolution(@NotNull SdkTypeId sdkTypeId) {
        Intrinsics.checkNotNullParameter((Object)sdkTypeId, (String)"sdkTypeId");
        return SimpleJavaSdkType.notSimpleJavaSdkTypeIfAlternativeExistsAndNotDependentSdkType().value(sdkTypeId);
    }

    @Override
    @Nullable
    public UnknownSdkResolver.UnknownSdkLookup createResolver(@Nullable Project project2, @NotNull ProgressIndicator indicator) {
        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
        if (!Registry.is("jdk.auto.setup")) {
            return null;
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return null;
        }
        return this.createResolverImpl(project2, indicator);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final UnknownSdkResolver.UnknownSdkLookup createResolverImpl(@Nullable Project project2, @NotNull ProgressIndicator indicator) {
        Object v2;
        block3: {
            void $this$singleOrNull$iv;
            Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
            SdkType[] sdkTypeArray = SdkType.getAllTypes();
            Intrinsics.checkNotNullExpressionValue((Object)sdkTypeArray, (String)"getAllTypes()");
            Object[] objectArray = sdkTypeArray;
            Condition condition = SimpleJavaSdkType.notSimpleJavaSdkTypeIfAlternativeExistsAndNotDependentSdkType();
            Intrinsics.checkNotNullExpressionValue((Object)condition, (String)"notSimpleJavaSdkTypeIfAl\u2026sAndNotDependentSdkType()");
            Condition condition2 = condition;
            boolean $i$f$singleOrNull = false;
            Object single$iv = null;
            boolean found$iv = false;
            for (void element$iv : $this$singleOrNull$iv) {
                SdkTypeId p0 = (SdkTypeId)element$iv;
                boolean bl = false;
                if (!condition2.value(p0)) continue;
                if (found$iv) {
                    v2 = null;
                    break block3;
                }
                single$iv = element$iv;
                found$iv = true;
            }
            v2 = !found$iv ? null : single$iv;
        }
        SdkType sdkType = v2;
        if (sdkType == null) {
            return null;
        }
        SdkType sdkType2 = sdkType;
        return new UnknownSdkResolver.UnknownSdkLookup(project2, indicator, sdkType2, this){
            @NotNull
            private final Lazy projectWslDistribution$delegate;
            @NotNull
            private final Lazy projectInWsl$delegate;
            @NotNull
            private final Lazy lazyDownloadModel$delegate;
            @NotNull
            private final Lazy lazyLocalJdks$delegate;
            final /* synthetic */ Project $project;
            final /* synthetic */ SdkType $sdkType;
            final /* synthetic */ JdkAuto this$0;
            {
                this.$project = $project;
                this.$sdkType = $sdkType;
                this.this$0 = $receiver;
                this.projectWslDistribution$delegate = LazyKt.lazy((Function0)((Function0)new Function0<WSLDistribution>($project){
                    final /* synthetic */ Project $project;
                    {
                        this.$project = $project;
                        super(0);
                    }

                    @Nullable
                    public final WSLDistribution invoke() {
                        WSLDistribution wSLDistribution;
                        Object object = this.$project;
                        if (object != null && (object = object.getBasePath()) != null) {
                            Object it = object;
                            boolean bl = false;
                            wSLDistribution = WslPath.Companion.getDistributionByWindowsUncPath((String)it);
                        } else {
                            wSLDistribution = null;
                        }
                        return wSLDistribution;
                    }
                }));
                this.projectInWsl$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Boolean>($project){
                    final /* synthetic */ Project $project;
                    {
                        this.$project = $project;
                        super(0);
                    }

                    @NotNull
                    public final Boolean invoke() {
                        boolean bl;
                        Object object = this.$project;
                        if (object != null && (object = object.getBasePath()) != null) {
                            Object it = object;
                            boolean bl2 = false;
                            bl = WslPath.Companion.isWslUncPath((String)it);
                        } else {
                            bl = false;
                        }
                        return bl;
                    }
                }));
                this.lazyDownloadModel$delegate = LazyKt.lazy((Function0)((Function0)new Function0<List<? extends JdkItem>>($indicator, this){
                    final /* synthetic */ ProgressIndicator $indicator;
                    final /* synthetic */ createResolverImpl.1 this$0;
                    {
                        this.$indicator = $indicator;
                        this.this$0 = $receiver;
                        super(0);
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @NotNull
                    public final List<JdkItem> invoke() {
                        List<JdkItem> list2;
                        this.$indicator.pushState();
                        this.$indicator.setText(ProjectBundle.message((String)"progress.text.downloading.jdk.list", (Object[])new Object[0]));
                        try {
                            JdkPredicate jdkPredicate = this.this$0.getProjectInWsl() ? JdkPredicate.Companion.forWSL() : JdkPredicate.Companion.default();
                            list2 = JdkListDownloader.Companion.getInstance().downloadModelForJdkInstaller(this.$indicator, jdkPredicate);
                        }
                        catch (ProcessCanceledException e) {
                            throw e;
                        }
                        catch (Throwable t) {
                            JdkAutoKt.access$getLOG$p().warn("JdkAuto has failed to download the list of available JDKs. " + t.getMessage(), t);
                            list2 = CollectionsKt.emptyList();
                        }
                        finally {
                            this.$indicator.popState();
                        }
                        return list2;
                    }
                }));
                this.lazyLocalJdks$delegate = LazyKt.lazy((Function0)((Function0)new Function0<List<JavaLocalSdkFix>>($indicator, $sdkType){
                    final /* synthetic */ ProgressIndicator $indicator;
                    final /* synthetic */ SdkType $sdkType;
                    {
                        this.$indicator = $indicator;
                        this.$sdkType = $sdkType;
                        super(0);
                    }

                    @NotNull
                    public final List<JavaLocalSdkFix> invoke() {
                        List list2;
                        this.$indicator.setText(ProjectBundle.message((String)"progress.text.detecting.local.jdks", (Object[])new Object[0]));
                        List result2 = new ArrayList<E>();
                        SdkDetector.getInstance().detectSdks(this.$sdkType, this.$indicator, new SdkDetector.DetectedSdkListener(result2){
                            final /* synthetic */ List<JavaLocalSdkFix> $result;
                            {
                                this.$result = $result;
                            }

                            public void onSdkDetected(@NotNull SdkType type, @NotNull String version, @NotNull String home2) {
                                Intrinsics.checkNotNullParameter((Object)type, (String)"type");
                                Intrinsics.checkNotNullParameter((Object)version, (String)"version");
                                Intrinsics.checkNotNullParameter((Object)home2, (String)"home");
                                JavaVersion javaVersion = JavaVersion.tryParse(version);
                                if (javaVersion == null) {
                                    return;
                                }
                                JavaVersion javaVersion2 = javaVersion;
                                String string2 = JdkUtil.suggestJdkName((String)version);
                                if (string2 == null) {
                                    return;
                                }
                                String suggestedName = string2;
                                ((Collection)this.$result).add(new JavaLocalSdkFix(home2, javaVersion2, suggestedName, null, null, 24, null));
                            }
                        });
                        List it = list2 = result2;
                        boolean bl = false;
                        JdkAutoKt.access$getLOG$p().info(CollectionsKt.joinToString$default((Iterable)result2, null, (CharSequence)"The following local JDKs were found: ", null, (int)0, null, (Function1)createResolverImpl.lazyLocalJdks.2.1.INSTANCE, (int)29, null));
                        return list2;
                    }
                }));
            }

            @Nullable
            public final WSLDistribution getProjectWslDistribution() {
                Lazy lazy = this.projectWslDistribution$delegate;
                return (WSLDistribution)lazy.getValue();
            }

            public final boolean getProjectInWsl() {
                Lazy lazy = this.projectInWsl$delegate;
                return (Boolean)lazy.getValue();
            }

            @NotNull
            public final List<JdkItem> getLazyDownloadModel() {
                Lazy lazy = this.lazyDownloadModel$delegate;
                return (List)lazy.getValue();
            }

            /*
             * Unable to fully structure code
             */
            private final JdkAutoHint resolveHint(UnknownSdk sdk) {
                block9: {
                    if (!Intrinsics.areEqual((Object)sdk.getSdkType(), (Object)this.$sdkType)) {
                        return null;
                    }
                    if (this.$project == null) {
                        return null;
                    }
                    v0 = sdk.getSdkName();
                    if (v0 == null) {
                        return null;
                    }
                    sdkName = v0;
                    $this$singleOrNull$iv = ((JdkAutoHints)JdkAutoHintService.Companion.getInstance(this.$project).getState()).getJdks();
                    $i$f$singleOrNull = false;
                    single$iv = null;
                    found$iv = false;
                    for (T element$iv : $this$singleOrNull$iv) {
                        it = (JdkAutoHint)element$iv;
                        $i$a$-singleOrNull-JdkAuto$createResolverImpl$1$resolveHint$1 = false;
                        if (!StringsKt.equals((String)it.getName(), (String)sdkName, (boolean)true)) ** GOTO lbl-1000
                        if (it.getPath() != null) {
                            $i$a$-let-JdkAuto$createResolverImpl$1$resolveHint$1$1 = false;
                            v1 = this.getProjectInWsl() == WslPath.Companion.isWslUncPath(path);
                        } else {
                            v1 = false;
                        }
                        if (v1) {
                            v2 = true;
                        } else lbl-1000:
                        // 2 sources

                        {
                            v2 = false;
                        }
                        if (!v2) continue;
                        if (found$iv) {
                            v3 = null;
                            break block9;
                        }
                        single$iv = element$iv;
                        found$iv = true;
                    }
                    v3 = found$iv == false ? null : single$iv;
                }
                return v3;
            }

            private final JdkRequirement parseSdkRequirement(UnknownSdk sdk2) {
                Object object;
                block5: {
                    block4: {
                        JdkAutoHint hint = this.resolveHint(sdk2);
                        object = hint;
                        if (object == null || (object = ((JdkAutoHint)object).getVersion()) == null || (object = ((Object)StringsKt.trim((CharSequence)((CharSequence)object))).toString()) == null) break block4;
                        String string2 = ((String)object).toLowerCase();
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).toLowerCase()");
                        object = string2;
                        if (string2 != null && (object = StringKt.nullize((String)object, true)) != null) break block5;
                    }
                    JavaVersion javaVersion = JavaVersion.tryParse(sdk2.getExpectedVersionString());
                    object = javaVersion != null ? javaVersion.toFeatureMinorUpdateString() : null;
                    if (object == null) {
                        object = sdk2.getSdkName();
                    }
                }
                Object namePredicate = object;
                return JdkRequirements.INSTANCE.parseRequirement((String)namePredicate, sdk2.getSdkVersionStringPredicate(), sdk2.getSdkHomePredicate());
            }

            private final UnknownSdkLocalSdkFix resolveHintPath(UnknownSdk sdk2, ProgressIndicator indicator) {
                Object object;
                JdkAutoHint hint = this.resolveHint(sdk2);
                Object object2 = hint;
                if (object2 == null || (object2 = ((JdkAutoHint)object2).getPath()) == null) {
                    return null;
                }
                Object path2 = object2;
                Object[] objectArray = new Object[]{path2};
                indicator.setText(ProjectBundle.message((String)"progress.text.resolving.hint.path", (Object[])objectArray));
                if (!new File((String)path2).isDirectory()) {
                    return null;
                }
                Object object3 = this;
                SdkType sdkType = this.$sdkType;
                try {
                    createResolverImpl.1 $this$resolveHintPath_u24lambda_u242 = object3;
                    boolean bl = false;
                    object = Result.constructor-impl((Object)sdkType.getVersionString((String)path2));
                }
                catch (Throwable throwable) {
                    object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
                }
                object3 = object;
                String string2 = (String)(Result.isFailure-impl((Object)object3) ? null : object3);
                if (string2 == null) {
                    return null;
                }
                String version = string2;
                return new UnknownSdkLocalSdkFix(hint, (String)path2, version, this.$sdkType){
                    private final /* synthetic */ JarSdkConfigurator $$delegate_0;
                    final /* synthetic */ JdkAutoHint $hint;
                    final /* synthetic */ String $path;
                    final /* synthetic */ String $version;
                    final /* synthetic */ SdkType $sdkType;
                    {
                        this.$hint = $hint;
                        this.$path = $path;
                        this.$version = $version;
                        this.$sdkType = $sdkType;
                        this.$$delegate_0 = new JarSdkConfigurator($hint.getIncludeJars());
                    }

                    public void configureSdk(@NotNull Sdk sdk2) {
                        Intrinsics.checkNotNullParameter((Object)sdk2, (String)"sdk");
                        this.$$delegate_0.configureSdk(sdk2);
                    }

                    @NotNull
                    public String getExistingSdkHome() {
                        return this.$path;
                    }

                    @NotNull
                    public String getVersionString() {
                        return this.$version;
                    }

                    @NotNull
                    public String getSuggestedSdkName() {
                        String string2 = this.$hint.getPath();
                        if (string2 == null) {
                            return "";
                        }
                        String hintPath = string2;
                        String string3 = this.$sdkType.suggestSdkName(null, hintPath);
                        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"sdkType.suggestSdkName(null, hintPath)");
                        return string3;
                    }

                    @NotNull
                    public String toString() {
                        return "UnknownSdkLocalSdkFix{hint " + this.$version + ", " + this.$path + "}";
                    }
                };
            }

            /*
             * WARNING - void declaration
             */
            @Nullable
            public UnknownSdkDownloadableSdkFix proposeDownload(@NotNull UnknownSdk sdk2, @NotNull ProgressIndicator indicator) {
                Object v1;
                void $this$maxByOrNull$iv;
                Intrinsics.checkNotNullParameter((Object)sdk2, (String)"sdk");
                Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                if (!Intrinsics.areEqual((Object)sdk2.getSdkType(), (Object)this.$sdkType)) {
                    return null;
                }
                JdkRequirement jdkRequirement = this.parseSdkRequirement(sdk2);
                if (jdkRequirement == null) {
                    return null;
                }
                JdkRequirement req = jdkRequirement;
                JdkAutoKt.access$getLOG$p().info("Looking for a possible download for " + sdk2.getSdkType().getPresentableName() + " with name " + sdk2);
                Object object = SequencesKt.mapNotNull((Sequence)SequencesKt.filter((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)this.getLazyDownloadModel()), (Function1)((Function1)new Function1<JdkItem, Boolean>(req){
                    final /* synthetic */ JdkRequirement $req;
                    {
                        this.$req = $req;
                        super(1);
                    }

                    @NotNull
                    public final Boolean invoke(@NotNull JdkItem it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        return this.$req.matches(it);
                    }
                })), (Function1)createResolverImpl.proposeDownload.jdkToDownload.2.INSTANCE), (Function1)createResolverImpl.proposeDownload.jdkToDownload.3.INSTANCE);
                boolean $i$f$maxByOrNull = false;
                Iterator iterator$iv = $this$maxByOrNull$iv.iterator();
                if (!iterator$iv.hasNext()) {
                    v1 = null;
                } else {
                    E maxElem$iv = iterator$iv.next();
                    if (!iterator$iv.hasNext()) {
                        v1 = maxElem$iv;
                    } else {
                        Pair it = (Pair)maxElem$iv;
                        boolean bl = false;
                        Comparable maxValue$iv = (JavaVersion)it.getSecond();
                        do {
                            E e$iv = iterator$iv.next();
                            Pair it2 = (Pair)e$iv;
                            $i$a$-maxByOrNull-JdkAuto$createResolverImpl$1$proposeDownload$jdkToDownload$4 = false;
                            Comparable v$iv = (JavaVersion)it2.getSecond();
                            if (maxValue$iv.compareTo(v$iv) >= 0) continue;
                            maxElem$iv = e$iv;
                            maxValue$iv = v$iv;
                        } while (iterator$iv.hasNext());
                        v1 = maxElem$iv;
                    }
                }
                Pair pair = v1;
                if (pair == null || (object = (JdkItem)pair.getFirst()) == null) {
                    return null;
                }
                Object jdkToDownload2 = object;
                Object object2 = this.resolveHint(sdk2);
                if (object2 == null || (object2 = ((JdkAutoHint)object2).getIncludeJars()) == null) {
                    object2 = CollectionsKt.emptyList();
                }
                JarSdkConfigurator jarConfigurator = new JarSdkConfigurator((List<String>)object2);
                return new UnknownSdkDownloadableSdkFix(jarConfigurator, (JdkItem)jdkToDownload2, this, this.this$0, this.$project){
                    private final /* synthetic */ JarSdkConfigurator $$delegate_0;
                    final /* synthetic */ JdkItem $jdkToDownload;
                    final /* synthetic */ createResolverImpl.1 this$0;
                    final /* synthetic */ JdkAuto this$1;
                    final /* synthetic */ Project $project;
                    {
                        this.$jdkToDownload = $jdkToDownload;
                        this.this$0 = $receiver;
                        this.this$1 = $receiver2;
                        this.$project = $project;
                        this.$$delegate_0 = $jarConfigurator;
                    }

                    public void configureSdk(@NotNull Sdk sdk2) {
                        Intrinsics.checkNotNullParameter((Object)sdk2, (String)"sdk");
                        this.$$delegate_0.configureSdk(sdk2);
                    }

                    @NotNull
                    public String getVersionString() {
                        return this.$jdkToDownload.getVersionString();
                    }

                    @NotNull
                    public String getPresentableVersionString() {
                        return this.$jdkToDownload.getPresentableVersionString();
                    }

                    @NotNull
                    public String getDownloadDescription() {
                        return this.$jdkToDownload.getFullPresentationText();
                    }

                    @NotNull
                    public SdkDownloadTask createTask(@NotNull ProgressIndicator indicator) {
                        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                        JdkInstaller jdkInstaller = JdkInstaller.Companion.getInstance();
                        Path homeDir = jdkInstaller.defaultInstallDir(this.$jdkToDownload, this.this$0.getProjectWslDistribution());
                        JdkInstallRequest request2 = jdkInstaller.prepareJdkInstallation(this.$jdkToDownload, homeDir);
                        return this.this$1.newDownloadTask(request2, this.$project);
                    }

                    @NotNull
                    public String toString() {
                        return "UnknownSdkDownloadableFix{" + this.$jdkToDownload.getFullPresentationText() + ", wsl=" + this.this$0.getProjectWslDistribution() + "}";
                    }
                };
            }

            @NotNull
            public final List<JavaLocalSdkFix> getLazyLocalJdks() {
                Lazy lazy = this.lazyLocalJdks$delegate;
                return (List)lazy.getValue();
            }

            /*
             * WARNING - void declaration
             */
            @Nullable
            public UnknownSdkLocalSdkFix proposeLocalFix(@NotNull UnknownSdk sdk2, @NotNull ProgressIndicator indicator) {
                JavaLocalSdkFix javaLocalSdkFix;
                JavaLocalSdkFix localSdkFix;
                Intrinsics.checkNotNullParameter((Object)sdk2, (String)"sdk");
                Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                if (!Intrinsics.areEqual((Object)sdk2.getSdkType(), (Object)this.$sdkType)) {
                    return null;
                }
                UnknownSdkLocalSdkFix hintMatch = this.resolveHintPath(sdk2, indicator);
                if (hintMatch != null) {
                    JdkAutoKt.access$getLOG$p().info("Found hint path for local SDK: path " + hintMatch.getExistingSdkHome());
                    return hintMatch;
                }
                JdkRequirement jdkRequirement = this.parseSdkRequirement(sdk2);
                if (jdkRequirement == null) {
                    createResolverImpl.1 $this$proposeLocalFix_u24lambda_u244 = this;
                    boolean bl = false;
                    JdkAutoKt.access$getLOG$p().info("Failed to parse unknown SDK requirement " + sdk2);
                    return null;
                }
                JdkRequirement req = jdkRequirement;
                JdkAutoKt.access$getLOG$p().info("Looking for a local SDK for " + sdk2.getSdkType().getPresentableName() + " with name " + sdk2);
                SdkType sdkType = sdk2.getSdkType();
                Intrinsics.checkNotNullExpressionValue((Object)sdkType, (String)"sdk.sdkType");
                JavaLocalSdkFix javaLocalSdkFix2 = createResolverImpl.1.proposeLocalFix$pickBestMatch(this.filterByWsl(this.tryUsingExistingSdk(req, sdkType, indicator)));
                if (javaLocalSdkFix2 == null) {
                    void $this$filterTo$iv$iv;
                    void $this$filter$iv;
                    Iterable $this$proposeLocalFix_u24lambda_u244 = this.getLazyLocalJdks();
                    createResolverImpl.1 var15_9 = this;
                    boolean $i$f$filter = false;
                    void var8_10 = $this$filter$iv;
                    Collection destination$iv$iv = new ArrayList<E>();
                    boolean $i$f$filterTo = false;
                    for (T element$iv$iv : $this$filterTo$iv$iv) {
                        JavaLocalSdkFix it = (JavaLocalSdkFix)element$iv$iv;
                        boolean bl = false;
                        if (!req.matches(it)) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    javaLocalSdkFix2 = createResolverImpl.1.proposeLocalFix$pickBestMatch(var15_9.filterByWsl((List)destination$iv$iv));
                }
                JavaLocalSdkFix javaLocalSdkFix3 = localSdkFix = javaLocalSdkFix2;
                if (javaLocalSdkFix3 != null) {
                    Object object = this.resolveHint(sdk2);
                    if (object == null || (object = ((JdkAutoHint)object).getIncludeJars()) == null) {
                        object = CollectionsKt.emptyList();
                    }
                    javaLocalSdkFix = JavaLocalSdkFix.copy$default(javaLocalSdkFix3, null, null, null, (List)object, null, 23, null);
                } else {
                    javaLocalSdkFix = null;
                }
                return javaLocalSdkFix;
            }

            private final List<JavaLocalSdkFix> tryUsingExistingSdk(JdkRequirement req, SdkType sdkType, ProgressIndicator indicator) {
                indicator.setText(ProjectBundle.message((String)"progress.text.checking.existing.jdks", (Object[])new Object[0]));
                List result2 = new ArrayList<E>();
                T t = ActionsKt.runReadAction(createResolverImpl.tryUsingExistingSdk.1.INSTANCE);
                Intrinsics.checkNotNullExpressionValue(t, (String)"runReadAction { ProjectJ\u2026e.getInstance().allJdks }");
                for (Sdk it : (Sdk[])t) {
                    String suggestedName;
                    JavaVersion version;
                    String homeDir;
                    Object object;
                    Object $this$tryUsingExistingSdk_u24lambda_u2410;
                    String versionString;
                    Object $this$tryUsingExistingSdk_u24lambda_u249;
                    Object $this$tryUsingExistingSdk_u24lambda_u248;
                    Object object2;
                    if (!Intrinsics.areEqual((Object)it.getSdkType(), (Object)sdkType)) continue;
                    Object object3 = this;
                    try {
                        createResolverImpl.1 $this$tryUsingExistingSdk_u24lambda_u247 = object3;
                        boolean bl = false;
                        object2 = Result.constructor-impl((Object)it.getHomePath());
                    }
                    catch (Throwable bl) {
                        object2 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
                    }
                    object3 = object2;
                    if ((String)(Result.isFailure-impl((Object)object3) ? null : object3) == null) continue;
                    object2 = this;
                    try {
                        $this$tryUsingExistingSdk_u24lambda_u248 = object2;
                        boolean bl = false;
                        $this$tryUsingExistingSdk_u24lambda_u248 = Result.constructor-impl((Object)it.getVersionString());
                    }
                    catch (Throwable bl) {
                        $this$tryUsingExistingSdk_u24lambda_u248 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
                    }
                    object2 = $this$tryUsingExistingSdk_u24lambda_u248;
                    if ((String)(Result.isFailure-impl((Object)object2) ? null : object2) == null) continue;
                    $this$tryUsingExistingSdk_u24lambda_u248 = this;
                    try {
                        $this$tryUsingExistingSdk_u24lambda_u249 = $this$tryUsingExistingSdk_u24lambda_u248;
                        boolean bl = false;
                        $this$tryUsingExistingSdk_u24lambda_u249 = Result.constructor-impl((Object)JavaVersion.tryParse(versionString));
                    }
                    catch (Throwable bl) {
                        $this$tryUsingExistingSdk_u24lambda_u249 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
                    }
                    $this$tryUsingExistingSdk_u24lambda_u248 = $this$tryUsingExistingSdk_u24lambda_u249;
                    if ((JavaVersion)(Result.isFailure-impl((Object)$this$tryUsingExistingSdk_u24lambda_u248) ? null : $this$tryUsingExistingSdk_u24lambda_u248) == null) continue;
                    $this$tryUsingExistingSdk_u24lambda_u249 = this;
                    try {
                        $this$tryUsingExistingSdk_u24lambda_u2410 = $this$tryUsingExistingSdk_u24lambda_u249;
                        boolean bl = false;
                        $this$tryUsingExistingSdk_u24lambda_u2410 = Result.constructor-impl((Object)JdkUtil.suggestJdkName((String)versionString));
                    }
                    catch (Throwable throwable) {
                        $this$tryUsingExistingSdk_u24lambda_u2410 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
                    }
                    $this$tryUsingExistingSdk_u24lambda_u249 = $this$tryUsingExistingSdk_u24lambda_u2410;
                    if ((String)(Result.isFailure-impl((Object)$this$tryUsingExistingSdk_u24lambda_u249) ? null : $this$tryUsingExistingSdk_u24lambda_u249) == null) continue;
                    if (!(it instanceof MockSdk)) {
                        Object $this$tryUsingExistingSdk_u24lambda_u2411;
                        object2 = this;
                        try {
                            $this$tryUsingExistingSdk_u24lambda_u2411 = object2;
                            boolean bl = false;
                            String homePath = it.getHomePath();
                            $this$tryUsingExistingSdk_u24lambda_u2411 = Result.constructor-impl((Object)(homePath != null && sdkType.isValidSdkHome(homePath) ? 1 : 0));
                        }
                        catch (Throwable bl) {
                            $this$tryUsingExistingSdk_u24lambda_u2411 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
                        }
                        object2 = $this$tryUsingExistingSdk_u24lambda_u2411;
                        if (!Intrinsics.areEqual((Object)(Result.isFailure-impl((Object)object2) ? null : object2), (Object)true)) continue;
                    }
                    object2 = this;
                    try {
                        createResolverImpl.1 $this$tryUsingExistingSdk_u24lambda_u2412 = object2;
                        boolean bl = false;
                        Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                        object = Result.constructor-impl((Object)req.matches(it));
                    }
                    catch (Throwable throwable) {
                        object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
                    }
                    object2 = object;
                    if (!Intrinsics.areEqual((Object)(Result.isFailure-impl((Object)object2) ? null : object2), (Object)true)) continue;
                    ((Collection)result2).add(new JavaLocalSdkFix(homeDir, version, suggestedName, null, it, 8, null));
                }
                return result2;
            }

            /*
             * WARNING - void declaration
             */
            private final List<JavaLocalSdkFix> filterByWsl(List<JavaLocalSdkFix> $this$filterByWsl) {
                void $this$filterTo$iv$iv;
                Iterable $this$filter$iv = $this$filterByWsl;
                boolean $i$f$filter = false;
                Iterable iterable = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList<E>();
                boolean $i$f$filterTo = false;
                for (T element$iv$iv : $this$filterTo$iv$iv) {
                    JavaLocalSdkFix it = (JavaLocalSdkFix)element$iv$iv;
                    boolean bl = false;
                    if (!(WslPath.Companion.isWslUncPath(it.getHomeDir()) == this.getProjectInWsl())) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                return (List)destination$iv$iv;
            }

            private static final JavaLocalSdkFix proposeLocalFix$pickBestMatch(List<JavaLocalSdkFix> $this$proposeLocalFix_u24pickBestMatch) {
                Object v0;
                Iterable $this$maxByOrNull$iv = $this$proposeLocalFix_u24pickBestMatch;
                boolean $i$f$maxByOrNull = false;
                Iterator<T> iterator$iv = $this$maxByOrNull$iv.iterator();
                if (!iterator$iv.hasNext()) {
                    v0 = null;
                } else {
                    T maxElem$iv = iterator$iv.next();
                    if (!iterator$iv.hasNext()) {
                        v0 = maxElem$iv;
                    } else {
                        JavaLocalSdkFix it = (JavaLocalSdkFix)maxElem$iv;
                        boolean bl = false;
                        Comparable maxValue$iv = it.getVersion();
                        do {
                            T e$iv = iterator$iv.next();
                            JavaLocalSdkFix it2 = (JavaLocalSdkFix)e$iv;
                            $i$a$-maxByOrNull-JdkAuto$createResolverImpl$1$proposeLocalFix$pickBestMatch$1 = false;
                            Comparable v$iv = it2.getVersion();
                            if (maxValue$iv.compareTo(v$iv) >= 0) continue;
                            maxElem$iv = e$iv;
                            maxValue$iv = v$iv;
                        } while (iterator$iv.hasNext());
                        v0 = maxElem$iv;
                    }
                }
                return v0;
            }
        };
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u00012\u00020\u0002B9\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0004\u0012\u000e\b\u0002\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00040\t\u0012\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\u0002\u0010\fJ\t\u0010\u0016\u001a\u00020\u0004H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\u0004H\u00c6\u0003J\u000f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00040\tH\u00c6\u0003J\u000b\u0010\u001a\u001a\u0004\u0018\u00010\u000bH\u00c6\u0003J\u0018\u0010\u001b\u001a\u00020\u001c2\r\b\u0001\u0010\u001d\u001a\u00070\u000b\u00a2\u0006\u0002\b\u001eH\u0096\u0001JC\u0010\u001f\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00042\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\u00042\u000e\b\u0002\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00040\t2\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000bH\u00c6\u0001J\u0013\u0010 \u001a\u00020!2\b\u0010\"\u001a\u0004\u0018\u00010#H\u00d6\u0003J\b\u0010$\u001a\u00020\u0004H\u0016J\r\u0010%\u001a\u00070\u0004\u00a2\u0006\u0002\b\u001eH\u0016J\n\u0010&\u001a\u0004\u0018\u00010\u000bH\u0016J\b\u0010'\u001a\u00020\u0004H\u0016J\r\u0010(\u001a\u00070\u0004\u00a2\u0006\u0002\b\u001eH\u0016J\t\u0010)\u001a\u00020*H\u00d6\u0001J\b\u0010+\u001a\u00020\u0004H\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00040\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0013\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u000eR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006,"}, d2={"Lcom/intellij/openapi/projectRoots/impl/jdkDownloader/JdkAuto$JavaLocalSdkFix;", "Lcom/intellij/openapi/roots/ui/configuration/UnknownSdkLocalSdkFix;", "Lcom/intellij/openapi/roots/ui/configuration/UnknownSdkFixConfigurator;", "homeDir", "", "version", "Lcom/intellij/util/lang/JavaVersion;", "suggestedName", "includeJars", "", "prototype", "Lcom/intellij/openapi/projectRoots/Sdk;", "(Ljava/lang/String;Lcom/intellij/util/lang/JavaVersion;Ljava/lang/String;Ljava/util/List;Lcom/intellij/openapi/projectRoots/Sdk;)V", "getHomeDir", "()Ljava/lang/String;", "getIncludeJars", "()Ljava/util/List;", "getPrototype", "()Lcom/intellij/openapi/projectRoots/Sdk;", "getSuggestedName", "getVersion", "()Lcom/intellij/util/lang/JavaVersion;", "component1", "component2", "component3", "component4", "component5", "configureSdk", "", "sdk", "Lorg/jetbrains/annotations/NotNull;", "copy", "equals", "", "other", "", "getExistingSdkHome", "getPresentableVersionString", "getRegisteredSdkPrototype", "getSuggestedSdkName", "getVersionString", "hashCode", "", "toString", "intellij.platform.lang.impl"})
    private static final class JavaLocalSdkFix
    implements UnknownSdkLocalSdkFix,
    UnknownSdkFixConfigurator {
        @NotNull
        private final String homeDir;
        @NotNull
        private final JavaVersion version;
        @NotNull
        private final String suggestedName;
        @NotNull
        private final List<String> includeJars;
        @Nullable
        private final Sdk prototype;
        private final /* synthetic */ JarSdkConfigurator $$delegate_0;

        public JavaLocalSdkFix(@NotNull String homeDir, @NotNull JavaVersion version, @NotNull String suggestedName, @NotNull List<String> includeJars, @Nullable Sdk prototype) {
            Intrinsics.checkNotNullParameter((Object)homeDir, (String)"homeDir");
            Intrinsics.checkNotNullParameter((Object)version, (String)"version");
            Intrinsics.checkNotNullParameter((Object)suggestedName, (String)"suggestedName");
            Intrinsics.checkNotNullParameter(includeJars, (String)"includeJars");
            this.homeDir = homeDir;
            this.version = version;
            this.suggestedName = suggestedName;
            this.includeJars = includeJars;
            this.prototype = prototype;
            this.$$delegate_0 = new JarSdkConfigurator(includeJars);
        }

        public /* synthetic */ JavaLocalSdkFix(String string2, JavaVersion javaVersion, String string3, List list2, Sdk sdk2, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 8) != 0) {
                list2 = CollectionsKt.emptyList();
            }
            if ((n & 0x10) != 0) {
                sdk2 = null;
            }
            this(string2, javaVersion, string3, list2, sdk2);
        }

        @NotNull
        public final String getHomeDir() {
            return this.homeDir;
        }

        @NotNull
        public final JavaVersion getVersion() {
            return this.version;
        }

        @NotNull
        public final String getSuggestedName() {
            return this.suggestedName;
        }

        @NotNull
        public final List<String> getIncludeJars() {
            return this.includeJars;
        }

        @Nullable
        public final Sdk getPrototype() {
            return this.prototype;
        }

        @Override
        public void configureSdk(@NotNull Sdk sdk2) {
            Intrinsics.checkNotNullParameter((Object)sdk2, (String)"sdk");
            this.$$delegate_0.configureSdk(sdk2);
        }

        @Override
        @NotNull
        public String getExistingSdkHome() {
            return this.homeDir;
        }

        @Override
        @NotNull
        public String getVersionString() {
            String string2 = JdkVersionDetector.formatVersionString((JavaVersion)this.version);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"formatVersionString(version)");
            return string2;
        }

        @Override
        @NotNull
        public String getPresentableVersionString() {
            String string2 = this.version.toFeatureMinorUpdateString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"version.toFeatureMinorUpdateString()");
            return string2;
        }

        @Override
        @NotNull
        public String getSuggestedSdkName() {
            return this.suggestedName;
        }

        @Override
        @Nullable
        public Sdk getRegisteredSdkPrototype() {
            return this.prototype;
        }

        @NotNull
        public String toString() {
            return "UnknownSdkLocalSdkFix{" + this.getPresentableVersionString() + ", dir=" + this.homeDir + "}";
        }

        @NotNull
        public final String component1() {
            return this.homeDir;
        }

        @NotNull
        public final JavaVersion component2() {
            return this.version;
        }

        @NotNull
        public final String component3() {
            return this.suggestedName;
        }

        @NotNull
        public final List<String> component4() {
            return this.includeJars;
        }

        @Nullable
        public final Sdk component5() {
            return this.prototype;
        }

        @NotNull
        public final JavaLocalSdkFix copy(@NotNull String homeDir, @NotNull JavaVersion version, @NotNull String suggestedName, @NotNull List<String> includeJars, @Nullable Sdk prototype) {
            Intrinsics.checkNotNullParameter((Object)homeDir, (String)"homeDir");
            Intrinsics.checkNotNullParameter((Object)version, (String)"version");
            Intrinsics.checkNotNullParameter((Object)suggestedName, (String)"suggestedName");
            Intrinsics.checkNotNullParameter(includeJars, (String)"includeJars");
            return new JavaLocalSdkFix(homeDir, version, suggestedName, includeJars, prototype);
        }

        public static /* synthetic */ JavaLocalSdkFix copy$default(JavaLocalSdkFix javaLocalSdkFix, String string2, JavaVersion javaVersion, String string3, List list2, Sdk sdk2, int n, Object object) {
            if ((n & 1) != 0) {
                string2 = javaLocalSdkFix.homeDir;
            }
            if ((n & 2) != 0) {
                javaVersion = javaLocalSdkFix.version;
            }
            if ((n & 4) != 0) {
                string3 = javaLocalSdkFix.suggestedName;
            }
            if ((n & 8) != 0) {
                list2 = javaLocalSdkFix.includeJars;
            }
            if ((n & 0x10) != 0) {
                sdk2 = javaLocalSdkFix.prototype;
            }
            return javaLocalSdkFix.copy(string2, javaVersion, string3, list2, sdk2);
        }

        public int hashCode() {
            int result2 = this.homeDir.hashCode();
            result2 = result2 * 31 + this.version.hashCode();
            result2 = result2 * 31 + this.suggestedName.hashCode();
            result2 = result2 * 31 + ((Object)this.includeJars).hashCode();
            result2 = result2 * 31 + (this.prototype == null ? 0 : this.prototype.hashCode());
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof JavaLocalSdkFix)) {
                return false;
            }
            JavaLocalSdkFix javaLocalSdkFix = (JavaLocalSdkFix)other;
            if (!Intrinsics.areEqual((Object)this.homeDir, (Object)javaLocalSdkFix.homeDir)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.version, (Object)javaLocalSdkFix.version)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.suggestedName, (Object)javaLocalSdkFix.suggestedName)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.includeJars, javaLocalSdkFix.includeJars)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.prototype, (Object)javaLocalSdkFix.prototype);
        }
    }
}

