/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.projectRoots.impl.jdkDownloader;

import com.intellij.execution.wsl.WSLDistribution;
import com.intellij.execution.wsl.WslPath;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.projectRoots.SdkTypeId;
import com.intellij.openapi.projectRoots.impl.jdkDownloader.JdkDownloadDialogKt;
import com.intellij.openapi.projectRoots.impl.jdkDownloader.JdkDownloaderLogger;
import com.intellij.openapi.projectRoots.impl.jdkDownloader.JdkDownloaderMergedModel;
import com.intellij.openapi.projectRoots.impl.jdkDownloader.JdkDownloaderModel;
import com.intellij.openapi.projectRoots.impl.jdkDownloader.JdkInstaller;
import com.intellij.openapi.projectRoots.impl.jdkDownloader.JdkItem;
import com.intellij.openapi.projectRoots.impl.jdkDownloader.JdkVersionItem;
import com.intellij.openapi.projectRoots.impl.jdkDownloader.JdkVersionVendorCombobox;
import com.intellij.openapi.projectRoots.impl.jdkDownloader.JdkVersionVendorElement;
import com.intellij.openapi.projectRoots.impl.jdkDownloader.JdkVersionVendorItem;
import com.intellij.openapi.ui.BrowseFolderRunnable;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.TextComponentAccessor;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.ui.CollectionComboBoxModel;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.components.ComponentsKt;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComponent;
import javax.swing.ListCellRenderer;
import javax.swing.event.DocumentEvent;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0092\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B)\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\b\u0010\"\u001a\u00020\u0011H\u0014J\n\u0010#\u001a\u0004\u0018\u00010$H\u0014J\u0016\u0010%\u001a\b\u0012\u0004\u0012\u00020\u000f0&2\u0006\u0010'\u001a\u00020\u001cH\u0002J\u0010\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020\u000fH\u0002J\u0012\u0010+\u001a\u00020)2\b\u0010,\u001a\u0004\u0018\u00010-H\u0002J\u0012\u0010.\u001a\u00020)2\b\u0010,\u001a\u0004\u0018\u00010-H\u0002J\u0012\u0010/\u001a\u00020)2\b\u0010,\u001a\u0004\u0018\u00010!H\u0002J\u0014\u00100\u001a\u0010\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u000202\u0018\u000101J\u0010\u00103\u001a\u00020)2\u0006\u00104\u001a\u000205H\u0002J1\u00106\u001a\u00020)\"\u0006\b\u0000\u00107\u0018\u0001*\b\u0012\u0004\u0012\u0002H70\u000e2\u0014\b\u0004\u00108\u001a\u000e\u0012\u0004\u0012\u0002H7\u0012\u0004\u0012\u00020)09H\u0082\bJ#\u0010:\u001a\u00020)*\u00020\u00132\u0014\b\u0004\u00108\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020)09H\u0082\bR\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\r\u001a\n\u0012\u0004\u0012\u00020\u000f\u0018\u00010\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u000e\u0010\u001b\u001a\u00020\u001cX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u000fX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010 \u001a\b\u0012\u0004\u0012\u00020!0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006;"}, d2={"Lcom/intellij/openapi/projectRoots/impl/jdkDownloader/JdkDownloadDialog;", "Lcom/intellij/openapi/ui/DialogWrapper;", "project", "Lcom/intellij/openapi/project/Project;", "parentComponent", "Ljava/awt/Component;", "sdkType", "Lcom/intellij/openapi/projectRoots/SdkTypeId;", "mergedModel", "Lcom/intellij/openapi/projectRoots/impl/jdkDownloader/JdkDownloaderMergedModel;", "(Lcom/intellij/openapi/project/Project;Ljava/awt/Component;Lcom/intellij/openapi/projectRoots/SdkTypeId;Lcom/intellij/openapi/projectRoots/impl/jdkDownloader/JdkDownloaderMergedModel;)V", "currentModel", "Lcom/intellij/openapi/projectRoots/impl/jdkDownloader/JdkDownloaderModel;", "installDirCombo", "Lcom/intellij/openapi/ui/ComboBox;", "", "installDirComponent", "Ljavax/swing/JComponent;", "installDirTextField", "Lcom/intellij/openapi/ui/TextFieldWithBrowseButton;", "panel", "getParentComponent", "()Ljava/awt/Component;", "getProject", "()Lcom/intellij/openapi/project/Project;", "getSdkType", "()Lcom/intellij/openapi/projectRoots/SdkTypeId;", "selectedItem", "Lcom/intellij/openapi/projectRoots/impl/jdkDownloader/JdkItem;", "selectedPath", "vendorComboBox", "Lcom/intellij/openapi/projectRoots/impl/jdkDownloader/JdkVersionVendorCombobox;", "versionComboBox", "Lcom/intellij/openapi/projectRoots/impl/jdkDownloader/JdkVersionItem;", "createCenterPanel", "doValidate", "Lcom/intellij/openapi/ui/ValidationInfo;", "getSuggestedInstallDirs", "", "newVersion", "onTargetPathChanged", "", "path", "onVendorActionItemSelected", "it", "Lcom/intellij/openapi/projectRoots/impl/jdkDownloader/JdkVersionVendorElement;", "onVendorSelectionChange", "onVersionSelectionChange", "selectJdkAndPath", "Lkotlin/Pair;", "Ljava/nio/file/Path;", "setModel", "forWsl", "", "onSelectionChange", "T", "action", "Lkotlin/Function1;", "onTextChange", "intellij.platform.lang.impl"})
@SourceDebugExtension(value={"SMAP\nJdkDownloadDialog.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JdkDownloadDialog.kt\ncom/intellij/openapi/projectRoots/impl/jdkDownloader/JdkDownloadDialog\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,408:1\n395#1,6:409\n403#1,4:415\n403#1,4:419\n1#2:423\n37#3,2:424\n661#4,11:426\n661#4,11:437\n1620#4,3:448\n1549#4:451\n1620#4,3:452\n*S KotlinDebug\n*F\n+ 1 JdkDownloadDialog.kt\ncom/intellij/openapi/projectRoots/impl/jdkDownloader/JdkDownloadDialog\n*L\n275#1:409,6\n284#1:415,4\n285#1:419,4\n308#1:424,2\n311#1:426,11\n315#1:437,11\n357#1:448,3\n359#1:451\n359#1:452,3\n*E\n"})
public final class JdkDownloadDialog
extends DialogWrapper {
    @Nullable
    private final Project project;
    @Nullable
    private final Component parentComponent;
    @NotNull
    private final SdkTypeId sdkType;
    @NotNull
    private final JdkDownloaderMergedModel mergedModel;
    @NotNull
    private final JComponent panel;
    @NotNull
    private final ComboBox<JdkVersionItem> versionComboBox;
    @NotNull
    private final JdkVersionVendorCombobox vendorComboBox;
    @Nullable
    private final TextFieldWithBrowseButton installDirTextField;
    @Nullable
    private final ComboBox<String> installDirCombo;
    @NotNull
    private final JComponent installDirComponent;
    @Nullable
    private JdkDownloaderModel currentModel;
    private JdkItem selectedItem;
    private String selectedPath;

    public JdkDownloadDialog(@Nullable Project project2, @Nullable Component parentComponent, @NotNull SdkTypeId sdkType, @NotNull JdkDownloaderMergedModel mergedModel) {
        Intrinsics.checkNotNullParameter((Object)sdkType, (String)"sdkType");
        Intrinsics.checkNotNullParameter((Object)mergedModel, (String)"mergedModel");
        super(project2, parentComponent, false, DialogWrapper.IdeModalityType.PROJECT);
        this.project = project2;
        this.parentComponent = parentComponent;
        this.sdkType = sdkType;
        this.mergedModel = mergedModel;
        this.setTitle(ProjectBundle.message((String)"dialog.title.download.jdk", (Object[])new Object[0]));
        this.setResizable(false);
        this.versionComboBox = new ComboBox();
        this.versionComboBox.setRenderer((ListCellRenderer)((Object)JdkDownloadDialogKt.access$getJdkVersionItemRenderer$p()));
        this.versionComboBox.setSwingPopup(false);
        this.vendorComboBox = new JdkVersionVendorCombobox();
        if (this.mergedModel.getHasWsl()) {
            this.installDirCombo = new ComboBox();
            this.installDirCombo.setEditable(true);
            this.installDirCombo.initBrowsableEditor((Runnable)new BrowseFolderRunnable(ProjectBundle.message((String)"dialog.title.select.path.to.install.jdk", (Object[])new Object[0]), null, this.project, FileChooserDescriptorFactory.createSingleFolderDescriptor(), (JComponent)this.installDirCombo, TextComponentAccessor.STRING_COMBOBOX_WHOLE_TEXT), this.getDisposable());
            this.installDirCombo.addActionListener(arg_0 -> JdkDownloadDialog._init_$lambda$0(this, arg_0));
            this.installDirTextField = null;
            this.installDirComponent = (JComponent)this.installDirCombo;
        } else {
            String string2 = ProjectBundle.message((String)"dialog.title.select.path.to.install.jdk", (Object[])new Object[0]);
            FileChooserDescriptor fileChooserDescriptor = FileChooserDescriptorFactory.createSingleFolderDescriptor();
            Intrinsics.checkNotNullExpressionValue((Object)fileChooserDescriptor, (String)"createSingleFolderDescriptor()");
            this.installDirTextField = ComponentsKt.textFieldWithBrowseButton$default((Project)this.project, (String)string2, (FileChooserDescriptor)fileChooserDescriptor, null, (int)8, null);
            JdkDownloadDialog jdkDownloadDialog = this;
            TextFieldWithBrowseButton $this$onTextChange$iv = this.installDirTextField;
            boolean $i$f$onTextChange = false;
            $this$onTextChange$iv.getTextField().getDocument().addDocumentListener(new DocumentAdapter($this$onTextChange$iv, this){
                final /* synthetic */ TextFieldWithBrowseButton $this_onTextChange;
                final /* synthetic */ JdkDownloadDialog this$0;
                {
                    this.$this_onTextChange = $receiver;
                    this.this$0 = jdkDownloadDialog;
                }

                protected void textChanged(@NotNull DocumentEvent e) {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    String string2 = this.$this_onTextChange.getText();
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"text");
                    String it = string2;
                    boolean bl = false;
                    JdkDownloadDialog.access$onTargetPathChanged(this.this$0, it);
                }
            });
            this.installDirTextField.getTextField().setColumns(36);
            this.installDirCombo = null;
            this.installDirComponent = (JComponent)this.installDirTextField;
        }
        this.vendorComboBox.onActionItemSelected((Function1<? super JdkVersionVendorItem, Unit>)((Function1)new Function1<JdkVersionVendorElement, Unit>((Object)this){

            public final void invoke(@Nullable JdkVersionVendorElement p0) {
                ((JdkDownloadDialog)((Object)this.receiver)).onVendorActionItemSelected(p0);
            }
        }));
        JdkDownloadDialog this_$iv = this;
        ComboBox<JdkVersionItem> $this$onSelectionChange$iv = this.vendorComboBox;
        boolean $i$f$onSelectionChange = false;
        $this$onSelectionChange$iv.addItemListener(new ItemListener(this){
            final /* synthetic */ JdkDownloadDialog $receiver$inlined;
            {
                this.$receiver$inlined = jdkDownloadDialog;
            }

            public final void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    Object object = e.getItem();
                    if (object == null) {
                        throw new NullPointerException("null cannot be cast to non-null type com.intellij.openapi.projectRoots.impl.jdkDownloader.JdkVersionVendorElement");
                    }
                    JdkVersionVendorElement p0 = (JdkVersionVendorElement)object;
                    boolean bl = false;
                    JdkDownloadDialog.access$onVendorSelectionChange(this.$receiver$inlined, p0);
                }
            }
        });
        this_$iv = this;
        $this$onSelectionChange$iv = this.versionComboBox;
        $i$f$onSelectionChange = false;
        $this$onSelectionChange$iv.addItemListener(new ItemListener(this){
            final /* synthetic */ JdkDownloadDialog $receiver$inlined;
            {
                this.$receiver$inlined = jdkDownloadDialog;
            }

            public final void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    Object object = e.getItem();
                    if (object == null) {
                        throw new NullPointerException("null cannot be cast to non-null type com.intellij.openapi.projectRoots.impl.jdkDownloader.JdkVersionItem");
                    }
                    JdkVersionItem p0 = (JdkVersionItem)object;
                    boolean bl = false;
                    JdkDownloadDialog.access$onVersionSelectionChange(this.$receiver$inlined, p0);
                }
            }
        });
        this.panel = (JComponent)BuilderKt.panel((Function1)((Function1)new Function1<Panel, Unit>(){

            public final void invoke(@NotNull Panel $this$panel) {
                Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
                String string2 = ProjectBundle.message((String)"dialog.row.jdk.version", (Object[])new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(\"dialog.row.jdk.version\")");
                $this$panel.row(string2, (Function1)new Function1<Row, Unit>(){

                    public final void invoke(@NotNull Row $this$row) {
                        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
                        $this$row.cell((JComponent)versionComboBox).widthGroup("combo");
                    }
                });
                String string3 = ProjectBundle.message((String)"dialog.row.jdk.vendor", (Object[])new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(\"dialog.row.jdk.vendor\")");
                $this$panel.row(string3, (Function1)new Function1<Row, Unit>(){

                    public final void invoke(@NotNull Row $this$row) {
                        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
                        $this$row.cell((JComponent)((Object)vendorComboBox)).widthGroup("combo").focused();
                    }
                });
                String string4 = ProjectBundle.message((String)"dialog.row.jdk.location", (Object[])new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"message(\"dialog.row.jdk.location\")");
                $this$panel.row(string4, (Function1)new Function1<Row, Unit>(){

                    public final void invoke(@NotNull Row $this$row) {
                        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
                        $this$row.cell(installDirComponent);
                    }
                });
            }
        }));
        this.myOKAction.putValue("Name", ProjectBundle.message((String)"dialog.button.download.jdk", (Object[])new Object[0]));
        this.setModel(this.mergedModel.getProjectWSLDistribution() != null);
        this.init();
    }

    @Nullable
    public final Project getProject() {
        return this.project;
    }

    @Nullable
    public final Component getParentComponent() {
        return this.parentComponent;
    }

    @NotNull
    public final SdkTypeId getSdkType() {
        return this.sdkType;
    }

    private final void setModel(boolean forWsl) {
        JdkVersionItem jdkVersionItem;
        JdkVersionVendorItem newVendorItem;
        JdkVersionItem newVersionItem;
        Object object;
        JdkDownloaderModel model2 = this.mergedModel.selectModel(forWsl);
        if (this.currentModel == model2) {
            return;
        }
        Object object2 = this.versionComboBox.getSelectedItem();
        JdkVersionItem prevSelectedVersion = object2 instanceof JdkVersionItem ? (JdkVersionItem)object2 : null;
        Object object3 = this.vendorComboBox.getSelectedItem();
        JdkVersionVendorItem jdkVersionVendorItem = object3 instanceof JdkVersionVendorItem ? (JdkVersionVendorItem)object3 : null;
        if (jdkVersionVendorItem != null) {
            Object it = object3 = jdkVersionVendorItem;
            boolean bl = false;
            object = ((JdkVersionVendorItem)it).getCanBeSelected() ? object3 : null;
        } else {
            object = null;
        }
        Object prevSelectedJdk = object;
        this.currentModel = model2;
        Collection $this$toTypedArray$iv = model2.getVersionGroups();
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        this.versionComboBox.setModel((ComboBoxModel)new DefaultComboBoxModel<JdkVersionItem>(thisCollection$iv.toArray(new JdkVersionItem[0])));
        if (prevSelectedVersion != null) {
            Object v2;
            block13: {
                Iterable $this$singleOrNull$iv = model2.getVersionGroups();
                boolean $i$f$singleOrNull = false;
                Object single$iv = null;
                boolean found$iv = false;
                for (Object element$iv : $this$singleOrNull$iv) {
                    JdkVersionItem it = (JdkVersionItem)element$iv;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getJdkVersion(), (Object)prevSelectedVersion.getJdkVersion())) continue;
                    if (found$iv) {
                        v2 = null;
                        break block13;
                    }
                    single$iv = element$iv;
                    found$iv = true;
                }
                v2 = !found$iv ? null : single$iv;
            }
            v3 = v2;
        } else {
            v3 = newVersionItem = null;
        }
        if (newVersionItem != null && prevSelectedJdk != null) {
            Object v4;
            block14: {
                Iterable $this$singleOrNull$iv = CollectionsKt.plus((Collection)newVersionItem.getIncludedItems(), (Iterable)newVersionItem.getExcludedItems());
                boolean $i$f$singleOrNull = false;
                Object single$iv = null;
                boolean found$iv = false;
                for (Object element$iv : $this$singleOrNull$iv) {
                    JdkVersionVendorItem it = (JdkVersionVendorItem)element$iv;
                    boolean bl = false;
                    if (!(it.getCanBeSelected() && Intrinsics.areEqual((Object)it.getItem().getSuggestedSdkName(), (Object)((JdkVersionVendorItem)prevSelectedJdk).getItem().getSuggestedSdkName()))) continue;
                    if (found$iv) {
                        v4 = null;
                        break block14;
                    }
                    single$iv = element$iv;
                    found$iv = true;
                }
                v4 = !found$iv ? null : single$iv;
            }
            v5 = v4;
        } else {
            v5 = newVendorItem = null;
        }
        if ((jdkVersionItem = newVersionItem) == null) {
            jdkVersionItem = model2.getDefaultVersion();
        }
        this.onVersionSelectionChange(jdkVersionItem);
        JdkVersionVendorItem jdkVersionVendorItem2 = newVendorItem;
        if (jdkVersionVendorItem2 == null) {
            jdkVersionVendorItem2 = model2.getDefaultVersionVendor();
        }
        this.onVendorSelectionChange(jdkVersionVendorItem2);
    }

    private final void onTargetPathChanged(String path2) {
        String path3;
        String string2 = FileUtil.expandUserHome(path2);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"expandUserHome(path)");
        this.selectedPath = path3 = string2;
        this.setModel(WslPath.Companion.isWslUncPath(path3));
    }

    private final void onVendorActionItemSelected(JdkVersionVendorElement it) {
        if (!(it instanceof JdkVersionVendorItem)) {
            return;
        }
        JdkVersionItem jdkVersionItem = ((JdkVersionVendorItem)it).getParent();
        if (jdkVersionItem == null) {
            return;
        }
        JdkVersionItem parent2 = jdkVersionItem;
        this.onVersionSelectionChange(parent2);
        this.vendorComboBox.setSelectedItem(((JdkVersionVendorItem)it).getSelectItem());
    }

    private final void onVendorSelectionChange(JdkVersionVendorElement it) {
        if (!(it instanceof JdkVersionVendorItem) || !((JdkVersionVendorItem)it).getCanBeSelected()) {
            return;
        }
        this.vendorComboBox.setSelectedItem(((JdkVersionVendorItem)it).getSelectItem());
        JdkItem newVersion = ((JdkVersionVendorItem)it).getItem();
        String path2 = ((Object)JdkInstaller.Companion.getInstance().defaultInstallDir(newVersion, this.mergedModel.getProjectWSLDistribution())).toString();
        String relativePath = FileUtil.getLocationRelativeToUserHome(path2);
        if (this.installDirTextField != null) {
            this.installDirTextField.setText(relativePath);
        } else {
            ComboBox<String> comboBox = this.installDirCombo;
            Intrinsics.checkNotNull(comboBox);
            comboBox.setModel((ComboBoxModel)new CollectionComboBoxModel<String>(this.getSuggestedInstallDirs(newVersion), relativePath));
        }
        this.selectedPath = path2;
        this.selectedItem = newVersion;
    }

    /*
     * WARNING - void declaration
     */
    private final List<String> getSuggestedInstallDirs(JdkItem newVersion) {
        void $this$mapTo$iv$iv;
        Collection collection;
        void $this$mapTo$iv;
        Iterable iterable = CollectionsKt.plus((Collection)CollectionsKt.listOf(null), (Iterable)this.mergedModel.getWslDistributions());
        Collection destination$iv = new LinkedHashSet();
        boolean $i$f$mapTo22 = false;
        for (Object item$iv : $this$mapTo$iv) {
            void it;
            WSLDistribution wSLDistribution = (WSLDistribution)item$iv;
            collection = destination$iv;
            boolean bl = false;
            collection.add(((Object)JdkInstaller.Companion.getInstance().defaultInstallDir(newVersion, (WSLDistribution)it)).toString());
        }
        Iterable $this$map$iv = destination$iv;
        boolean $i$f$map = false;
        Iterable $i$f$mapTo22 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string2 = (String)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(FileUtil.getLocationRelativeToUserHome((String)it));
        }
        return (List)destination$iv$iv;
    }

    private final void onVersionSelectionChange(JdkVersionItem it) {
        if (it == null) {
            return;
        }
        this.versionComboBox.setSelectedItem((Object)it);
        this.vendorComboBox.setModel(it.getModel());
    }

    @Nullable
    protected ValidationInfo doValidate() {
        ValidationInfo validationInfo;
        String error2;
        ValidationInfo validationInfo2 = super.doValidate();
        if (validationInfo2 != null) {
            ValidationInfo it = validationInfo2;
            boolean bl = false;
            return it;
        }
        JdkInstaller jdkInstaller = JdkInstaller.Companion.getInstance();
        String string2 = this.selectedPath;
        if (string2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"selectedPath");
            string2 = null;
        }
        String string3 = error2 = (String)jdkInstaller.validateInstallDir(string2).component2();
        if (string3 != null) {
            String it = string3;
            boolean bl = false;
            validationInfo = new ValidationInfo(error2, this.installDirComponent);
        } else {
            validationInfo = null;
        }
        return validationInfo;
    }

    @NotNull
    protected JComponent createCenterPanel() {
        return this.panel;
    }

    @Nullable
    public final Pair<JdkItem, Path> selectJdkAndPath() {
        Path selectedFile;
        if (!this.showAndGet()) {
            return null;
        }
        JdkInstaller jdkInstaller = JdkInstaller.Companion.getInstance();
        String string2 = this.selectedPath;
        if (string2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"selectedPath");
            string2 = null;
        }
        if ((selectedFile = (Path)jdkInstaller.validateInstallDir(string2).component1()) == null) {
            return null;
        }
        JdkItem jdkItem = this.selectedItem;
        if (jdkItem == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"selectedItem");
            jdkItem = null;
        }
        JdkDownloaderLogger.INSTANCE.logSelected(jdkItem);
        JdkItem jdkItem2 = this.selectedItem;
        if (jdkItem2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"selectedItem");
            jdkItem2 = null;
        }
        return TuplesKt.to((Object)jdkItem2, (Object)selectedFile);
    }

    private final void onTextChange(TextFieldWithBrowseButton $this$onTextChange, Function1<? super String, Unit> action2) {
        boolean $i$f$onTextChange = false;
        $this$onTextChange.getTextField().getDocument().addDocumentListener(new DocumentAdapter(action2, $this$onTextChange){
            final /* synthetic */ Function1<String, Unit> $action;
            final /* synthetic */ TextFieldWithBrowseButton $this_onTextChange;
            {
                this.$action = $action;
                this.$this_onTextChange = $receiver;
            }

            protected void textChanged(@NotNull DocumentEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                String string2 = this.$this_onTextChange.getText();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"text");
                this.$action.invoke((Object)string2);
            }
        });
    }

    private final /* synthetic */ <T> void onSelectionChange(ComboBox<T> $this$onSelectionChange, Function1<? super T, Unit> action2) {
        boolean $i$f$onSelectionChange = false;
        Intrinsics.needClassReification();
        $this$onSelectionChange.addItemListener(new ItemListener(action2){
            final /* synthetic */ Function1<T, Unit> $action;
            {
                this.$action = $action;
            }

            public final void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    Object object = e.getItem();
                    Intrinsics.reifiedOperationMarker((int)1, (String)"T");
                    this.$action.invoke(object);
                }
            }
        });
    }

    private static final void _init_$lambda$0(JdkDownloadDialog this$0, ActionEvent it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Object object = this$0.installDirCombo.getEditor().getItem();
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.String");
        this$0.onTargetPathChanged((String)object);
    }

    public static final /* synthetic */ void access$onTargetPathChanged(JdkDownloadDialog $this, String path2) {
        $this.onTargetPathChanged(path2);
    }

    public static final /* synthetic */ void access$onVendorSelectionChange(JdkDownloadDialog $this, JdkVersionVendorElement it) {
        $this.onVendorSelectionChange(it);
    }

    public static final /* synthetic */ void access$onVersionSelectionChange(JdkDownloadDialog $this, JdkVersionItem it) {
        $this.onVersionSelectionChange(it);
    }
}

