/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.projectRoots.impl.jdkDownloader;

import com.intellij.execution.wsl.WSLDistribution;
import com.intellij.execution.wsl.WslDistributionManager;
import com.intellij.execution.wsl.WslPath;
import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.ControlFlowException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkModel;
import com.intellij.openapi.projectRoots.SdkTypeId;
import com.intellij.openapi.projectRoots.SimpleJavaSdkType;
import com.intellij.openapi.projectRoots.impl.jdkDownloader.JdkDownloadDialog;
import com.intellij.openapi.projectRoots.impl.jdkDownloader.JdkDownloadDialogKt;
import com.intellij.openapi.projectRoots.impl.jdkDownloader.JdkDownloaderBase;
import com.intellij.openapi.projectRoots.impl.jdkDownloader.JdkDownloaderDialogHostExtension;
import com.intellij.openapi.projectRoots.impl.jdkDownloader.JdkDownloaderKt;
import com.intellij.openapi.projectRoots.impl.jdkDownloader.JdkDownloaderMergedModel;
import com.intellij.openapi.projectRoots.impl.jdkDownloader.JdkDownloaderModel;
import com.intellij.openapi.projectRoots.impl.jdkDownloader.JdkInstallRequest;
import com.intellij.openapi.projectRoots.impl.jdkDownloader.JdkInstaller;
import com.intellij.openapi.projectRoots.impl.jdkDownloader.JdkItem;
import com.intellij.openapi.projectRoots.impl.jdkDownloader.JdkListDownloader;
import com.intellij.openapi.projectRoots.impl.jdkDownloader.JdkListDownloaderBase;
import com.intellij.openapi.projectRoots.impl.jdkDownloader.JdkPredicate;
import com.intellij.openapi.roots.ui.configuration.projectRoot.SdkDownload;
import com.intellij.openapi.roots.ui.configuration.projectRoot.SdkDownloadTask;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.registry.Registry;
import java.awt.Component;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J>\u0010\u0004\u001a\u0002H\u0005\"\u0004\b\u0000\u0010\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\b\b\u0001\u0010\b\u001a\u00020\t2\u0014\b\u0004\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u0002H\u00050\u000bH\u0082\b\u00a2\u0006\u0002\u0010\rJ:\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u000e\u0010\u0018\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u001a0\u0019H\u0016J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016\u00a8\u0006\u001d"}, d2={"Lcom/intellij/openapi/projectRoots/impl/jdkDownloader/JdkDownloader;", "Lcom/intellij/openapi/roots/ui/configuration/projectRoot/SdkDownload;", "Lcom/intellij/openapi/projectRoots/impl/jdkDownloader/JdkDownloaderBase;", "()V", "computeInBackground", "T", "project", "Lcom/intellij/openapi/project/Project;", "title", "", "action", "Lkotlin/Function1;", "Lcom/intellij/openapi/progress/ProgressIndicator;", "(Lcom/intellij/openapi/project/Project;Ljava/lang/String;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "showDownloadUI", "", "sdkTypeId", "Lcom/intellij/openapi/projectRoots/SdkTypeId;", "sdkModel", "Lcom/intellij/openapi/projectRoots/SdkModel;", "parentComponent", "Ljavax/swing/JComponent;", "selectedSdk", "Lcom/intellij/openapi/projectRoots/Sdk;", "sdkCreatedCallback", "Ljava/util/function/Consumer;", "Lcom/intellij/openapi/roots/ui/configuration/projectRoot/SdkDownloadTask;", "supportsDownload", "", "intellij.platform.lang.impl"})
@SourceDebugExtension(value={"SMAP\nJdkDownloader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JdkDownloader.kt\ncom/intellij/openapi/projectRoots/impl/jdkDownloader/JdkDownloader\n*L\n1#1,140:1\n121#1,3:141\n121#1,3:144\n*S KotlinDebug\n*F\n+ 1 JdkDownloader.kt\ncom/intellij/openapi/projectRoots/impl/jdkDownloader/JdkDownloader\n*L\n63#1:141,3\n102#1:144,3\n*E\n"})
public final class JdkDownloader
implements SdkDownload,
JdkDownloaderBase {
    @Override
    public boolean supportsDownload(@NotNull SdkTypeId sdkTypeId) {
        Intrinsics.checkNotNullParameter((Object)sdkTypeId, (String)"sdkTypeId");
        if (!Registry.is("jdk.downloader")) {
            return false;
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return false;
        }
        return SimpleJavaSdkType.notSimpleJavaSdkTypeIfAlternativeExistsAndNotDependentSdkType().value(sdkTypeId);
    }

    @Override
    public void showDownloadUI(@NotNull SdkTypeId sdkTypeId, @NotNull SdkModel sdkModel, @NotNull JComponent parentComponent, @Nullable Sdk selectedSdk, @NotNull Consumer<? super SdkDownloadTask> sdkCreatedCallback) {
        Object object;
        Pair<JdkItem, Path> pair;
        Project project2;
        Intrinsics.checkNotNullParameter((Object)sdkTypeId, (String)"sdkTypeId");
        Intrinsics.checkNotNullParameter((Object)sdkModel, (String)"sdkModel");
        Intrinsics.checkNotNullParameter((Object)parentComponent, (String)"parentComponent");
        Intrinsics.checkNotNullParameter(sdkCreatedCallback, (String)"sdkCreatedCallback");
        DataContext dataContext2 = DataManager.getInstance().getDataContext((Component)parentComponent);
        Intrinsics.checkNotNullExpressionValue((Object)dataContext2, (String)"getInstance().getDataContext(parentComponent)");
        DataContext dataContext3 = dataContext2;
        Project project3 = project2 = (Project)CommonDataKeys.PROJECT.getData(dataContext3);
        boolean bl = project3 != null ? project3.isDisposed() : false;
        if (bl) {
            return;
        }
        JdkDownloaderDialogHostExtension jdkDownloaderDialogHostExtension = (JdkDownloaderDialogHostExtension)dataContext3.getData(JdkDownloaderKt.getJDK_DOWNLOADER_EXT());
        if (jdkDownloaderDialogHostExtension == null) {
            jdkDownloaderDialogHostExtension = new JdkDownloaderDialogHostExtension(){};
        }
        JdkDownloaderDialogHostExtension extension2 = jdkDownloaderDialogHostExtension;
        try {
            pair = this;
            String string2 = ProjectBundle.message((String)"progress.title.downloading.jdk.list", (Object[])new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(\"progress.title.downloading.jdk.list\")");
            String title$iv = string2;
            boolean $i$f$computeInBackground = false;
            pair = (JdkDownloaderMergedModel)ProgressManager.getInstance().run(new Task.WithResult<JdkDownloaderMergedModel, Exception>(project2, title$iv, extension2, project2, sdkTypeId){
                final /* synthetic */ JdkDownloaderDialogHostExtension $extension$inlined;
                final /* synthetic */ Project $project$inlined;
                final /* synthetic */ SdkTypeId $sdkTypeId$inlined;
                {
                    this.$extension$inlined = jdkDownloaderDialogHostExtension;
                    this.$project$inlined = project2;
                    this.$sdkTypeId$inlined = sdkTypeId;
                    super($project, $title, true);
                }

                protected JdkDownloaderMergedModel compute(@NotNull ProgressIndicator indicator) {
                    JdkDownloaderMergedModel jdkDownloaderMergedModel;
                    JdkPredicate jdkPredicate;
                    WSLDistribution projectWslDistribution2;
                    List wslDistributions;
                    Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                    ProgressIndicator it = indicator;
                    boolean bl = false;
                    Function1 buildModel2 = (Function1)new Function1<JdkPredicate, JdkDownloaderModel>(it, this.$extension$inlined, this.$sdkTypeId$inlined){
                        final /* synthetic */ ProgressIndicator $it;
                        final /* synthetic */ JdkDownloaderDialogHostExtension $extension;
                        final /* synthetic */ SdkTypeId $sdkTypeId;
                        {
                            this.$it = $it;
                            this.$extension = $extension;
                            this.$sdkTypeId = $sdkTypeId;
                            super(1);
                        }

                        /*
                         * WARNING - void declaration
                         */
                        @Nullable
                        public final JdkDownloaderModel invoke(@NotNull JdkPredicate predicate2) {
                            JdkDownloaderModel jdkDownloaderModel;
                            Iterable<T> iterable;
                            void $this$filterTo$iv$iv;
                            void $this$filter$iv;
                            Intrinsics.checkNotNullParameter((Object)predicate2, (String)"predicate");
                            Iterable<T> iterable2 = JdkListDownloaderBase.downloadForUI$default(JdkListDownloader.Companion.getInstance(), this.$it, null, predicate2, 2, null);
                            JdkDownloaderDialogHostExtension jdkDownloaderDialogHostExtension = this.$extension;
                            SdkTypeId sdkTypeId = this.$sdkTypeId;
                            boolean $i$f$filter = false;
                            void var7_7 = $this$filter$iv;
                            Collection destination$iv$iv = new ArrayList<E>();
                            boolean $i$f$filterTo = false;
                            for (T element$iv$iv : $this$filterTo$iv$iv) {
                                JdkItem it = (JdkItem)element$iv$iv;
                                boolean bl = false;
                                if (!jdkDownloaderDialogHostExtension.shouldIncludeItem(sdkTypeId, it)) continue;
                                destination$iv$iv.add(element$iv$iv);
                            }
                            Iterable<T> it = iterable2 = (List)destination$iv$iv;
                            boolean bl = false;
                            Iterable<T> iterable3 = iterable = !((Collection)it).isEmpty() ? iterable2 : null;
                            if (iterable != null) {
                                it = iterable;
                                boolean bl2 = false;
                                jdkDownloaderModel = JdkDownloadDialogKt.buildJdkDownloaderModel((List<JdkItem>)it);
                            } else {
                                jdkDownloaderModel = null;
                            }
                            return jdkDownloaderModel;
                        }
                    };
                    boolean allowWsl = this.$extension$inlined.allowWsl();
                    if (allowWsl) {
                        List list2 = WslDistributionManager.getInstance().getInstalledDistributions();
                        v1 = list2;
                        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getInstance().installedDistributions");
                    } else {
                        v1 = wslDistributions = CollectionsKt.emptyList();
                    }
                    if (allowWsl) {
                        String string2;
                        if (this.$project$inlined != null && (string2 = this.$project$inlined.getBasePath()) != null) {
                            String it2 = string2;
                            boolean bl2 = false;
                            v2 = WslPath.Companion.getDistributionByWindowsUncPath(it2);
                        } else {
                            v2 = null;
                        }
                    } else {
                        v2 = projectWslDistribution2 = null;
                    }
                    if ((jdkPredicate = this.$extension$inlined.createMainPredicate()) == null) {
                        jdkPredicate = JdkPredicate.Companion.default();
                    }
                    JdkDownloaderModel jdkDownloaderModel = (JdkDownloaderModel)buildModel2.invoke((Object)jdkPredicate);
                    if (jdkDownloaderModel == null) {
                        jdkDownloaderMergedModel = null;
                    } else {
                        JdkDownloaderModel jdkDownloaderModel2;
                        JdkDownloaderModel mainModel = jdkDownloaderModel;
                        if (allowWsl && !((Collection)wslDistributions).isEmpty()) {
                            JdkPredicate jdkPredicate2 = this.$extension$inlined.createWslPredicate();
                            if (jdkPredicate2 == null) {
                                jdkPredicate2 = JdkPredicate.Companion.forWSL();
                            }
                            jdkDownloaderModel2 = (JdkDownloaderModel)buildModel2.invoke((Object)jdkPredicate2);
                        } else {
                            jdkDownloaderModel2 = null;
                        }
                        JdkDownloaderModel wslModel = jdkDownloaderModel2;
                        jdkDownloaderMergedModel = new JdkDownloaderMergedModel(mainModel, wslModel, wslDistributions, projectWslDistribution2);
                    }
                    return jdkDownloaderMergedModel;
                }
            });
        }
        catch (Throwable e) {
            if (e instanceof ControlFlowException) {
                throw e;
            }
            JdkDownloaderKt.access$getLOG$p().warn("Failed to download the list of installable JDKs. " + e.getMessage(), e);
            pair = null;
        }
        JdkDownloader items2 = pair;
        Project project4 = project2;
        boolean bl2 = project4 != null ? project4.isDisposed() : false;
        if (bl2) {
            return;
        }
        if (items2 == null) {
            Messages.showErrorDialog((Project)project2, (String)ProjectBundle.message((String)"error.message.no.jdk.for.download", (Object[])new Object[0]), (String)ProjectBundle.message((String)"error.message.title.download.jdk", (Object[])new Object[0]));
            return;
        }
        Pair<JdkItem, Path> pair2 = new JdkDownloadDialog(project2, parentComponent, sdkTypeId, (JdkDownloaderMergedModel)((Object)items2)).selectJdkAndPath();
        if (pair2 == null) {
            return;
        }
        pair = pair2;
        JdkItem jdkItem = (JdkItem)pair.component1();
        Path jdkHome = (Path)pair.component2();
        try {
            object = this;
            String string3 = ProjectBundle.message((String)"progress.title.preparing.jdk", (Object[])new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(\"progress.title.preparing.jdk\")");
            String title$iv = string3;
            boolean $i$f$computeInBackground = false;
            object = (JdkInstallRequest)ProgressManager.getInstance().run(new Task.WithResult<JdkInstallRequest, Exception>(project2, title$iv, jdkItem, jdkHome){
                final /* synthetic */ JdkItem $jdkItem$inlined;
                final /* synthetic */ Path $jdkHome$inlined;
                {
                    this.$jdkItem$inlined = jdkItem;
                    this.$jdkHome$inlined = path2;
                    super($project, $title, true);
                }

                protected JdkInstallRequest compute(@NotNull ProgressIndicator indicator) {
                    Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                    ProgressIndicator it = indicator;
                    boolean bl = false;
                    return JdkInstaller.Companion.getInstance().prepareJdkInstallation(this.$jdkItem$inlined, this.$jdkHome$inlined);
                }
            });
        }
        catch (Throwable e) {
            if (e instanceof ControlFlowException) {
                throw e;
            }
            JdkDownloaderKt.access$getLOG$p().warn("Failed to prepare JDK installation to " + jdkHome + ". " + e.getMessage(), e);
            Object[] objectArray = new Object[]{jdkHome};
            Messages.showErrorDialog((Project)project2, (String)ProjectBundle.message((String)"error.message.text.jdk.install.failed", (Object[])objectArray), (String)ProjectBundle.message((String)"error.message.title.download.jdk", (Object[])new Object[0]));
            return;
        }
        Object request2 = object;
        sdkCreatedCallback.accept(this.newDownloadTask((JdkInstallRequest)request2, project2));
    }

    private final <T> T computeInBackground(Project project2, @NlsContexts.DialogTitle String title, Function1<? super ProgressIndicator, ? extends T> action2) {
        boolean $i$f$computeInBackground = false;
        return ProgressManager.getInstance().run(new Task.WithResult<T, Exception>(project2, title, action2){
            final /* synthetic */ Function1<ProgressIndicator, T> $action;
            {
                this.$action = $action;
                super($project, $title, true);
            }

            protected T compute(@NotNull ProgressIndicator indicator) {
                Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                return (T)this.$action.invoke((Object)indicator);
            }
        });
    }
}

