/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.projectRoots.impl.jdkDownloader;

import com.intellij.internal.statistic.eventLog.EventLogGroup;
import com.intellij.internal.statistic.eventLog.events.EventField;
import com.intellij.internal.statistic.eventLog.events.EventFields;
import com.intellij.internal.statistic.eventLog.events.EventId1;
import com.intellij.internal.statistic.eventLog.events.EventId2;
import com.intellij.internal.statistic.service.fus.collectors.CounterUsagesCollector;
import com.intellij.openapi.projectRoots.impl.jdkDownloader.JdkItem;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.java.JdkVersionDetector;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0010\u001a\u00020\u000bH\u0016J\u0010\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014J\u000e\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\tJ\u000e\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\u0019R\u001c\u0010\u0003\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00050\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u000e\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/intellij/openapi/projectRoots/impl/jdkDownloader/JdkDownloaderLogger;", "Lcom/intellij/internal/statistic/service/fus/collectors/CounterUsagesCollector;", "()V", "DETECTED_SDK", "Lcom/intellij/internal/statistic/eventLog/events/EventId2;", "", "", "DOWNLOAD", "Lcom/intellij/internal/statistic/eventLog/events/EventId1;", "", "GROUP", "Lcom/intellij/internal/statistic/eventLog/EventLogGroup;", "JDKS", "", "SELECTED_SDK", "UNKNOWN_JDK", "getGroup", "logDetected", "", "jdkInfo", "Lorg/jetbrains/jps/model/java/JdkVersionDetector$JdkVersionInfo;", "logDownload", "success", "logSelected", "jdkItem", "Lcom/intellij/openapi/projectRoots/impl/jdkDownloader/JdkItem;", "intellij.platform.lang.impl"})
public final class JdkDownloaderLogger
extends CounterUsagesCollector {
    @NotNull
    public static final JdkDownloaderLogger INSTANCE = new JdkDownloaderLogger();
    @NotNull
    private static final String UNKNOWN_JDK = "Unknown";
    @NotNull
    private static final List<String> JDKS;
    @NotNull
    private static final EventLogGroup GROUP;
    @NotNull
    private static final EventId1<Boolean> DOWNLOAD;
    @NotNull
    private static final EventId2<String, Integer> DETECTED_SDK;
    @NotNull
    private static final EventId2<String, Integer> SELECTED_SDK;

    private JdkDownloaderLogger() {
    }

    @NotNull
    public EventLogGroup getGroup() {
        return GROUP;
    }

    public final void logDownload(boolean success) {
        DOWNLOAD.log((Object)success);
    }

    /*
     * Unable to fully structure code
     */
    public final void logSelected(@NotNull JdkItem jdkItem) {
        block22: {
            block19: {
                block18: {
                    block17: {
                        block21: {
                            block20: {
                                block16: {
                                    Intrinsics.checkNotNullParameter((Object)jdkItem, (String)"jdkItem");
                                    var3_2 = jdkItem.getProduct().getVendor();
                                    switch (var3_2.hashCode()) {
                                        case 1191552022: {
                                            if (!var3_2.equals("JetBrains")) {
                                                ** break;
                                            }
                                            break block16;
                                        }
                                        case 81858: {
                                            if (!var3_2.equals("SAP")) {
                                                ** break;
                                            }
                                            break block17;
                                        }
                                        case 72276: {
                                            if (!var3_2.equals("IBM")) {
                                                ** break;
                                            }
                                            break block18;
                                        }
                                        case -249489881: {
                                            if (!var3_2.equals("Eclipse")) {
                                                ** break;
                                            }
                                            break block19;
                                        }
                                        case 1699194861: {
                                            if (!var3_2.equals("BellSoft")) {
                                                ** break;
                                            }
                                            break block20;
                                        }
                                        case 1964569124: {
                                            if (var3_2.equals("Amazon")) break;
                                            ** break;
                                        }
                                        case -1924994658: {
                                            if (!var3_2.equals("Oracle")) {
                                                ** break;
                                            }
                                            break block21;
                                        }
                                        case 2057392: {
                                            if (!var3_2.equals("Azul")) ** break;
                                            v0 = "Azul Zulu";
                                            break block22;
                                        }
                                    }
                                    v0 = "Amazon Corretto";
                                    break block22;
                                }
                                v0 = "JetBrains Runtime";
                                break block22;
                            }
                            v0 = "BellSoft Liberica";
                            break block22;
                        }
                        v0 = "Oracle OpenJDK";
                        break block22;
                    }
                    v0 = "SAP SapMachine";
                    break block22;
                }
                v0 = "IBM Semeru";
                break block22;
            }
            v0 = "Eclipse Temurin";
            break block22;
lbl55:
            // 9 sources

            v0 = "Unknown";
        }
        name = v0;
        JdkDownloaderLogger.SELECTED_SDK.log((Object)name, (Object)jdkItem.getJdkMajorVersion());
    }

    public final void logDetected(@Nullable JdkVersionDetector.JdkVersionInfo jdkInfo) {
        Pair pair;
        if (jdkInfo == null) {
            pair = null;
        } else if (CollectionsKt.contains((Iterable)JDKS, (Object)jdkInfo.variant.displayName)) {
            String string2 = jdkInfo.variant.displayName;
            if (string2 == null) {
                string2 = UNKNOWN_JDK;
            }
            pair = TuplesKt.to((Object)string2, (Object)jdkInfo.version.feature);
        } else {
            pair = TuplesKt.to((Object)UNKNOWN_JDK, (Object)jdkInfo.version.feature);
        }
        if (pair == null) {
            return;
        }
        Pair pair2 = pair;
        String name = (String)pair2.component1();
        int version = ((Number)pair2.component2()).intValue();
        DETECTED_SDK.log((Object)name, (Object)version);
    }

    static {
        Object[] objectArray = new String[]{"AdoptOpenJDK (HotSpot)", "AdoptOpenJDK (OpenJ9)", "Eclipse Temurin", "IBM Semeru", "Amazon Corretto", "GraalVM", "IBM JDK", "JetBrains Runtime", "BellSoft Liberica", "Oracle OpenJDK", "SAP SapMachine", "Azul Zulu", UNKNOWN_JDK};
        JDKS = CollectionsKt.listOf((Object[])objectArray);
        GROUP = new EventLogGroup("jdk.downloader", 1, null, 4, null);
        DOWNLOAD = GROUP.registerEvent("download", (EventField)EventFields.Boolean((String)"success"));
        DETECTED_SDK = GROUP.registerEvent("detected", (EventField)EventFields.String((String)"product", JDKS), (EventField)EventFields.Int((String)"version"));
        SELECTED_SDK = GROUP.registerEvent("selected", (EventField)EventFields.String((String)"product", JDKS), (EventField)EventFields.Int((String)"version"));
    }
}

