/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.projectRoots.impl.jdkDownloader;

import com.intellij.codeWithMe.ClientId;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.execution.wsl.WSLCommandLineOptions;
import com.intellij.execution.wsl.WSLDistribution;
import com.intellij.execution.wsl.WslPath;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.impl.jdkDownloader.JdkInstallRequest;
import com.intellij.openapi.projectRoots.impl.jdkDownloader.JdkInstallerBase;
import com.intellij.openapi.projectRoots.impl.jdkDownloader.JdkInstallerKt;
import com.intellij.openapi.projectRoots.impl.jdkDownloader.JdkInstallerListener;
import com.intellij.openapi.projectRoots.impl.jdkDownloader.JdkInstallerStore;
import com.intellij.openapi.projectRoots.impl.jdkDownloader.JdkItem;
import com.intellij.openapi.projectRoots.impl.jdkDownloader.WSLDistributionForJdkInstaller;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0007\u0018\u0000 \u001a2\u00020\u0001:\u0002\u001a\u001bB\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016J\u0012\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0002J\u001a\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\b2\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006J\u0012\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\tH\u0016J\u0016\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00040\u000b2\u0006\u0010\f\u001a\u00020\bH\u0014J$\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0014J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0006H\u0002J\u0012\u0010\u0018\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0019\u001a\u00020\u0004H\u0014\u00a8\u0006\u001c"}, d2={"Lcom/intellij/openapi/projectRoots/impl/jdkDownloader/JdkInstaller;", "Lcom/intellij/openapi/projectRoots/impl/jdkDownloader/JdkInstallerBase;", "()V", "defaultInstallDir", "Ljava/nio/file/Path;", "wslDistribution", "Lcom/intellij/execution/wsl/WSLDistribution;", "newVersion", "Lcom/intellij/openapi/projectRoots/impl/jdkDownloader/JdkItem;", "Lcom/intellij/openapi/projectRoots/impl/jdkDownloader/WSLDistributionForJdkInstaller;", "findHistoryRoots", "", "feedItem", "installJdkImpl", "", "request", "Lcom/intellij/openapi/projectRoots/impl/jdkDownloader/JdkInstallRequest;", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "project", "Lcom/intellij/openapi/project/Project;", "wrap", "Lcom/intellij/openapi/projectRoots/impl/jdkDownloader/JdkInstaller$WSLDistributionForJdkInstallerImpl;", "d", "wslDistributionFromPath", "targetDir", "Companion", "WSLDistributionForJdkInstallerImpl", "intellij.platform.lang.impl"})
@SourceDebugExtension(value={"SMAP\nJdkInstaller.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JdkInstaller.kt\ncom/intellij/openapi/projectRoots/impl/jdkDownloader/JdkInstaller\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,581:1\n39#2,3:582\n39#2,3:586\n1#3:585\n*S KotlinDebug\n*F\n+ 1 JdkInstaller.kt\ncom/intellij/openapi/projectRoots/impl/jdkDownloader/JdkInstaller\n*L\n83#1:582,3\n104#1:586,3\n*E\n"})
public final class JdkInstaller
extends JdkInstallerBase {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Override
    @NotNull
    protected List<Path> findHistoryRoots(@NotNull JdkItem feedItem) {
        Intrinsics.checkNotNullParameter((Object)feedItem, (String)"feedItem");
        boolean $i$f$service = false;
        Class<JdkInstallerStore> serviceClass$iv = JdkInstallerStore.class;
        JdkInstallerStore jdkInstallerStore = ApplicationManager.getApplication().getService(serviceClass$iv);
        if (jdkInstallerStore == null) {
            throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ")");
        }
        return jdkInstallerStore.findInstallations(feedItem);
    }

    @Override
    @Nullable
    protected WSLDistributionForJdkInstaller wslDistributionFromPath(@NotNull Path targetDir) {
        Intrinsics.checkNotNullParameter((Object)targetDir, (String)"targetDir");
        WSLDistribution wSLDistribution = WslPath.Companion.getDistributionByWindowsUncPath(((Object)targetDir).toString());
        if (wSLDistribution == null) {
            return null;
        }
        WSLDistribution d = wSLDistribution;
        return this.wrap(d);
    }

    private final WSLDistributionForJdkInstallerImpl wrap(WSLDistribution d) {
        return new WSLDistributionForJdkInstallerImpl(d);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void installJdkImpl(@NotNull JdkInstallRequest request2, @Nullable ProgressIndicator indicator, @Nullable Project project2) {
        Intrinsics.checkNotNullParameter((Object)request2, (String)"request");
        JdkInstallerKt.access$getJDK_INSTALL_LISTENER_EP_NAME$p().forEachExtensionSafe(arg_0 -> JdkInstaller.installJdkImpl$lambda$0((Function1)new Function1<JdkInstallerListener, Unit>(request2, project2){
            final /* synthetic */ JdkInstallRequest $request;
            final /* synthetic */ Project $project;
            {
                this.$request = $request;
                this.$project = $project;
                super(1);
            }

            public final void invoke(@NotNull JdkInstallerListener it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                it.onJdkDownloadStarted(this.$request, this.$project);
            }
        }, arg_0));
        try {
            super.installJdkImpl(request2, indicator, project2);
            JdkInstaller jdkInstaller = this;
            try {
                JdkInstaller $this$installJdkImpl_u24lambda_u241 = jdkInstaller;
                boolean bl = false;
                boolean $i$f$service = false;
                Class<JdkInstallerStore> serviceClass$iv = JdkInstallerStore.class;
                JdkInstallerStore jdkInstallerStore = ApplicationManager.getApplication().getService(serviceClass$iv);
                if (jdkInstallerStore == null) {
                    throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ")");
                }
                jdkInstallerStore.registerInstall(request2.getItem(), request2.getInstallDir());
                Object object = Result.constructor-impl((Object)Unit.INSTANCE);
            }
            catch (Throwable throwable) {
                Object object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
            }
            JdkInstallerKt.access$getJDK_INSTALL_LISTENER_EP_NAME$p().forEachExtensionSafe(arg_0 -> JdkInstaller.installJdkImpl$lambda$2((Function1)new Function1<JdkInstallerListener, Unit>(request2, project2){
                final /* synthetic */ JdkInstallRequest $request;
                final /* synthetic */ Project $project;
                {
                    this.$request = $request;
                    this.$project = $project;
                    super(1);
                }

                public final void invoke(@NotNull JdkInstallerListener it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    it.onJdkDownloadFinished(this.$request, this.$project);
                }
            }, arg_0));
        }
        catch (Throwable throwable) {
            JdkInstallerKt.access$getJDK_INSTALL_LISTENER_EP_NAME$p().forEachExtensionSafe(arg_0 -> JdkInstaller.installJdkImpl$lambda$2((Function1)new /* invalid duplicate definition of identical inner class */, arg_0));
            throw throwable;
        }
    }

    @Override
    @NotNull
    public Path defaultInstallDir(@Nullable WSLDistributionForJdkInstaller wslDistribution) {
        if (wslDistribution instanceof WSLDistributionForJdkInstallerImpl) {
            return this.defaultInstallDir(((WSLDistributionForJdkInstallerImpl)wslDistribution).getD());
        }
        return this.defaultInstallDir();
    }

    private final Path defaultInstallDir(WSLDistribution wslDistribution) {
        WSLDistribution wSLDistribution = wslDistribution;
        if (wSLDistribution != null) {
            WSLDistribution dist = wSLDistribution;
            boolean bl = false;
            String string2 = dist.getUserHome();
            if (string2 != null) {
                String home2 = string2;
                boolean bl2 = false;
                Path path2 = Paths.get(dist.getWindowsPath(home2 + "/.jdks"), new String[0]);
                Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"get(dist.getWindowsPath(\"$home/.jdks\"))");
                return path2;
            }
        }
        return this.defaultInstallDir();
    }

    @Override
    @NotNull
    public Path defaultInstallDir() {
        Path path2;
        String explicitHome = System.getProperty("jdk.downloader.home");
        if (explicitHome != null) {
            Path path3 = Paths.get(explicitHome, new String[0]);
            Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"get(explicitHome)");
            return path3;
        }
        String string2 = System.getProperty("user.home");
        if (string2 == null) {
            string2 = ".";
        }
        Path home2 = Paths.get(FileUtil.toCanonicalPath(string2), new String[0]);
        if (SystemInfo.isLinux) {
            Path path4 = home2.resolve(".jdks");
            path2 = path4;
            Intrinsics.checkNotNullExpressionValue((Object)path4, (String)"home.resolve(\".jdks\")");
        } else if (SystemInfo.isMac) {
            Path path5 = home2.resolve("Library/Java/JavaVirtualMachines");
            path2 = path5;
            Intrinsics.checkNotNullExpressionValue((Object)path5, (String)"home.resolve(\"Library/Java/JavaVirtualMachines\")");
        } else if (SystemInfo.isWindows) {
            Path path6 = home2.resolve(".jdks");
            path2 = path6;
            Intrinsics.checkNotNullExpressionValue((Object)path6, (String)"home.resolve(\".jdks\")");
        } else {
            throw new IllegalStateException(("Unsupported OS: " + SystemInfo.getOsNameAndVersion()).toString());
        }
        return path2;
    }

    @NotNull
    public final Path defaultInstallDir(@NotNull JdkItem newVersion, @Nullable WSLDistribution wslDistribution) {
        Intrinsics.checkNotNullParameter((Object)newVersion, (String)"newVersion");
        return this.defaultInstallDir(this.defaultInstallDir(wslDistribution), newVersion);
    }

    public static /* synthetic */ Path defaultInstallDir$default(JdkInstaller jdkInstaller, JdkItem jdkItem, WSLDistribution wSLDistribution, int n, Object object) {
        if ((n & 2) != 0) {
            wSLDistribution = null;
        }
        return jdkInstaller.defaultInstallDir(jdkItem, wSLDistribution);
    }

    private static final void installJdkImpl$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void installJdkImpl$lambda$2(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    @JvmStatic
    @NotNull
    public static final JdkInstaller getInstance() {
        return Companion.getInstance();
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J&\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0012"}, d2={"Lcom/intellij/openapi/projectRoots/impl/jdkDownloader/JdkInstaller$WSLDistributionForJdkInstallerImpl;", "Lcom/intellij/openapi/projectRoots/impl/jdkDownloader/WSLDistributionForJdkInstaller;", "d", "Lcom/intellij/execution/wsl/WSLDistribution;", "(Lcom/intellij/execution/wsl/WSLDistribution;)V", "getD", "()Lcom/intellij/execution/wsl/WSLDistribution;", "executeOnWsl", "Lcom/intellij/execution/process/ProcessOutput;", "command", "", "", "dir", "timeout", "", "getWslPath", "path", "Ljava/nio/file/Path;", "intellij.platform.lang.impl"})
    private static final class WSLDistributionForJdkInstallerImpl
    implements WSLDistributionForJdkInstaller {
        @NotNull
        private final WSLDistribution d;

        public WSLDistributionForJdkInstallerImpl(@NotNull WSLDistribution d) {
            Intrinsics.checkNotNullParameter((Object)d, (String)"d");
            this.d = d;
        }

        @NotNull
        public final WSLDistribution getD() {
            return this.d;
        }

        @Override
        @NotNull
        public String getWslPath(@NotNull Path path2) {
            Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
            String string2 = this.d.getWslPath(((Object)path2).toString());
            if (string2 == null) {
                throw new IllegalStateException(("Failed to map " + path2 + " to WSL").toString());
            }
            return string2;
        }

        @Override
        @NotNull
        public ProcessOutput executeOnWsl(@NotNull List<String> command2, @NotNull String dir, int timeout) {
            Intrinsics.checkNotNullParameter(command2, (String)"command");
            Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
            ProcessOutput processOutput = this.d.executeOnWsl(command2, new WSLCommandLineOptions().setRemoteWorkingDirectory(dir), timeout, null);
            Intrinsics.checkNotNullExpressionValue((Object)processOutput, (String)"d.executeOnWsl(command, \u2026tory(dir), timeout, null)");
            return processOutput;
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0007\u00a8\u0006\u0005"}, d2={"Lcom/intellij/openapi/projectRoots/impl/jdkDownloader/JdkInstaller$Companion;", "", "()V", "getInstance", "Lcom/intellij/openapi/projectRoots/impl/jdkDownloader/JdkInstaller;", "intellij.platform.lang.impl"})
    @SourceDebugExtension(value={"SMAP\nJdkInstaller.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JdkInstaller.kt\ncom/intellij/openapi/projectRoots/impl/jdkDownloader/JdkInstaller$Companion\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,581:1\n39#2,3:582\n*S KotlinDebug\n*F\n+ 1 JdkInstaller.kt\ncom/intellij/openapi/projectRoots/impl/jdkDownloader/JdkInstaller$Companion\n*L\n80#1:582,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final JdkInstaller getInstance() {
            boolean $i$f$service = false;
            Class<JdkInstaller> serviceClass$iv = JdkInstaller.class;
            JdkInstaller jdkInstaller = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (jdkInstaller == null) {
                throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ")");
            }
            return jdkInstaller;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

