/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.projectRoots.impl.jdkDownloader;

import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.hash.Hashing;
import com.intellij.execution.wsl.WslPath;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.ControlFlowException;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.projectRoots.JdkUtil;
import com.intellij.openapi.projectRoots.impl.jdkDownloader.JdkDownloaderLogger;
import com.intellij.openapi.projectRoots.impl.jdkDownloader.JdkInstallRequest;
import com.intellij.openapi.projectRoots.impl.jdkDownloader.JdkInstallerBase;
import com.intellij.openapi.projectRoots.impl.jdkDownloader.JdkInstallerWSL;
import com.intellij.openapi.projectRoots.impl.jdkDownloader.JdkItem;
import com.intellij.openapi.projectRoots.impl.jdkDownloader.JdkListParser;
import com.intellij.openapi.projectRoots.impl.jdkDownloader.JdkPredicate;
import com.intellij.openapi.projectRoots.impl.jdkDownloader.LocallyFoundJdk;
import com.intellij.openapi.projectRoots.impl.jdkDownloader.PendingJdkRequest;
import com.intellij.openapi.projectRoots.impl.jdkDownloader.WSLDistributionForJdkInstaller;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.Url;
import com.intellij.util.Urls;
import com.intellij.util.io.Decompressor;
import com.intellij.util.io.HttpRequests;
import com.intellij.util.io.PathKt;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0010\u001a\u00020\u0011H&J\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\rJ\u0012\u0010\u0010\u001a\u00020\u00112\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0016J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\rH\u0004J\u001c\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0018\u001a\u00020\r2\b\u0010\u0019\u001a\u0004\u0018\u00010\u0014H\u0002J\u0016\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00110\u001b2\u0006\u0010\u0018\u001a\u00020\rH\u0014J\u0014\u0010\u001c\u001a\u0004\u0018\u00010\r2\b\u0010\u001d\u001a\u0004\u0018\u00010\u0011H\u0002J\u0012\u0010\u001c\u001a\u0004\u0018\u00010\r2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001fJ\"\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u00172\b\u0010#\u001a\u0004\u0018\u00010$2\b\u0010%\u001a\u0004\u0018\u00010&J$\u0010'\u001a\u00020!2\u0006\u0010\"\u001a\u00020\u00172\b\u0010#\u001a\u0004\u0018\u00010$2\b\u0010%\u001a\u0004\u0018\u00010&H\u0014J\u0012\u0010(\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0015\u001a\u00020\u0011H\u0002J\u0016\u0010)\u001a\u00020\u00172\u0006\u0010*\u001a\u00020\r2\u0006\u0010+\u001a\u00020\u0011J\u0016\u0010,\u001a\u00020\u00172\u0006\u0010*\u001a\u00020\r2\u0006\u0010+\u001a\u00020\u0011J\u0018\u0010-\u001a\u00020\u000e2\u0006\u0010*\u001a\u00020\r2\u0006\u0010+\u001a\u00020\u0011H\u0002J#\u0010.\u001a\u0017\u0012\u0006\u0012\u0004\u0018\u00010\u0011\u0012\u000b\u0012\t\u0018\u00010\u001f\u00a2\u0006\u0002\b00/2\u0006\u00101\u001a\u00020\u001fJ\u0010\u00102\u001a\u00020!2\u0006\u0010\"\u001a\u00020\u0017H\u0002J\u0012\u00103\u001a\u0004\u0018\u00010\u00142\u0006\u00104\u001a\u00020\u0011H\u0014R\u001f\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0084\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0006\u0010\u0002\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\u000b\u001a\u001e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\fj\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e`\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00065"}, d2={"Lcom/intellij/openapi/projectRoots/impl/jdkDownloader/JdkInstallerBase;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getLOG$annotations", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "myLock", "Ljava/util/concurrent/locks/ReentrantLock;", "myPendingDownloads", "Ljava/util/HashMap;", "Lcom/intellij/openapi/projectRoots/impl/jdkDownloader/JdkItem;", "Lcom/intellij/openapi/projectRoots/impl/jdkDownloader/PendingJdkRequest;", "Lkotlin/collections/HashMap;", "defaultInstallDir", "Ljava/nio/file/Path;", "newVersion", "wslDistribution", "Lcom/intellij/openapi/projectRoots/impl/jdkDownloader/WSLDistributionForJdkInstaller;", "installDir", "findAlreadyInstalledJdk", "Lcom/intellij/openapi/projectRoots/impl/jdkDownloader/JdkInstallRequest;", "feedItem", "distribution", "findHistoryRoots", "", "findJdkItemForInstalledJdk", "jdkPath", "jdkHome", "", "installJdk", "", "request", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "project", "Lcom/intellij/openapi/project/Project;", "installJdkImpl", "markerFile", "prepareJdkInstallation", "jdkItem", "targetPath", "prepareJdkInstallationDirect", "prepareJdkInstallationImpl", "validateInstallDir", "Lkotlin/Pair;", "Lorg/jetbrains/annotations/Nls;", "selectedPath", "writeMarkerFile", "wslDistributionFromPath", "targetDir", "intellij.platform.lang.impl"})
@SourceDebugExtension(value={"SMAP\nJdkInstaller.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JdkInstaller.kt\ncom/intellij/openapi/projectRoots/impl/jdkDownloader/JdkInstallerBase\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,581:1\n1#2:582\n179#3,2:583\n*S KotlinDebug\n*F\n+ 1 JdkInstaller.kt\ncom/intellij/openapi/projectRoots/impl/jdkDownloader/JdkInstallerBase\n*L\n388#1:583,2\n*E\n"})
public abstract class JdkInstallerBase {
    @NotNull
    private final Logger LOG;
    @NotNull
    private final ReentrantLock myLock;
    @NotNull
    private final HashMap<JdkItem, PendingJdkRequest> myPendingDownloads;

    public JdkInstallerBase() {
        Logger logger = Logger.getInstance(this.getClass());
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(javaClass)");
        this.LOG = logger;
        this.myLock = new ReentrantLock();
        this.myPendingDownloads = new HashMap();
    }

    @NotNull
    protected final Logger getLOG() {
        return this.LOG;
    }

    protected static /* synthetic */ void getLOG$annotations() {
    }

    @NotNull
    public abstract Path defaultInstallDir();

    @NotNull
    public Path defaultInstallDir(@Nullable WSLDistributionForJdkInstaller wslDistribution) {
        return this.defaultInstallDir();
    }

    @NotNull
    public final Path defaultInstallDir(@NotNull JdkItem newVersion) {
        Intrinsics.checkNotNullParameter((Object)newVersion, (String)"newVersion");
        return this.defaultInstallDir(this.defaultInstallDir(), newVersion);
    }

    @NotNull
    protected final Path defaultInstallDir(@NotNull Path installDir, @NotNull JdkItem newVersion) {
        Intrinsics.checkNotNullParameter((Object)installDir, (String)"installDir");
        Intrinsics.checkNotNullParameter((Object)newVersion, (String)"newVersion");
        Path targetDir = installDir.resolve(newVersion.getInstallFolderName());
        int count2 = 1;
        Path uniqueDir = targetDir;
        while (true) {
            Path path2;
            Intrinsics.checkNotNullExpressionValue((Object)uniqueDir, (String)"uniqueDir");
            LinkOption[] linkOptionArray = new LinkOption[]{};
            if (!Files.exists(path2, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) break;
            uniqueDir = targetDir.getParent().resolve(targetDir.getFileName() + "-" + count2++);
        }
        Path path3 = uniqueDir.toAbsolutePath();
        Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"uniqueDir.toAbsolutePath()");
        return path3;
    }

    @NotNull
    public final Pair<Path, String> validateInstallDir(@NotNull String selectedPath) {
        Object $this$validateInstallDir_u24lambda_u240;
        Intrinsics.checkNotNullParameter((Object)selectedPath, (String)"selectedPath");
        if (StringsKt.isBlank((CharSequence)selectedPath)) {
            return TuplesKt.to(null, (Object)ProjectBundle.message((String)"dialog.message.error.target.path.empty", (Object[])new Object[0]));
        }
        Object object = this;
        try {
            $this$validateInstallDir_u24lambda_u240 = object;
            boolean bl = false;
            $this$validateInstallDir_u24lambda_u240 = Result.constructor-impl((Object)Paths.get(FileUtil.expandUserHome(selectedPath), new String[0]));
        }
        catch (Throwable bl) {
            $this$validateInstallDir_u24lambda_u240 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
        }
        object = $this$validateInstallDir_u24lambda_u240;
        Throwable throwable = Result.exceptionOrNull-impl((Object)object);
        if (throwable != null) {
            Throwable t = throwable;
            boolean bl = false;
            this.LOG.warn("Failed to resolve user path: " + selectedPath + ". " + t.getMessage(), t);
            return TuplesKt.to(null, (Object)ProjectBundle.message((String)"dialog.message.error.resolving.path", (Object[])new Object[0]));
        }
        Path targetDir = (Path)object;
        if (Files.isRegularFile(targetDir, new LinkOption[0])) {
            return TuplesKt.to(null, (Object)ProjectBundle.message((String)"dialog.message.error.target.path.exists.file", (Object[])new Object[0]));
        }
        if (Files.isDirectory(targetDir, new LinkOption[0])) {
            File[] fileArray = targetDir.toFile().listFiles();
            boolean bl = fileArray != null ? !(fileArray.length == 0) : false;
            if (bl) {
                return TuplesKt.to(null, (Object)ProjectBundle.message((String)"dialog.message.error.target.path.exists.nonEmpty.dir", (Object[])new Object[0]));
            }
        }
        return TuplesKt.to((Object)targetDir, null);
    }

    public final void installJdk(@NotNull JdkInstallRequest request2, @Nullable ProgressIndicator indicator, @Nullable Project project2) {
        Intrinsics.checkNotNullParameter((Object)request2, (String)"request");
        if (request2 instanceof LocallyFoundJdk) {
            return;
        }
        if (request2 instanceof PendingJdkRequest) {
            ((PendingJdkRequest)request2).tryStartInstallOrWait(indicator, (Function0<Unit>)((Function0)new Function0<Unit>(this, request2, indicator, project2){
                final /* synthetic */ JdkInstallerBase this$0;
                final /* synthetic */ JdkInstallRequest $request;
                final /* synthetic */ ProgressIndicator $indicator;
                final /* synthetic */ Project $project;
                {
                    this.this$0 = $receiver;
                    this.$request = $request;
                    this.$indicator = $indicator;
                    this.$project = $project;
                    super(0);
                }

                public final void invoke() {
                    this.this$0.installJdkImpl(this.$request, this.$indicator, this.$project);
                }
            }));
            return;
        }
        this.LOG.error("Unexpected JdkInstallRequest: " + request2 + " of type " + request2.getClass().getName());
        this.installJdkImpl(request2, indicator, project2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void installJdkImpl(@NotNull JdkInstallRequest request2, @Nullable ProgressIndicator indicator, @Nullable Project project2) {
        Object object;
        Object sizeDiff;
        Intrinsics.checkNotNullParameter((Object)request2, (String)"request");
        JdkItem item = request2.getItem();
        ProgressIndicator progressIndicator = indicator;
        if (progressIndicator != null) {
            Object[] objectArray = new Object[]{item.getFullPresentationText()};
            progressIndicator.setText(ProjectBundle.message((String)"progress.text.installing.jdk.1", (Object[])objectArray));
        }
        Path targetDir = request2.getInstallDir();
        Url url = Urls.parse((String)item.getUrl(), (boolean)false);
        if (url == null) {
            throw new IllegalStateException(("Cannot parse download URL: " + item.getUrl()).toString());
        }
        Url url2 = url;
        if (!StringsKt.equals((String)url2.getScheme(), (String)"https", (boolean)true)) {
            throw new IllegalStateException(("URL must use https:// protocol, but was: " + url2).toString());
        }
        WSLDistributionForJdkInstaller wslDistribution = this.wslDistributionFromPath(targetDir);
        if (wslDistribution != null && !Intrinsics.areEqual((Object)item.getOs(), (Object)"linux")) {
            throw new IllegalStateException(("Cannot install non-linux JDK into WSL environment to " + targetDir + " from " + item).toString());
        }
        ProgressIndicator progressIndicator2 = indicator;
        if (progressIndicator2 != null) {
            progressIndicator2.setText2(ProjectBundle.message((String)"progress.text2.downloading.jdk", (Object[])new Object[0]));
        }
        String[] stringArray = new String[]{FileUtil.sanitizeFileName("jdk-" + System.nanoTime() + "-" + item.getArchiveFileName())};
        Path downloadFile = Paths.get(PathManager.getTempPath(), stringArray);
        try {
            Object $this$installJdkImpl_u24lambda_u243;
            Object $this$installJdkImpl_u24lambda_u242;
            try {
                HttpRequests.request((String)item.getUrl()).productNameAsUserAgent().saveToFile(downloadFile.toFile(), indicator);
                Intrinsics.checkNotNullExpressionValue((Object)downloadFile, (String)"downloadFile");
                if (!PathKt.isFile(downloadFile)) {
                    throw new RuntimeException("Downloaded file does not exist: " + downloadFile);
                }
            }
            catch (Throwable t) {
                if (!(t instanceof ControlFlowException)) throw new RuntimeException("Failed to download " + item.getFullPresentationText() + " from " + url2 + ". " + t.getMessage(), t);
                throw t;
            }
            Object object2 = this;
            try {
                $this$installJdkImpl_u24lambda_u242 = object2;
                boolean bl2 = false;
                $this$installJdkImpl_u24lambda_u242 = Result.constructor-impl((Object)(Files.size(downloadFile) - item.getArchiveSize()));
            }
            catch (Throwable bl2) {
                $this$installJdkImpl_u24lambda_u242 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl2));
            }
            object2 = $this$installJdkImpl_u24lambda_u242;
            sizeDiff = (Long)(Result.isFailure-impl((Object)object2) ? null : object2);
            Long l = sizeDiff;
            long l2 = 0L;
            if (l == null || l != l2) {
                Object object3;
                String string2 = item.getFullPresentationText();
                Long l3 = sizeDiff;
                if (l3 != null) {
                    object3 = Math.abs(l3);
                    throw new RuntimeException("The downloaded " + string2 + " has incorrect file size,\nthe difference is " + object3 + " bytes.\nCheck your internet connection and try again later");
                }
                object3 = "unknown";
                throw new RuntimeException("The downloaded " + string2 + " has incorrect file size,\nthe difference is " + object3 + " bytes.\nCheck your internet connection and try again later");
            }
            $this$installJdkImpl_u24lambda_u242 = this;
            try {
                $this$installJdkImpl_u24lambda_u243 = (JdkInstallerBase)$this$installJdkImpl_u24lambda_u242;
                boolean bl3 = false;
                $this$installJdkImpl_u24lambda_u243 = Result.constructor-impl((Object)com.google.common.io.Files.asByteSource((File)downloadFile.toFile()).hash(Hashing.sha256()).toString());
            }
            catch (Throwable bl3) {
                $this$installJdkImpl_u24lambda_u243 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl3));
            }
            $this$installJdkImpl_u24lambda_u242 = $this$installJdkImpl_u24lambda_u243;
            String actualHashCode = (String)(Result.isFailure-impl((Object)$this$installJdkImpl_u24lambda_u242) ? null : $this$installJdkImpl_u24lambda_u242);
            if (!StringsKt.equals((String)actualHashCode, (String)item.getSha256(), (boolean)true)) {
                String string3 = item.getFullPresentationText();
                String string4 = actualHashCode;
                String string5 = string4;
                if (string4 != null) throw new RuntimeException("Failed to verify SHA-256 checksum for " + string3 + "\n\nThe actual value is " + string5 + ",\nbut expected " + item.getSha256() + " was expected\nCheck your internet connection and try again later");
                string5 = "unknown";
                throw new RuntimeException("Failed to verify SHA-256 checksum for " + string3 + "\n\nThe actual value is " + string5 + ",\nbut expected " + item.getSha256() + " was expected\nCheck your internet connection and try again later");
            }
            ProgressIndicator progressIndicator3 = indicator;
            if (progressIndicator3 != null) {
                progressIndicator3.setIndeterminate(true);
            }
            ProgressIndicator progressIndicator4 = indicator;
            if (progressIndicator4 != null) {
                progressIndicator4.setText2(ProjectBundle.message((String)"progress.text2.unpacking.jdk", (Object[])new Object[0]));
            }
            try {
                Object $this$installJdkImpl_u24lambda_u246;
                boolean bl;
                if (wslDistribution != null) {
                    JdkInstallerWSL.INSTANCE.unpackJdkOnWsl(wslDistribution, item.getPackageType(), downloadFile, targetDir, item.getPackageRootPrefix());
                } else {
                    Decompressor it = item.getPackageType().openDecompressor(downloadFile).entryFilter(arg_0 -> JdkInstallerBase.installJdkImpl$lambda$4((Function1)new Function1<Decompressor.Entry, Boolean>(indicator){
                        final /* synthetic */ ProgressIndicator $indicator;
                        {
                            this.$indicator = $indicator;
                            super(1);
                        }

                        @NotNull
                        public final Boolean invoke(Decompressor.Entry it) {
                            block0: {
                                ProgressIndicator progressIndicator = this.$indicator;
                                if (progressIndicator == null) break block0;
                                progressIndicator.checkCanceled();
                            }
                            return true;
                        }
                    }, arg_0));
                    bl = false;
                    char[] cArray = new char[]{'/'};
                    String fullMatchPath = StringsKt.trim((String)item.getPackageRootPrefix(), (char[])cArray);
                    (StringsKt.isBlank((CharSequence)fullMatchPath) ? it : it.removePrefixPath(fullMatchPath)).extract(targetDir);
                }
                $this$installJdkImpl_u24lambda_u242 = this;
                try {
                    $this$installJdkImpl_u24lambda_u246 = (JdkInstallerBase)$this$installJdkImpl_u24lambda_u242;
                    bl = false;
                    super.writeMarkerFile(request2);
                    $this$installJdkImpl_u24lambda_u246 = Result.constructor-impl((Object)Unit.INSTANCE);
                }
                catch (Throwable throwable) {
                    $this$installJdkImpl_u24lambda_u246 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
                }
                JdkDownloaderLogger.INSTANCE.logDownload(true);
            }
            catch (Throwable t) {
                if (!(t instanceof ControlFlowException)) throw new RuntimeException("Failed to extract " + item.getFullPresentationText() + ". " + t.getMessage(), t);
                throw t;
            }
            sizeDiff = this;
        }
        catch (Throwable t) {
            try {
                JdkDownloaderLogger.INSTANCE.logDownload(false);
                PathKt.delete$default(targetDir, false, 1, null);
                Path path2 = this.markerFile(targetDir);
                if (path2 == null) throw t;
                PathKt.delete$default(path2, false, 1, null);
                throw t;
            }
            catch (Throwable throwable) {
                JdkInstallerBase jdkInstallerBase = this;
                try {
                    JdkInstallerBase $this$installJdkImpl_u24lambda_u247 = jdkInstallerBase;
                    boolean bl5 = false;
                    FileUtil.delete(downloadFile);
                    Object object3 = Result.constructor-impl((Object)Unit.INSTANCE);
                    throw throwable;
                }
                catch (Throwable throwable2) {
                    Object object4 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable2));
                }
                throw throwable;
            }
        }
        try {
            JdkInstallerBase $this$installJdkImpl_u24lambda_u247 = (JdkInstallerBase)sizeDiff;
            boolean bl4 = false;
            FileUtil.delete(downloadFile);
            object = Result.constructor-impl((Object)Unit.INSTANCE);
            return;
        }
        catch (Throwable bl4) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl4));
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final JdkInstallRequest prepareJdkInstallation(@NotNull JdkItem jdkItem, @NotNull Path targetPath) {
        WSLDistributionForJdkInstaller distribution;
        JdkInstallRequest existingRequest;
        Intrinsics.checkNotNullParameter((Object)jdkItem, (String)"jdkItem");
        Intrinsics.checkNotNullParameter((Object)targetPath, (String)"targetPath");
        if (Registry.is("jdk.downloader.reuse.installed") && (existingRequest = this.findAlreadyInstalledJdk(jdkItem, distribution = this.wslDistributionFromPath(targetPath))) != null) {
            return existingRequest;
        }
        if (Registry.is("jdk.downloader.reuse.downloading")) {
            PendingJdkRequest pendingJdkRequest;
            Lock lock = this.myLock;
            lock.lock();
            try {
                boolean bl = false;
                PendingJdkRequest pendingJdkRequest2 = this.myPendingDownloads.computeIfAbsent(jdkItem, arg_0 -> JdkInstallerBase.prepareJdkInstallation$lambda$9$lambda$8((Function1)new Function1<JdkItem, PendingJdkRequest>(this, jdkItem, targetPath){
                    final /* synthetic */ JdkInstallerBase this$0;
                    final /* synthetic */ JdkItem $jdkItem;
                    final /* synthetic */ Path $targetPath;
                    {
                        this.this$0 = $receiver;
                        this.$jdkItem = $jdkItem;
                        this.$targetPath = $targetPath;
                        super(1);
                    }

                    @NotNull
                    public final PendingJdkRequest invoke(@NotNull JdkItem it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        return JdkInstallerBase.access$prepareJdkInstallationImpl(this.this$0, this.$jdkItem, this.$targetPath);
                    }
                }, arg_0));
                pendingJdkRequest = pendingJdkRequest2;
            }
            finally {
                lock.unlock();
            }
            Intrinsics.checkNotNullExpressionValue((Object)pendingJdkRequest, (String)"myLock.withLock {\n      \u2026em, targetPath) }\n      }");
            return pendingJdkRequest;
        }
        return this.prepareJdkInstallationDirect(jdkItem, targetPath);
    }

    @NotNull
    public final JdkInstallRequest prepareJdkInstallationDirect(@NotNull JdkItem jdkItem, @NotNull Path targetPath) {
        Intrinsics.checkNotNullParameter((Object)jdkItem, (String)"jdkItem");
        Intrinsics.checkNotNullParameter((Object)targetPath, (String)"targetPath");
        return this.prepareJdkInstallationImpl(jdkItem, targetPath);
    }

    private final PendingJdkRequest prepareJdkInstallationImpl(JdkItem jdkItem, Path targetPath) {
        Pair<Path, String> pair = this.validateInstallDir(((Object)targetPath).toString());
        Path home2 = (Path)pair.component1();
        String error2 = (String)pair.component2();
        if (home2 == null || error2 != null) {
            String string2 = error2;
            if (string2 == null) {
                string2 = "Invalid Target Directory";
            }
            throw new RuntimeException(string2);
        }
        Path javaHome = jdkItem.resolveJavaHome(targetPath);
        Files.createDirectories(javaHome, new FileAttribute[0]);
        PendingJdkRequest request2 = new PendingJdkRequest(jdkItem, targetPath, javaHome);
        this.writeMarkerFile(request2);
        return request2;
    }

    private final Path markerFile(Path installDir) {
        Path path2 = installDir.getParent();
        return path2 != null ? path2.resolve("." + installDir.getFileName() + ".intellij") : null;
    }

    private final void writeMarkerFile(JdkInstallRequest request2) {
        Path installDir = request2.getInstallDir();
        Path path2 = this.markerFile(installDir);
        if (path2 == null) {
            return;
        }
        Path markerFile2 = path2;
        try {
            request2.getItem().writeMarkerFile(markerFile2);
        }
        catch (Throwable t) {
            if (t instanceof ControlFlowException) {
                throw t;
            }
            this.LOG.warn("Failed to write marker file to " + markerFile2 + ". " + t.getMessage(), t);
        }
    }

    @Nullable
    public final JdkItem findJdkItemForInstalledJdk(@Nullable String jdkHome) {
        try {
            if (jdkHome == null) {
                return null;
            }
            Path jdkPath = Paths.get(jdkHome, new String[0]);
            return this.findJdkItemForInstalledJdk(jdkPath);
        }
        catch (Throwable t) {
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final JdkItem findJdkItemForInstalledJdk(Path jdkPath) {
        try {
            Object v0;
            JdkPredicate predicate2;
            block6: {
                void $this$firstOrNull$iv;
                if (jdkPath == null) {
                    return null;
                }
                if (!PathKt.isDirectory(jdkPath)) {
                    return null;
                }
                predicate2 = WslPath.Companion.isWslUncPath(((Object)jdkPath).toString()) ? JdkPredicate.Companion.forWSL() : JdkPredicate.Companion.default();
                Sequence sequence = SequencesKt.mapNotNull((Sequence)SequencesKt.take((Sequence)SequencesKt.takeWhile((Sequence)SequencesKt.generateSequence((Object)jdkPath, (Function1)findJdkItemForInstalledJdk.markerFile.1.INSTANCE), (Function1)findJdkItemForInstalledJdk.markerFile.2.INSTANCE), (int)5), (Function1)((Function1)new Function1<Path, Path>(this){
                    final /* synthetic */ JdkInstallerBase this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    @Nullable
                    public final Path invoke(@NotNull Path it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        return JdkInstallerBase.access$markerFile(this.this$0, it);
                    }
                }));
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    Path it = (Path)element$iv;
                    boolean bl = false;
                    if (!PathKt.isFile(it)) continue;
                    v0 = element$iv;
                    break block6;
                }
                v0 = null;
            }
            Path path2 = v0;
            if (path2 == null) {
                return null;
            }
            Path markerFile2 = path2;
            ObjectNode json = JdkListParser.INSTANCE.readTree(PathKt.readBytes(markerFile2));
            return (JdkItem)CollectionsKt.firstOrNull(JdkListParser.INSTANCE.parseJdkItem(json, predicate2));
        }
        catch (Throwable e) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final JdkInstallRequest findAlreadyInstalledJdk(JdkItem feedItem, WSLDistributionForJdkInstaller distribution) {
        try {
            List list2;
            JdkInstallerBase $this$findAlreadyInstalledJdk_u24lambda_u2412 = this;
            boolean bl = false;
            Path defaultInstallDir = $this$findAlreadyInstalledJdk_u24lambda_u2412.defaultInstallDir(distribution);
            if (!PathKt.isDirectory(defaultInstallDir)) {
                list2 = CollectionsKt.emptyList();
            } else {
                AutoCloseable autoCloseable = Files.list(defaultInstallDir);
                Throwable throwable = null;
                try {
                    Stream it = (Stream)autoCloseable;
                    boolean bl2 = false;
                    List list3 = it.toList();
                    list2 = list3;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
                }
            }
            List localRoots = list2;
            List<Path> historyRoots = this.findHistoryRoots(feedItem);
            Intrinsics.checkNotNullExpressionValue((Object)localRoots, (String)"localRoots");
            for (Path installDir : CollectionsKt.plus((Collection)localRoots, (Iterable)historyRoots)) {
                Path jdkHome;
                JdkItem item;
                Intrinsics.checkNotNullExpressionValue((Object)installDir, (String)"installDir");
                if (!PathKt.isDirectory(installDir) || this.findJdkItemForInstalledJdk(installDir) == null || !Intrinsics.areEqual((Object)item, (Object)feedItem) || !PathKt.isDirectory(jdkHome = item.resolveJavaHome(installDir)) || !JdkUtil.checkForJdk((Path)jdkHome) || !Intrinsics.areEqual((Object)this.wslDistributionFromPath(jdkHome), (Object)distribution)) continue;
                return new LocallyFoundJdk(feedItem, installDir, jdkHome);
            }
        }
        finally {
            return null;
        }
        {
        }
    }

    @NotNull
    protected List<Path> findHistoryRoots(@NotNull JdkItem feedItem) {
        Intrinsics.checkNotNullParameter((Object)feedItem, (String)"feedItem");
        return CollectionsKt.emptyList();
    }

    @Nullable
    protected WSLDistributionForJdkInstaller wslDistributionFromPath(@NotNull Path targetDir) {
        Intrinsics.checkNotNullParameter((Object)targetDir, (String)"targetDir");
        return null;
    }

    private static final boolean installJdkImpl$lambda$4(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final PendingJdkRequest prepareJdkInstallation$lambda$9$lambda$8(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (PendingJdkRequest)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ Path access$markerFile(JdkInstallerBase $this, Path installDir) {
        return $this.markerFile(installDir);
    }

    public static final /* synthetic */ PendingJdkRequest access$prepareJdkInstallationImpl(JdkInstallerBase $this, JdkItem jdkItem, Path targetPath) {
        return $this.prepareJdkInstallationImpl(jdkItem, targetPath);
    }
}

